/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.rewards;

import com.gmail.nossr50.datatypes.skills.SkillType;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.convo.generic.OverridePrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.module.CustomReward;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestRewardsPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final String classPrefix;
    private boolean hasReward = false;
    private final int size = 12;

    public QuestRewardsPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.classPrefix = ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("rewardsTitle").replace("<quest>", (String)Objects.requireNonNull(context.getSessionData((Object)"questName")));
    }

    @Override
    public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return org.bukkit.ChatColor.BLUE;
            }
            case 7: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 8: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 9: {
                if (this.plugin.getDependencies().getPartiesApi() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 11: {
                if (context.getSessionData((Object)"detailsOverrideRew") == null) {
                    if (!this.hasReward) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 12: {
                return org.bukkit.ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetMoney");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("rewSetMoney");
            }
            case 2: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetQuestPoints").replace("<points>", BukkitLang.get("questPoints"));
            }
            case 3: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetItems");
            }
            case 4: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetExperience");
            }
            case 5: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetCommands");
            }
            case 6: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetPermission");
            }
            case 7: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetMcMMO");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("rewSetMcMMO");
            }
            case 8: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetHeroes");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("rewSetHeroes");
            }
            case 9: {
                if (this.plugin.getDependencies().getPartiesApi() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetPartiesExperience");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("rewSetPartiesExperience");
            }
            case 10: {
                return org.bukkit.ChatColor.DARK_PURPLE + BukkitLang.get("rewSetCustom");
            }
            case 11: {
                if (!this.hasReward) {
                    return org.bukkit.ChatColor.GRAY + BukkitLang.get("overrideCreateSet");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("overrideCreateSet");
            }
            case 12: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    Integer moneyRew = (Integer)context.getSessionData((Object)"moneyRew");
                    if (moneyRew == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + this.plugin.getDependencies().getVaultEconomy().format((double)moneyRew.intValue()) + org.bukkit.ChatColor.GRAY + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 2: {
                if (context.getSessionData((Object)"questPointsRew") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"questPointsRew") + " " + BukkitLang.get("questPoints") + org.bukkit.ChatColor.GRAY + ")";
            }
            case 3: {
                if (context.getSessionData((Object)"itemRews") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)"itemRews");
                if (items != null) {
                    for (ItemStack item : items) {
                        if (item == null) {
                            text.append(org.bukkit.ChatColor.RED).append("     - null\n");
                            this.plugin.getLogger().severe(org.bukkit.ChatColor.RED + "Item reward was null while editing quest ID " + context.getSessionData((Object)"questId"));
                            continue;
                        }
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(org.bukkit.ChatColor.GRAY).append(" x ").append(org.bukkit.ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 4: {
                if (context.getSessionData((Object)"expRew") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"expRew") + " " + BukkitLang.get("points") + org.bukkit.ChatColor.GRAY + ")";
            }
            case 5: {
                if (context.getSessionData((Object)"commandRews") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List commands = (List)context.getSessionData((Object)"commandRews");
                List overrides = (List)context.getSessionData((Object)"commandOverrideDisplay");
                int index = 0;
                if (commands != null) {
                    for (String cmd : commands) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(cmd);
                        if (overrides != null && index < overrides.size()) {
                            text.append(org.bukkit.ChatColor.GRAY).append(" (\"").append(org.bukkit.ChatColor.AQUA).append((String)overrides.get(index)).append(org.bukkit.ChatColor.GRAY).append("\")");
                        }
                        ++index;
                    }
                }
                return text.toString();
            }
            case 6: {
                if (context.getSessionData((Object)"permissionRews") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List permissions = (List)context.getSessionData((Object)"permissionRews");
                List worlds = (List)context.getSessionData((Object)"permissionWorlds");
                int index = 0;
                if (permissions != null) {
                    for (String perm : permissions) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(perm);
                        if (worlds != null && index < worlds.size()) {
                            text.append(org.bukkit.ChatColor.GRAY).append("[").append(org.bukkit.ChatColor.DARK_AQUA).append((String)worlds.get(index)).append(org.bukkit.ChatColor.GRAY).append("]");
                        }
                        ++index;
                    }
                }
                return text.toString();
            }
            case 7: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    if (context.getSessionData((Object)"mcMMOSkillRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List skills = (List)context.getSessionData((Object)"mcMMOSkillRews");
                    List amounts = (List)context.getSessionData((Object)"mcMMOSkillAmounts");
                    if (skills != null && amounts != null) {
                        for (String skill : skills) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(skill).append(org.bukkit.ChatColor.GRAY).append(" x ").append(org.bukkit.ChatColor.DARK_AQUA).append(amounts.get(skills.indexOf(skill)));
                        }
                    }
                    return text.toString();
                }
                return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 8: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    if (context.getSessionData((Object)"heroesClassRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List heroClasses = (List)context.getSessionData((Object)"heroesClassRews");
                    List amounts = (List)context.getSessionData((Object)"heroesAmountRews");
                    if (heroClasses != null && amounts != null) {
                        for (String heroClass : heroClasses) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(amounts.get(heroClasses.indexOf(heroClass))).append(" ").append(org.bukkit.ChatColor.DARK_AQUA).append(heroClass).append(" ").append(BukkitLang.get("experience"));
                        }
                    }
                    return text.toString();
                }
                return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 9: {
                if (context.getSessionData((Object)"partiesExperienceRews") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"partiesExperienceRews") + " " + BukkitLang.get("points") + org.bukkit.ChatColor.GRAY + ")";
            }
            case 10: {
                if (context.getSessionData((Object)"customRews") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList customRew = (LinkedList)context.getSessionData((Object)"customRews");
                if (customRew != null) {
                    for (String s : customRew) {
                        text.append("\n").append(org.bukkit.ChatColor.LIGHT_PURPLE).append("     - ").append(s);
                    }
                }
                return text.toString();
            }
            case 11: {
                if (context.getSessionData((Object)"detailsOverrideRew") == null) {
                    if (!this.hasReward) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List overrides = (List)context.getSessionData((Object)"detailsOverrideRew");
                if (overrides != null) {
                    for (String override : overrides) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(override);
                    }
                }
                return text.toString();
            }
            case 12: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        String input = (String)context.getSessionData((Object)(this.classPrefix + "-override"));
        if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cancel"))) {
            if (input.equalsIgnoreCase(BukkitLang.get("clear"))) {
                context.setSessionData((Object)"detailsOverrideRew", null);
            } else {
                LinkedList<String> overrides = new LinkedList<String>();
                if (context.getSessionData((Object)"detailsOverrideRew") != null) {
                    overrides.addAll((List)context.getSessionData((Object)"detailsOverrideRew"));
                }
                overrides.add(input);
                context.setSessionData((Object)"detailsOverrideRew", overrides);
                context.setSessionData((Object)(this.classPrefix + "-override"), null);
            }
        }
        this.checkReward(context);
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + "- " + this.getTitle(context).replace((String)Objects.requireNonNull(context.getSessionData((Object)"questName")), org.bukkit.ChatColor.AQUA + (String)context.getSessionData((Object)"questName") + org.bukkit.ChatColor.LIGHT_PURPLE) + " -");
        for (int i = 1; i <= 12; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    return new QuestRewardsMoneyPrompt(context);
                }
                return new QuestRewardsPrompt(context);
            }
            case 2: {
                return new QuestRewardsQuestPointsPrompt(context);
            }
            case 3: {
                return new QuestRewardsItemListPrompt(context);
            }
            case 4: {
                return new QuestRewardsExperiencePrompt(context);
            }
            case 5: {
                if (!this.plugin.hasLimitedAccess(context.getForWhom())) {
                    return new QuestRewardsCommandsPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("noPermission"));
                return new QuestRewardsPrompt(context);
            }
            case 6: {
                if (!this.plugin.hasLimitedAccess(context.getForWhom())) {
                    return new QuestRewardsPermissionsListPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("noPermission"));
                return new QuestRewardsPrompt(context);
            }
            case 7: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    return new QuestRewardsMcMMOListPrompt(context);
                }
                return new QuestRewardsPrompt(context);
            }
            case 8: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    return new QuestRewardsHeroesListPrompt(context);
                }
                return new QuestRewardsPrompt(context);
            }
            case 9: {
                return new QuestRewardsPartiesExperiencePrompt(context);
            }
            case 10: {
                return new QuestCustomRewardModulePrompt(context);
            }
            case 11: {
                if (this.hasReward) {
                    return new OverridePrompt.Builder().source((Prompt)this).promptText(BukkitLang.get("overrideCreateEnter")).build();
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestRewardsPrompt(context);
            }
            case 12: {
                return this.plugin.getQuestFactory().returnToMenu(context);
            }
        }
        return new QuestRewardsPrompt(context);
    }

    public boolean checkReward(ConversationContext context) {
        if (context.getSessionData((Object)"moneyRew") != null || context.getSessionData((Object)"questPointsRew") != null || context.getSessionData((Object)"itemRews") != null || context.getSessionData((Object)"expRew") != null || context.getSessionData((Object)"commandRews") != null || context.getSessionData((Object)"permissionRews") != null || context.getSessionData((Object)"mcMMOSkillRews") != null || context.getSessionData((Object)"heroesClassRews") != null || context.getSessionData((Object)"partiesExperienceRews") != null || context.getSessionData((Object)"phatLootRews") != null || context.getSessionData((Object)"customRews") != null) {
            this.hasReward = true;
            return true;
        }
        return false;
    }

    public class QuestRewardsMoneyPrompt
    extends QuestsEditorStringPrompt {
        public QuestRewardsMoneyPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewMoneyPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String text = this.getQueryText(context);
            if (QuestRewardsPrompt.this.plugin.getDependencies().getVaultEconomy() != null) {
                text = text.replace("<money>", QuestRewardsPrompt.this.plugin.getDependencies().getVaultEconomy().currencyNamePlural());
            }
            return org.bukkit.ChatColor.YELLOW + text;
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRewardsMoneyPrompt(context);
                    }
                    context.setSessionData((Object)"moneyRew", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRewardsMoneyPrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"moneyRew", null);
                return new QuestRewardsPrompt(context);
            }
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestRewardsQuestPointsPrompt
    extends QuestsEditorStringPrompt {
        public QuestRewardsQuestPointsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewQuestPointsPrompt").replace("<points>", BukkitLang.get("questPoints"));
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRewardsQuestPointsPrompt(context);
                    }
                    context.setSessionData((Object)"questPointsRew", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRewardsQuestPointsPrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"questPointsRew", null);
                return new QuestRewardsPrompt(context);
            }
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestRewardsItemListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestRewardsItemListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("itemRewardsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 2: {
                    return org.bukkit.ChatColor.RED;
                }
                case 3: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"itemRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List items = (List)context.getSessionData((Object)"itemRews");
                    if (items != null) {
                        for (ItemStack is : items) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> itemRew;
                if (context.getSessionData((Object)"itemRews") != null) {
                    itemRew = (List)context.getSessionData((Object)"itemRews");
                    if (itemRew != null) {
                        itemRew.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)"itemRews", itemRew);
                    }
                } else {
                    itemRew = new LinkedList();
                    itemRew.add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)"itemRews", itemRew);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + this.getTitle(context));
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewItemsCleared"));
                    context.setSessionData((Object)"itemRews", null);
                    return new QuestRewardsItemListPrompt(context);
                }
                case 3: {
                    return new QuestRewardsPrompt(context);
                }
            }
            return new QuestRewardsItemListPrompt(context);
        }
    }

    public class QuestRewardsExperiencePrompt
    extends QuestsEditorStringPrompt {
        public QuestRewardsExperiencePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewExperiencePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRewardsExperiencePrompt(context);
                    }
                    context.setSessionData((Object)"expRew", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRewardsExperiencePrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"expRew", null);
                return new QuestRewardsPrompt(context);
            }
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestRewardsCommandsPrompt
    extends QuestsEditorStringPrompt {
        public QuestRewardsCommandsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewCommandPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] args = input.split(BukkitLang.get("charSemi"));
                LinkedList<String> commands = new LinkedList<String>();
                block19: for (String s : args) {
                    if (s.startsWith("/")) {
                        s = s.substring(1);
                    }
                    switch (s.trim().split(" ")[0].toLowerCase()) {
                        case "ban": 
                        case "ban-ip": 
                        case "deop": 
                        case "kick": 
                        case "kill": 
                        case "timings": 
                        case "op": 
                        case "pardon": 
                        case "pardon-ip": 
                        case "reload": 
                        case "stop": 
                        case "we": 
                        case "whitelist": 
                        case "worldedit": {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption") + org.bukkit.ChatColor.DARK_RED + " (" + s.trim() + ")");
                            continue block19;
                        }
                        default: {
                            commands.add(s.trim());
                        }
                    }
                }
                context.setSessionData((Object)"commandRews", commands.isEmpty() ? null : commands);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"commandRews", null);
            }
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestRewardsPermissionsListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestRewardsPermissionsListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("permissionRewardsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 2: {
                    if (context.getSessionData((Object)"permissionRews") == null) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.RED;
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetPermission");
                }
                case 2: {
                    if (context.getSessionData((Object)"permissionRews") == null) {
                        return org.bukkit.ChatColor.GRAY + BukkitLang.get("rewSetPermissionWorlds");
                    }
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetPermissionWorlds");
                }
                case 3: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"permissionRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List permission = (List)context.getSessionData((Object)"permissionRews");
                    if (permission != null) {
                        for (String s : permission) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"permissionRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    if (context.getSessionData((Object)"permissionWorlds") == null) {
                        return org.bukkit.ChatColor.YELLOW + "(" + BukkitLang.get("stageEditorOptional") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List permissionWorlds = (List)context.getSessionData((Object)"permissionWorlds");
                    if (permissionWorlds != null) {
                        for (String s : permissionWorlds) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestPermissionsPrompt(context);
                }
                case 2: {
                    return new QuestPermissionsWorldsPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewPermissionsCleared"));
                    context.setSessionData((Object)"permissionRews", null);
                    context.setSessionData((Object)"permissionWorlds", null);
                    return new QuestRewardsPermissionsListPrompt(context);
                }
                case 4: {
                    return new QuestRewardsPrompt(context);
                }
            }
            return null;
        }
    }

    public class QuestRewardsMcMMOListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestRewardsMcMMOListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("mcMMORewardsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.RED;
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetSkills");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetSkillAmounts");
                }
                case 3: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"mcMMOSkillRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List skills = (List)context.getSessionData((Object)"mcMMOSkillRews");
                    if (skills != null) {
                        for (String s : skills) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"mcMMOSkillAmounts") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List amounts = (List)context.getSessionData((Object)"mcMMOSkillAmounts");
                    if (amounts != null) {
                        for (Integer i : amounts) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestMcMMOSkillsPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)"mcMMOSkillRews") == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("rewSetMcMMOSkillsFirst"));
                        return new QuestRewardsMcMMOListPrompt(context);
                    }
                    return new QuestMcMMOAmountsPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewMcMMOCleared"));
                    context.setSessionData((Object)"mcMMOSkillRews", null);
                    context.setSessionData((Object)"mcMMOSkillAmounts", null);
                    return new QuestRewardsMcMMOListPrompt(context);
                }
                case 4: {
                    List skills = (List)context.getSessionData((Object)"mcMMOSkillRews");
                    List amounts = (List)context.getSessionData((Object)"mcMMOSkillAmounts");
                    int one = skills != null ? skills.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        return new QuestRewardsPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestRewardsMcMMOListPrompt(context);
                }
            }
            return new QuestRewardsMcMMOListPrompt(context);
        }
    }

    public class QuestRewardsHeroesListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestRewardsHeroesListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("heroesRewardsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.RED;
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetHeroesClasses");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewSetHeroesAmounts");
                }
                case 3: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"heroesClassRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List classes = (List)context.getSessionData((Object)"heroesClassRews");
                    if (classes != null) {
                        for (String s : classes) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"heroesAmountRews") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List amounts = (List)context.getSessionData((Object)"heroesAmountRews");
                    if (amounts != null) {
                        for (Double d : amounts) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(d);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestHeroesClassesPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)"heroesClassRews") == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("rewSetHeroesClassesFirst"));
                        return new QuestRewardsHeroesListPrompt(context);
                    }
                    return new QuestHeroesExperiencePrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewHeroesCleared"));
                    context.setSessionData((Object)"heroesClassRews", null);
                    context.setSessionData((Object)"heroesAmountRews", null);
                    return new QuestRewardsHeroesListPrompt(context);
                }
                case 4: {
                    List classes = (List)context.getSessionData((Object)"heroesClassRews");
                    List amounts = (List)context.getSessionData((Object)"heroesAmountRews");
                    int one = classes != null ? classes.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        return new QuestRewardsPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("rewHeroesListsNotSameSize"));
                    return new QuestRewardsHeroesListPrompt(context);
                }
            }
            return new QuestRewardsHeroesListPrompt(context);
        }
    }

    public class QuestRewardsPartiesExperiencePrompt
    extends QuestsEditorStringPrompt {
        public QuestRewardsPartiesExperiencePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewPartiesExperiencePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRewardsPartiesExperiencePrompt(context);
                    }
                    context.setSessionData((Object)"partiesExperienceRews", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRewardsPartiesExperiencePrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"partiesExperienceRews", null);
                return new QuestRewardsPrompt(context);
            }
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestCustomRewardModulePrompt
    extends QuestsEditorStringPrompt {
        public QuestCustomRewardModulePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorModules");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorModulePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!(context.getForWhom() instanceof Player) || !QuestRewardsPrompt.this.plugin.getConfigSettings().canClickablePrompts()) {
                StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
                if (QuestRewardsPrompt.this.plugin.getCustomRewards().isEmpty()) {
                    text.append(org.bukkit.ChatColor.DARK_AQUA).append(org.bukkit.ChatColor.UNDERLINE).append("https://pikamug.gitbook.io/quests/casual/modules").append(org.bukkit.ChatColor.RESET).append("\n");
                    text.append(org.bukkit.ChatColor.RED).append("(").append(BukkitLang.get("stageEditorNoModules")).append(")").append("\n");
                } else {
                    for (String name : QuestRewardsPrompt.this.plugin.getCustomRewards().stream().map(CustomReward::getModuleName).collect(Collectors.toCollection(TreeSet::new))) {
                        text.append(org.bukkit.ChatColor.DARK_PURPLE).append("  - ").append(name).append("\n");
                    }
                }
                return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            }
            TextComponent component = new TextComponent(this.getTitle(context) + "\n");
            component.setColor(ChatColor.LIGHT_PURPLE);
            TextComponent line = new TextComponent("");
            if (QuestRewardsPrompt.this.plugin.getCustomRewards().isEmpty()) {
                TextComponent link = new TextComponent("https://pikamug.gitbook.io/quests/casual/modules\n");
                link.setColor(ChatColor.DARK_AQUA);
                link.setUnderlined(Boolean.valueOf(true));
                line.addExtra((BaseComponent)link);
                line.addExtra(org.bukkit.ChatColor.RED + "(" + BukkitLang.get("stageEditorNoModules") + ")\n");
            } else {
                for (String name : QuestRewardsPrompt.this.plugin.getCustomRewards().stream().map(CustomReward::getModuleName).collect(Collectors.toCollection(TreeSet::new))) {
                    TextComponent click = new TextComponent(org.bukkit.ChatColor.DARK_PURPLE + "  - " + name + "\n");
                    click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + name));
                    line.addExtra((BaseComponent)click);
                }
            }
            component.addExtra((BaseComponent)line);
            component.addExtra(org.bukkit.ChatColor.YELLOW + this.getQueryText(context));
            ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
            return "";
        }

        public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String found = null;
                for (CustomReward cr : QuestRewardsPrompt.this.plugin.getCustomRewards()) {
                    if (!cr.getModuleName().equalsIgnoreCase(input)) continue;
                    found = cr.getModuleName();
                    break;
                }
                if (found == null) {
                    for (CustomReward cr : QuestRewardsPrompt.this.plugin.getCustomRewards()) {
                        if (!cr.getModuleName().toLowerCase().contains(input.toLowerCase())) continue;
                        found = cr.getModuleName();
                        break;
                    }
                }
                if (found != null) {
                    return new QuestCustomRewardsPrompt(found, context);
                }
            } else {
                if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                    return new QuestRewardsPrompt(context);
                }
                if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                    context.setSessionData((Object)"customRews", null);
                    context.setSessionData((Object)"customRewData", null);
                    context.setSessionData((Object)"customRewDataTemp", null);
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewCustomCleared"));
                    return new QuestRewardsPrompt(context);
                }
            }
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("rewCustomNotFound"));
            return new QuestCustomRewardModulePrompt(context);
        }
    }

    private class QuestRewardCustomDataPrompt
    extends StringPrompt {
        private QuestRewardCustomDataPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            String text = "";
            String temp = (String)context.getSessionData((Object)"customRewDataTemp");
            Map descriptions = (Map)context.getSessionData((Object)"customRewDataDesc");
            if (temp != null && descriptions != null) {
                if (descriptions.get(temp) != null) {
                    text = text + (String)descriptions.get(temp) + "\n";
                }
                String lang = BukkitLang.get("stageEditorCustomDataPrompt");
                lang = lang.replace("<data>", temp);
                text = text + org.bukkit.ChatColor.YELLOW + lang;
            }
            return text;
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customRewData");
            if (dataMapList != null) {
                Map dataMap = (Map)dataMapList.getLast();
                dataMap.put((String)context.getSessionData((Object)"customRewDataTemp"), input);
                context.setSessionData((Object)"customRewDataTemp", null);
            }
            return new QuestRewardCustomDataListPrompt();
        }
    }

    private class QuestRewardCustomDataListPrompt
    extends StringPrompt {
        private QuestRewardCustomDataListPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.GOLD + "- ");
            LinkedList list = (LinkedList)context.getSessionData((Object)"customRews");
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customRewData");
            if (list != null && dataMapList != null) {
                String rewName = (String)list.getLast();
                Map dataMap = (Map)dataMapList.getLast();
                text.append(rewName).append(" -\n");
                int index = 1;
                LinkedList dataMapKeys = new LinkedList(dataMap.keySet());
                Collections.sort(dataMapKeys);
                for (String dataKey : dataMapKeys) {
                    text.append(org.bukkit.ChatColor.BLUE).append(org.bukkit.ChatColor.BOLD).append(index).append(org.bukkit.ChatColor.RESET).append(org.bukkit.ChatColor.YELLOW).append(" - ").append(dataKey);
                    if (dataMap.get(dataKey) != null) {
                        text.append(org.bukkit.ChatColor.GRAY).append(" (").append(org.bukkit.ChatColor.AQUA).append(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)dataMap.get(dataKey).toString())).append(org.bukkit.ChatColor.GRAY).append(")\n");
                    } else {
                        text.append(org.bukkit.ChatColor.GRAY).append(" (").append(BukkitLang.get("noneSet")).append(org.bukkit.ChatColor.GRAY).append(")\n");
                    }
                    ++index;
                }
                text.append(org.bukkit.ChatColor.GREEN).append(org.bukkit.ChatColor.BOLD).append(index).append(org.bukkit.ChatColor.YELLOW).append(" - ").append(BukkitLang.get("done"));
            }
            return text.toString();
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customRewData");
            if (dataMapList != null) {
                int numInput;
                Map dataMap = (Map)dataMapList.getLast();
                try {
                    numInput = Integer.parseInt(input);
                }
                catch (NumberFormatException nfe) {
                    return new QuestRewardCustomDataListPrompt();
                }
                if (numInput < 1 || numInput > dataMap.size() + 1) {
                    return new QuestRewardCustomDataListPrompt();
                }
                if (numInput < dataMap.size() + 1) {
                    LinkedList dataMapKeys = new LinkedList(dataMap.keySet());
                    Collections.sort(dataMapKeys);
                    String selectedKey = (String)dataMapKeys.get(numInput - 1);
                    context.setSessionData((Object)"customRewDataTemp", (Object)selectedKey);
                    return new QuestRewardCustomDataPrompt();
                }
                if (dataMap.containsValue(null)) {
                    return new QuestRewardCustomDataListPrompt();
                }
                context.setSessionData((Object)"customRewDataDesc", null);
            }
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestCustomRewardsPrompt
    extends QuestsEditorStringPrompt {
        private final String moduleName;

        public QuestCustomRewardsPrompt(String moduleName, ConversationContext context) {
            super(context);
            this.moduleName = moduleName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("customRewardsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewCustomRewardPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!(context.getForWhom() instanceof Player) || !QuestRewardsPrompt.this.plugin.getConfigSettings().canClickablePrompts()) {
                StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
                if (QuestRewardsPrompt.this.plugin.getCustomRewards().isEmpty()) {
                    text.append(org.bukkit.ChatColor.DARK_AQUA).append(org.bukkit.ChatColor.UNDERLINE).append("https://pikamug.gitbook.io/quests/casual/modules\n");
                    text.append(org.bukkit.ChatColor.RED).append("(").append(BukkitLang.get("stageEditorNoModules")).append(")\n");
                } else {
                    for (CustomReward cr : QuestRewardsPrompt.this.plugin.getCustomRewards()) {
                        if (!cr.getModuleName().equals(this.moduleName)) continue;
                        text.append(org.bukkit.ChatColor.DARK_PURPLE).append("  - ").append(cr.getName()).append("\n");
                    }
                }
                return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            }
            TextComponent component = new TextComponent(this.getTitle(context) + "\n");
            component.setColor(ChatColor.LIGHT_PURPLE);
            TextComponent line = new TextComponent("");
            if (QuestRewardsPrompt.this.plugin.getCustomRewards().isEmpty()) {
                TextComponent link = new TextComponent("https://pikamug.gitbook.io/quests/casual/modules\n");
                link.setColor(ChatColor.DARK_AQUA);
                link.setUnderlined(Boolean.valueOf(true));
                line.addExtra((BaseComponent)link);
                line.addExtra(org.bukkit.ChatColor.RED + "(" + BukkitLang.get("stageEditorNoModules") + ")\n");
            } else {
                for (CustomReward co : QuestRewardsPrompt.this.plugin.getCustomRewards()) {
                    if (!co.getModuleName().equals(this.moduleName)) continue;
                    TextComponent click = new TextComponent(org.bukkit.ChatColor.DARK_PURPLE + "  - " + co.getName() + "\n");
                    click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + co.getName()));
                    line.addExtra((BaseComponent)click);
                }
            }
            component.addExtra((BaseComponent)line);
            component.addExtra(org.bukkit.ChatColor.YELLOW + this.getQueryText(context));
            ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
            return "";
        }

        /*
         * Enabled aggressive block sorting
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                CustomReward found;
                block9: {
                    found = null;
                    for (CustomReward cr : QuestRewardsPrompt.this.plugin.getCustomRewards()) {
                        if (!cr.getModuleName().equals(this.moduleName) || !cr.getName().toLowerCase().contains(input.toLowerCase())) continue;
                        found = cr;
                        break;
                    }
                    if (found == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("rewCustomNotFound"));
                        return new QuestCustomRewardsPrompt(this.moduleName, context);
                    }
                    if (context.getSessionData((Object)"customRews") != null) {
                        LinkedList list = (LinkedList)context.getSessionData((Object)"customRews");
                        LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customRewData");
                        if (list != null && dataMapList != null && !list.contains(found.getName())) {
                            list.add(found.getName());
                            dataMapList.add(found.getData());
                            context.setSessionData((Object)"customRews", (Object)list);
                            context.setSessionData((Object)"customRewData", (Object)dataMapList);
                            break block9;
                        } else {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("rewCustomAlreadyAdded"));
                            return new QuestCustomRewardsPrompt(this.moduleName, context);
                        }
                    }
                    LinkedList<Map<String, Object>> dataMapList = new LinkedList<Map<String, Object>>();
                    dataMapList.add(found.getData());
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(found.getName());
                    context.setSessionData((Object)"customRews", list);
                    context.setSessionData((Object)"customRewData", dataMapList);
                }
                if (found.getData().isEmpty()) return new QuestRewardsPrompt(context);
                context.setSessionData((Object)"customRewDataDesc", found.getDescriptions());
                return new QuestRewardCustomDataListPrompt();
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestRewardsPrompt(context);
            context.setSessionData((Object)"customRews", null);
            context.setSessionData((Object)"customRewData", null);
            context.setSessionData((Object)"customRewDataTemp", null);
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("rewCustomCleared"));
            return new QuestRewardsPrompt(context);
        }
    }

    public class QuestHeroesExperiencePrompt
    extends QuestsEditorStringPrompt {
        public QuestHeroesExperiencePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("heroesExperienceTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewHeroesExperiencePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String text = this.getTitle(context) + "\n";
            text = text + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            return text;
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] arr = input.split(" ");
                LinkedList<Double> amounts = new LinkedList<Double>();
                for (String s : arr) {
                    try {
                        double d = Double.parseDouble(s);
                        amounts.add(d);
                    }
                    catch (NumberFormatException nfe) {
                        String text = BukkitLang.get("reqNotANumber");
                        text = text.replace("<input>", s);
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + text);
                        return new QuestHeroesExperiencePrompt(context);
                    }
                }
                context.setSessionData((Object)"heroesAmountRews", amounts);
            }
            return new QuestRewardsHeroesListPrompt(context);
        }
    }

    public class QuestHeroesClassesPrompt
    extends QuestsEditorStringPrompt {
        public QuestHeroesClassesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("heroesClassesTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewHeroesClassesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<String> list = new LinkedList<String>();
            for (HeroClass hc : QuestRewardsPrompt.this.plugin.getDependencies().getHeroes().getClassManager().getClasses()) {
                list.add(hc.getName());
            }
            if (list.isEmpty()) {
                text.append(org.bukkit.ChatColor.GRAY).append("(").append(BukkitLang.get("none")).append(")\n");
            } else {
                Collections.sort(list);
                for (int i = 0; i < list.size(); ++i) {
                    text.append(org.bukkit.ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase((String)list.get(i)));
                    if (i >= list.size() - 1) continue;
                    text.append(org.bukkit.ChatColor.GRAY).append(", ");
                }
            }
            text.append("\n").append(org.bukkit.ChatColor.YELLOW).append(this.getQueryText(context));
            return text.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] arr = input.split(" ");
                LinkedList<String> classes = new LinkedList<String>();
                for (String s : arr) {
                    HeroClass hc = QuestRewardsPrompt.this.plugin.getDependencies().getHeroes().getClassManager().getClass(s);
                    if (hc == null) {
                        String text = BukkitLang.get("rewHeroesInvalidClass");
                        text = text.replace("<input>", s);
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + text);
                        return new QuestHeroesClassesPrompt(context);
                    }
                    classes.add(hc.getName());
                }
                context.setSessionData((Object)"heroesClassRews", classes);
            }
            return new QuestRewardsHeroesListPrompt(context);
        }
    }

    public class QuestMcMMOAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMcMMOAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqMcMMOAmountsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : args) {
                    try {
                        amounts.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        String text = BukkitLang.get("reqNotANumber");
                        text = text.replace("<input>", s);
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + text);
                        return new QuestMcMMOAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)"mcMMOSkillAmounts", amounts);
            }
            return new QuestRewardsMcMMOListPrompt(context);
        }
    }

    public class QuestMcMMOSkillsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMcMMOSkillsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("skillListTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewMcMMOPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder skillList = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            SkillType[] skills = SkillType.values();
            for (int i = 0; i < skills.length; ++i) {
                skillList.append(org.bukkit.ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(skills[i].getName()));
                if (i >= skills.length - 1) continue;
                skillList.append(org.bukkit.ChatColor.GRAY).append(", ");
            }
            skillList.append("\n").append(org.bukkit.ChatColor.YELLOW).append(this.getQueryText(context));
            return skillList.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> skills = new LinkedList<String>();
                for (String s : args) {
                    if (QuestRewardsPrompt.this.plugin.getDependencies().getMcMMOSkill(s) != null) {
                        if (skills.contains(s)) {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("listDuplicate"));
                            return new QuestMcMMOSkillsPrompt(context);
                        }
                    } else {
                        String text = BukkitLang.get("reqMcMMOError");
                        text = text.replace("<input>", s);
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + text);
                        return new QuestMcMMOSkillsPrompt(context);
                    }
                    skills.add(BukkitMiscUtil.getCapitalized(s));
                }
                context.setSessionData((Object)"mcMMOSkillRews", skills);
            }
            return new QuestRewardsMcMMOListPrompt(context);
        }
    }

    public class QuestPermissionsWorldsPrompt
    extends QuestsEditorStringPrompt {
        public QuestPermissionsWorldsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewPermissionsWorldPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] args = input.split(BukkitLang.get("charSemi"));
                LinkedList<String> worlds = new LinkedList<String>(Arrays.asList(args));
                for (String w : worlds) {
                    if (w.equals("null") || QuestRewardsPrompt.this.plugin.getServer().getWorld(w) != null) continue;
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("eventEditorInvalidWorld").replace("<input>", w));
                    return new QuestPermissionsWorldsPrompt(context);
                }
                context.setSessionData((Object)"permissionWorlds", worlds);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"permissionWorlds", null);
            }
            return new QuestRewardsPermissionsListPrompt(context);
        }
    }

    public class QuestPermissionsPrompt
    extends QuestsEditorStringPrompt {
        public QuestPermissionsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewPermissionsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRewardsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] args = input.split(" ");
                LinkedList<String> permissions = new LinkedList<String>();
                for (String s : args) {
                    if (s.startsWith("/")) {
                        s = s.substring(1);
                    }
                    String[] arr = new String[]{"*", "bukkit.*", "bukkit.command", "fawe", "minecraft.*", "minecraft.command", "quests", "vault", "worledit"};
                    boolean found = false;
                    for (String value : arr) {
                        if (!s.startsWith(value)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption") + org.bukkit.ChatColor.DARK_RED + " (" + s.trim() + ")");
                        continue;
                    }
                    permissions.add(s.trim());
                }
                context.setSessionData((Object)"permissionRews", permissions);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"permissionRews", null);
            }
            return new QuestRewardsPermissionsListPrompt(context);
        }
    }
}

