/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.stages;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.generic.OverridePrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.objectives.QuestBlocksPrompt;
import me.pikamug.quests.convo.quests.objectives.QuestItemsPrompt;
import me.pikamug.quests.convo.quests.objectives.QuestMobsPrompt;
import me.pikamug.quests.convo.quests.objectives.QuestNpcsPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMenuPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestStageMainPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int stageNum;
    private final String stagePrefix;
    private final String classPrefix;
    private boolean hasObjective = false;
    private final int size = 17;

    public QuestStageMainPrompt(int stageNum, ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.stageNum = stageNum;
        this.stagePrefix = "stage" + stageNum;
        this.classPrefix = ((Object)((Object)this)).getClass().getSimpleName();
    }

    public int getStageNumber() {
        return this.stageNum;
    }

    @Override
    public int getSize() {
        return 17;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return context.getSessionData((Object)"questName") + " | " + BukkitLang.get("stageEditorStage") + " " + this.stageNum;
    }

    @Override
    public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return org.bukkit.ChatColor.BLUE;
            }
            case 9: 
            case 10: 
            case 11: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 12: {
                if (context.getSessionData((Object)(this.stagePrefix + "delay")) == null) {
                    return org.bukkit.ChatColor.GRAY;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 13: {
                if (context.getSessionData((Object)(this.stagePrefix + "startMessage")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 14: {
                if (context.getSessionData((Object)(this.stagePrefix + "completeMessage")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 15: {
                if (context.getSessionData((Object)(this.stagePrefix + "overrideDisplay")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 16: {
                return org.bukkit.ChatColor.RED;
            }
            case 17: {
                return org.bukkit.ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return org.bukkit.ChatColor.GOLD + BukkitLang.get("stageEditorBlocks");
            }
            case 2: {
                return org.bukkit.ChatColor.GOLD + BukkitLang.get("stageEditorItems");
            }
            case 3: {
                return org.bukkit.ChatColor.GOLD + BukkitLang.get("stageEditorNPCs");
            }
            case 4: {
                return org.bukkit.ChatColor.GOLD + BukkitLang.get("stageEditorMobs");
            }
            case 5: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorKillPlayers");
            }
            case 6: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorReachLocs");
            }
            case 7: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorPassword");
            }
            case 8: {
                return org.bukkit.ChatColor.DARK_PURPLE + BukkitLang.get("stageEditorCustom");
            }
            case 9: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + BukkitLang.get("stageEditorEvents");
                }
                return org.bukkit.ChatColor.AQUA + BukkitLang.get("stageEditorEvents");
            }
            case 10: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + BukkitLang.get("stageEditorConditions");
                }
                return org.bukkit.ChatColor.AQUA + BukkitLang.get("stageEditorConditions");
            }
            case 11: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + BukkitLang.get("delay");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("delay");
            }
            case 12: {
                if (context.getSessionData((Object)(this.stagePrefix + "delay")) == null) {
                    return org.bukkit.ChatColor.GRAY + BukkitLang.get("stageEditorDelayMessage");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorDelayMessage");
            }
            case 13: {
                if (context.getSessionData((Object)(this.stagePrefix + "startMessage")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY + BukkitLang.get("stageEditorStartMessage");
                    }
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorStartMessage");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorStartMessage");
            }
            case 14: {
                if (context.getSessionData((Object)(this.stagePrefix + "completeMessage")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY + BukkitLang.get("stageEditorCompleteMessage");
                    }
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorCompleteMessage");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorCompleteMessage");
            }
            case 15: {
                if (context.getSessionData((Object)(this.stagePrefix + "overrideDisplay")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY + BukkitLang.get("overrideCreateSet");
                    }
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("overrideCreateSet");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("overrideCreateSet");
            }
            case 16: {
                return org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorDelete");
            }
            case 17: {
                return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)(this.stagePrefix + "breakNames")) == null && context.getSessionData((Object)(this.stagePrefix + "damageNames")) == null && context.getSessionData((Object)(this.stagePrefix + "placeNames")) == null && context.getSessionData((Object)(this.stagePrefix + "useNames")) == null && context.getSessionData((Object)(this.stagePrefix + "cutNames")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "";
            }
            case 2: {
                if (context.getSessionData((Object)(this.stagePrefix + "craftItems")) == null && context.getSessionData((Object)(this.stagePrefix + "smeltItems")) == null && context.getSessionData((Object)(this.stagePrefix + "enchantItems")) == null && context.getSessionData((Object)(this.stagePrefix + "brewItems")) == null && context.getSessionData((Object)(this.stagePrefix + "consumeItems")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "";
            }
            case 3: {
                if (context.getSessionData((Object)(this.stagePrefix + "deliveryNPCs")) == null && context.getSessionData((Object)(this.stagePrefix + "npcIdsToTalkTo")) == null && context.getSessionData((Object)(this.stagePrefix + "npcIdsToKill")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "";
            }
            case 4: {
                if (context.getSessionData((Object)(this.stagePrefix + "mobTypes")) == null && context.getSessionData((Object)(this.stagePrefix + "tameTypes")) == null && context.getSessionData((Object)(this.stagePrefix + "fish")) == null && context.getSessionData((Object)(this.stagePrefix + "cowMilk")) == null && context.getSessionData((Object)(this.stagePrefix + "shearColors")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "";
            }
            case 5: {
                if (context.getSessionData((Object)(this.stagePrefix + "playerKill")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer players = (Integer)context.getSessionData((Object)(this.stagePrefix + "playerKill"));
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + players + " " + BukkitLang.get("stageEditorPlayers") + org.bukkit.ChatColor.GRAY + ")";
            }
            case 6: {
                if (context.getSessionData((Object)(this.stagePrefix + "reachLocations")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList locations = (LinkedList)context.getSessionData((Object)(this.stagePrefix + "reachLocations"));
                LinkedList radii = (LinkedList)context.getSessionData((Object)(this.stagePrefix + "reachLocationRadii"));
                LinkedList names = (LinkedList)context.getSessionData((Object)(this.stagePrefix + "reachLocationNames"));
                if (locations != null && radii != null && names != null) {
                    for (int i = 0; i < locations.size(); ++i) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(BukkitLang.get("stageEditorReachRadii1")).append(" ").append(org.bukkit.ChatColor.BLUE).append(radii.get(i)).append(org.bukkit.ChatColor.GRAY).append(" ").append(BukkitLang.get("stageEditorReachRadii2")).append(" ").append(org.bukkit.ChatColor.AQUA).append((String)names.get(i)).append(org.bukkit.ChatColor.GRAY).append(" (").append(org.bukkit.ChatColor.DARK_AQUA).append((String)locations.get(i)).append(org.bukkit.ChatColor.GRAY).append(")");
                    }
                }
                return text.toString();
            }
            case 7: {
                if (context.getSessionData((Object)(this.stagePrefix + "passwordPhrases")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList passPhrases = (LinkedList)context.getSessionData((Object)(this.stagePrefix + "passwordPhrases"));
                LinkedList passDisplays = (LinkedList)context.getSessionData((Object)(this.stagePrefix + "passwordDisplays"));
                if (passPhrases != null && passDisplays != null) {
                    for (int i = 0; i < passDisplays.size(); ++i) {
                        text.append("\n").append(org.bukkit.ChatColor.AQUA).append("     - \"").append((String)passDisplays.get(i)).append("\"\n").append(org.bukkit.ChatColor.DARK_AQUA).append("          - ").append((String)passPhrases.get(i));
                    }
                }
                return text.toString();
            }
            case 8: {
                if (context.getSessionData((Object)(this.stagePrefix + "customObjectives")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList customObj = (LinkedList)context.getSessionData((Object)(this.stagePrefix + "customObjectives"));
                if (customObj != null) {
                    for (String s : customObj) {
                        text.append("\n").append(org.bukkit.ChatColor.LIGHT_PURPLE).append("     - ").append(s);
                    }
                }
                return text.toString();
            }
            case 9: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                }
                if (context.getSessionData((Object)(this.stagePrefix + "startEvent")) == null && context.getSessionData((Object)(this.stagePrefix + "finishEvent")) == null && context.getSessionData((Object)(this.stagePrefix + "deathEvent")) == null && context.getSessionData((Object)(this.stagePrefix + "disconnectEvent")) == null && context.getSessionData((Object)(this.stagePrefix + "chatEvents")) == null && context.getSessionData((Object)(this.stagePrefix + "commandEvents")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "";
            }
            case 10: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                }
                if (context.getSessionData((Object)(this.stagePrefix + "condition")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "";
            }
            case 11: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                }
                if (context.getSessionData((Object)(this.stagePrefix + "delay")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Long time = (Long)context.getSessionData((Object)(this.stagePrefix + "delay"));
                if (time == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + BukkitMiscUtil.getTime(time) + org.bukkit.ChatColor.GRAY + ")";
            }
            case 12: {
                if (!this.hasObjective) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                }
                if (context.getSessionData((Object)(this.stagePrefix + "delay")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noDelaySet") + ")";
                }
                if (context.getSessionData((Object)(this.stagePrefix + "delayMessage")) == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + "\"" + context.getSessionData((Object)(this.stagePrefix + "delayMessage")) + "\"" + org.bukkit.ChatColor.GRAY + ")";
            }
            case 13: {
                if (context.getSessionData((Object)(this.stagePrefix + "startMessage")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + "\"" + context.getSessionData((Object)(this.stagePrefix + "startMessage")) + "\"" + org.bukkit.ChatColor.GRAY + ")";
            }
            case 14: {
                if (context.getSessionData((Object)(this.stagePrefix + "completeMessage")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + "\"" + context.getSessionData((Object)(this.stagePrefix + "completeMessage")) + "\"" + org.bukkit.ChatColor.GRAY + ")";
            }
            case 15: {
                List overrides;
                if (context.getSessionData((Object)(this.stagePrefix + "overrideDisplay")) == null) {
                    if (!this.hasObjective) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                if (this.stagePrefix != null && (overrides = (List)context.getSessionData((Object)(this.stagePrefix + "overrideDisplay"))) != null) {
                    for (String override : overrides) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(override);
                    }
                }
                return text.toString();
            }
            case 16: 
            case 17: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        String input = (String)context.getSessionData((Object)(this.classPrefix + "-override"));
        if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(this.stagePrefix + "overrideDisplay"), null);
            } else {
                LinkedList<String> overrides = new LinkedList<String>();
                if (context.getSessionData((Object)(this.stagePrefix + "overrideDisplay")) != null) {
                    overrides.addAll((List)context.getSessionData((Object)(this.stagePrefix + "overrideDisplay")));
                }
                overrides.add(input);
                context.setSessionData((Object)(this.stagePrefix + "overrideDisplay"), overrides);
                context.setSessionData((Object)(this.classPrefix + "-override"), null);
            }
        }
        context.setSessionData((Object)this.stagePrefix, (Object)Boolean.TRUE);
        this.checkObjective(context);
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + "- " + org.bukkit.ChatColor.AQUA + this.getTitle(context).replaceFirst(" \\| ", org.bukkit.ChatColor.LIGHT_PURPLE + " | ") + " -");
        for (int i = 1; i <= 17; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestBlocksPrompt(this.stageNum, context);
            }
            case 2: {
                return new QuestItemsPrompt(this.stageNum, context);
            }
            case 3: {
                return new QuestNpcsPrompt(this.stageNum, context);
            }
            case 4: {
                return new QuestMobsPrompt(this.stageNum, context);
            }
            case 5: {
                return new QuestKillPlayerPrompt(context);
            }
            case 6: {
                return new QuestReachListPrompt(context);
            }
            case 7: {
                return new QuestPasswordListPrompt(context);
            }
            case 8: {
                return new QuestCustomObjectiveModulePrompt(context);
            }
            case 9: {
                if (this.hasObjective) {
                    return new QuestActionListPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 10: {
                if (this.hasObjective) {
                    return new QuestConditionListPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 11: {
                if (this.hasObjective) {
                    return new QuestDelayPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 12: {
                if (context.getSessionData((Object)(this.stagePrefix + "delay")) == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorNoDelaySet"));
                    return new QuestStageMainPrompt(this.stageNum, context);
                }
                return new QuestDelayMessagePrompt(context);
            }
            case 13: {
                if (this.hasObjective) {
                    return new QuestStartMessagePrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 14: {
                if (this.hasObjective) {
                    return new QuestCompleteMessagePrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 15: {
                if (this.hasObjective) {
                    return new OverridePrompt.Builder().source((Prompt)this).promptText(BukkitLang.get("overrideCreateEnter")).build();
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 16: {
                return new QuestStageDeletePrompt(context);
            }
            case 17: {
                return new QuestStageMenuPrompt(context);
            }
        }
        return new QuestStageMainPrompt(this.stageNum, context);
    }

    public boolean checkObjective(ConversationContext context) {
        if (context.getSessionData((Object)(this.stagePrefix + "breakNames")) != null || context.getSessionData((Object)(this.stagePrefix + "damageNames")) != null || context.getSessionData((Object)(this.stagePrefix + "placeNames")) != null || context.getSessionData((Object)(this.stagePrefix + "useNames")) != null || context.getSessionData((Object)(this.stagePrefix + "cutNames")) != null || context.getSessionData((Object)(this.stagePrefix + "craftItems")) != null || context.getSessionData((Object)(this.stagePrefix + "smeltItems")) != null || context.getSessionData((Object)(this.stagePrefix + "enchantItems")) != null || context.getSessionData((Object)(this.stagePrefix + "brewItems")) != null || context.getSessionData((Object)(this.stagePrefix + "consumeItems")) != null || context.getSessionData((Object)(this.stagePrefix + "deliveryNPCs")) != null || context.getSessionData((Object)(this.stagePrefix + "npcIdsToTalkTo")) != null || context.getSessionData((Object)(this.stagePrefix + "npcIdsToKill")) != null || context.getSessionData((Object)(this.stagePrefix + "mobTypes")) != null || context.getSessionData((Object)(this.stagePrefix + "fish")) != null || context.getSessionData((Object)(this.stagePrefix + "cowMilk")) != null || context.getSessionData((Object)(this.stagePrefix + "tameTypes")) != null || context.getSessionData((Object)(this.stagePrefix + "shearColors")) != null || context.getSessionData((Object)(this.stagePrefix + "playerKill")) != null || context.getSessionData((Object)(this.stagePrefix + "reachLocations")) != null || context.getSessionData((Object)(this.stagePrefix + "passwordPhrases")) != null || context.getSessionData((Object)(this.stagePrefix + "customObjectives")) != null) {
            this.hasObjective = true;
            return true;
        }
        return false;
    }

    public class QuestKillPlayerPrompt
    extends QuestsEditorStringPrompt {
        public QuestKillPlayerPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorKillPlayerPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorPositiveAmount"));
                        return new QuestKillPlayerPrompt(context);
                    }
                    if (i <= 0) return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "playerKill"), (Object)i);
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestKillPlayerPrompt(context);
                }
            } else {
                if (input == null || !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "playerKill"), null);
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestReachListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestReachListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorReachLocs");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 4: {
                    return org.bukkit.ChatColor.RED;
                }
                case 5: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorSetLocations");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorSetLocationRadii");
                }
                case 3: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorSetLocationNames");
                }
                case 4: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List locations = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations"));
                    if (locations != null) {
                        for (String s : locations) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.DARK_AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List radius = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii"));
                    if (radius != null) {
                        for (Integer i : radius) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List names = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames"));
                    if (names != null) {
                        for (String s : names) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    if (context.getForWhom() instanceof Player) {
                        ConcurrentHashMap<UUID, Block> temp = QuestStageMainPrompt.this.plugin.getQuestFactory().getSelectedReachLocations();
                        temp.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                        QuestStageMainPrompt.this.plugin.getQuestFactory().setSelectedReachLocations(temp);
                        return new QuestReachLocationPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("consoleError"));
                    return new QuestReachListPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations")) == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorNoLocations"));
                        return new QuestReachListPrompt(context);
                    }
                    return new QuestReachRadiiPrompt(context);
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations")) == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorNoLocations"));
                        return new QuestReachListPrompt(context);
                    }
                    return new QuestReachNamesPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations"), null);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii"), null);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames"), null);
                    return new QuestReachListPrompt(context);
                }
                case 5: {
                    List locations = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations"));
                    List radius = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii"));
                    List names = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames"));
                    int one = locations != null ? locations.size() : 0;
                    int two = radius != null ? radius.size() : 0;
                    int three = names != null ? names.size() : 0;
                    if (one == two && two == three) {
                        return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestReachListPrompt(context);
                }
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestPasswordListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestPasswordListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorPassword");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.RED;
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorAddPasswordDisplay");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorAddPasswordPhrases");
                }
                case 3: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List displays = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays"));
                    if (displays != null) {
                        for (String display : displays) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(display);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List phrases = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases"));
                    if (phrases != null) {
                        for (String phrase : phrases) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.DARK_AQUA).append(phrase);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestPasswordDisplayPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays")) == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorMustSetPasswordDisplays"));
                        return new QuestPasswordListPrompt(context);
                    }
                    return new QuestPasswordPhrasePrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays"), null);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases"), null);
                    return new QuestPasswordListPrompt(context);
                }
                case 4: {
                    List displays = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays"));
                    List phrases = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases"));
                    int one = displays != null ? displays.size() : 0;
                    int two = phrases != null ? phrases.size() : 0;
                    if (one == two) {
                        return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestPasswordListPrompt(context);
                }
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestCustomObjectiveModulePrompt
    extends QuestsEditorStringPrompt {
        public QuestCustomObjectiveModulePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorModules");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorModulePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!(context.getForWhom() instanceof Player) || !QuestStageMainPrompt.this.plugin.getConfigSettings().canClickablePrompts()) {
                StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
                if (QuestStageMainPrompt.this.plugin.getCustomObjectives().isEmpty()) {
                    text.append(org.bukkit.ChatColor.DARK_AQUA).append(org.bukkit.ChatColor.UNDERLINE).append("https://pikamug.gitbook.io/quests/casual/modules").append(org.bukkit.ChatColor.RESET).append("\n");
                    text.append(org.bukkit.ChatColor.RED).append("(").append(BukkitLang.get("stageEditorNoModules")).append(")").append("\n");
                } else {
                    for (String name : QuestStageMainPrompt.this.plugin.getCustomObjectives().stream().map(CustomObjective::getModuleName).collect(Collectors.toCollection(TreeSet::new))) {
                        text.append(org.bukkit.ChatColor.DARK_PURPLE).append("  - ").append(name).append("\n");
                    }
                }
                return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            }
            TextComponent component = new TextComponent(this.getTitle(context) + "\n");
            component.setColor(ChatColor.LIGHT_PURPLE);
            TextComponent line = new TextComponent("");
            if (QuestStageMainPrompt.this.plugin.getCustomObjectives().isEmpty()) {
                TextComponent link = new TextComponent("https://pikamug.gitbook.io/quests/casual/modules\n");
                link.setColor(ChatColor.DARK_AQUA);
                link.setUnderlined(Boolean.valueOf(true));
                line.addExtra((BaseComponent)link);
                line.addExtra(org.bukkit.ChatColor.RED + "(" + BukkitLang.get("stageEditorNoModules") + ")\n");
            } else {
                for (String name : QuestStageMainPrompt.this.plugin.getCustomObjectives().stream().map(CustomObjective::getModuleName).collect(Collectors.toCollection(TreeSet::new))) {
                    TextComponent click = new TextComponent(org.bukkit.ChatColor.DARK_PURPLE + "  - " + name + "\n");
                    click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + name));
                    line.addExtra((BaseComponent)click);
                }
            }
            component.addExtra((BaseComponent)line);
            component.addExtra(org.bukkit.ChatColor.YELLOW + this.getQueryText(context));
            ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
            return "";
        }

        public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String found = null;
                for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                    if (!co.getModuleName().equalsIgnoreCase(input)) continue;
                    found = co.getModuleName();
                    break;
                }
                if (found == null) {
                    for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                        if (!co.getModuleName().toLowerCase().contains(input.toLowerCase())) continue;
                        found = co.getModuleName();
                        break;
                    }
                }
                if (found != null) {
                    return new QuestCustomObjectivesPrompt(found, context);
                }
            } else {
                if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
                if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"), null);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"), null);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataTemp"), null);
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorCustomCleared"));
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
            }
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorModuleNotFound"));
            return new QuestCustomObjectiveModulePrompt(context);
        }
    }

    public class QuestActionListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 8;

        public QuestActionListPrompt(ConversationContext context) {
            super(context);
            this.size = 8;
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorStageEvents");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 8: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorStartEvent");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorFinishEvent");
                }
                case 3: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorFailEvent");
                }
                case 4: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorDeathEvent");
                }
                case 5: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorDisconnectEvent");
                }
                case 6: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorChatEvents");
                }
                case 7: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorCommandEvents");
                }
                case 8: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "startEvent")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.YELLOW + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "startEvent")) + org.bukkit.ChatColor.YELLOW + ")";
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "finishEvent")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.YELLOW + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "finishEvent")) + org.bukkit.ChatColor.YELLOW + ")";
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "failEvent")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.YELLOW + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "failEvent")) + org.bukkit.ChatColor.YELLOW + ")";
                }
                case 4: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "deathEvent")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.YELLOW + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "deathEvent")) + org.bukkit.ChatColor.YELLOW + ")";
                }
                case 5: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "disconnectEvent")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.YELLOW + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "disconnectEvent")) + org.bukkit.ChatColor.YELLOW + ")";
                }
                case 6: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList chatEvents = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents"));
                    LinkedList chatEventTriggers = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEventTriggers"));
                    if (chatEvents != null && chatEventTriggers != null) {
                        for (String event : chatEvents) {
                            text.append("\n").append(org.bukkit.ChatColor.AQUA).append("     - ").append(event).append(org.bukkit.ChatColor.BLUE).append(" (").append(BukkitLang.get("stageEditorTriggeredBy")).append(": \"").append((String)chatEventTriggers.get(chatEvents.indexOf(event))).append("\")");
                        }
                    }
                    return text.toString();
                }
                case 7: {
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents")) == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList commandEvents = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents"));
                    LinkedList commandEventTriggers = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEventTriggers"));
                    if (commandEvents != null && commandEventTriggers != null) {
                        for (String event : commandEvents) {
                            text.append("\n").append(org.bukkit.ChatColor.AQUA).append("     - ").append(event).append(org.bukkit.ChatColor.BLUE).append(" (").append(BukkitLang.get("stageEditorTriggeredBy")).append(": \"").append((String)commandEventTriggers.get(commandEvents.indexOf(event))).append("\")");
                        }
                    }
                    return text.toString();
                }
                case 8: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 8; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestStartActionPrompt(context);
                }
                case 2: {
                    return new QuestFinishActionPrompt(context);
                }
                case 3: {
                    return new QuestFailActionPrompt(context);
                }
                case 4: {
                    return new QuestDeathActionPrompt(context);
                }
                case 5: {
                    return new QuestDisconnectActionPrompt(context);
                }
                case 6: {
                    return new QuestChatActionPrompt(context);
                }
                case 7: {
                    return new QuestCommandActionPrompt(context);
                }
                case 8: {
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
            }
            return new QuestActionListPrompt(context);
        }
    }

    public class QuestConditionListPrompt
    extends QuestsEditorStringPrompt {
        public QuestConditionListPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorConditions");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorConditionsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedConditions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none")).append("\n");
            } else {
                for (Condition c : QuestStageMainPrompt.this.plugin.getLoadedConditions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(c.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Condition found = null;
                for (Condition c : QuestStageMainPrompt.this.plugin.getLoadedConditions()) {
                    if (!c.getName().equalsIgnoreCase(input)) continue;
                    found = c;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidCondition").replace("<input>", input));
                    return new QuestConditionListPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "condition"), (Object)found.getName());
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "condition"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorConditionCleared"));
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            return new QuestConditionListPrompt(context);
        }
    }

    public class QuestDelayPrompt
    extends QuestsEditorStringPrompt {
        public QuestDelayPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("timePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null) {
                long stageDelay;
                if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
                if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "delay"), null);
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.GREEN + BukkitLang.get("stageEditorDelayCleared"));
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
                try {
                    int i = Integer.parseInt(input);
                    stageDelay = (long)i * 1000L;
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestDelayPrompt(context);
                }
                if (stageDelay < 1000L) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                    return new QuestDelayPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "delay"), (Object)stageDelay);
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestDelayMessagePrompt
    extends QuestsEditorStringPrompt {
        public QuestDelayMessagePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorDelayMessagePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "delayMessage"), (Object)input);
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "delayMessage"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorMessageCleared"));
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            return new QuestDelayMessagePrompt(context);
        }
    }

    public class QuestStartMessagePrompt
    extends QuestsEditorStringPrompt {
        public QuestStartMessagePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorStartMessagePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "startMessage"), (Object)input);
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "startMessage"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorMessageCleared"));
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestCompleteMessagePrompt
    extends QuestsEditorStringPrompt {
        public QuestCompleteMessagePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorCompleteMessagePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "completeMessage"), (Object)input);
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "completeMessage"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorMessageCleared"));
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestStageDeletePrompt
    extends QuestsEditorStringPrompt {
        public final int size = 2;

        public QuestStageDeletePrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.GREEN;
                }
                case 2: {
                    return org.bukkit.ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.YELLOW + this.getQueryText(context) + " (" + org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorStage") + " " + QuestStageMainPrompt.this.stageNum + org.bukkit.ChatColor.YELLOW + ")\n" + org.bukkit.ChatColor.GOLD + "(" + BukkitLang.get("stageEditorConfirmStageNote") + ")\n");
            for (int i = 1; i <= 2; ++i) {
                text.append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append("\n");
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord")))) {
                new QuestStageMenuPrompt(context).deleteStage(context, QuestStageMainPrompt.this.stageNum);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorDeleteSucces"));
                return new QuestStageMenuPrompt(context);
            }
            if (input != null && (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord")))) {
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
            return new QuestStageDeletePrompt(context);
        }
    }

    private class QuestObjectiveCustomDataPrompt
    extends StringPrompt {
        private QuestObjectiveCustomDataPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            String text = "";
            String temp = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataTemp"));
            Map descriptions = (Map)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataDescriptions"));
            if (descriptions != null && descriptions.get(temp) != null) {
                text = text + org.bukkit.ChatColor.GOLD + (String)descriptions.get(temp) + "\n";
            }
            String msg = BukkitLang.get("stageEditorCustomDataPrompt");
            msg = msg.replace("<data>", temp);
            text = text + org.bukkit.ChatColor.YELLOW + msg;
            return text;
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"));
            LinkedList<AbstractMap.SimpleEntry<String, String>> promptList = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            String temp = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataTemp"));
            if (dataMapList != null) {
                for (Map.Entry dataMap : dataMapList) {
                    if (((String)dataMap.getKey()).equals(temp)) {
                        promptList.add(new AbstractMap.SimpleEntry<String, String>((String)dataMap.getKey(), input));
                        continue;
                    }
                    promptList.add(new AbstractMap.SimpleEntry((String)dataMap.getKey(), dataMap.getValue()));
                }
            }
            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"), promptList);
            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataTemp"), null);
            return new QuestObjectiveCustomDataListPrompt();
        }
    }

    private class QuestObjectiveCustomDataListPrompt
    extends StringPrompt {
        private QuestObjectiveCustomDataListPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.GOLD + "- ");
            LinkedList list = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"));
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"));
            if (list != null && QuestStageMainPrompt.this.plugin != null) {
                String objName = (String)list.getLast();
                CustomObjective found = null;
                for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                    if (!co.getName().equals(objName)) continue;
                    found = co;
                    break;
                }
                if (found == null) {
                    return "Could not find custom objective";
                }
                text.append(objName).append(" -\n");
                int index = 1;
                for (Map.Entry entry : found.getData()) {
                    if (dataMapList == null) continue;
                    for (Map.Entry currentData : dataMapList) {
                        if (!((String)currentData.getKey()).equals(entry.getKey())) continue;
                        text.append(org.bukkit.ChatColor.BLUE).append(org.bukkit.ChatColor.BOLD).append(index).append(org.bukkit.ChatColor.RESET).append(org.bukkit.ChatColor.YELLOW).append(" - ").append((String)entry.getKey());
                        if (currentData.getValue() != null) {
                            text.append(org.bukkit.ChatColor.GRAY).append(" (").append(org.bukkit.ChatColor.AQUA).append(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)currentData.getValue().toString())).append(org.bukkit.ChatColor.GRAY).append(")\n");
                        } else {
                            text.append(org.bukkit.ChatColor.GRAY).append(" (").append(BukkitLang.get("noneSet")).append(org.bukkit.ChatColor.GRAY).append(")\n");
                        }
                        ++index;
                    }
                }
                text.append(org.bukkit.ChatColor.GREEN).append(org.bukkit.ChatColor.BOLD).append(index).append(org.bukkit.ChatColor.YELLOW).append(" - ").append(BukkitLang.get("done"));
            }
            return text.toString();
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            LinkedList list = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"));
            if (list != null && QuestStageMainPrompt.this.plugin != null) {
                int numInput;
                String objName = (String)list.getLast();
                CustomObjective found = null;
                for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                    if (!co.getName().equals(objName)) continue;
                    found = co;
                    break;
                }
                if (found == null) {
                    QuestStageMainPrompt.this.plugin.getLogger().severe("Could not find custom objective following input: " + input);
                    return new QuestObjectiveCustomDataListPrompt();
                }
                LinkedList<Map.Entry<String, Object>> dataMapList = found.getData();
                try {
                    numInput = Integer.parseInt(input);
                }
                catch (NumberFormatException nfe) {
                    return new QuestObjectiveCustomDataListPrompt();
                }
                if (numInput < 1 || numInput > dataMapList.size() + 1) {
                    return new QuestObjectiveCustomDataListPrompt();
                }
                if (numInput < dataMapList.size() + 1) {
                    LinkedList<String> dataMapKeys = new LinkedList<String>();
                    for (Map.Entry entry : dataMapList) {
                        dataMapKeys.add((String)entry.getKey());
                    }
                    String selectedKey = (String)dataMapKeys.get(numInput - 1);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataTemp"), (Object)selectedKey);
                    return new QuestObjectiveCustomDataPrompt();
                }
                LinkedList dataMaps = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"));
                if (dataMaps != null) {
                    for (Map.Entry entry : dataMaps) {
                        if (entry.getValue() != null) continue;
                        return new QuestObjectiveCustomDataListPrompt();
                    }
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataDescriptions"), null);
                return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    private class QuestCustomObjectiveCountPrompt
    extends StringPrompt {
        private QuestCustomObjectiveCountPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.GOLD + "- ");
            LinkedList list = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"));
            if (list != null && QuestStageMainPrompt.this.plugin != null) {
                String objName = (String)list.getLast();
                text.append(objName).append(" -\n");
                CustomObjective found = null;
                for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                    if (!co.getName().equals(objName)) continue;
                    found = co;
                    break;
                }
                if (found != null) {
                    text.append(org.bukkit.ChatColor.YELLOW).append(found.getCountPrompt());
                }
            }
            return text.toString();
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            try {
                int num = Integer.parseInt(input);
                LinkedList counts = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveCounts"));
                LinkedList list = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"));
                if (counts != null && list != null && QuestStageMainPrompt.this.plugin != null) {
                    counts.set(counts.size() - 1, num);
                    String objName = (String)list.getLast();
                    CustomObjective found = null;
                    for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                        if (!co.getName().equals(objName)) continue;
                        found = co;
                        break;
                    }
                    if (found != null && !found.getData().isEmpty()) {
                        context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataDescriptions"), found.getDescriptions());
                        return new QuestObjectiveCustomDataListPrompt();
                    }
                    return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                }
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                return new QuestCustomObjectiveCountPrompt();
            }
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestCustomObjectivesPrompt
    extends QuestsEditorStringPrompt {
        private final String moduleName;

        public QuestCustomObjectivesPrompt(String moduleName, ConversationContext context) {
            super(context);
            this.moduleName = moduleName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("customObjectivesTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorCustomPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!(context.getForWhom() instanceof Player) || !QuestStageMainPrompt.this.plugin.getConfigSettings().canClickablePrompts()) {
                StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + "- " + this.getTitle(context) + " -\n");
                if (QuestStageMainPrompt.this.plugin.getCustomObjectives().isEmpty()) {
                    text.append(org.bukkit.ChatColor.DARK_AQUA).append(org.bukkit.ChatColor.UNDERLINE).append("https://pikamug.gitbook.io/quests/casual/modules\n");
                    text.append(org.bukkit.ChatColor.RED).append("(").append(BukkitLang.get("stageEditorNoModules")).append(")\n");
                } else {
                    for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                        if (!co.getModuleName().equals(this.moduleName)) continue;
                        text.append(org.bukkit.ChatColor.DARK_PURPLE).append("  - ").append(co.getName()).append("\n");
                    }
                }
                return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            }
            TextComponent component = new TextComponent(this.getTitle(context) + "\n");
            component.setColor(ChatColor.LIGHT_PURPLE);
            TextComponent line = new TextComponent("");
            if (QuestStageMainPrompt.this.plugin.getCustomObjectives().isEmpty()) {
                TextComponent link = new TextComponent("https://pikamug.gitbook.io/quests/casual/modules\n");
                link.setColor(ChatColor.DARK_AQUA);
                link.setUnderlined(Boolean.valueOf(true));
                line.addExtra((BaseComponent)link);
                line.addExtra(org.bukkit.ChatColor.RED + "(" + BukkitLang.get("stageEditorNoModules") + ")\n");
            } else {
                for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                    if (!co.getModuleName().equals(this.moduleName)) continue;
                    TextComponent click = new TextComponent(org.bukkit.ChatColor.DARK_PURPLE + "  - " + co.getName() + "\n");
                    click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + co.getName()));
                    line.addExtra((BaseComponent)click);
                }
            }
            component.addExtra((BaseComponent)line);
            component.addExtra(org.bukkit.ChatColor.YELLOW + this.getQueryText(context));
            ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
            return "";
        }

        /*
         * Enabled aggressive block sorting
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                CustomObjective found;
                block9: {
                    LinkedList dataMapList;
                    found = null;
                    for (CustomObjective co : QuestStageMainPrompt.this.plugin.getCustomObjectives()) {
                        if (!co.getModuleName().equals(this.moduleName) || !co.getName().toLowerCase().contains(input.toLowerCase())) continue;
                        found = co;
                        break;
                    }
                    if (found == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorModuleNotFound"));
                        return new QuestCustomObjectivesPrompt(this.moduleName, context);
                    }
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives")) != null) {
                        LinkedList list = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"));
                        dataMapList = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"));
                        LinkedList countList = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveCounts"));
                        if (list != null && !list.contains(found.getName()) && dataMapList != null && countList != null) {
                            list.add(found.getName());
                            dataMapList.addAll(found.getData());
                            countList.add(-999);
                            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"), (Object)list);
                            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"), (Object)dataMapList);
                            break block9;
                        } else {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorCustomAlreadyAdded"));
                            return new QuestCustomObjectivesPrompt(this.moduleName, context);
                        }
                    }
                    LinkedList<Integer> countList = new LinkedList<Integer>();
                    dataMapList = new LinkedList(found.getData());
                    countList.add(-999);
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(found.getName());
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"), list);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"), (Object)dataMapList);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveCounts"), countList);
                }
                if (found.canShowCount()) {
                    return new QuestCustomObjectiveCountPrompt();
                }
                if (found.getData().isEmpty()) return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataDescriptions"), found.getDescriptions());
                return new QuestObjectiveCustomDataListPrompt();
            }
            if (input == null || !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectives"), null);
            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveData"), null);
            context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "customObjectiveDataTemp"), null);
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorCustomCleared"));
            return new QuestStageMainPrompt(QuestStageMainPrompt.this.stageNum, context);
        }
    }

    public class QuestCommandActionTriggerPrompt
    extends QuestsEditorStringPrompt {
        public QuestCommandActionTriggerPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorCommandTrigger");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            String tempEvent = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandTempEvent"));
            if (tempEvent != null) {
                return BukkitLang.get("stageEditorCommandEventsTriggerPrompt").replace("<event>", tempEvent).replace("<action>", tempEvent);
            }
            return BukkitLang.get("stageEditorCommandEventsTriggerPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String tempEvent = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandTempEvent"));
            String text = org.bukkit.ChatColor.GOLD + "- " + this.getTitle(context) + " -\n";
            if (tempEvent != null) {
                text = text + org.bukkit.ChatColor.YELLOW + this.getQueryText(context).replaceFirst(tempEvent, org.bukkit.ChatColor.AQUA + tempEvent + org.bukkit.ChatColor.YELLOW);
            }
            return text;
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents")) == null) {
                    LinkedList<String> commandEvents = new LinkedList<String>();
                    LinkedList<String> commandEventTriggers = new LinkedList<String>();
                    String event = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandTempEvent"));
                    commandEvents.add(event);
                    commandEventTriggers.add(input.trim());
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents"), commandEvents);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEventTriggers"), commandEventTriggers);
                    return new QuestActionListPrompt(context);
                }
                LinkedList commandEvents = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents"));
                LinkedList commandEventTriggers = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEventTriggers"));
                String event = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandTempEvent"));
                if (commandEvents != null && commandEventTriggers != null) {
                    commandEvents.add(event);
                    commandEventTriggers.add(input.trim());
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents"), (Object)commandEvents);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEventTriggers"), (Object)commandEventTriggers);
                }
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            return new QuestCommandActionTriggerPrompt(context);
        }
    }

    public class QuestCommandActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestCommandActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorCommandEvents");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorCommandEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none"));
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestCommandActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandTempEvent"), (Object)found.getName());
                return new QuestCommandActionTriggerPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEvents"), null);
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "commandEventTriggers"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorCommandEventsCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestCommandActionPrompt(context);
        }
    }

    public class QuestChatActionTriggerPrompt
    extends QuestsEditorStringPrompt {
        public QuestChatActionTriggerPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorChatTrigger");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            String tempEvent = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatTempEvent"));
            if (tempEvent != null) {
                return BukkitLang.get("stageEditorChatEventsTriggerPrompt").replace("<event>", tempEvent).replace("<action>", tempEvent);
            }
            return BukkitLang.get("stageEditorChatEventsTriggerPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String tempEvent = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatTempEvent"));
            String text = org.bukkit.ChatColor.GOLD + "- " + this.getTitle(context) + " -\n";
            if (tempEvent != null) {
                text = text + org.bukkit.ChatColor.YELLOW + this.getQueryText(context).replaceFirst(tempEvent, org.bukkit.ChatColor.AQUA + tempEvent + org.bukkit.ChatColor.YELLOW);
            }
            return text;
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents")) == null) {
                    LinkedList<String> chatEvents = new LinkedList<String>();
                    LinkedList<String> chatEventTriggers = new LinkedList<String>();
                    String event = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatTempEvent"));
                    chatEvents.add(event);
                    chatEventTriggers.add(input.trim());
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents"), chatEvents);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEventTriggers"), chatEventTriggers);
                    return new QuestActionListPrompt(context);
                }
                LinkedList chatEvents = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents"));
                LinkedList chatEventTriggers = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEventTriggers"));
                String event = (String)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatTempEvent"));
                if (chatEvents != null && chatEventTriggers != null) {
                    chatEvents.add(event);
                    chatEventTriggers.add(input.trim());
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents"), (Object)chatEvents);
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEventTriggers"), (Object)chatEventTriggers);
                }
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            return new QuestChatActionTriggerPrompt(context);
        }
    }

    public class QuestChatActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestChatActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorChatEvents");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorChatEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none"));
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestChatActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatTempEvent"), (Object)found.getName());
                return new QuestChatActionTriggerPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEvents"), null);
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "chatEventTriggers"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorChatEventsCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestChatActionPrompt(context);
        }
    }

    public class QuestDisconnectActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestDisconnectActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorDisconnectEvent");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none"));
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestDisconnectActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "disconnectEvent"), (Object)found.getName());
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "disconnectEvent"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorEventCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestDisconnectActionPrompt(context);
        }
    }

    public class QuestDeathActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestDeathActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorDeathEvent");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none")).append("\n");
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestDeathActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "deathEvent"), (Object)found.getName());
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "deathEvent"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorEventCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestDeathActionPrompt(context);
        }
    }

    public class QuestFailActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestFailActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorFailEvent");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none"));
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestFailActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "failEvent"), (Object)found.getName());
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "failEvent"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorEventCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestFailActionPrompt(context);
        }
    }

    public class QuestFinishActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestFinishActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorFinishEvent");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none"));
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestFinishActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "finishEvent"), (Object)found.getName());
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "finishEvent"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorEventCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestFinishActionPrompt(context);
        }
    }

    public class QuestStartActionPrompt
    extends QuestsEditorStringPrompt {
        public QuestStartActionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorStartEvent");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEventsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            if (QuestStageMainPrompt.this.plugin.getLoadedActions().isEmpty()) {
                text.append(org.bukkit.ChatColor.RED).append("- ").append(BukkitLang.get("none")).append("\n");
            } else {
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    text.append(org.bukkit.ChatColor.GREEN).append("- ").append(a.getName()).append("\n");
                }
            }
            return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                Action found = null;
                for (Action a : QuestStageMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    found = a;
                    break;
                }
                if (found == null) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorInvalidEvent").replace("<input>", input));
                    return new QuestStartActionPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "startEvent"), (Object)found.getName());
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestActionListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "startEvent"), null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorEventCleared"));
                return new QuestActionListPrompt(context);
            }
            return new QuestStartActionPrompt(context);
        }
    }

    public class QuestPasswordPhrasePrompt
    extends QuestsEditorStringPrompt {
        public QuestPasswordPhrasePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorPasswordPhrasePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context) + "\n";
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases")) != null) {
                    List phrases = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases"));
                    if (phrases != null) {
                        phrases.addAll(Arrays.asList(input.split(BukkitLang.get("charSemi"))));
                    }
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases"), (Object)phrases);
                } else {
                    LinkedList<String> phrases = new LinkedList<String>(Arrays.asList(input.split(BukkitLang.get("charSemi"))));
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordPhrases"), phrases);
                }
            }
            return new QuestPasswordListPrompt(context);
        }
    }

    public class QuestPasswordDisplayPrompt
    extends QuestsEditorStringPrompt {
        public QuestPasswordDisplayPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorPasswordDisplayPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context) + "\n";
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays")) != null) {
                    List displays = (List)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays"));
                    if (displays != null) {
                        displays.addAll(Arrays.asList(input.split(BukkitLang.get("charSemi"))));
                    }
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays"), (Object)displays);
                } else {
                    LinkedList<String> displays = new LinkedList<String>(Arrays.asList(input.split(BukkitLang.get("charSemi"))));
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "passwordDisplays"), displays);
                }
            }
            return new QuestPasswordListPrompt(context);
        }
    }

    public class QuestReachNamesPrompt
    extends QuestsEditorStringPrompt {
        public QuestReachNamesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorReachLocationNamesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> locNames = new LinkedList<String>(Arrays.asList(input.split(BukkitLang.get("charSemi"))));
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames"), locNames);
            }
            return new QuestReachListPrompt(context);
        }
    }

    public class QuestReachRadiiPrompt
    extends QuestsEditorStringPrompt {
        public QuestReachRadiiPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorReachLocationRadiiPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Integer> radii = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        if (i < 1) {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestReachRadiiPrompt(context);
                        }
                        radii.add(i);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                        return new QuestReachRadiiPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii"), radii);
            }
            return new QuestReachListPrompt(context);
        }
    }

    public class QuestReachLocationPrompt
    extends QuestsEditorStringPrompt {
        public QuestReachLocationPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorReachLocationPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestStageMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            Player player = (Player)context.getForWhom();
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdAdd"))) {
                LinkedList names;
                LinkedList amounts;
                Block block = QuestStageMainPrompt.this.plugin.getQuestFactory().getSelectedReachLocations().get(player.getUniqueId());
                if (block != null) {
                    LinkedList locations;
                    Location loc = block.getLocation();
                    LinkedList linkedList = locations = context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations")) != null ? (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations")) : new LinkedList();
                    if (locations != null) {
                        locations.add(BukkitConfigUtil.getLocationInfo(loc));
                    }
                    context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocations"), (Object)locations);
                    amounts = new LinkedList();
                    names = new LinkedList();
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii")) != null) {
                        amounts = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii"));
                    }
                    if (context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames")) != null) {
                        names = (LinkedList)context.getSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames"));
                    }
                    if (locations != null && amounts != null && names != null) {
                        for (int i = 0; i < locations.size(); ++i) {
                            if (i >= amounts.size()) {
                                amounts.add(5);
                            }
                            if (i < names.size()) continue;
                            names.add(BukkitLang.get("location").replace("<id>", "#" + (i + 1)));
                        }
                    }
                } else {
                    player.sendMessage(org.bukkit.ChatColor.RED + BukkitLang.get("stageEditorNoBlockSelected"));
                    return new QuestReachLocationPrompt(context);
                }
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationRadii"), (Object)amounts);
                context.setSessionData((Object)(QuestStageMainPrompt.this.stagePrefix + "reachLocationNames"), (Object)names);
                ConcurrentHashMap<UUID, Block> temp = QuestStageMainPrompt.this.plugin.getQuestFactory().getSelectedReachLocations();
                temp.remove(player.getUniqueId());
                QuestStageMainPrompt.this.plugin.getQuestFactory().setSelectedReachLocations(temp);
                return new QuestReachListPrompt(context);
            }
            if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> temp = QuestStageMainPrompt.this.plugin.getQuestFactory().getSelectedReachLocations();
                temp.remove(player.getUniqueId());
                QuestStageMainPrompt.this.plugin.getQuestFactory().setSelectedReachLocations(temp);
                return new QuestReachListPrompt(context);
            }
            return new QuestReachLocationPrompt(context);
        }
    }
}

