/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.stages;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMainPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestStageMenuPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 2;

    public QuestStageMenuPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("stageEditorStages");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        int stages = this.getStages(context);
        if (number > 0) {
            if (number < stages + 1) {
                return ChatColor.BLUE;
            }
            if (number == stages + 1) {
                return ChatColor.BLUE;
            }
            if (number == stages + 2) {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        int stages = this.getStages(context);
        if (number > 0) {
            if (number < stages + 1) {
                return ChatColor.GOLD + BukkitLang.get("stageEditorEditStage") + " " + number;
            }
            if (number == stages + 1) {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorNewStage");
            }
            if (number == stages + 2) {
                return ChatColor.YELLOW + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.LIGHT_PURPLE + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= this.getStages(context) + 2; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        int i = input.intValue();
        int stages = this.getStages(context);
        if (i > 0) {
            if (i < stages + 1) {
                return new QuestStageMainPrompt(i, context);
            }
            if (i == stages + 1) {
                return new QuestStageMainPrompt(stages + 1, context);
            }
            if (i == stages + 2) {
                return this.plugin.getQuestFactory().returnToMenu(context);
            }
        }
        return new QuestStageMenuPrompt(context);
    }

    public int getStages(ConversationContext context) {
        int num = 1;
        while (context.getSessionData((Object)("stage" + num)) != null) {
            ++num;
        }
        return num - 1;
    }

    public void deleteStage(ConversationContext context, int stageNum) {
        boolean last;
        int stages = this.getStages(context);
        int current = stageNum;
        String pref = "stage" + current;
        boolean bl = last = stageNum == stages;
        do {
            if (!last) {
                if (++current > stages) break;
                pref = "stage" + current;
                String newPref = "stage" + (current - 1);
                context.setSessionData((Object)(newPref + "breakNames"), context.getSessionData((Object)(pref + "breakNames")));
                context.setSessionData((Object)(newPref + "breakAmounts"), context.getSessionData((Object)(pref + "breakAmounts")));
                context.setSessionData((Object)(newPref + "breakDurability"), context.getSessionData((Object)(pref + "breakDurability")));
                context.setSessionData((Object)(newPref + "damageNames"), context.getSessionData((Object)(pref + "damageNames")));
                context.setSessionData((Object)(newPref + "damageAmounts"), context.getSessionData((Object)(pref + "damageAmounts")));
                context.setSessionData((Object)(newPref + "damageDurability"), context.getSessionData((Object)(pref + "damageDurability")));
                context.setSessionData((Object)(newPref + "placeNames"), context.getSessionData((Object)(pref + "placeNames")));
                context.setSessionData((Object)(newPref + "placeNames"), context.getSessionData((Object)(pref + "placeAmounts")));
                context.setSessionData((Object)(newPref + "placeDurability"), context.getSessionData((Object)(pref + "placeDurability")));
                context.setSessionData((Object)(newPref + "useNames"), context.getSessionData((Object)(pref + "useNames")));
                context.setSessionData((Object)(newPref + "useAmounts"), context.getSessionData((Object)(pref + "useAmounts")));
                context.setSessionData((Object)(newPref + "useDurability"), context.getSessionData((Object)(pref + "useDurability")));
                context.setSessionData((Object)(newPref + "cutNames"), context.getSessionData((Object)(pref + "cutNames")));
                context.setSessionData((Object)(newPref + "cutAmounts"), context.getSessionData((Object)(pref + "cutAmounts")));
                context.setSessionData((Object)(newPref + "cutDurability"), context.getSessionData((Object)(pref + "cutDurability")));
                context.setSessionData((Object)(newPref + "craftItems"), context.getSessionData((Object)(pref + "craftItems")));
                context.setSessionData((Object)(newPref + "smeltItems"), context.getSessionData((Object)(pref + "smeltItems")));
                context.setSessionData((Object)(newPref + "enchantItems"), context.getSessionData((Object)(pref + "enchantItems")));
                context.setSessionData((Object)(newPref + "brewItems"), context.getSessionData((Object)(pref + "brewItems")));
                context.setSessionData((Object)(newPref + "fish"), context.getSessionData((Object)(pref + "fish")));
                context.setSessionData((Object)(newPref + "playerKill"), context.getSessionData((Object)(pref + "playerKill")));
                context.setSessionData((Object)(newPref + "deliveryItems"), context.getSessionData((Object)(pref + "deliveryItems")));
                context.setSessionData((Object)(newPref + "deliveryNPCs"), context.getSessionData((Object)(pref + "deliveryNPCs")));
                context.setSessionData((Object)(newPref + "deliveryMessages"), context.getSessionData((Object)(pref + "deliveryMessages")));
                context.setSessionData((Object)(newPref + "npcIdsToTalkTo"), context.getSessionData((Object)(pref + "npcIdsToTalkTo")));
                context.setSessionData((Object)(newPref + "npcIdsToKill"), context.getSessionData((Object)(pref + "npcIdsToKill")));
                context.setSessionData((Object)(newPref + "npcAmountsToKill"), context.getSessionData((Object)(pref + "npcAmountsToKill")));
                context.setSessionData((Object)(newPref + "mobTypes"), context.getSessionData((Object)(pref + "mobTypes")));
                context.setSessionData((Object)(newPref + "mobAmounts"), context.getSessionData((Object)(pref + "mobAmounts")));
                context.setSessionData((Object)(newPref + "killLocations"), context.getSessionData((Object)(pref + "killLocations")));
                context.setSessionData((Object)(newPref + "killLocationRadii"), context.getSessionData((Object)(pref + "killLocationRadii")));
                context.setSessionData((Object)(newPref + "killLocationNames"), context.getSessionData((Object)(pref + "killLocationNames")));
                context.setSessionData((Object)(newPref + "reachLocations"), context.getSessionData((Object)(pref + "reachLocations")));
                context.setSessionData((Object)(newPref + "reachLocationRadii"), context.getSessionData((Object)(pref + "reachLocationRadii")));
                context.setSessionData((Object)(newPref + "reachLocationNames"), context.getSessionData((Object)(pref + "reachLocationNames")));
                context.setSessionData((Object)(newPref + "tameTypes"), context.getSessionData((Object)(pref + "tameTypes")));
                context.setSessionData((Object)(newPref + "tameAmounts"), context.getSessionData((Object)(pref + "tameAmounts")));
                context.setSessionData((Object)(newPref + "shearColors"), context.getSessionData((Object)(pref + "shearColors")));
                context.setSessionData((Object)(newPref + "shearAmounts"), context.getSessionData((Object)(pref + "shearAmounts")));
                context.setSessionData((Object)(newPref + "startEvent"), context.getSessionData((Object)(pref + "startEvent")));
                context.setSessionData((Object)(newPref + "disconnectEvent"), context.getSessionData((Object)(pref + "disconnectEvent")));
                context.setSessionData((Object)(newPref + "deathEvent"), context.getSessionData((Object)(pref + "deathEvent")));
                context.setSessionData((Object)(newPref + "chatEvents"), context.getSessionData((Object)(pref + "chatEvents")));
                context.setSessionData((Object)(newPref + "chatEventTriggers"), context.getSessionData((Object)(pref + "chatEventTriggers")));
                context.setSessionData((Object)(newPref + "finishEvent"), context.getSessionData((Object)(pref + "finishEvent")));
                context.setSessionData((Object)(newPref + "customObjectives"), context.getSessionData((Object)(pref + "customObjectives")));
                context.setSessionData((Object)(newPref + "customObjectiveData"), context.getSessionData((Object)(pref + "customObjectiveData")));
                context.setSessionData((Object)(newPref + "customObjectiveCounts"), context.getSessionData((Object)(pref + "customObjectiveCounts")));
                context.setSessionData((Object)(newPref + "customObjectiveDataDescriptions"), context.getSessionData((Object)(pref + "customObjectiveDataDescriptions")));
                context.setSessionData((Object)(newPref + "customObjectiveDataTemp"), context.getSessionData((Object)(pref + "customObjectiveDataTemp")));
                context.setSessionData((Object)(newPref + "passwordDisplays"), context.getSessionData((Object)(pref + "passwordDisplays")));
                context.setSessionData((Object)(newPref + "passwordPhrases"), context.getSessionData((Object)(pref + "passwordPhrases")));
                context.setSessionData((Object)(newPref + "overrideDisplay"), context.getSessionData((Object)(pref + "overrideDisplay")));
                context.setSessionData((Object)(newPref + "delay"), context.getSessionData((Object)(pref + "delay")));
                context.setSessionData((Object)(newPref + "delayMessage"), context.getSessionData((Object)(pref + "delayMessage")));
                context.setSessionData((Object)(newPref + "denizen"), context.getSessionData((Object)(pref + "denizen")));
                context.setSessionData((Object)(newPref + "completeMessage"), context.getSessionData((Object)(pref + "completeMessage")));
                context.setSessionData((Object)(newPref + "startMessage"), context.getSessionData((Object)(pref + "startMessage")));
            }
            context.setSessionData((Object)(pref + "breakNames"), null);
            context.setSessionData((Object)(pref + "breakAmounts"), null);
            context.setSessionData((Object)(pref + "breakDurability"), null);
            context.setSessionData((Object)(pref + "damageNames"), null);
            context.setSessionData((Object)(pref + "damageAmounts"), null);
            context.setSessionData((Object)(pref + "damageDurability"), null);
            context.setSessionData((Object)(pref + "placeNames"), null);
            context.setSessionData((Object)(pref + "placeAmounts"), null);
            context.setSessionData((Object)(pref + "placeDurability"), null);
            context.setSessionData((Object)(pref + "useNames"), null);
            context.setSessionData((Object)(pref + "useAmounts"), null);
            context.setSessionData((Object)(pref + "useDurability"), null);
            context.setSessionData((Object)(pref + "cutNames"), null);
            context.setSessionData((Object)(pref + "cutAmounts"), null);
            context.setSessionData((Object)(pref + "cutDurability"), null);
            context.setSessionData((Object)(pref + "craftItems"), null);
            context.setSessionData((Object)(pref + "smeltItems"), null);
            context.setSessionData((Object)(pref + "enchantItems"), null);
            context.setSessionData((Object)(pref + "brewItems"), null);
            context.setSessionData((Object)(pref + "fish"), null);
            context.setSessionData((Object)(pref + "playerKill"), null);
            context.setSessionData((Object)(pref + "deliveryItems"), null);
            context.setSessionData((Object)(pref + "deliveryNPCs"), null);
            context.setSessionData((Object)(pref + "deliveryMessages"), null);
            context.setSessionData((Object)(pref + "npcIdsToTalkTo"), null);
            context.setSessionData((Object)(pref + "npcIdsToKill"), null);
            context.setSessionData((Object)(pref + "npcAmountsToKill"), null);
            context.setSessionData((Object)(pref + "mobTypes"), null);
            context.setSessionData((Object)(pref + "mobAmounts"), null);
            context.setSessionData((Object)(pref + "killLocations"), null);
            context.setSessionData((Object)(pref + "killLocationRadii"), null);
            context.setSessionData((Object)(pref + "killLocationNames"), null);
            context.setSessionData((Object)(pref + "reachLocations"), null);
            context.setSessionData((Object)(pref + "reachLocationRadii"), null);
            context.setSessionData((Object)(pref + "reachLocationNames"), null);
            context.setSessionData((Object)(pref + "tameTypes"), null);
            context.setSessionData((Object)(pref + "tameAmounts"), null);
            context.setSessionData((Object)(pref + "shearColors"), null);
            context.setSessionData((Object)(pref + "shearAmounts"), null);
            context.setSessionData((Object)(pref + "finishEvent"), null);
            context.setSessionData((Object)(pref + "startEvent"), null);
            context.setSessionData((Object)(pref + "deathEvent"), null);
            context.setSessionData((Object)(pref + "chatEvents"), null);
            context.setSessionData((Object)(pref + "chatEventTriggers"), null);
            context.setSessionData((Object)(pref + "disconnectEvent"), null);
            context.setSessionData((Object)(pref + "customObjectives"), null);
            context.setSessionData((Object)(pref + "customObjectiveData"), null);
            context.setSessionData((Object)(pref + "customObjectiveCounts"), null);
            context.setSessionData((Object)(pref + "customObjectiveDataDescriptions"), null);
            context.setSessionData((Object)(pref + "customObjectiveDataTemp"), null);
            context.setSessionData((Object)(pref + "passwordDisplays"), null);
            context.setSessionData((Object)(pref + "passwordPhrases"), null);
            context.setSessionData((Object)(pref + "overrideDisplay"), null);
            context.setSessionData((Object)(pref + "delay"), null);
            context.setSessionData((Object)(pref + "delayMessage"), null);
            context.setSessionData((Object)(pref + "denizen"), null);
            context.setSessionData((Object)(pref + "completeMessage"), null);
            context.setSessionData((Object)(pref + "startMessage"), null);
        } while (!last);
        if (!last) {
            context.setSessionData((Object)("stage" + (current - 1)), null);
        } else {
            context.setSessionData((Object)("stage" + current), null);
        }
    }
}

