/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies;

import com.alessiodp.parties.api.Parties;
import com.alessiodp.parties.api.interfaces.PartiesAPI;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.UserManager;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.Dependencies;
import me.pikamug.quests.dependencies.npc.BukkitEntityNpcDependency;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.dependencies.npc.citizens.BukkitCitizensDependency;
import me.pikamug.quests.dependencies.npc.znpcsplus.BukkitZnpcsPlusDependency;
import me.pikamug.quests.dependencies.npc.znpcsplus.legacy.BukkitZnpcsPlusLegacyDependency;
import me.pikamug.quests.dependencies.reflect.denizen.DenizenAPI;
import me.pikamug.quests.dependencies.reflect.worldguard.WorldGuardAPI;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.unite.api.objects.PartyProvider;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ro.niconeko.astralbooks.api.AstralBooks;
import ro.niconeko.astralbooks.api.AstralBooksAPI;

public class BukkitDependencies
implements Dependencies {
    private static final Set<PartyProvider> partyProviders = new HashSet<PartyProvider>();
    private static final Set<BukkitNpcDependency> npcDependencies = new HashSet<BukkitNpcDependency>();
    public static PlaceholderAPIPlugin placeholder = null;
    private static Economy economy = null;
    private static Permission permission = null;
    private static PartyProvider partyProvider = null;
    private static WorldGuardAPI worldGuard = null;
    private static mcMMO mcmmo = null;
    private static Heroes heroes = null;
    private static DenizenAPI denizen = null;
    private static AstralBooksAPI astralBooks = null;
    private static PartiesAPI parties = null;
    private final BukkitQuestsPlugin plugin;
    private int npcEffectThread = -1;

    public BukkitDependencies(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    public Economy getVaultEconomy() {
        if (economy == null && this.isPluginAvailable("Vault") && !this.setupEconomy()) {
            this.plugin.getLogger().warning("Economy provider not found.");
        }
        return economy;
    }

    public Permission getVaultPermission() {
        if (permission == null && this.isPluginAvailable("Vault") && !this.setupPermissions()) {
            this.plugin.getLogger().warning("Permission provider not found.");
        }
        return permission;
    }

    public PartyProvider getPartyProvider() {
        if (partyProvider == null && this.isPluginAvailable("Unite") && !this.setupParty()) {
            this.plugin.getLogger().warning("Party provider not found.");
        }
        return partyProvider;
    }

    public Set<PartyProvider> getPartyProviders() {
        if (partyProvider == null && this.isPluginAvailable("Unite") && !this.setupParty()) {
            this.plugin.getLogger().warning("Party providers not found.");
        }
        return partyProviders;
    }

    public WorldGuardAPI getWorldGuardApi() {
        if (worldGuard == null && this.isPluginAvailable("WorldGuard")) {
            worldGuard = new WorldGuardAPI(this.plugin.getServer().getPluginManager().getPlugin("WorldGuard"));
        }
        return worldGuard;
    }

    public mcMMO getMcmmoClassic() {
        if (mcmmo == null && this.isPluginAvailable("mcMMO")) {
            try {
                Class.forName("com.gmail.nossr50.datatypes.skills.SkillType");
                mcmmo = (mcMMO)this.plugin.getServer().getPluginManager().getPlugin("mcMMO");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mcmmo;
    }

    public Heroes getHeroes() {
        if (heroes == null && this.isPluginAvailable("Heroes")) {
            heroes = (Heroes)this.plugin.getServer().getPluginManager().getPlugin("Heroes");
        }
        return heroes;
    }

    public PlaceholderAPIPlugin getPlaceholderApi() {
        if (placeholder == null && this.isPluginAvailable("PlaceholderAPI")) {
            placeholder = (PlaceholderAPIPlugin)this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        }
        return placeholder;
    }

    public Set<BukkitNpcDependency> getNpcDependencies() {
        return npcDependencies;
    }

    public boolean hasAnyNpcDependencies() {
        return !npcDependencies.isEmpty();
    }

    public boolean hasAnyEntityNpcDependencies() {
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            if (!(npcDependency instanceof BukkitEntityNpcDependency)) continue;
            return true;
        }
        return false;
    }

    public BukkitNpcDependency getNpcDependency(String dependencyName) {
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            if (!npcDependency.getLabel().equalsIgnoreCase(dependencyName)) continue;
            return npcDependency;
        }
        return null;
    }

    public void addNpcDependency(BukkitNpcDependency npcDependency) {
        npcDependencies.add(npcDependency);
        this.plugin.getLogger().info("Successfully linked Quests with " + npcDependency.getLabel());
        this.startNpcEffectThread();
    }

    private void initNpcDependency() {
        if (this.isPluginAvailable("Citizens")) {
            try {
                this.addNpcDependency(new BukkitCitizensDependency(this.plugin));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Legacy version of Citizens found. Citizens in Quests not enabled.");
            }
        }
        if (this.isPluginAvailable("ZNPCsPlus")) {
            try {
                Class.forName("lol.pyr.znpcsplus.ZNPCsPlus");
                this.addNpcDependency(new BukkitZnpcsPlusLegacyDependency(this.plugin));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Class.forName("lol.pyr.znpcsplus.ZNpcsPlus");
                this.addNpcDependency(new BukkitZnpcsPlusDependency(this.plugin));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DenizenAPI getDenizenApi() {
        if (denizen == null && this.isPluginAvailable("Denizen")) {
            denizen = new DenizenAPI();
        }
        return denizen;
    }

    public AstralBooksAPI getAstralBooksApi() {
        if (astralBooks == null && this.isPluginAvailable("AstralBooks")) {
            try {
                astralBooks = ((AstralBooks)Objects.requireNonNull(this.plugin.getServer().getPluginManager().getPlugin("AstralBooks"))).getAPI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return astralBooks;
    }

    public PartiesAPI getPartiesApi() {
        if (parties == null && this.isPluginAvailable("Parties")) {
            try {
                Class.forName("com.alessiodp.parties.api.Parties");
                parties = Parties.getApi();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parties;
    }

    @Override
    public boolean isPluginAvailable(String pluginName) {
        if (this.plugin.getServer().getPluginManager().getPlugin(pluginName) != null) {
            try {
                if (Objects.requireNonNull(this.plugin.getServer().getPluginManager().getPlugin(pluginName)).isEnabled()) {
                    return true;
                }
                this.plugin.getLogger().warning(pluginName + " was detected, but is not enabled! Fix " + pluginName + " to allow linkage.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean setupEconomy() {
        try {
            RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp != null) {
                economy = (Economy)rsp.getProvider();
            }
            return economy != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp != null) {
            permission = (Permission)rsp.getProvider();
        }
        return permission != null;
    }

    private boolean setupParty() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(PartyProvider.class);
        if (rsp != null) {
            partyProvider = (PartyProvider)rsp.getProvider();
            for (RegisteredServiceProvider rsp2 : this.plugin.getServer().getServicesManager().getRegistrations(PartyProvider.class)) {
                if (rsp2 == null) continue;
                partyProviders.add((PartyProvider)rsp2.getProvider());
            }
        }
        return partyProvider != null;
    }

    public boolean runDenizenScript(String scriptName, Quester quester, UUID uuid) {
        return this.plugin.getDenizenTrigger().runDenizenScript(scriptName, quester, uuid);
    }

    @Nullable
    public Location getNpcLocation(UUID uuid) {
        BukkitNpcDependency npcDependency;
        Location location = null;
        Iterator<BukkitNpcDependency> iterator = npcDependencies.iterator();
        while (iterator.hasNext() && (location = (npcDependency = iterator.next()).getLocation(uuid)) == null) {
        }
        return location;
    }

    @Nullable
    public Entity getNpcEntity(UUID uuid) {
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            Entity entity;
            if (!(npcDependency instanceof BukkitEntityNpcDependency) || (entity = ((BukkitEntityNpcDependency)((Object)npcDependency)).getEntity(uuid)) == null) continue;
            return entity;
        }
        return null;
    }

    @NotNull
    public String getNpcName(UUID uuid) {
        String name = "NPC";
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            String npcName = npcDependency.getName(uuid);
            if (npcName == null) continue;
            name = npcName;
            break;
        }
        return BukkitConfigUtil.parseString(name);
    }

    @Nullable
    public UUID getUuidFromNpc(Entity entity) {
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            UUID uuid;
            if (!(npcDependency instanceof BukkitEntityNpcDependency) || (uuid = ((BukkitEntityNpcDependency)((Object)npcDependency)).getUniqueId(entity)) == null) continue;
            return uuid;
        }
        return null;
    }

    public boolean isNpc(UUID uuid) {
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            if (!npcDependency.isNpc(uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean isNpc(Entity entity) {
        for (BukkitNpcDependency npcDependency : npcDependencies) {
            if (!(npcDependency instanceof BukkitEntityNpcDependency) || !((BukkitEntityNpcDependency)((Object)npcDependency)).isNpc(entity)) continue;
            return true;
        }
        return false;
    }

    public void startNpcEffectThread() {
        if (this.npcEffectThread == -1 && this.plugin.getConfigSettings().canNpcEffects()) {
            this.npcEffectThread = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this.plugin.getNpcEffectThread(), 20L, 20L);
        }
    }

    public void stopNpcEffectThread() {
        this.plugin.getServer().getScheduler().cancelTask(this.npcEffectThread);
    }

    public SkillType getMcMMOSkill(String s) {
        return SkillType.getSkill((String)s);
    }

    public int getMcmmoSkillLevel(SkillType st, String player) {
        McMMOPlayer mPlayer = UserManager.getPlayer((String)player);
        if (mPlayer == null) {
            return -1;
        }
        return mPlayer.getProfile().getSkillLevel(st);
    }

    public Hero getHero(UUID uuid) {
        Player p = this.plugin.getServer().getPlayer(uuid);
        if (p == null) {
            return null;
        }
        if (heroes != null) {
            return heroes.getCharacterManager().getHero(p);
        }
        return null;
    }

    public HeroClass getHeroClass(String className) {
        if (heroes != null) {
            return this.getHeroes().getClassManager().getClass(className);
        }
        return null;
    }

    public boolean testPrimaryHeroesClass(String primaryClass, UUID uuid) {
        if (heroes != null) {
            return this.getHero(uuid).getHeroClass().getName().equalsIgnoreCase(primaryClass);
        }
        return false;
    }

    public boolean testSecondaryHeroesClass(String secondaryClass, UUID uuid) {
        if (heroes != null) {
            return this.getHero(uuid).getSecondClass().getName().equalsIgnoreCase(secondaryClass);
        }
        return false;
    }

    @Override
    public void init() {
        this.initNpcDependency();
        this.getWorldGuardApi();
        this.getDenizenApi();
        this.getMcmmoClassic();
        this.getHeroes();
        this.getPlaceholderApi();
        this.getAstralBooksApi();
        this.getPartiesApi();
        this.getPartyProvider();
        this.getVaultEconomy();
        this.getVaultPermission();
    }
}

