/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.npc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import me.pikamug.quests.dependencies.npc.NpcDependency;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BukkitNpcDependency
extends NpcDependency {
    @NotNull
    public String getLabel();

    @Nullable
    public Location getLocation(UUID var1);

    @NotNull
    public List<UUID> getAllNpcUniqueIds();

    @NotNull
    public Map<UUID, Location> getNpcsByLocationPredicate(BiPredicate<UUID, Location> var1);

    @NotNull
    default public Map<UUID, Location> getNpcsByNearbyLocation(Location location, double radius) {
        if (location.getWorld() == null) {
            return Collections.emptyMap();
        }
        return this.getNpcsByLocationPredicate((uuid, npcLocation) -> npcLocation.getWorld().getUID().equals(location.getWorld().getUID()) && location.distance(npcLocation) < radius);
    }

    @NotNull
    default public Map<UUID, Location> getNpcsByNearbyLocationSquared(Location location, double radius) {
        if (location.getWorld() == null) {
            return Collections.emptyMap();
        }
        return this.getNpcsByLocationPredicate((uuid, npcLocation) -> npcLocation.getWorld().getUID().equals(location.getWorld().getUID()) && location.distanceSquared(npcLocation) < radius);
    }
}

