/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.npc.citizens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.npc.BukkitEntityNpcDependency;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.listeners.npc.BukkitCitizensListener;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitCitizensDependency
implements BukkitNpcDependency,
BukkitEntityNpcDependency {
    private final CitizensPlugin citizens = (CitizensPlugin)Bukkit.getServer().getPluginManager().getPlugin("Citizens");

    public BukkitCitizensDependency(BukkitQuestsPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)new BukkitCitizensListener(plugin, this), (Plugin)plugin);
    }

    @Override
    @NotNull
    public String getLabel() {
        return "Citizens";
    }

    @Override
    public boolean isNpc(UUID uuid) {
        return this.citizens.getNPCRegistry().getByUniqueId(uuid) != null;
    }

    @Override
    @Nullable
    public String getName(UUID uuid) {
        NPC npc = this.citizens.getNPCRegistry().getByUniqueId(uuid);
        return npc != null ? npc.getName() : null;
    }

    @Override
    @Nullable
    public Location getLocation(UUID uuid) {
        NPC npc = this.citizens.getNPCRegistry().getByUniqueId(uuid);
        return npc != null ? npc.getStoredLocation() : null;
    }

    @Override
    @NotNull
    public List<UUID> getAllNpcUniqueIds() {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (NPC npc : this.citizens.getNPCRegistry()) {
            ids.add(npc.getUniqueId());
        }
        return ids;
    }

    @Override
    @NotNull
    public Map<UUID, Location> getNpcsByLocationPredicate(BiPredicate<UUID, Location> predicate) {
        HashMap<UUID, Location> npcs = new HashMap<UUID, Location>();
        for (NPC npc : this.citizens.getNPCRegistry()) {
            UUID uuid = npc.getUniqueId();
            Location location = npc.getStoredLocation();
            if (location == null || location.getWorld() == null || !predicate.test(uuid, location)) continue;
            npcs.put(uuid, location);
        }
        return npcs;
    }

    @Override
    public boolean isNpc(Entity entity) {
        return this.citizens.getNPCRegistry().isNPC(entity);
    }

    @Override
    @Nullable
    public Entity getEntity(UUID uuid) {
        NPC npc = this.citizens.getNPCRegistry().getByUniqueId(uuid);
        return npc != null ? npc.getEntity() : null;
    }

    @Override
    @Nullable
    public UUID getUniqueId(Entity entity) {
        NPC npc = this.citizens.getNPCRegistry().getNPC(entity);
        return npc != null ? npc.getUniqueId() : null;
    }

    public CitizensPlugin getApi() {
        return this.citizens;
    }
}

