/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.npc.znpcsplus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import lol.pyr.znpcsplus.api.NpcApi;
import lol.pyr.znpcsplus.api.NpcApiProvider;
import lol.pyr.znpcsplus.api.entity.EntityProperty;
import lol.pyr.znpcsplus.api.npc.Npc;
import lol.pyr.znpcsplus.api.npc.NpcEntry;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.listeners.npc.BukkitZnpcsPlusListener;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitZnpcsPlusDependency
implements BukkitNpcDependency {
    private static final NpcApi api = NpcApiProvider.get();

    public BukkitZnpcsPlusDependency(BukkitQuestsPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)new BukkitZnpcsPlusListener(plugin, this), (Plugin)plugin);
    }

    @Override
    @NotNull
    public String getLabel() {
        return "ZNPCsPlus";
    }

    @Nullable
    private Npc getNpc(UUID uuid) {
        NpcEntry npcEntry = api.getNpcRegistry().getByUuid(uuid);
        return npcEntry != null ? npcEntry.getNpc() : null;
    }

    @Override
    public boolean isNpc(UUID uuid) {
        return this.getNpc(uuid) != null;
    }

    @Override
    @Nullable
    public String getName(UUID uuid) {
        Npc npc = this.getNpc(uuid);
        if (npc == null) {
            return null;
        }
        EntityProperty displayNameProperty = api.getPropertyRegistry().getByName("display_name", String.class);
        if (displayNameProperty != null && npc.hasProperty(displayNameProperty)) {
            return (String)npc.getProperty(displayNameProperty);
        }
        return null;
    }

    @Override
    @Nullable
    public Location getLocation(UUID uuid) {
        Npc npc = this.getNpc(uuid);
        if (npc == null) {
            return null;
        }
        World world = npc.getWorld();
        if (world == null) {
            return null;
        }
        return npc.getLocation().toBukkitLocation(world);
    }

    @Override
    @NotNull
    public List<UUID> getAllNpcUniqueIds() {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (NpcEntry npcEntry : api.getNpcRegistry().getAllPlayerMade()) {
            ids.add(npcEntry.getNpc().getUuid());
        }
        return ids;
    }

    @Override
    @NotNull
    public Map<UUID, Location> getNpcsByLocationPredicate(BiPredicate<UUID, Location> predicate) {
        HashMap<UUID, Location> npcs = new HashMap<UUID, Location>();
        for (NpcEntry npcEntry : api.getNpcRegistry().getAllPlayerMade()) {
            Npc npc = npcEntry.getNpc();
            World world = npc.getWorld();
            if (world == null) continue;
            Location location = npc.getLocation().toBukkitLocation(world);
            if (!predicate.test(npc.getUuid(), location)) continue;
            npcs.put(npc.getUuid(), location);
        }
        return npcs;
    }

    public NpcApi getApi() {
        return api;
    }
}

