/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.npc.znpcsplus.legacy;

import io.github.znetworkw.znpcservers.npc.NPC;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import lol.pyr.znpcsplus.ZNPCsPlus;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.npc.BukkitEntityNpcDependency;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.listeners.npc.BukkitZnpcsPlusLegacyListener;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitZnpcsPlusLegacyDependency
implements BukkitNpcDependency,
BukkitEntityNpcDependency {
    private final ZNPCsPlus znpcsPlusLegacy;

    public BukkitZnpcsPlusLegacyDependency(BukkitQuestsPlugin plugin) {
        this.znpcsPlusLegacy = (ZNPCsPlus)plugin.getServer().getPluginManager().getPlugin("ZNPCsPlus");
        plugin.getServer().getPluginManager().registerEvents((Listener)new BukkitZnpcsPlusLegacyListener(plugin, this), (Plugin)plugin);
    }

    @Override
    @NotNull
    public String getLabel() {
        return "ZNPCsPlus-Legacy";
    }

    @Nullable
    private NPC getNpc(UUID uuid) {
        return NPC.all().stream().filter(npc -> npc.getUUID().equals(uuid)).findAny().orElse(null);
    }

    @Override
    public boolean isNpc(UUID uuid) {
        return this.getNpc(uuid) != null;
    }

    @Override
    @Nullable
    public String getName(UUID uuid) {
        NPC npc = this.getNpc(uuid);
        if (npc == null) {
            return null;
        }
        Entity entity = (Entity)npc.getBukkitEntity();
        String customName = entity.getCustomName();
        if (customName == null) {
            customName = (String)npc.getNpcPojo().getHologramLines().get(0);
        }
        return customName;
    }

    @Override
    @Nullable
    public Location getLocation(UUID uuid) {
        NPC npc = this.getNpc(uuid);
        return npc != null ? npc.getLocation() : null;
    }

    @Override
    @NotNull
    public List<UUID> getAllNpcUniqueIds() {
        return NPC.all().stream().map(NPC::getUUID).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Map<UUID, Location> getNpcsByLocationPredicate(BiPredicate<UUID, Location> predicate) {
        return NPC.all().stream().filter(npc -> predicate.test(npc.getUUID(), npc.getLocation())).collect(Collectors.toMap(NPC::getUUID, NPC::getLocation));
    }

    @Nullable
    private NPC getNpc(Entity entity) {
        return NPC.all().stream().filter(npc -> npc.getUUID().equals(entity.getUniqueId())).findAny().orElse(null);
    }

    @Override
    public boolean isNpc(Entity entity) {
        return this.getNpc(entity) != null;
    }

    @Override
    @Nullable
    public Entity getEntity(UUID uuid) {
        NPC npc = this.getNpc(uuid);
        return npc != null ? (Entity)npc.getBukkitEntity() : null;
    }

    @Override
    @Nullable
    public UUID getUniqueId(Entity entity) {
        NPC npc = this.getNpc(entity);
        return npc != null ? npc.getUUID() : null;
    }

    public ZNPCsPlus getApi() {
        return this.znpcsPlusLegacy;
    }
}

