/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.reflect.denizen;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.reflect.denizen.DenizenAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class DenizenAPI_1_0_9 {
    private static final BukkitQuestsPlugin quests = (BukkitQuestsPlugin)Bukkit.getPluginManager().getPlugin("Quests");
    private static final DenizenAPI api = quests != null ? quests.getDependencies().getDenizenApi() : null;

    public static boolean containsScript(String input) {
        if (quests == null || DenizenAPI_1_0_9.api.scriptRegistry == null || DenizenAPI_1_0_9.api.containsScriptMethod == null) {
            return false;
        }
        boolean script = false;
        try {
            script = (Boolean)DenizenAPI_1_0_9.api.containsScriptMethod.invoke(DenizenAPI_1_0_9.api.scriptRegistry, input);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen ScriptRegistry#containsScript", e);
        }
        return script;
    }

    @Nullable
    public static String getScriptContainerName(String input) {
        if (quests == null || DenizenAPI_1_0_9.api.scriptRegistry == null || DenizenAPI_1_0_9.api.scriptContainer == null) {
            return null;
        }
        String name = null;
        try {
            Constructor<?> constructor = DenizenAPI_1_0_9.api.scriptRegistry.getConstructor(YamlConfiguration.class, String.class);
            Object instance = constructor.newInstance(null, input);
            name = (String)instance.getClass().getMethod("getName", new Class[0]).invoke(DenizenAPI_1_0_9.api.scriptContainer, new Object[0]);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen ScriptContainer#getName", e);
        }
        return name;
    }

    @Nullable
    public static Set<String> getScriptNames() {
        if (quests == null || DenizenAPI_1_0_9.api.scriptRegistry == null || DenizenAPI_1_0_9.api.getScriptNamesMethod == null) {
            return null;
        }
        Set names = null;
        try {
            names = (Set)DenizenAPI_1_0_9.api.getScriptNamesMethod.invoke(DenizenAPI_1_0_9.api.scriptRegistry, new Object[0]);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen ScriptRegistry#_getScriptNames", e);
        }
        return names;
    }

    @Nullable
    public static Object getScriptContainerAs(String scriptName) {
        if (quests == null || DenizenAPI_1_0_9.api.scriptRegistry == null || DenizenAPI_1_0_9.api.taskScriptContainer == null) {
            return null;
        }
        Object container = null;
        try {
            container = DenizenAPI_1_0_9.api.getScriptContainerAsMethod.invoke(DenizenAPI_1_0_9.api.scriptRegistry, scriptName, DenizenAPI_1_0_9.api.taskScriptContainer);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen #getScriptContainerAs", e);
        }
        return container;
    }

    @Nullable
    public static Object mirrorBukkitPlayer(Player player) {
        if (quests == null || DenizenAPI_1_0_9.api.dPlayer == null || DenizenAPI_1_0_9.api.mirrorBukkitPlayerMethod == null) {
            return null;
        }
        Object dp = null;
        try {
            dp = DenizenAPI_1_0_9.api.mirrorBukkitPlayerMethod.invoke(DenizenAPI_1_0_9.api.dPlayer, player);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen dPlayer#mirrorBukkitPlayer", e);
        }
        return dp;
    }

    @Nullable
    public static Object mirrorCitizensNPC(NPC npc) {
        if (quests == null || DenizenAPI_1_0_9.api.dNPC == null || DenizenAPI_1_0_9.api.mirrorCitizensNPCMethod == null) {
            return null;
        }
        Object dp = null;
        try {
            dp = DenizenAPI_1_0_9.api.mirrorCitizensNPCMethod.invoke(DenizenAPI_1_0_9.api.dNPC, npc);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen dNPC#mirrorCitizensNPC", e);
        }
        return dp;
    }

    public static void runTaskScript(String scriptName, Player player, NPC npc) {
        if (quests == null || DenizenAPI_1_0_9.api.scriptRegistry == null || DenizenAPI_1_0_9.api.bukkitScriptEntryData == null || DenizenAPI_1_0_9.api.scriptEntryData == null) {
            return;
        }
        try {
            Constructor<?> constructor = DenizenAPI_1_0_9.api.bukkitScriptEntryData.getConstructors()[0];
            Object tsc = DenizenAPI_1_0_9.getScriptContainerAs(scriptName);
            if (tsc != null) {
                Method runTaskScript = tsc.getClass().getMethod("runTaskScript", DenizenAPI_1_0_9.api.scriptEntryData, Map.class);
                runTaskScript.invoke(tsc, constructor.newInstance(DenizenAPI_1_0_9.mirrorBukkitPlayer(player), DenizenAPI_1_0_9.mirrorCitizensNPC(npc)), null);
            }
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen TaskScriptContainer#runTaskScript", e);
        }
    }
}

