/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.reflect.denizen;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.reflect.denizen.DenizenAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DenizenAPI_1_1_0 {
    private static final BukkitQuestsPlugin quests = (BukkitQuestsPlugin)Bukkit.getPluginManager().getPlugin("Quests");
    private static final DenizenAPI api = quests != null ? quests.getDependencies().getDenizenApi() : null;

    public static boolean containsScript(String input) {
        if (quests == null || DenizenAPI_1_1_0.api.scriptRegistry == null || DenizenAPI_1_1_0.api.containsScriptMethod == null) {
            return false;
        }
        boolean script = false;
        try {
            script = (Boolean)DenizenAPI_1_1_0.api.containsScriptMethod.invoke(DenizenAPI_1_1_0.api.scriptRegistry, input);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen ScriptRegistry#containsScript", e);
        }
        return script;
    }

    @Nullable
    public static String getScriptContainerName(String input) {
        return ScriptRegistry.getScriptContainer((String)input).getName();
    }

    @Nullable
    public static Set<String> getScriptNames() {
        if (quests == null || DenizenAPI_1_1_0.api.scriptRegistry == null || DenizenAPI_1_1_0.api.getScriptNamesMethod == null) {
            return null;
        }
        Set names = null;
        try {
            names = (Set)DenizenAPI_1_1_0.api.getScriptNamesMethod.invoke(DenizenAPI_1_1_0.api.scriptRegistry, new Object[0]);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen ScriptRegistry#_getScriptNames", e);
        }
        return names;
    }

    @Nullable
    public static Object getScriptContainerAs(String scriptName) {
        return ScriptRegistry.getScriptContainerAs((String)scriptName, TaskScriptContainer.class);
    }

    @Nullable
    public static Object mirrorBukkitPlayer(Player player) {
        return PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
    }

    @NotNull
    public static Object mirrorCitizensNPC(NPC npc) {
        return NPCTag.fromEntity((Entity)npc.getEntity());
    }

    public static void runTaskScript(String scriptName, Player player, NPC npc) {
        if (quests == null) {
            return;
        }
        try {
            Constructor<?> constructor = DenizenAPI_1_1_0.api.bukkitScriptEntryData.getConstructors()[0];
            Object tsc = DenizenAPI_1_1_0.getScriptContainerAs(scriptName);
            if (tsc != null) {
                Method runTaskScript = tsc.getClass().getMethod("runTaskScript", DenizenAPI_1_1_0.api.scriptEntryData, Map.class);
                runTaskScript.invoke(tsc, constructor.newInstance(DenizenAPI_1_1_0.mirrorBukkitPlayer(player), DenizenAPI_1_1_0.mirrorCitizensNPC(npc)), null);
            }
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen TaskScriptContainer#runTaskScript", e);
        }
    }
}

