/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.reflect.denizen;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.reflect.denizen.DenizenAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DenizenAPI_1_1_1 {
    private static final BukkitQuestsPlugin quests = (BukkitQuestsPlugin)Bukkit.getPluginManager().getPlugin("Quests");
    private static final DenizenAPI api = quests != null ? quests.getDependencies().getDenizenApi() : null;

    public static boolean containsScript(String input) {
        if (quests == null || DenizenAPI_1_1_1.api.scriptRegistry == null || DenizenAPI_1_1_1.api.containsScriptMethod == null) {
            return false;
        }
        boolean script = false;
        try {
            script = (Boolean)DenizenAPI_1_1_1.api.containsScriptMethod.invoke(DenizenAPI_1_1_1.api.scriptRegistry, input);
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen ScriptRegistry#containsScript", e);
        }
        return script;
    }

    @Nullable
    public static String getScriptContainerName(String input) {
        return ScriptRegistry.getScriptContainer((String)input).getName();
    }

    @NotNull
    public static Set<String> getScriptNames() {
        return ScriptRegistry.scriptContainers.keySet();
    }

    @Nullable
    public static Object getScriptContainerAs(String scriptName) {
        return ScriptRegistry.getScriptContainerAs((String)scriptName, TaskScriptContainer.class);
    }

    @Nullable
    public static Object mirrorBukkitPlayer(Player player) {
        return PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
    }

    @NotNull
    public static Object mirrorCitizensNPC(NPC npc) {
        return NPCTag.fromEntity((Entity)npc.getEntity());
    }

    public static void runTaskScript(String scriptName, Player player, NPC npc) {
        TaskScriptContainer taskScript = (TaskScriptContainer)ScriptRegistry.getScriptContainerAs((String)scriptName, TaskScriptContainer.class);
        BukkitScriptEntryData entryData = new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player), npc != null ? NPCTag.fromEntity((Entity)npc.getEntity()) : null);
        InstantQueue queue = new InstantQueue(taskScript.getName());
        if (quests == null) {
            return;
        }
        try {
            Method addEntries = queue.getClass().getMethod("addEntries", List.class);
            addEntries.invoke((Object)queue, taskScript.getBaseEntries(entryData.clone()));
            queue.start();
        }
        catch (Exception e) {
            quests.getPluginLogger().log(Level.WARNING, "Error invoking Denizen InstantQueue#addEntries", e);
        }
    }
}

