/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.dependencies.reflect.worldguard;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import me.pikamug.quests.dependencies.reflect.worldguard.WorldGuardAPI_7_0_0;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardAPI {
    private Object worldGuard7 = null;
    private WorldGuardPlugin worldGuardPlugin = null;
    private Object regionContainer = null;
    private Method regionContainerGetMethod = null;
    private Class<?> vector = null;
    private Constructor<?> vectorConstructor = null;
    private boolean initialized = false;

    public WorldGuardAPI(Plugin wg) {
        if (wg instanceof WorldGuardPlugin) {
            this.worldGuardPlugin = (WorldGuardPlugin)wg;
            try {
                Class.forName("com.sk89q.worldguard.WorldGuard");
                this.worldGuard7 = WorldGuardAPI_7_0_0.getInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isEnabled() {
        return this.worldGuardPlugin != null;
    }

    protected RegionAssociable getAssociable(Player player) {
        Object associable = player == null ? Associables.constant((Association)Association.NON_MEMBER) : this.worldGuardPlugin.wrapPlayer(player);
        return associable;
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            if (this.worldGuard7 == null) {
                try {
                    Method getRegionContainerMethod = this.worldGuardPlugin.getClass().getMethod("getRegionContainer", new Class[0]);
                    this.regionContainer = getRegionContainerMethod.invoke((Object)this.worldGuardPlugin, new Object[0]);
                    this.regionContainerGetMethod = this.regionContainer.getClass().getMethod("get", World.class);
                    this.vector = Class.forName("com.sk89q.worldedit.Vector");
                    this.vectorConstructor = this.vector.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                }
                catch (Exception e) {
                    Bukkit.getLogger().log(Level.WARNING, "Quests failed to bind to WorldGuard, integration will not work!", e);
                    this.regionContainer = null;
                    return;
                }
            }
            if (this.regionContainer == null) {
                Bukkit.getLogger().warning("Quests failed to find RegionContainer, WorldGuard integration will not function!");
            }
        }
    }

    @Nullable
    public RegionManager getRegionManager(World world) {
        if (this.worldGuard7 != null) {
            return WorldGuardAPI_7_0_0.getRegionManager(world);
        }
        this.initialize();
        if (this.regionContainer == null || this.regionContainerGetMethod == null) {
            return null;
        }
        RegionManager regionManager = null;
        try {
            regionManager = (RegionManager)this.regionContainerGetMethod.invoke(this.regionContainer, world);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.WARNING, "Quests encountered an error getting WorldGuard RegionManager", e);
        }
        return regionManager;
    }

    public ApplicableRegionSet getApplicableRegions(World world, Location location) {
        if (this.worldGuard7 != null) {
            return WorldGuardAPI_7_0_0.getApplicableRegions(world, location);
        }
        this.initialize();
        RegionManager regionManager = this.getRegionManager(world);
        ApplicableRegionSet ars = null;
        if (regionManager == null) {
            return null;
        }
        try {
            Method getApplicableRegionsMethod = regionManager.getClass().getMethod("getApplicableRegions", Location.class);
            ars = (ApplicableRegionSet)getApplicableRegionsMethod.invoke((Object)regionManager, location);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.WARNING, "Quests encountered an error getting RegionManager#getApplicableRegions", e);
        }
        return ars;
    }

    public List<String> getApplicableRegionsIDs(World world, Location location) {
        if (this.worldGuard7 != null) {
            return WorldGuardAPI_7_0_0.getApplicableRegionsIDs(world, location);
        }
        this.initialize();
        RegionManager regionManager = this.getRegionManager(world);
        List ari = null;
        if (regionManager == null) {
            return null;
        }
        try {
            Method getApplicableRegionsMethod = regionManager.getClass().getMethod("getApplicableRegionsIDs", this.vector);
            ari = (List)getApplicableRegionsMethod.invoke((Object)regionManager, this.vectorConstructor.newInstance(location.getX(), location.getY(), location.getZ()));
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.WARNING, "Quests encountered an error getting RegionManager#getApplicableRegionsIDs", e);
        }
        return ari;
    }
}

