/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.entity;

import me.pikamug.quests.entity.QuestMob;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class BukkitQuestMob
implements QuestMob {
    private String name = null;
    private EntityType entityType = null;
    private Location spawnLocation = null;
    private Integer spawnAmounts = null;
    private ItemStack[] inventory = new ItemStack[5];
    private Float[] dropChances = new Float[5];

    public BukkitQuestMob() {
    }

    public BukkitQuestMob(EntityType entityType, Location spawnLocation, int spawnAmounts) {
        this.entityType = entityType;
        this.spawnLocation = spawnLocation;
        this.spawnAmounts = spawnAmounts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public EntityType getType() {
        return this.entityType;
    }

    public void setType(EntityType entityType) {
        this.entityType = entityType;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public void setSpawnLocation(Location spawnLocation) {
        this.spawnLocation = spawnLocation;
    }

    @Override
    public Integer getSpawnAmounts() {
        return this.spawnAmounts;
    }

    @Override
    public void setSpawnAmounts(int spawnAmounts) {
        this.spawnAmounts = spawnAmounts;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void setInventory(ItemStack[] inventory) {
        this.inventory = inventory;
    }

    @Override
    public Float[] getDropChances() {
        return this.dropChances;
    }

    @Override
    public void setDropChances(Float[] dropChances) {
        this.dropChances = dropChances;
    }

    public void setHelmet(ItemStack helmet, float dropChance) {
        this.inventory[4] = helmet;
        this.dropChances[4] = Float.valueOf(dropChance);
    }

    public void setChest(ItemStack chest, float dropChance) {
        this.inventory[3] = chest;
        this.dropChances[3] = Float.valueOf(dropChance);
    }

    public void setLeggings(ItemStack leggings, float dropChance) {
        this.inventory[2] = leggings;
        this.dropChances[2] = Float.valueOf(dropChance);
    }

    public void setBoots(ItemStack boots, float dropChance) {
        this.inventory[1] = boots;
        this.dropChances[1] = Float.valueOf(dropChance);
    }

    public void setHeldItem(ItemStack heldItem, float dropChance) {
        this.inventory[0] = heldItem;
        this.dropChances[0] = Float.valueOf(dropChance);
    }

    @Override
    public void spawn() {
        World world = this.spawnLocation.getWorld();
        if (world == null) {
            return;
        }
        for (int i = 0; i < this.spawnAmounts; ++i) {
            EntityEquipment eq;
            LivingEntity entity = (LivingEntity)world.spawnEntity(this.spawnLocation, this.entityType);
            if (this.name != null) {
                entity.setCustomName(this.name);
                entity.setCustomNameVisible(true);
            }
            if ((eq = entity.getEquipment()) == null) {
                return;
            }
            eq.setItemInHand(this.inventory[0]);
            eq.setBoots(this.inventory[1]);
            eq.setLeggings(this.inventory[2]);
            eq.setChestplate(this.inventory[3]);
            eq.setHelmet(this.inventory[4]);
            if (this.dropChances[0] != null) {
                eq.setItemInHandDropChance(this.dropChances[0].floatValue());
            }
            if (this.dropChances[1] != null) {
                eq.setBootsDropChance(this.dropChances[1].floatValue());
            }
            if (this.dropChances[2] != null) {
                eq.setLeggingsDropChance(this.dropChances[2].floatValue());
            }
            if (this.dropChances[3] != null) {
                eq.setChestplateDropChance(this.dropChances[3].floatValue());
            }
            if (this.dropChances[4] == null) continue;
            eq.setHelmetDropChance(this.dropChances[4].floatValue());
        }
    }

    public static BukkitQuestMob fromString(String str) {
        String[] args;
        String name = null;
        EntityType entityType = null;
        Location loc = null;
        Integer amounts = null;
        ItemStack[] inventory = new ItemStack[5];
        Float[] dropChances = new Float[5];
        for (String string : args = str.split("::")) {
            if (string.startsWith("type-")) {
                entityType = BukkitMiscUtil.getProperMobType(string.substring(5));
                continue;
            }
            if (string.startsWith("name-")) {
                name = string.substring(5);
                continue;
            }
            if (string.startsWith("spawn-")) {
                loc = BukkitConfigUtil.getLocation(string.substring(6));
                continue;
            }
            if (string.startsWith("amounts-")) {
                amounts = Integer.parseInt(string.substring(8));
                continue;
            }
            if (string.startsWith("hand-")) {
                inventory[0] = BukkitItemUtil.readItemStack(string.substring(5));
                continue;
            }
            if (string.startsWith("hand_drop-")) {
                try {
                    dropChances[0] = Float.valueOf(Float.parseFloat(string.substring(10)));
                }
                catch (NumberFormatException e) {
                    Bukkit.getLogger().info("Drop chance for hand was required, but left empty. Setting to 1.0");
                    dropChances[0] = Float.valueOf(1.0f);
                }
                continue;
            }
            if (string.startsWith("boots-")) {
                inventory[1] = BukkitItemUtil.readItemStack(string.substring(6));
                continue;
            }
            if (string.startsWith("boots_drop-")) {
                try {
                    dropChances[1] = Float.valueOf(Float.parseFloat(string.substring(11)));
                }
                catch (NumberFormatException e) {
                    Bukkit.getLogger().info("Drop chance for boots was required, but left empty. Setting to 1.0");
                    dropChances[1] = Float.valueOf(1.0f);
                }
                continue;
            }
            if (string.startsWith("leggings-")) {
                inventory[2] = BukkitItemUtil.readItemStack(string.substring(9));
                continue;
            }
            if (string.startsWith("leggings_drop-")) {
                try {
                    dropChances[2] = Float.valueOf(Float.parseFloat(string.substring(14)));
                }
                catch (NumberFormatException e) {
                    Bukkit.getLogger().info("Drop chance for leggings was required, but left empty. Setting to 1.0");
                    dropChances[2] = Float.valueOf(1.0f);
                }
                continue;
            }
            if (string.startsWith("chest-")) {
                inventory[3] = BukkitItemUtil.readItemStack(string.substring(6));
                continue;
            }
            if (string.startsWith("chest_drop-")) {
                try {
                    dropChances[3] = Float.valueOf(Float.parseFloat(string.substring(11)));
                }
                catch (NumberFormatException e) {
                    Bukkit.getLogger().info("Drop chance for chest was required, but left empty. Setting to 1.0");
                    dropChances[3] = Float.valueOf(1.0f);
                }
                continue;
            }
            if (string.startsWith("helmet-")) {
                inventory[4] = BukkitItemUtil.readItemStack(string.substring(7));
                continue;
            }
            if (!string.startsWith("helmet_drop-")) continue;
            try {
                dropChances[4] = Float.valueOf(Float.parseFloat(string.substring(12)));
            }
            catch (NumberFormatException e) {
                Bukkit.getLogger().info("Drop chance for helmet was required, but left empty. Setting to 1.0");
                dropChances[4] = Float.valueOf(1.0f);
            }
        }
        BukkitQuestMob qm = new BukkitQuestMob(entityType, loc, amounts != null ? amounts : 1);
        qm.setName(name);
        qm.inventory = inventory;
        qm.dropChances = dropChances;
        return qm;
    }
}

