/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.enums;

import java.util.HashMap;
import java.util.Map;

public enum ObjectiveType {
    BREAK_BLOCK(1, "BreakBlock"),
    DAMAGE_BLOCK(2, "DamageBlock"),
    PLACE_BLOCK(3, "PlaceBlock"),
    USE_BLOCK(4, "UseBlock"),
    CUT_BLOCK(5, "CutBlock"),
    CRAFT_ITEM(6, "CraftItem"),
    SMELT_ITEM(7, "SmeltItem"),
    ENCHANT_ITEM(8, "EnchantItem"),
    BREW_ITEM(9, "BrewItem"),
    CONSUME_ITEM(10, "ConsumeItem"),
    DELIVER_ITEM(11, "DeliverItem"),
    MILK_COW(12, "MilkCow"),
    CATCH_FISH(13, "CatchFish"),
    KILL_MOB(14, "KillMob"),
    KILL_PLAYER(15, "KillPlayer"),
    TALK_TO_NPC(16, "TalkToNPC"),
    KILL_NPC(17, "KillNPC"),
    TAME_MOB(18, "TameMob"),
    SHEAR_SHEEP(19, "ShearSheep"),
    REACH_LOCATION(20, "ReachLocation"),
    PASSWORD(21, "Password"),
    CUSTOM(127, "Custom");

    private final String name;
    private final byte typeId;
    private static final Map<String, ObjectiveType> NAME_MAP;
    private static final Map<Byte, ObjectiveType> ID_MAP;

    private ObjectiveType(int typeId, String name) {
        this.typeId = (byte)typeId;
        this.name = name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static ObjectiveType fromName(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("custom")) {
            return CUSTOM;
        }
        return NAME_MAP.get(name.toLowerCase());
    }

    public static ObjectiveType fromId(int id) {
        if (id > 127) {
            return null;
        }
        return ID_MAP.get((byte)id);
    }

    static {
        NAME_MAP = new HashMap<String, ObjectiveType>();
        ID_MAP = new HashMap<Byte, ObjectiveType>();
        for (ObjectiveType type : ObjectiveType.values()) {
            if (type.name != null) {
                NAME_MAP.put(type.name.toLowerCase(), type);
            }
            if (type.typeId <= 0) continue;
            ID_MAP.put(type.typeId, type);
        }
    }
}

