/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum StorageType {
    YAML("YAML", "yaml", "yml"),
    MYSQL("MySQL", "mysql"),
    JAR("JAR", "jar"),
    CUSTOM("Custom", "custom");

    private final String name;
    private final List<String> identifiers;

    private StorageType(String name, String ... identifiers) {
        this.name = name;
        this.identifiers = Collections.unmodifiableList(Arrays.asList(identifiers));
    }

    public static StorageType parse(String name, StorageType def) {
        for (StorageType t : StorageType.values()) {
            for (String id : t.getIdentifiers()) {
                if (!id.equalsIgnoreCase(name)) continue;
                return t;
            }
        }
        return def;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }
}

