/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.item;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.libs.bookutil.BookUtil;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitObjective;
import me.pikamug.quests.quests.components.Objective;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.stack.BlockItemStack;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitQuestJournal {
    final BukkitQuestsPlugin plugin;
    final Quester owner;
    final ItemStack journal;

    public BukkitQuestJournal(BukkitQuestsPlugin plugin, Quester owner) {
        this.plugin = plugin;
        this.owner = owner;
        Player player = owner.getPlayer();
        String title = ChatColor.LIGHT_PURPLE + BukkitLang.get(player, "journalTitle");
        this.journal = BookUtil.writtenBook().author(player.getName()).title(title).pages(this.getPages()).build();
        if (this.journal.getItemMeta() != null) {
            ItemMeta meta = this.journal.getItemMeta();
            meta.setDisplayName(title);
            this.journal.setItemMeta(meta);
        }
    }

    public List<BaseComponent[]> getPages() {
        Player player = this.owner.getPlayer();
        if (this.owner.getCurrentQuests().isEmpty()) {
            String title = BukkitLang.get(player, "journalTitle");
            return Collections.singletonList(new BookUtil.PageBuilder().add((BaseComponent)new TextComponent(ChatColor.DARK_RED + BukkitLang.get(player, "journalNoQuests").replace("<journal>", title))).build());
        }
        LinkedList<BaseComponent[]> pages = new LinkedList<BaseComponent[]>();
        List sortedList = this.owner.getCurrentQuests().keySet().stream().sorted(Comparator.comparing(Quest::getName)).collect(Collectors.toList());
        for (Quest quest : sortedList) {
            TextComponent title = new TextComponent(quest.getName());
            title.setColor(net.md_5.bungee.api.ChatColor.DARK_PURPLE);
            title.setBold(Boolean.valueOf(true));
            BookUtil.PageBuilder builder = new BookUtil.PageBuilder().add((BaseComponent)title).newLine();
            for (Objective obj : this.owner.getCurrentObjectives(quest, false, false)) {
                BukkitObjective objective = (BukkitObjective)obj;
                if (objective.getMessage() == null) continue;
                String message = "- " + BukkitLang.BukkitFormatToken.convertString(player, objective.getMessage().trim().replaceAll("\\s{2,}", ""));
                if (!this.plugin.getConfigSettings().canShowCompletedObjs() && objective.getProgress() >= objective.getGoal()) continue;
                String[] split = null;
                if (message.contains("<item>")) {
                    TranslatableComponent tc;
                    BlockItemStack goal;
                    split = message.split("<item>");
                    builder.add(split[0]);
                    if (objective.getGoalAsBlockItem() != null) {
                        goal = objective.getGoalAsBlockItem();
                        if (this.plugin.getConfigSettings().canTranslateNames()) {
                            try {
                                tc = new TranslatableComponent(this.plugin.getLocaleManager().queryMaterial(goal.getType(), goal.getDurability(), null), new Object[0]);
                                tc.setColor(net.md_5.bungee.api.ChatColor.DARK_AQUA);
                                builder.add((BaseComponent)tc);
                            }
                            catch (Exception e) {
                                builder.add(ChatColor.RED + BukkitItemUtil.getPrettyItemName(goal.getType().name()));
                                this.plugin.getLogger().severe(e.getMessage());
                                this.plugin.getLogger().info("for Quest " + quest.getId() + " " + message);
                            }
                        } else {
                            builder.add(ChatColor.AQUA + BukkitItemUtil.getPrettyItemName(goal.getType().name()));
                        }
                    } else if (objective.getGoalAsItem() != null) {
                        goal = objective.getGoalAsItem();
                        if (goal.getItemMeta() != null && goal.getItemMeta().hasDisplayName()) {
                            builder.add("" + ChatColor.DARK_AQUA + ChatColor.ITALIC + goal.getItemMeta().getDisplayName());
                        } else if (this.plugin.getConfigSettings().canTranslateNames()) {
                            tc = new TranslatableComponent(this.plugin.getLocaleManager().queryItemStack((ItemStack)goal), new Object[0]);
                            tc.setColor(net.md_5.bungee.api.ChatColor.DARK_AQUA);
                            builder.add((BaseComponent)tc);
                        } else {
                            builder.add(ChatColor.AQUA + BukkitItemUtil.getPrettyItemName(goal.getType().name()));
                        }
                    }
                    if (split.length > 1) {
                        builder.add(split[1]).newLine();
                    }
                }
                if (message.contains("<mob>") && objective.getGoalAsMob() != null) {
                    split = message.split("<mob>");
                    builder.add(split[0]);
                    if (this.plugin.getConfigSettings().canTranslateNames()) {
                        TranslatableComponent tc = new TranslatableComponent(this.plugin.getLocaleManager().queryEntityType(objective.getGoalAsMob().getEntityType(), null), new Object[0]);
                        tc.setColor(net.md_5.bungee.api.ChatColor.DARK_RED);
                        builder.add((BaseComponent)tc);
                    } else {
                        builder.add(BukkitMiscUtil.snakeCaseToUpperCamelCase(objective.getGoalAsMob().getEntityType().name()));
                    }
                    if (split.length > 1) {
                        builder.add(split[1]).newLine();
                    }
                }
                if (split != null) continue;
                builder.add(message).newLine();
            }
            pages.add(builder.build());
        }
        return pages;
    }

    public Quester getOwner() {
        return this.owner;
    }

    public ItemStack toItemStack() {
        return this.journal;
    }
}

