/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.libs.bookutil.internals;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import me.pikamug.quests.libs.bookutil.UnsupportedVersionException;
import me.pikamug.quests.libs.bookutil.internals.BookHelper;
import me.pikamug.quests.libs.bookutil.internals.NmsUtil;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class NmsBookHelper
implements BookHelper {
    private final boolean doubleHands;
    private final Field craftMetaBookField;
    private final Method chatSerializerA;
    private final Method craftMetaBookInternalAddPageMethod;
    private final Method entityPlayerOpenBook;
    private final Object[] hands;

    public NmsBookHelper() {
        block8: {
            this.doubleHands = NmsUtil.major <= 1 && NmsUtil.minor >= 9;
            try {
                Class<?> craftMetaBookClass = NmsUtil.getCraftClass("inventory.CraftMetaBook");
                this.craftMetaBookField = craftMetaBookClass.getDeclaredField("pages");
                this.craftMetaBookField.setAccessible(true);
                Method cmbInternalAddMethod = null;
                try {
                    cmbInternalAddMethod = craftMetaBookClass.getDeclaredMethod("internalAddPage", String.class);
                    cmbInternalAddMethod.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                this.craftMetaBookInternalAddPageMethod = cmbInternalAddMethod;
                Class<?> chatSerializer = NmsUtil.getNmsClass("IChatBaseComponent$ChatSerializer", "network.chat", false);
                if (chatSerializer == null) {
                    chatSerializer = NmsUtil.getNmsClass("ChatSerializer", true);
                }
                this.chatSerializerA = chatSerializer.getDeclaredMethod("a", String.class);
                Class<?> entityPlayerClass = NmsUtil.getNmsClass("EntityPlayer", "server.level", true);
                Class<?> itemStackClass = NmsUtil.getNmsClass("ItemStack", "world.item", true);
                if (this.doubleHands) {
                    Method openBookMethod;
                    Class<?> enumHandClass = NmsUtil.getNmsClass("EnumHand", "world", true);
                    try {
                        openBookMethod = entityPlayerClass.getMethod("a", itemStackClass, enumHandClass);
                    }
                    catch (NoSuchMethodException e) {
                        openBookMethod = entityPlayerClass.getMethod("openBook", itemStackClass, enumHandClass);
                    }
                    this.entityPlayerOpenBook = openBookMethod;
                    this.hands = enumHandClass.getEnumConstants();
                    break block8;
                }
                this.entityPlayerOpenBook = entityPlayerClass.getMethod("openBook", itemStackClass);
                this.hands = null;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot initiate reflections for " + NmsUtil.version, e);
            }
        }
    }

    @Override
    public void setPages(BookMeta meta, BaseComponent[][] components) {
        try {
            List pages = (List)this.craftMetaBookField.get(meta);
            if (pages != null) {
                pages.clear();
            }
            for (BaseComponent[] c : components) {
                if (c == null) continue;
                String json = ComponentSerializer.toString((BaseComponent[])c);
                if (this.craftMetaBookInternalAddPageMethod != null) {
                    this.craftMetaBookInternalAddPageMethod.invoke((Object)meta, json);
                    continue;
                }
                pages.add(this.chatSerializerA.invoke(null, json));
            }
        }
        catch (Exception e) {
            throw new UnsupportedVersionException(e);
        }
    }

    @Override
    public void openBook(Player player, ItemStack book) {
        try {
            if (this.doubleHands) {
                this.entityPlayerOpenBook.invoke(NmsUtil.toNms(player), NmsUtil.nmsCopy(book), this.hands[0]);
            } else {
                this.entityPlayerOpenBook.invoke(NmsUtil.toNms(player), NmsUtil.nmsCopy(book));
            }
        }
        catch (Exception e) {
            throw new UnsupportedVersionException(e);
        }
    }
}

