/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.libs.mysql.cj.protocol.a;

import me.pikamug.quests.libs.mysql.cj.exceptions.ExceptionFactory;
import me.pikamug.quests.libs.mysql.cj.exceptions.WrongArgumentException;
import me.pikamug.quests.libs.mysql.cj.protocol.ColumnDefinition;
import me.pikamug.quests.libs.mysql.cj.protocol.ProtocolEntityFactory;
import me.pikamug.quests.libs.mysql.cj.protocol.a.ColumnDefinitionFactory;
import me.pikamug.quests.libs.mysql.cj.protocol.a.NativePacketPayload;
import me.pikamug.quests.libs.mysql.cj.result.DefaultColumnDefinition;
import me.pikamug.quests.libs.mysql.cj.result.Field;

public class MergingColumnDefinitionFactory
extends ColumnDefinitionFactory
implements ProtocolEntityFactory<ColumnDefinition, NativePacketPayload> {
    public MergingColumnDefinitionFactory(long columnCount, ColumnDefinition columnDefinitionFromCache) {
        super(columnCount, columnDefinitionFromCache);
    }

    @Override
    public boolean mergeColumnDefinitions() {
        return true;
    }

    @Override
    public ColumnDefinition createFromFields(Field[] fields) {
        if (this.columnDefinitionFromCache != null) {
            if ((long)fields.length != this.columnCount) {
                throw ExceptionFactory.createException(WrongArgumentException.class, "Wrong number of ColumnDefinition fields.");
            }
            Field[] f = this.columnDefinitionFromCache.getFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setFlags(f[i].getFlags());
            }
        }
        return new DefaultColumnDefinition(fields);
    }
}

