/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.libs.mysql.cj.protocol.a;

import java.io.IOException;
import java.util.ArrayList;
import me.pikamug.quests.libs.mysql.cj.conf.PropertyKey;
import me.pikamug.quests.libs.mysql.cj.protocol.ColumnDefinition;
import me.pikamug.quests.libs.mysql.cj.protocol.ProtocolEntityFactory;
import me.pikamug.quests.libs.mysql.cj.protocol.ProtocolEntityReader;
import me.pikamug.quests.libs.mysql.cj.protocol.Resultset;
import me.pikamug.quests.libs.mysql.cj.protocol.ResultsetRow;
import me.pikamug.quests.libs.mysql.cj.protocol.a.ColumnDefinitionFactory;
import me.pikamug.quests.libs.mysql.cj.protocol.a.NativeConstants;
import me.pikamug.quests.libs.mysql.cj.protocol.a.NativePacketPayload;
import me.pikamug.quests.libs.mysql.cj.protocol.a.NativeProtocol;
import me.pikamug.quests.libs.mysql.cj.protocol.a.TextRowFactory;
import me.pikamug.quests.libs.mysql.cj.protocol.a.result.AbstractResultsetRows;
import me.pikamug.quests.libs.mysql.cj.protocol.a.result.OkPacket;
import me.pikamug.quests.libs.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import me.pikamug.quests.libs.mysql.cj.protocol.a.result.ResultsetRowsStreaming;

public class TextResultsetReader
implements ProtocolEntityReader<Resultset, NativePacketPayload> {
    protected NativeProtocol protocol;

    public TextResultsetReader(NativeProtocol prot) {
        this.protocol = prot;
    }

    @Override
    public Resultset read(int maxRows, boolean streamResults, NativePacketPayload resultPacket, ColumnDefinition metadata, ProtocolEntityFactory<Resultset, NativePacketPayload> resultSetFactory) throws IOException {
        Resultset rs = null;
        long columnCount = resultPacket.readInteger(NativeConstants.IntegerDataType.INT_LENENC);
        if (columnCount > 0L) {
            ColumnDefinition cdef = this.protocol.read(ColumnDefinition.class, new ColumnDefinitionFactory(columnCount, metadata));
            if (!this.protocol.getServerSession().isEOFDeprecated()) {
                this.protocol.skipPacket();
            }
            AbstractResultsetRows rows = null;
            if (!streamResults) {
                TextRowFactory trf = new TextRowFactory(this.protocol, cdef, resultSetFactory.getResultSetConcurrency(), false);
                ArrayList<ResultsetRow> rowList = new ArrayList<ResultsetRow>();
                ResultsetRow row = this.protocol.read(ResultsetRow.class, trf);
                while (row != null) {
                    if (maxRows == -1 || rowList.size() < maxRows) {
                        rowList.add(row);
                    }
                    row = this.protocol.read(ResultsetRow.class, trf);
                }
                rows = new ResultsetRowsStatic(rowList, cdef);
            } else {
                rows = new ResultsetRowsStreaming<Resultset>(this.protocol, cdef, false, resultSetFactory);
                this.protocol.setStreamingData(rows);
            }
            rs = resultSetFactory.createFromProtocolEntity(rows);
        } else {
            if (columnCount == -1L) {
                String charEncoding = this.protocol.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
                String fileName = resultPacket.readString(NativeConstants.StringSelfDataType.STRING_TERM, this.protocol.getServerSession().getCharsetSettings().doesPlatformDbCharsetMatches() ? charEncoding : null);
                resultPacket = this.protocol.sendFileToServer(fileName);
            }
            OkPacket ok = (OkPacket)this.protocol.readServerStatusForResultSets(resultPacket, false);
            rs = resultSetFactory.createFromProtocolEntity(ok);
        }
        return rs;
    }
}

