/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.libs.mysql.cj.protocol.a.authentication;

import java.util.List;
import me.pikamug.quests.libs.mysql.cj.callback.MysqlCallbackHandler;
import me.pikamug.quests.libs.mysql.cj.callback.UsernameCallback;
import me.pikamug.quests.libs.mysql.cj.protocol.AuthenticationPlugin;
import me.pikamug.quests.libs.mysql.cj.protocol.Protocol;
import me.pikamug.quests.libs.mysql.cj.protocol.Security;
import me.pikamug.quests.libs.mysql.cj.protocol.a.NativeConstants;
import me.pikamug.quests.libs.mysql.cj.protocol.a.NativePacketPayload;

public class MysqlNativePasswordPlugin
implements AuthenticationPlugin<NativePacketPayload> {
    public static String PLUGIN_NAME = "mysql_native_password";
    private Protocol<NativePacketPayload> protocol = null;
    private MysqlCallbackHandler usernameCallbackHandler = null;
    private String password = null;

    @Override
    public void init(Protocol<NativePacketPayload> prot, MysqlCallbackHandler cbh) {
        this.protocol = prot;
        this.usernameCallbackHandler = cbh;
    }

    @Override
    public void destroy() {
        this.reset();
        this.protocol = null;
        this.usernameCallbackHandler = null;
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
        if (user == null && this.usernameCallbackHandler != null) {
            this.usernameCallbackHandler.handle(new UsernameCallback(System.getProperty("user.name")));
        }
    }

    @Override
    public boolean nextAuthenticationStep(NativePacketPayload fromServer, List<NativePacketPayload> toServer) {
        toServer.clear();
        NativePacketPayload packet = null;
        String pwd = this.password;
        packet = fromServer == null || pwd == null || pwd.length() == 0 ? new NativePacketPayload(new byte[0]) : new NativePacketPayload(Security.scramble411(pwd, fromServer.readBytes(NativeConstants.StringSelfDataType.STRING_TERM), this.protocol.getServerSession().getCharsetSettings().getPasswordCharacterEncoding()));
        toServer.add(packet);
        return true;
    }
}

