/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.libs.mysql.cj.xdevapi;

import java.util.ArrayList;
import java.util.List;
import me.pikamug.quests.libs.mysql.cj.MysqlxSession;
import me.pikamug.quests.libs.mysql.cj.conf.PropertySet;
import me.pikamug.quests.libs.mysql.cj.exceptions.ExceptionFactory;
import me.pikamug.quests.libs.mysql.cj.exceptions.WrongArgumentException;
import me.pikamug.quests.libs.mysql.cj.protocol.ColumnDefinition;
import me.pikamug.quests.libs.mysql.cj.protocol.ProtocolEntity;
import me.pikamug.quests.libs.mysql.cj.protocol.ResultBuilder;
import me.pikamug.quests.libs.mysql.cj.protocol.x.FetchDoneEntity;
import me.pikamug.quests.libs.mysql.cj.protocol.x.Notice;
import me.pikamug.quests.libs.mysql.cj.protocol.x.StatementExecuteOk;
import me.pikamug.quests.libs.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import me.pikamug.quests.libs.mysql.cj.result.BufferedRowList;
import me.pikamug.quests.libs.mysql.cj.result.DefaultColumnDefinition;
import me.pikamug.quests.libs.mysql.cj.result.Field;
import me.pikamug.quests.libs.mysql.cj.result.Row;
import me.pikamug.quests.libs.mysql.cj.result.RowList;
import me.pikamug.quests.libs.mysql.cj.xdevapi.DocResult;
import me.pikamug.quests.libs.mysql.cj.xdevapi.DocResultImpl;

public class DocResultBuilder
implements ResultBuilder<DocResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private DocResult result;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public DocResultBuilder(MysqlxSession sess) {
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public DocResult build() {
        this.result = new DocResultImpl((RowList)new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

