/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners;

import java.util.HashSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.events.quester.BukkitQuesterPostUpdateObjectiveEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreUpdateObjectiveEvent;
import me.pikamug.quests.nms.BukkitActionBarProvider;
import me.pikamug.quests.player.BukkitQuestProgress;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitObjective;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.stack.BlockItemStack;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class BukkitBlockListener
implements Listener {
    private final BukkitQuestsPlugin plugin;

    public BukkitBlockListener(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BlockItemStack blockItem = BlockItemStack.of(event.getBlock());
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType breakType = ObjectiveType.BREAK_BLOCK;
            ObjectiveType placeType = ObjectiveType.PLACE_BLOCK;
            ObjectiveType cutType = ObjectiveType.CUT_BLOCK;
            HashSet<String> dispatchedBreakQuestIDs = new HashSet<String>();
            HashSet<String> dispatchedPlaceQuestIDs = new HashSet<String>();
            HashSet<String> dispatchedCutQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true) || !quester.getCurrentQuests().containsKey(quest)) continue;
                BukkitStage currentStage = (BukkitStage)quester.getCurrentStage(quest);
                if (currentStage == null) {
                    this.plugin.getLogger().severe("Player " + player.getName() + " (" + player.getUniqueId() + ") has invalid stage for quest " + quest.getName() + " (" + quest.getId() + ")");
                    continue;
                }
                if (currentStage.containsObjective(breakType)) {
                    if (quest.getOptions().canIgnoreSilkTouch() && player.getItemInHand().containsEnchantment(Enchantment.SILK_TOUCH)) {
                        BukkitActionBarProvider.sendActionBar(player, ChatColor.RED + BukkitLang.get(player, "optionSilkTouchFail").replace("<quest>", quest.getName()));
                    } else {
                        quester.breakBlock(quest, blockItem);
                        dispatchedBreakQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, breakType, (q, cq) -> {
                            if (!dispatchedBreakQuestIDs.contains(cq.getId())) {
                                q.breakBlock((Quest)cq, blockItem);
                            }
                            return null;
                        }));
                    }
                }
                BukkitQuestProgress questProgress = (BukkitQuestProgress)quester.getQuestProgressOrDefault(quest);
                if (quest.getOptions().canIgnoreBlockReplace()) {
                    if (currentStage.containsObjective(placeType)) {
                        int progress;
                        for (int i = 0; i < questProgress.blocksPlaced.size() && (progress = questProgress.blocksPlaced.get(i) - 1) >= 0; ++i) {
                            if (i >= currentStage.getBlocksToPlace().size()) {
                                this.plugin.getLogger().info("Quest " + quest.getId() + " had abnormally large amount of blocks to place. You can probably ignore this.");
                                break;
                            }
                            BlockItemStack is = currentStage.getBlocksToPlace().get(i);
                            if (!event.getBlock().getType().equals((Object)is.getType()) || is.getAmount() <= 0) continue;
                            BlockItemStack goal = BlockItemStack.clone(is, 64);
                            for (BlockItemStack stack : currentStage.getBlocksToPlace()) {
                                if (!stack.matches(goal)) continue;
                                goal = stack;
                            }
                            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(quester, quest, new BukkitObjective(placeType, null, is.getAmount(), goal.getAmount()));
                            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                            questProgress.blocksPlaced.set(i, progress);
                            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(quester, quest, new BukkitObjective(placeType, null, progress, goal.getAmount()));
                            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
                        }
                    }
                    dispatchedPlaceQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, placeType, (q, cq) -> {
                        if (!dispatchedPlaceQuestIDs.contains(cq.getId())) {
                            int progress;
                            BukkitQuestProgress qQuestProgress = (BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)cq);
                            for (int i = 0; i < qQuestProgress.blocksPlaced.size() && (progress = qQuestProgress.blocksPlaced.get(i) - 1) >= 0; ++i) {
                                BlockItemStack is = currentStage.getBlocksToPlace().get(i);
                                if (!event.getBlock().getType().equals((Object)is.getType()) || is.getAmount() <= 0) continue;
                                BlockItemStack goal = BlockItemStack.clone(is, 64);
                                for (BlockItemStack stack : ((BukkitStage)quester.getCurrentStage((Quest)cq)).getBlocksToPlace()) {
                                    if (!stack.matches(goal)) continue;
                                    goal = stack;
                                }
                                BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent((BukkitQuester)q, (Quest)cq, new BukkitObjective(placeType, null, is.getAmount(), goal.getAmount()));
                                this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                                qQuestProgress.blocksPlaced.set(i, progress);
                                BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent((BukkitQuester)q, (Quest)cq, new BukkitObjective(placeType, null, progress, goal.getAmount()));
                                this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
                            }
                        }
                        return null;
                    }));
                }
                if (currentStage.containsObjective(cutType) && player.getItemInHand().getType().equals((Object)Material.SHEARS)) {
                    quester.cutBlock(quest, blockItem);
                }
                dispatchedCutQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, cutType, (q, cq) -> {
                    if (!dispatchedCutQuestIDs.contains(cq.getId()) && player.getItemInHand().getType().equals((Object)Material.SHEARS)) {
                        q.cutBlock((Quest)cq, blockItem);
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onBlockDamage(BlockDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BlockItemStack blockItemStack = BlockItemStack.of(event.getBlock());
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType type = ObjectiveType.DAMAGE_BLOCK;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.damageBlock(quest, blockItemStack);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.damageBlock((Quest)cq, blockItemStack);
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BlockItemStack blockItemStack = BlockItemStack.of(event.getBlock());
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType placeType = ObjectiveType.PLACE_BLOCK;
            ObjectiveType breakType = ObjectiveType.BREAK_BLOCK;
            HashSet<String> dispatchedPlaceQuestIDs = new HashSet<String>();
            HashSet<String> dispatchedBreakQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest)) {
                    BukkitStage currentStage = (BukkitStage)quester.getCurrentStage(quest);
                    if (currentStage.containsObjective(placeType)) {
                        quester.placeBlock(quest, blockItemStack);
                    }
                    BukkitQuestProgress questProgress = (BukkitQuestProgress)quester.getQuestProgressOrDefault(quest);
                    if (quest.getOptions().canIgnoreBlockReplace()) {
                        if (currentStage.containsObjective(breakType)) {
                            int progress;
                            for (int i = 0; i < questProgress.blocksBroken.size() && (progress = questProgress.blocksBroken.get(i) - 1) >= 0; ++i) {
                                if (i >= currentStage.getBlocksToBreak().size()) {
                                    this.plugin.getLogger().info("Quest " + quest.getId() + " had abnormally large amount of blocks to break. You can probably ignore this.");
                                    break;
                                }
                                BlockItemStack is = currentStage.getBlocksToBreak().get(i);
                                if (!event.getBlock().getType().equals((Object)is.getType()) || is.getAmount() <= 0) continue;
                                BlockItemStack goal = BlockItemStack.clone(is, 64);
                                for (BlockItemStack stack : currentStage.getBlocksToBreak()) {
                                    if (!stack.matches(goal)) continue;
                                    goal = stack;
                                }
                                BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(quester, quest, new BukkitObjective(placeType, null, is.getAmount(), goal.getAmount()));
                                this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                                questProgress.blocksBroken.set(i, progress);
                                BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(quester, quest, new BukkitObjective(placeType, null, progress, goal.getAmount()));
                                this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
                            }
                        }
                        dispatchedBreakQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, breakType, (q, cq) -> {
                            if (!dispatchedBreakQuestIDs.contains(cq.getId())) {
                                int progress;
                                BukkitQuestProgress qQuestProgress = (BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)cq);
                                for (int i = 0; i < qQuestProgress.blocksBroken.size() && (progress = qQuestProgress.blocksBroken.get(i) - 1) >= 0; ++i) {
                                    BlockItemStack is = currentStage.getBlocksToBreak().get(i);
                                    if (!event.getBlock().getType().equals((Object)is.getType()) || is.getAmount() <= 0) continue;
                                    BlockItemStack goal = BlockItemStack.clone(is, 64);
                                    for (BlockItemStack stack : ((BukkitStage)quester.getCurrentStage((Quest)cq)).getBlocksToBreak()) {
                                        if (!stack.matches(goal)) continue;
                                        goal = stack;
                                    }
                                    BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent((BukkitQuester)q, (Quest)cq, new BukkitObjective(breakType, null, is.getAmount(), goal.getAmount()));
                                    this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                                    qQuestProgress.blocksBroken.set(i, progress);
                                    BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent((BukkitQuester)q, (Quest)cq, new BukkitObjective(breakType, null, progress, goal.getAmount()));
                                    this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
                                }
                            }
                            return null;
                        }));
                    }
                }
                dispatchedPlaceQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, placeType, (q, cq) -> {
                    if (!dispatchedPlaceQuestIDs.contains(cq.getId())) {
                        q.placeBlock((Quest)cq, blockItemStack);
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onBlockUse(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        EquipmentSlot e = null;
        try {
            e = event.getHand();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (e == null || e.equals((Object)EquipmentSlot.HAND)) {
            Player player = event.getPlayer();
            if (this.plugin.canUseQuests(event.getPlayer().getUniqueId())) {
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                if (quester.isSelectingBlock()) {
                    return;
                }
                if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !event.isCancelled() && event.getClickedBlock() != null) {
                    BlockItemStack blockItemStack = BlockItemStack.of(event.getClickedBlock());
                    ObjectiveType type = ObjectiveType.USE_BLOCK;
                    HashSet<String> dispatchedQuestIDs = new HashSet<String>();
                    for (Quest quest : this.plugin.getLoadedQuests()) {
                        if (!quester.meetsCondition(quest, true)) continue;
                        if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                            quester.useBlock(quest, blockItemStack);
                        }
                        dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                            if (!dispatchedQuestIDs.contains(cq.getId())) {
                                q.useBlock((Quest)cq, blockItemStack);
                            }
                            return null;
                        }));
                    }
                }
            }
        }
    }
}

