/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners;

import java.util.List;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.quest.BukkitQuestCommandHandler;
import me.pikamug.quests.commands.questadmin.BukkitQuestadminCommandHandler;
import me.pikamug.quests.commands.quests.BukkitQuestsCommandHandler;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitCommandManager
implements TabExecutor {
    private final BukkitQuestsPlugin plugin;

    public BukkitCommandManager(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender cs, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (this.plugin.isLoading()) {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("errorLoading"));
            return true;
        }
        if (cs instanceof Player && !this.plugin.canUseQuests(((Player)cs).getUniqueId())) {
            cs.sendMessage(ChatColor.RED + BukkitLang.get((Player)cs, "noPermission"));
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("quest")) {
            return new BukkitQuestCommandHandler(this.plugin).check(cs, args);
        }
        if (cmd.getName().equalsIgnoreCase("quests")) {
            return new BukkitQuestsCommandHandler(this.plugin).check(cs, args);
        }
        if (cmd.getName().equalsIgnoreCase("questadmin") || cmd.getName().equalsIgnoreCase("questsadmin")) {
            return new BukkitQuestadminCommandHandler(this.plugin).check(cs, args);
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender cs, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length > 0) {
            if (cmd.getName().equalsIgnoreCase("quest")) {
                return new BukkitQuestCommandHandler(this.plugin).suggest(cs, args);
            }
            if (cmd.getName().equalsIgnoreCase("quests")) {
                return new BukkitQuestsCommandHandler(this.plugin).suggest(cs, args);
            }
            if (cmd.getName().equalsIgnoreCase("questadmin")) {
                return new BukkitQuestadminCommandHandler(this.plugin).suggest(cs, args);
            }
        }
        return null;
    }
}

