/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners;

import java.util.HashSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.nms.BukkitActionBarProvider;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitInventoryUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class BukkitItemListener
implements Listener {
    private final BukkitQuestsPlugin plugin;

    public BukkitItemListener(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.NOTHING)) {
            return;
        }
        if (event.getWhoClicked() instanceof Player && this.plugin.canUseQuests((player = (Player)event.getWhoClicked()).getUniqueId())) {
            ItemStack craftedItem = this.getCraftedItem(event);
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType type = ObjectiveType.CRAFT_ITEM;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    if (this.plugin.getConfigSettings().canPreventExploit() && (craftedItem.getMaxStackSize() == 0 || BukkitInventoryUtil.getEmptySlots(player) < craftedItem.getAmount() / craftedItem.getMaxStackSize())) {
                        BukkitActionBarProvider.sendActionBar(player, ChatColor.RED + BukkitLang.get(player, "inventoryFull"));
                        event.setCancelled(true);
                        return;
                    }
                    quester.craftItem(quest, craftedItem);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.craftItem((Quest)cq, craftedItem);
                    }
                    return null;
                }));
            }
        }
    }

    private ItemStack getCraftedItem(CraftItemEvent event) {
        if (event.isShiftClick()) {
            ItemStack recipeResult = event.getRecipe().getResult();
            int resultAmt = recipeResult.getAmount();
            int leastIngredient = -1;
            for (ItemStack item : event.getInventory().getMatrix()) {
                if (item == null || item.getType().equals((Object)Material.AIR)) continue;
                int re = item.getAmount() * resultAmt;
                if (leastIngredient != -1 && re >= leastIngredient) continue;
                leastIngredient = re;
            }
            return new ItemStack(recipeResult.getType(), leastIngredient, recipeResult.getDurability());
        }
        return event.getCurrentItem();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        block6: {
            Player player;
            block7: {
                if (event.isCancelled()) {
                    return;
                }
                if (!(event.getWhoClicked() instanceof Player)) break block6;
                player = (Player)event.getWhoClicked();
                if (event.getInventory().getType() != InventoryType.FURNACE && !event.getInventory().getType().name().equals("BLAST_FURNACE") && !event.getInventory().getType().name().equals("SMOKER")) break block7;
                if (event.getSlotType() != InventoryType.SlotType.RESULT) break block6;
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                ObjectiveType type = ObjectiveType.SMELT_ITEM;
                HashSet<String> dispatchedQuestIDs = new HashSet<String>();
                for (Quest quest : this.plugin.getLoadedQuests()) {
                    if (!quester.meetsCondition(quest, true)) continue;
                    if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                        quester.smeltItem(quest, event.getCurrentItem());
                    }
                    dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                        if (!dispatchedQuestIDs.contains(cq.getId())) {
                            q.smeltItem((Quest)cq, event.getCurrentItem());
                        }
                        return null;
                    }));
                }
                break block6;
            }
            if (event.getInventory().getType() == InventoryType.BREWING && (event.getSlotType() == InventoryType.SlotType.CRAFTING || event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY))) {
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                ObjectiveType type = ObjectiveType.BREW_ITEM;
                HashSet<String> dispatchedQuestIDs = new HashSet<String>();
                for (Quest quest : this.plugin.getLoadedQuests()) {
                    if (!quester.meetsCondition(quest, true)) continue;
                    if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type) && this.isAllowedBrewingAction(event)) {
                        quester.brewItem(quest, event.getCurrentItem());
                    }
                    dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                        if (!dispatchedQuestIDs.contains(cq.getId()) && this.isAllowedBrewingAction(event)) {
                            q.brewItem((Quest)cq, event.getCurrentItem());
                        }
                        return null;
                    }));
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigSettings().canPreventExploit()) {
            return;
        }
        if (event.getWhoClicked() instanceof Player && event.getInventory().getType() == InventoryType.BREWING) {
            BukkitQuester quester = this.plugin.getQuester(event.getWhoClicked().getUniqueId());
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.getCurrentQuests().containsKey(quest) || !quester.getCurrentStage(quest).containsObjective(ObjectiveType.BREW_ITEM)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    public boolean isAllowedBrewingAction(InventoryClickEvent event) {
        if (!this.plugin.getConfigSettings().canPreventExploit()) {
            return true;
        }
        int slot = event.getRawSlot();
        InventoryAction action = event.getAction();
        if (event.getSlotType() != InventoryType.SlotType.CRAFTING && action.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            event.setCancelled(true);
            return false;
        }
        if (event.getCursor() != null && this.isWaterBottle(event.getCursor())) {
            return true;
        }
        if ((slot == 0 || slot == 1 || slot == 2) && (action.equals((Object)InventoryAction.PLACE_ONE) || action.equals((Object)InventoryAction.PLACE_SOME) || action.equals((Object)InventoryAction.PLACE_ALL))) {
            event.setCancelled(true);
            return false;
        }
        return true;
    }

    public boolean isWaterBottle(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType().equals((Object)Material.POTION)) {
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            if (meta == null) {
                return false;
            }
            if (meta.getBasePotionData().getType().equals((Object)PotionType.WATER)) {
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.canUseQuests(event.getEnchanter().getUniqueId())) {
            ItemStack enchantedItem = event.getItem().clone();
            enchantedItem.setAmount(1);
            enchantedItem.addUnsafeEnchantments(event.getEnchantsToAdd());
            BukkitQuester quester = this.plugin.getQuester(event.getEnchanter().getUniqueId());
            ObjectiveType type = ObjectiveType.ENCHANT_ITEM;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    if (enchantedItem.getType().equals((Object)Material.BOOK)) {
                        quester.enchantBook(quest, enchantedItem, event.getEnchantsToAdd());
                    } else {
                        quester.enchantItem(quest, enchantedItem);
                    }
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        if (enchantedItem.getType().equals((Object)Material.BOOK)) {
                            q.enchantBook((Quest)cq, enchantedItem, event.getEnchantsToAdd());
                        } else {
                            q.enchantItem((Quest)cq, enchantedItem);
                        }
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onConsumeItem(PlayerItemConsumeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.canUseQuests(event.getPlayer().getUniqueId())) {
            ItemStack consumedItem = event.getItem().clone();
            consumedItem.setAmount(1);
            BukkitQuester quester = this.plugin.getQuester(event.getPlayer().getUniqueId());
            ObjectiveType type = ObjectiveType.CONSUME_ITEM;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.consumeItem(quest, consumedItem);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.consumeItem((Quest)cq, consumedItem);
                    }
                    return null;
                }));
            }
        }
    }
}

