/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.player.BukkitQuestProgress;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public abstract class BukkitNpcListener
implements Listener {
    protected final BukkitQuestsPlugin plugin;
    protected final BukkitNpcDependency npcDependency;

    public BukkitNpcListener(BukkitQuestsPlugin plugin, BukkitNpcDependency npcDependency) {
        this.plugin = plugin;
        this.npcDependency = npcDependency;
    }

    public void interactNPC(Player player, UUID npcId, ClickType clickType) {
        if (this.plugin.getQuestFactory().getSelectingNpcs().contains(player.getUniqueId())) {
            if (npcId == null || !this.npcDependency.isNpc(npcId)) {
                this.plugin.getLogger().severe("NPC was null while selecting");
                return;
            }
            player.acceptConversationInput(String.valueOf(npcId));
        }
        if (clickType == ClickType.RIGHT && !player.isConversing()) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            block14: for (Object quest : quester.getCurrentQuests().keySet()) {
                BukkitStage currentStage = (BukkitStage)quester.getCurrentStage((Quest)quest);
                if (!currentStage.containsObjective(ObjectiveType.DELIVER_ITEM)) continue;
                ItemStack hand = player.getItemInHand();
                int currentIndex = -1;
                LinkedList<Integer> matches = new LinkedList<Integer>();
                int reasonCode = 0;
                for (ItemStack is : currentStage.getItemsToDeliver()) {
                    ++currentIndex;
                    reasonCode = BukkitItemUtil.compareItems(is, hand, true);
                    if (reasonCode != 0) continue;
                    matches.add(currentIndex);
                }
                if (!matches.isEmpty()) {
                    for (Integer match : matches) {
                        UUID uuid = currentStage.getItemDeliveryTargets().get(match);
                        if (!uuid.equals(npcId)) continue;
                        quester.deliverToNPC((Quest)quest, uuid, hand);
                        return;
                    }
                    continue;
                }
                if (hand.getType().equals((Object)Material.AIR)) continue;
                for (UUID uuid : currentStage.getItemDeliveryTargets()) {
                    EnchantmentStorageMeta esMeta;
                    boolean hasMeta;
                    if (!uuid.equals(npcId)) continue;
                    String text = "";
                    boolean bl = hasMeta = hand.getItemMeta() != null;
                    if (hasMeta) {
                        text = text + ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + (hand.getItemMeta().hasDisplayName() ? hand.getItemMeta().getDisplayName() + ChatColor.GRAY + " (" : "");
                    }
                    text = text + ChatColor.AQUA + "<item>" + (hand.getDurability() != 0 ? ":" + ChatColor.BLUE + hand.getDurability() : "") + ChatColor.GRAY;
                    if (hasMeta) {
                        text = text + (hand.getItemMeta().hasDisplayName() ? ")" : "");
                    }
                    text = text + " x " + ChatColor.DARK_AQUA + hand.getAmount() + ChatColor.GRAY;
                    if (this.plugin.getConfigSettings().canTranslateNames() && !hasMeta && !hand.getItemMeta().hasDisplayName()) {
                        this.plugin.getLocaleManager().sendMessage(player, BukkitLang.get(player, "questInvalidDeliveryItem").replace("<item>", text), hand.getType(), hand.getDurability(), null);
                    } else {
                        player.sendMessage(BukkitLang.get(player, "questInvalidDeliveryItem").replace("<item>", text).replace("<item>", BukkitItemUtil.getName(hand)));
                    }
                    switch (reasonCode) {
                        case 1: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "one item is null"));
                            break;
                        }
                        case 0: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "ERROR"));
                            break;
                        }
                        case -1: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "name"));
                            break;
                        }
                        case -2: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "amount"));
                            break;
                        }
                        case -3: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "durability"));
                            break;
                        }
                        case -4: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "display name or lore"));
                            break;
                        }
                        case -5: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "enchantments"));
                            break;
                        }
                        case -6: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "stored enchants"));
                            break;
                        }
                        case -7: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "item flags"));
                            break;
                        }
                        case -8: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "book data"));
                            break;
                        }
                        case -9: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "potion type"));
                            break;
                        }
                        case -10: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "fish variant"));
                            break;
                        }
                        default: {
                            player.sendMessage(ChatColor.GRAY + BukkitLang.get(player, "difference").replace("<data>", "unknown"));
                        }
                    }
                    if (!hasMeta || !hand.getType().equals((Object)Material.ENCHANTED_BOOK) || !(esMeta = (EnchantmentStorageMeta)hand.getItemMeta()).hasStoredEnchants()) continue block14;
                    for (Map.Entry e : esMeta.getStoredEnchants().entrySet()) {
                        HashMap<Enchantment, Integer> single = new HashMap<Enchantment, Integer>();
                        single.put((Enchantment)e.getKey(), (Integer)e.getValue());
                        this.plugin.getLocaleManager().sendMessage(player, ChatColor.GRAY + "\u2515 " + ChatColor.DARK_GREEN + "<enchantment> <level>\n", single);
                    }
                    continue block14;
                }
            }
            boolean hasObjective = false;
            for (Quest quest : quester.getCurrentQuests().keySet()) {
                if (!quester.meetsCondition(quest, true) || !quester.getCurrentStage(quest).containsObjective(ObjectiveType.TALK_TO_NPC) || !quester.getCurrentStage(quest).getNpcsToInteract().contains(npcId)) continue;
                int npcIndex = quester.getCurrentStage(quest).getNpcsToInteract().indexOf(npcId);
                if (quester.getQuestProgressOrDefault(quest) != null && npcIndex > -1 && !((BukkitQuestProgress)quester.getQuestProgressOrDefault((Quest)quest)).npcsInteracted.get(npcIndex).booleanValue()) {
                    hasObjective = true;
                }
                quester.interactWithNPC(quest, npcId);
            }
            if (hasObjective || !this.plugin.getQuestNpcUuids().contains(npcId)) {
                return;
            }
            boolean hasAtLeastOneGUI = false;
            LinkedList<Quest> npcQuests = new LinkedList<Quest>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                BukkitQuest bukkitQuest = (BukkitQuest)quest;
                if (quester.getCurrentQuests().containsKey(bukkitQuest) || bukkitQuest.getNpcStart() == null || !bukkitQuest.getNpcStart().equals(npcId)) continue;
                if (this.plugin.getConfigSettings().canIgnoreLockedQuests() && (!quester.getCompletedQuests().contains(bukkitQuest) || bukkitQuest.getPlanner().getCooldown() > -1L)) {
                    if (!bukkitQuest.testRequirements(quester)) continue;
                    npcQuests.add(bukkitQuest);
                    if (bukkitQuest.getGUIDisplay() == null) continue;
                    hasAtLeastOneGUI = true;
                    continue;
                }
                if (quester.getCompletedQuests().contains(bukkitQuest) && bukkitQuest.getPlanner().getCooldown() <= -1L) continue;
                npcQuests.add(bukkitQuest);
                if (bukkitQuest.getGUIDisplay() == null) continue;
                hasAtLeastOneGUI = true;
            }
            if (npcQuests.size() == 1) {
                BukkitQuest quest = (BukkitQuest)npcQuests.get(0);
                if (quester.canAcceptOffer(quest, true)) {
                    quester.setQuestIdToTake(quest.getId());
                    if (!this.plugin.getConfigSettings().canConfirmAccept()) {
                        quester.takeQuest(quest, false);
                    } else if (quest.getGUIDisplay() != null) {
                        quester.showGUIDisplay(npcId, npcQuests);
                    } else {
                        for (String msg : this.extracted(quester).split("<br>")) {
                            player.sendMessage(msg);
                        }
                        this.plugin.getConversationFactory().buildConversation((Conversable)player).begin();
                    }
                }
            } else if (npcQuests.size() > 1) {
                if (hasAtLeastOneGUI) {
                    quester.showGUIDisplay(npcId, npcQuests);
                } else {
                    Conversation c = this.plugin.getNpcConversationFactory().buildConversation((Conversable)player);
                    c.getContext().setSessionData((Object)"npcQuests", npcQuests);
                    c.getContext().setSessionData((Object)"npc", (Object)this.npcDependency.getName(npcId));
                    c.begin();
                }
            } else {
                BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "noMoreQuest"));
            }
        }
    }

    protected void preKillNPC(Entity damager, UUID npcId) {
        if (this.plugin.getDependencies().isNpc(damager)) {
            return;
        }
        ObjectiveType type = ObjectiveType.KILL_NPC;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        Player player = null;
        if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) {
            player = (Player)((Projectile)damager).getShooter();
        } else if (damager instanceof Player) {
            player = (Player)damager;
        }
        if (player != null) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            for (Quest quest : quester.getCurrentQuests().keySet()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.killNPC(quest, npcId);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.killNPC((Quest)cq, npcId);
                    }
                    return null;
                }));
            }
        }
    }

    private String extracted(Quester quester) {
        Quest quest = this.plugin.getQuestById(quester.getQuestIdToTake());
        return MessageFormat.format("{0}- {1}{2}{3} -\n\n{4}{5}\n", ChatColor.GOLD, ChatColor.DARK_PURPLE, quest.getName(), ChatColor.GOLD, ChatColor.RESET, quest.getDescription());
    }

    public static enum ClickType {
        LEFT,
        RIGHT;

    }
}

