/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners;

import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.BukkitUpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.conversations.Conversable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitPlayerListener
implements Listener {
    private final BukkitQuestsPlugin plugin;

    public BukkitPlayerListener(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        ItemStack clicked;
        ItemStack item;
        InventoryAction ac = event.getAction();
        if (ac.equals((Object)InventoryAction.NOTHING)) {
            return;
        }
        if (BukkitItemUtil.isItem(event.getCurrentItem()) && BukkitItemUtil.isJournal(event.getCurrentItem())) {
            if (ac.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || ac.equals((Object)InventoryAction.DROP_ALL_SLOT) || ac.equals((Object)InventoryAction.DROP_ONE_SLOT)) {
                event.setCancelled(true);
                return;
            }
        } else if (BukkitItemUtil.isItem(event.getCurrentItem()) && BukkitItemUtil.isJournal(event.getCursor())) {
            if (ac.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || ac.equals((Object)InventoryAction.DROP_ALL_CURSOR) || ac.equals((Object)InventoryAction.DROP_ONE_CURSOR)) {
                event.setCancelled(true);
                return;
            }
        } else if ((ac.equals((Object)InventoryAction.SWAP_WITH_CURSOR) || ac.equals((Object)InventoryAction.HOTBAR_SWAP) || ac.equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD)) && event.getHotbarButton() > -1 && BukkitItemUtil.isItem(item = event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) && BukkitItemUtil.isJournal(item)) {
            event.setCancelled(true);
            return;
        }
        if (BukkitItemUtil.isItem(event.getCurrentItem()) && BukkitItemUtil.isJournal(event.getCurrentItem()) || BukkitItemUtil.isItem(event.getCursor()) && BukkitItemUtil.isJournal(event.getCursor())) {
            int upper = event.getView().getTopInventory().getSize();
            if (event.getView().getTopInventory().getType().equals((Object)InventoryType.CRAFTING)) {
                upper += 4;
            }
            int lower = event.getView().getBottomInventory().getSize();
            int relative = event.getRawSlot() - upper;
            if (relative < 0 || relative >= lower) {
                event.setCancelled(true);
                return;
            }
        }
        BukkitQuester quester = this.plugin.getQuester(event.getWhoClicked().getUniqueId());
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().contains(BukkitLang.get(player, "quests")) && BukkitItemUtil.isItem(clicked = event.getCurrentItem())) {
            event.setCancelled(true);
            for (Quest quest : this.plugin.getLoadedQuests()) {
                int i;
                BukkitQuest bukkitQuest = (BukkitQuest)quest;
                if (bukkitQuest.getGUIDisplay() == null || (i = BukkitItemUtil.compareItems(clicked, bukkitQuest.prepareDisplay(quester), false)) != 0 && i != -7) continue;
                if (quester.canAcceptOffer(quest, true)) {
                    try {
                        quester.takeQuest(quest, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> event.getWhoClicked().closeInventory(), 1L);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDragEvent(InventoryDragEvent event) {
        if (BukkitItemUtil.isItem(event.getOldCursor()) && BukkitItemUtil.isJournal(event.getOldCursor()) || BukkitItemUtil.isItem(event.getCursor()) && BukkitItemUtil.isJournal(event.getCursor())) {
            int upper = event.getView().getTopInventory().getSize();
            if (event.getView().getTopInventory().getType().equals((Object)InventoryType.CRAFTING)) {
                upper += 4;
            }
            int lower = event.getView().getBottomInventory().getSize();
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int relative = (Integer)iterator.next();
                if ((relative -= upper) >= 0 && relative < lower) continue;
                event.setCancelled(true);
                break;
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (BukkitItemUtil.isJournal(event.getItemDrop().getItemStack()) && !event.getPlayer().hasPermission("quests.admin.drop")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        EquipmentSlot e = null;
        try {
            e = event.getHand();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (e == null || e.equals((Object)EquipmentSlot.HAND)) {
            if (BukkitItemUtil.isJournal(event.getPlayer().getItemInHand())) {
                Player player = event.getPlayer();
                if (event.hasBlock()) {
                    if (event.getClickedBlock() == null) {
                        return;
                    }
                    if (event.getClickedBlock().getType().name().equals("LECTERN") || event.getClickedBlock().getType().name().equals("CHISELED_BOOKSHELF")) {
                        event.setCancelled(true);
                        BukkitLang.send(player, ChatColor.RED + BukkitLang.get(event.getPlayer(), "journalDenied").replace("<journal>", BukkitLang.get(event.getPlayer(), "journalTitle")));
                        return;
                    }
                    if (this.plugin.getConfigSettings().canAllowPranks() && event.getClickedBlock().getType().name().contains("PORTAL")) {
                        event.setCancelled(true);
                        BukkitLang.send(player, " " + ChatColor.AQUA + ChatColor.UNDERLINE + "https://www.youtube.com/watch?v=dQw4w9WgXcQ");
                        return;
                    }
                }
                if (this.plugin.getConfigSettings().canAllowPranks() && event.getPlayer().getInventory().getHelmet() != null && (event.getPlayer().getInventory().getHelmet().getType().name().equals("PUMPKIN") || event.getPlayer().getInventory().getHelmet().getType().name().equals("CARVED_PUMPKIN"))) {
                    if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
                        BukkitLang.send(player, " " + ChatColor.AQUA + ChatColor.UNDERLINE + "https://www.youtube.com/watch?v=nJROKaZJgbI");
                    }
                    event.setCancelled(true);
                    return;
                }
            }
            if (this.plugin.canUseQuests(event.getPlayer().getUniqueId())) {
                BukkitQuester quester = this.plugin.getQuester(event.getPlayer().getUniqueId());
                Player player = event.getPlayer();
                if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                    boolean hasObjective = false;
                    if (!event.isCancelled()) {
                        for (Quest quest : this.plugin.getLoadedQuests()) {
                            if (!quester.getCurrentQuests().containsKey(quest) || !quester.getCurrentStage(quest).containsObjective(ObjectiveType.USE_BLOCK)) continue;
                            hasObjective = true;
                        }
                    }
                    if (!hasObjective) {
                        Location loc;
                        Block block;
                        if (this.plugin.getQuestFactory().getSelectedBlockStarts().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getQuestFactory().getSelectedBlockStarts();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getQuestFactory().setSelectedBlockStarts(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getActionFactory().getSelectedExplosionLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getActionFactory().getSelectedExplosionLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getActionFactory().setSelectedExplosionLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getActionFactory().getSelectedEffectLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getActionFactory().getSelectedEffectLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getActionFactory().setSelectedEffectLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getActionFactory().getSelectedMobLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getActionFactory().getSelectedMobLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getActionFactory().setSelectedMobLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getActionFactory().getSelectedLightningLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getActionFactory().getSelectedLightningLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getActionFactory().setSelectedLightningLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getActionFactory().getSelectedTeleportLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getActionFactory().getSelectedTeleportLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getActionFactory().setSelectedTeleportLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getQuestFactory().getSelectedKillLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getQuestFactory().getSelectedKillLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getQuestFactory().setSelectedKillLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (this.plugin.getQuestFactory().getSelectedReachLocations().containsKey(event.getPlayer().getUniqueId())) {
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            loc = block.getLocation();
                            ConcurrentHashMap<UUID, Block> temp = this.plugin.getQuestFactory().getSelectedReachLocations();
                            temp.put(player.getUniqueId(), block);
                            this.plugin.getQuestFactory().setSelectedReachLocations(temp);
                            if (loc.getWorld() != null) {
                                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questSelectedLocation") + " " + ChatColor.AQUA + loc.getWorld().getName() + ": " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ChatColor.GOLD + " (" + ChatColor.GREEN + BukkitItemUtil.getName(new ItemStack(block.getType())) + ChatColor.GOLD + ")");
                            }
                            event.setCancelled(true);
                        } else if (!player.isConversing()) {
                            for (Quest quest : this.plugin.getLoadedQuests()) {
                                BukkitQuest bukkitQuest = (BukkitQuest)quest;
                                if (bukkitQuest.getBlockStart() == null || event.getClickedBlock() == null || !bukkitQuest.getBlockStart().equals((Object)event.getClickedBlock().getLocation())) continue;
                                if (quester.getCurrentQuests().size() >= this.plugin.getConfigSettings().getMaxQuests() && this.plugin.getConfigSettings().getMaxQuests() > 0) {
                                    String msg = BukkitLang.get(player, "questMaxAllowed");
                                    msg = msg.replace("<number>", String.valueOf(this.plugin.getConfigSettings().getMaxQuests()));
                                    BukkitLang.send(player, ChatColor.YELLOW + msg);
                                    continue;
                                }
                                if (quester.getCompletedQuests().contains(bukkitQuest)) {
                                    if (bukkitQuest.getPlanner().getCooldown() > -1L && quester.getRemainingCooldown(bukkitQuest) > 0L) {
                                        String early = BukkitLang.get(player, "questTooEarly");
                                        early = early.replace("<quest>", bukkitQuest.getName());
                                        early = early.replace("<time>", BukkitMiscUtil.getTime(quester.getRemainingCooldown(bukkitQuest)));
                                        BukkitLang.send(player, ChatColor.YELLOW + early);
                                        continue;
                                    }
                                    if (quester.getCompletedQuests().contains(bukkitQuest) && bukkitQuest.getPlanner().getCooldown() < 0L) {
                                        Object completed = BukkitLang.get(player, "questAlreadyCompleted");
                                        completed = ((String)completed).replace("<quest>", bukkitQuest.getName());
                                        BukkitLang.send(player, ChatColor.YELLOW + (String)completed);
                                        continue;
                                    }
                                }
                                for (Quest currentQuest : quester.getCurrentQuests().keySet()) {
                                    if (!currentQuest.getId().equals(bukkitQuest.getId())) continue;
                                    BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "questAlreadyOn"));
                                    return;
                                }
                                quester.setQuestIdToTake(bukkitQuest.getId());
                                if (!this.plugin.getConfigSettings().canConfirmAccept()) {
                                    quester.takeQuest(bukkitQuest, false);
                                    break;
                                }
                                Quest toTake = this.plugin.getQuestById(quester.getQuestIdToTake());
                                String s = ChatColor.GOLD + "- " + ChatColor.DARK_PURPLE + toTake.getName() + ChatColor.GOLD + " -\n\n" + ChatColor.RESET + toTake.getDescription() + "\n";
                                for (String msg : s.split("<br>")) {
                                    BukkitLang.send(player, msg);
                                }
                                this.plugin.getConversationFactory().buildConversation((Conversable)player).begin();
                                break;
                            }
                        }
                    }
                }
                if (event.getItem() != null && event.getItem().getType().equals((Object)Material.COMPASS)) {
                    if (!quester.canUseCompass()) {
                        return;
                    }
                    if (event.getAction().equals((Object)Action.LEFT_CLICK_AIR) || event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                        quester.resetCompass();
                        BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "compassReset"));
                    } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                        quester.findNextCompassTarget(true);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player;
        if (event.getRightClicked().getType() == EntityType.ITEM_FRAME && BukkitItemUtil.isJournal((player = event.getPlayer()).getItemInHand())) {
            event.setCancelled(true);
            BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "journalDenied").replace("<journal>", BukkitLang.get(player, "journalTitle")));
        }
    }

    @EventHandler
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getItemStack() != null && event.getItemStack().getType() == Material.MILK_BUCKET && this.plugin.canUseQuests((player = event.getPlayer()).getUniqueId())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType type = ObjectiveType.MILK_COW;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.milkCow(quest);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.milkCow((Quest)cq);
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.canUseQuests(event.getPlayer().getUniqueId())) {
            final BukkitQuester quester = this.plugin.getQuester(event.getPlayer().getUniqueId());
            for (final Quest quest : this.plugin.getLoadedQuests()) {
                Stage currentStage;
                if (!quester.meetsCondition(quest, true) || !quester.getCurrentQuests().containsKey(quest) || (currentStage = quester.getCurrentStage(quest)) == null) continue;
                if (!currentStage.getChatActions().isEmpty()) {
                    String chat = event.getMessage();
                    for (final String s : currentStage.getChatActions().keySet()) {
                        if (!s.equalsIgnoreCase(chat)) continue;
                        new BukkitRunnable(){

                            public void run() {
                                currentStage.getChatActions().get(s).fire(quester, quest);
                            }
                        }.runTask((Plugin)this.plugin);
                    }
                }
                ObjectiveType type = ObjectiveType.PASSWORD;
                HashSet<String> dispatchedQuestIDs = new HashSet<String>();
                if (quester.getCurrentStage(quest).containsObjective(type)) {
                    for (String pass : quester.getCurrentStage(quest).getPasswordPhrases()) {
                        if (!pass.equalsIgnoreCase(event.getMessage())) continue;
                        event.setCancelled(true);
                        break;
                    }
                    quester.sayPassword(quest, event);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.sayPassword((Quest)cq, event);
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        BukkitQuester quester;
        if (this.plugin.canUseQuests(event.getPlayer().getUniqueId()) && !(quester = this.plugin.getQuester(event.getPlayer().getUniqueId())).getCurrentQuests().isEmpty()) {
            for (Quest quest : quester.getCurrentQuests().keySet()) {
                if (!quest.getOptions().canAllowCommands() && !event.getMessage().startsWith("/quest")) {
                    Player player = event.getPlayer();
                    BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "optCommandsDenied").replace("<quest>", quest.getName()));
                    event.setCancelled(true);
                    this.plugin.getLogger().info("Player " + player.getName() + " tried to use command " + event.getMessage() + " but was denied because they are currently on quest " + quest.getName());
                    return;
                }
                Stage currentStage = quester.getCurrentStage(quest);
                if (currentStage == null) {
                    this.plugin.getLogger().severe("currentStage was null for " + quester.getUUID().toString() + " on command for quest " + quest.getName());
                    continue;
                }
                if (currentStage.getCommandActions().isEmpty()) continue;
                String command = event.getMessage().toLowerCase();
                for (String s : currentStage.getCommandActions().keySet()) {
                    if (!command.startsWith("/" + s.toLowerCase())) continue;
                    currentStage.getCommandActions().get(s).fire(quester, quest);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity().getType() == EntityType.SHEEP && this.plugin.canUseQuests((player = event.getPlayer()).getUniqueId())) {
            Sheep sheep = (Sheep)event.getEntity();
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType type = ObjectiveType.SHEAR_SHEEP;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.shearSheep(quest, sheep.getColor());
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.shearSheep((Quest)cq, sheep.getColor());
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onEntityTame(EntityTameEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getOwner() instanceof Player && this.plugin.canUseQuests((player = (Player)event.getOwner()).getUniqueId())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType type = ObjectiveType.TAME_MOB;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.tameMob(quest, event.getEntityType());
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.tameMob((Quest)cq, event.getEntityType());
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)event.getEntity().getLastDamageCause();
            Entity damager = damageEvent.getDamager();
            if (damager instanceof Projectile) {
                Projectile projectile = (Projectile)damager;
                if (projectile.getShooter() != null && projectile.getShooter() instanceof Entity) {
                    this.preKillMob((Entity)projectile.getShooter(), (Entity)event.getEntity());
                }
            } else if (damager instanceof TNTPrimed) {
                TNTPrimed tnt = (TNTPrimed)damager;
                Entity source = tnt.getSource();
                if (source != null && source.isValid()) {
                    this.preKillMob(source, (Entity)event.getEntity());
                }
            } else if (damager instanceof Wolf) {
                BukkitQuester quester;
                Wolf wolf = (Wolf)damager;
                if (wolf.isTamed() && wolf.getOwner() != null && (quester = this.plugin.getQuester(wolf.getOwner().getUniqueId())) != null) {
                    this.preKillPlayer((Entity)quester.getPlayer(), (Entity)event.getEntity());
                }
            } else {
                this.preKillMob(damager, (Entity)event.getEntity());
            }
        }
    }

    public void preKillMob(Entity damager, Entity target) {
        if (!this.plugin.canUseQuests(damager.getUniqueId())) {
            return;
        }
        if (damager instanceof Player) {
            if (this.plugin.getDependencies().isNpc(target)) {
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(damager.getUniqueId());
            ObjectiveType type = ObjectiveType.KILL_MOB;
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true) || !quester.getCurrentQuests().containsKey(quest) || !quester.getCurrentStage(quest).containsObjective(type)) continue;
                quester.killMob(quest, target.getLocation(), target.getType());
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player target;
        if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)event.getEntity().getLastDamageCause();
            Entity damager = damageEvent.getDamager();
            if (event.getEntity().getUniqueId().equals(damager.getUniqueId())) {
                return;
            }
            if (damager instanceof Projectile) {
                Projectile projectile = (Projectile)damager;
                if (projectile.getShooter() != null && projectile.getShooter() instanceof Entity) {
                    this.preKillPlayer((Entity)projectile.getShooter(), (Entity)event.getEntity());
                }
            } else if (damager instanceof TNTPrimed) {
                TNTPrimed tnt = (TNTPrimed)damager;
                Entity source = tnt.getSource();
                if (source != null && source.isValid()) {
                    this.preKillPlayer(source, (Entity)event.getEntity());
                }
            } else if (damager instanceof Wolf) {
                Wolf wolf = (Wolf)damager;
                if (wolf.isTamed() && wolf.getOwner() != null) {
                    BukkitQuester quester = this.plugin.getQuester(wolf.getOwner().getUniqueId());
                    this.preKillPlayer((Entity)quester.getPlayer(), (Entity)event.getEntity());
                }
            } else {
                this.preKillPlayer(damager, (Entity)event.getEntity());
            }
        }
        if (this.plugin.canUseQuests((target = event.getEntity()).getUniqueId())) {
            BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
            for (Quest quest : quester.getCurrentQuests().keySet()) {
                Stage stage = quester.getCurrentStage(quest);
                if (stage == null || stage.getDeathAction() == null) continue;
                quester.getCurrentStage(quest).getDeathAction().fire(quester, quest);
            }
        }
        ItemStack found = null;
        for (ItemStack stack : event.getDrops()) {
            if (!BukkitItemUtil.isJournal(stack)) continue;
            found = stack;
            break;
        }
        if (found != null) {
            event.getDrops().remove(found);
        }
    }

    public void preKillPlayer(Entity damager, Entity target) {
        if (damager == null || target == null || damager.equals(target)) {
            return;
        }
        if (!this.plugin.canUseQuests(damager.getUniqueId())) {
            return;
        }
        if (damager instanceof Player && target instanceof Player) {
            if (this.plugin.getDependencies().isNpc(damager) && this.plugin.getDependencies().isNpc(target)) {
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(damager.getUniqueId());
            ObjectiveType type = ObjectiveType.KILL_PLAYER;
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true) || !quester.getCurrentQuests().containsKey(quest) || !quester.getCurrentStage(quest).containsObjective(type)) continue;
                quester.killPlayer(quest, (Player)target);
            }
        }
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            ObjectiveType type = ObjectiveType.CATCH_FISH;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quester.meetsCondition(quest, true) || !event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH)) continue;
                if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest).containsObjective(type)) {
                    quester.catchFish(quest);
                }
                dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                    if (!dispatchedQuestIDs.contains(cq.getId())) {
                        q.catchFish((Quest)cq);
                    }
                    return null;
                }));
            }
        }
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            quester.findCompassTarget();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                quester.meetsCondition(quest, true);
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, quester::findCompassTarget, 10L);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("quests.admin.update")) {
            new BukkitUpdateChecker(this.plugin, 3711).getVersion(version -> {
                if (BukkitUpdateChecker.compareVersions(this.plugin.getDescription().getVersion().split("-")[0], version)) {
                    event.getPlayer().sendMessage(ChatColor.GRAY + "[" + ChatColor.YELLOW + "Quests" + ChatColor.GRAY + "] " + ChatColor.GREEN + BukkitLang.get(player, "updateTo").replace("<version>", (CharSequence)version).replace("<url>", ChatColor.DARK_AQUA + "" + ChatColor.UNDERLINE + this.plugin.getDescription().getWebsite()));
                }
            });
        }
        if (this.plugin.canUseQuests(player.getUniqueId())) {
            BukkitQuester noobCheck = new BukkitQuester(this.plugin, player.getUniqueId());
            if (this.plugin.getConfigSettings().canGenFilesOnJoin() && !noobCheck.hasData()) {
                noobCheck.saveData();
            }
            this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                CompletableFuture<Quester> cf = this.plugin.getStorage().loadQuester(player.getUniqueId());
                try {
                    Quester quester = cf.get();
                    if (quester == null) {
                        return;
                    }
                    for (Quest q : quester.getCompletedQuests()) {
                        if (q == null || quester.getCompletedTimes().containsKey(q) || q.getPlanner().getCooldown() <= -1L) continue;
                        quester.getCompletedTimes().put(q, System.currentTimeMillis());
                    }
                    for (Quest quest : quester.getCurrentQuests().keySet()) {
                        quester.checkQuest(quest);
                    }
                    for (Quest quest : quester.getCurrentQuests().keySet()) {
                        if (quester.getCurrentStage(quest).getDelay() <= -1L) continue;
                        quester.startStageTimer(quest);
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        boolean alreadyHasAtLeastOneGlobalQuest = false;
                        for (Quest cq : quester.getCurrentQuests().keySet()) {
                            if (!cq.getOptions().canGiveGloballyAtLogin()) continue;
                            alreadyHasAtLeastOneGlobalQuest = true;
                            break;
                        }
                        for (Quest quest : this.plugin.getLoadedQuests()) {
                            if (!quest.getOptions().canGiveGloballyAtLogin() || quester.getCurrentQuests().containsKey(quest)) continue;
                            if (quester.getCompletedQuests().contains(quest) && quest.getPlanner().getCooldown() < 0L) {
                                if (this.plugin.getConfigSettings().getConsoleLogging() <= 3) continue;
                                this.plugin.getLogger().info(quester.getUUID() + " ignored global quest ID " + quest.getId() + " because it was already completed");
                                continue;
                            }
                            if (!quest.getOptions().canAllowStackingGlobal() && alreadyHasAtLeastOneGlobalQuest) {
                                if (this.plugin.getConfigSettings().getConsoleLogging() <= 3) continue;
                                this.plugin.getLogger().info(quester.getUUID() + " denied global quest ID " + quest.getId() + " because it was not stackable");
                                continue;
                            }
                            if (!quester.canAcceptOffer(quest, quest.getOptions().canInformOnStart())) continue;
                            alreadyHasAtLeastOneGlobalQuest = true;
                            quester.takeQuest(quest, false);
                        }
                        if (quester.hasJournal()) {
                            quester.updateJournal();
                        }
                        quester.findCompassTarget();
                    }, 40L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 20L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.canUseQuests(event.getPlayer().getUniqueId())) {
            ConcurrentSkipListSet temp;
            BukkitQuester quester = this.plugin.getQuester(event.getPlayer().getUniqueId());
            for (Quest quest : quester.getCurrentQuests().keySet()) {
                Stage currentStage = quester.getCurrentStage(quest);
                if (currentStage == null) {
                    this.plugin.getLogger().severe("currentStage was null for " + quester.getUUID().toString() + " on quit for quest " + quest.getName());
                    continue;
                }
                if (currentStage.getDelay() > -1L) {
                    quester.stopStageTimer(quest);
                }
                if (currentStage.getDisconnectAction() == null) continue;
                currentStage.getDisconnectAction().fire(quester, quest);
            }
            if (!this.plugin.getConfigSettings().canGenFilesOnJoin()) {
                if (quester.hasBaseData()) {
                    quester.saveData();
                }
            } else {
                quester.saveData();
            }
            if (this.plugin.getQuestFactory().getSelectingNpcs().contains(event.getPlayer().getUniqueId())) {
                temp = this.plugin.getQuestFactory().getSelectingNpcs();
                temp.remove(event.getPlayer().getUniqueId());
                this.plugin.getQuestFactory().setSelectingNpcs(temp);
            }
            temp = (ConcurrentSkipListSet)this.plugin.getOfflineQuesters();
            temp.removeIf(q -> q.getUUID().equals(quester.getUUID()));
            temp.add(quester);
            this.plugin.setOfflineQuesters(temp);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getTo() == null) {
            return;
        }
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        if (this.plugin.getDependencies().isNpc((Entity)event.getPlayer())) {
            return;
        }
        this.playerMove(event.getPlayer().getUniqueId(), event.getTo());
    }

    public void playerMove(UUID uuid, Location location) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            BukkitQuester quester = this.plugin.getQuester(uuid);
            if (quester != null && this.plugin.canUseQuests(uuid)) {
                ObjectiveType type = ObjectiveType.REACH_LOCATION;
                HashSet<String> dispatchedQuestIDs = new HashSet<String>();
                for (Quest quest : this.plugin.getLoadedQuests()) {
                    if (!quester.meetsCondition(quest, true)) continue;
                    if (quester.getCurrentQuests().containsKey(quest) && quester.getCurrentStage(quest) != null && quester.getCurrentStage(quest).containsObjective(type)) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> quester.reachLocation(quest, location));
                    }
                    dispatchedQuestIDs.addAll(quester.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                        if (!dispatchedQuestIDs.contains(cq.getId())) {
                            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> q.reachLocation((Quest)cq, location));
                        }
                        return null;
                    }));
                }
            }
        });
    }
}

