/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners;

import me.pikamug.quests.util.BukkitLang;
import me.pikamug.unite.api.events.PartyCreateEvent;
import me.pikamug.unite.api.events.PartyDeleteEvent;
import me.pikamug.unite.api.events.PartyJoinEvent;
import me.pikamug.unite.api.events.PartyLeaveEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class BukkitUniteListener
implements Listener {
    @EventHandler
    public void onPartyCreate(PartyCreateEvent event) {
        Player p;
        if (event.getCreator() != null && (p = Bukkit.getServer().getPlayer(event.getCreator())) != null && !BukkitLang.get("questPartiesCreate").isEmpty()) {
            BukkitLang.send(p, ChatColor.YELLOW + BukkitLang.get("questPartiesCreate"));
        }
    }

    @EventHandler
    public void onPartyDelete(PartyDeleteEvent event) {
        Player p;
        if (event.getDisbander() != null && (p = Bukkit.getServer().getPlayer(event.getDisbander())) != null && !BukkitLang.get("questPartiesDelete").isEmpty()) {
            BukkitLang.send(p, ChatColor.RED + BukkitLang.get("questPartiesDelete"));
        }
    }

    @EventHandler
    public void onPlayerJoinEvent(PartyJoinEvent event) {
        Player p = Bukkit.getServer().getPlayer(event.getPlayer());
        if (p != null && !BukkitLang.get("questPartiesLeave").isEmpty()) {
            BukkitLang.send(p, ChatColor.GREEN + BukkitLang.get(p, "questPartiesJoin"));
            if (!BukkitLang.get("questPartiesJoinBroadcast").isEmpty()) {
                for (Player online : Bukkit.getOnlinePlayers()) {
                    if (event.getPlayer().equals(online.getUniqueId()) || !event.getPartyProvider().areInSameParty(p, online)) continue;
                    online.sendMessage(ChatColor.GREEN + BukkitLang.get("questPartiesJoinBroadcast").replace("<player>", p.getName()));
                }
            }
        }
    }

    @EventHandler
    public void onPlayerLeaveEvent(PartyLeaveEvent event) {
        Player p = Bukkit.getServer().getPlayer(event.getPlayer());
        if (p != null && !BukkitLang.get("questPartiesLeave").isEmpty()) {
            BukkitLang.send(p, ChatColor.RED + BukkitLang.get(p, "questPartiesLeave"));
            if (!BukkitLang.get("questPartiesLeaveBroadcast").isEmpty()) {
                for (Player online : Bukkit.getOnlinePlayers()) {
                    if (event.getPlayer().equals(online.getUniqueId()) || !event.getPartyProvider().areInSameParty(p, online)) continue;
                    online.sendMessage(ChatColor.RED + BukkitLang.get("questPartiesLeaveBroadcast").replace("<player>", p.getName()));
                }
            }
        }
    }
}

