/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.listeners.npc;

import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.npc.citizens.BukkitCitizensDependency;
import me.pikamug.quests.listeners.BukkitNpcListener;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class BukkitCitizensListener
extends BukkitNpcListener {
    public BukkitCitizensListener(BukkitQuestsPlugin plugin, BukkitCitizensDependency npcDependency) {
        super(plugin, npcDependency);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onNPCRightClick(NPCRightClickEvent event) {
        this.interactNPC(event.getClicker(), event.getNPC() != null ? event.getNPC().getUniqueId() : null, BukkitNpcListener.ClickType.RIGHT);
    }

    @EventHandler
    public void onNPCLeftClick(NPCLeftClickEvent event) {
        this.interactNPC(event.getClicker(), event.getNPC() != null ? event.getNPC().getUniqueId() : null, BukkitNpcListener.ClickType.LEFT);
    }

    @EventHandler
    public void onNPCDeath(NPCDeathEvent event) {
        if (event.getNPC() == null || event.getNPC().getEntity() == null || event.getNPC().getEntity().getLastDamageCause() == null) {
            return;
        }
        if (event.getNPC().getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)event.getNPC().getEntity().getLastDamageCause();
            Entity damager = damageEvent.getDamager();
            UUID npcId = event.getNPC().getUniqueId();
            this.preKillNPC(damager, npcId);
        }
    }
}

