/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

public class BukkitQuestsLog4JFilter
extends AbstractFilter {
    private static final long serialVersionUID = -5594073755007974514L;

    private static Filter.Result validateMessage(String message) {
        if (message == null) {
            return Filter.Result.NEUTRAL;
        }
        if (message.contains("[PikaMug]")) {
            return Filter.Result.DENY;
        }
        if (message.contains("quests-hikari - Shutdown")) {
            return Filter.Result.DENY;
        }
        if (message.contains("quests choice")) {
            return Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(LogEvent event) {
        if (event == null) {
            return Filter.Result.NEUTRAL;
        }
        return BukkitQuestsLog4JFilter.validateMessage(event.getMessage().getFormattedMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return BukkitQuestsLog4JFilter.validateMessage(msg.getFormattedMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return BukkitQuestsLog4JFilter.validateMessage(msg);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        if (msg == null) {
            return Filter.Result.NEUTRAL;
        }
        return BukkitQuestsLog4JFilter.validateMessage(msg.toString());
    }
}

