/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.module;

import java.io.File;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.events.quester.BukkitQuesterPostUpdateObjectiveEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreUpdateObjectiveEvent;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.player.BukkitQuestProgress;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitObjective;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.stack.BlockItemStack;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;

public class BukkitCustomObjective
implements CustomObjective,
Listener {
    private final BukkitQuestsPlugin plugin = (BukkitQuestsPlugin)BukkitQuestsPlugin.getPlugin(BukkitQuestsPlugin.class);
    private String name = null;
    private String author = null;
    private String display = "Progress: %count%";
    private Map.Entry<String, Short> item = new AbstractMap.SimpleEntry<String, Short>("BOOK", (short)0);
    private final LinkedList<Map.Entry<String, Object>> data = new LinkedList();
    private final Map<String, String> descriptions = new HashMap<String, String>();
    private String countPrompt = "Enter number";
    private boolean showCount = true;
    private int count = 1;

    @Override
    public String getModuleName() {
        return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getName().replace(".jar", "");
    }

    @Override
    public Map.Entry<String, Short> getModuleItem() {
        return new AbstractMap.SimpleEntry<String, Short>("IRON_INGOT", (short)0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(String display) {
        this.display = display;
    }

    @Override
    public Map.Entry<String, Short> getItem() {
        return this.item;
    }

    @Override
    public void setItem(String type, short durability) {
        this.item = new AbstractMap.SimpleEntry<String, Short>(type, durability);
    }

    @Override
    public LinkedList<Map.Entry<String, Object>> getData() {
        return this.data;
    }

    @Override
    public void addStringPrompt(String title, String description, Object defaultValue) {
        AbstractMap.SimpleEntry<String, Object> prompt = new AbstractMap.SimpleEntry<String, Object>(title, defaultValue);
        this.data.add(prompt);
        this.descriptions.put(title, description);
    }

    @Override
    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public String getCountPrompt() {
        return this.countPrompt;
    }

    @Override
    public void setCountPrompt(String countPrompt) {
        this.countPrompt = countPrompt;
    }

    @Override
    public boolean canShowCount() {
        return this.showCount;
    }

    @Override
    public void setShowCount(boolean showCount) {
        this.showCount = showCount;
    }

    @Override
    public Map<String, Object> getDataForPlayer(UUID uuid, CustomObjective customObj, Quest quest) {
        BukkitCustomObjective bukkitCustomObj = (BukkitCustomObjective)customObj;
        BukkitQuest bukkitQuest = (BukkitQuest)quest;
        BukkitQuester quester = this.plugin.getQuester(uuid);
        if (quester != null) {
            Stage currentStage = quester.getCurrentStage(bukkitQuest);
            if (currentStage == null) {
                return null;
            }
            CustomObjective found = null;
            for (CustomObjective co : currentStage.getCustomObjectives()) {
                if (!co.getName().equals(bukkitCustomObj.getName())) continue;
                found = co;
                break;
            }
            if (found != null) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                for (Map.Entry entry : found.getData()) {
                    for (Map.Entry entry2 : currentStage.getCustomObjectiveData()) {
                        if (!((String)entry2.getKey()).equals(entry.getKey())) continue;
                        m.put((String)entry2.getKey(), entry2.getValue());
                    }
                }
                if (!m.isEmpty()) {
                    return m;
                }
            }
        }
        return null;
    }

    @Override
    public void incrementObjective(UUID uuid, CustomObjective customObj, Quest quest, int count) {
        BukkitCustomObjective bukkitCustomObj = (BukkitCustomObjective)customObj;
        BukkitQuest bukkitQuest = (BukkitQuest)quest;
        BukkitQuester quester = this.plugin.getQuester(uuid);
        if (quester != null && quester.hasCustomObjective(bukkitQuest, bukkitCustomObj.getName())) {
            if (!quester.meetsCondition(bukkitQuest, true)) {
                return;
            }
            int index = -1;
            BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)quester.getQuestProgressOrDefault(bukkitQuest);
            LinkedList<Integer> customObjCounts = bukkitQuestProgress.customObjectiveCounts;
            for (CustomObjective co : quester.getCurrentStage(bukkitQuest).getCustomObjectives()) {
                ++index;
                if (!co.getName().equals(this.getName())) continue;
                if (index >= customObjCounts.size()) {
                    this.plugin.getLogger().severe("Index was larger than count for " + bukkitCustomObj.getName() + " by " + bukkitCustomObj.getAuthor());
                    continue;
                }
                int old = customObjCounts.get(index);
                bukkitQuestProgress.customObjectiveCounts.set(index, old + count);
                break;
            }
            if (index > -1) {
                int progress = customObjCounts.get(index);
                int goal = quester.getCurrentStage(bukkitQuest).getCustomObjectiveCounts().get(index);
                ObjectiveType type = ObjectiveType.CUSTOM;
                BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(quester, bukkitQuest, new BukkitObjective(type, null, progress, goal));
                this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                if (progress >= goal) {
                    quester.finishObjective(bukkitQuest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, goal, (short)0)), null, null, null, null, null, null, bukkitCustomObj);
                    int finalIndex = index;
                    quester.dispatchMultiplayerObjectives(bukkitQuest, quester.getCurrentStage(bukkitQuest), q -> {
                        BukkitQuestProgress qBukkitQuestProgress = (BukkitQuestProgress)q.getQuestProgressOrDefault(bukkitQuest);
                        int old = qBukkitQuestProgress.customObjectiveCounts.get(finalIndex);
                        qBukkitQuestProgress.customObjectiveCounts.set(finalIndex, old + count);
                        q.finishObjective(bukkitQuest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, goal, (short)0)), null, null, null, null, null, null, bukkitCustomObj);
                        return null;
                    });
                }
                BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(quester, bukkitQuest, new BukkitObjective(type, null, progress, goal));
                this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
            }
        }
    }
}

