/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.nms;

import java.util.Map;
import me.pikamug.quests.enums.BukkitPreBuiltParticle;
import me.pikamug.quests.nms.BukkitParticleProvider_Modern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public abstract class BukkitParticleProvider {
    private static BukkitParticleProvider loaded;

    abstract Map<BukkitPreBuiltParticle, Object> getParticleMap();

    abstract void spawnParticle(Player var1, Location var2, Object var3, float var4, float var5, float var6, float var7, int var8, int[] var9);

    public static void sendToPlayer(Player player, Location location, String particleId, float offsetX, float offsetY, float offsetZ, float speed, int count, int[] data) {
        Object particle;
        BukkitPreBuiltParticle pbp = BukkitPreBuiltParticle.fromIdentifier(particleId);
        if (pbp != null) {
            particle = loaded.getParticleMap().get((Object)pbp);
        } else {
            try {
                particle = Particle.valueOf((String)particleId);
            }
            catch (IllegalArgumentException exception) {
                return;
            }
        }
        loaded.spawnParticle(player, location, particle, offsetX, offsetY, offsetZ, speed, count, data);
    }

    public static void sendToPlayer(Player player, Location location, String particleId) {
        BukkitPreBuiltParticle particle = BukkitPreBuiltParticle.fromIdentifier(particleId);
        if (particle != null) {
            Location pos = location.clone();
            if (particle.getVector() != null) {
                pos.add(particle.getVector());
            }
            BukkitParticleProvider.sendToPlayer(player, location, particle);
        } else {
            try {
                loaded.spawnParticle(player, location, Particle.valueOf((String)particleId), 0.0f, 0.0f, 0.0f, 1.0f, 3, null);
            }
            catch (NoClassDefFoundError e1) {
                Bukkit.getLogger().severe("[Quests] This protocol does not support npc-effect: " + particleId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static void sendToPlayer(Player player, Location location, BukkitPreBuiltParticle particle) {
        Location pos = location.clone();
        if (particle.getVector() != null) {
            pos.add(particle.getVector());
        }
        try {
            loaded.spawnParticle(player, pos, loaded.getParticleMap().get((Object)particle), particle.getOffsetX(), particle.getOffsetY(), particle.getOffsetZ(), particle.getSpeed(), particle.getCount(), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion().split("-")[0];
        try {
            String packageName = BukkitParticleProvider.class.getPackage().getName();
            if (bukkitVersion.startsWith("1.8.") || bukkitVersion.equals("1.8")) {
                String internalsName = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
                loaded = (BukkitParticleProvider)Class.forName(packageName + ".BukkitParticleProvider_" + internalsName).newInstance();
            } else {
                loaded = new BukkitParticleProvider_Modern();
            }
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            Bukkit.getLogger().severe("[Quests] No valid particle implementation for version " + bukkitVersion);
        }
    }
}

