/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.player;

import com.alessiodp.parties.api.interfaces.Party;
import com.alessiodp.parties.api.interfaces.PartyPlayer;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.conditions.BukkitCondition;
import me.pikamug.quests.config.BukkitConfigSettings;
import me.pikamug.quests.convo.misc.QuestAbandonPrompt;
import me.pikamug.quests.dependencies.BukkitDependencies;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.entity.BukkitCountableMob;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.events.quest.QuestQuitEvent;
import me.pikamug.quests.events.quest.QuestTakeEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPostStartQuestEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPostUpdateObjectiveEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreOpenGUIEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreStartQuestEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreUpdateObjectiveEvent;
import me.pikamug.quests.item.BukkitQuestJournal;
import me.pikamug.quests.libs.localelib.LocaleManager;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.module.CustomRequirement;
import me.pikamug.quests.nms.BukkitActionBarProvider;
import me.pikamug.quests.nms.BukkitTitleProvider;
import me.pikamug.quests.player.BukkitQuestProgress;
import me.pikamug.quests.player.QuestProgress;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitObjective;
import me.pikamug.quests.quests.components.BukkitRequirements;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.quests.components.Objective;
import me.pikamug.quests.quests.components.Planner;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.tasks.BukkitStageTimer;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitInventoryUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.RomanNumeral;
import me.pikamug.quests.util.stack.BlockItemStack;
import me.pikamug.unite.api.objects.PartyProvider;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitQuester
implements Quester {
    private final BukkitQuestsPlugin plugin;
    private UUID id;
    protected String questIdToTake;
    protected String questIdToQuit;
    private String lastKnownName;
    protected int questPoints = 0;
    private String compassTargetQuestId;
    private long lastNotifiedCondition = 0L;
    protected ConcurrentHashMap<Integer, Quest> timers = new ConcurrentHashMap();
    protected ConcurrentHashMap<Quest, Integer> currentQuests = new ConcurrentHashMap<Quest, Integer>(){
        private static final long serialVersionUID = 6361484975823846780L;

        @Override
        public Integer put(@NotNull Quest key, @NotNull Integer val) {
            Integer data = super.put(key, val);
            BukkitQuester.this.updateJournal();
            return data;
        }

        @Override
        public Integer remove(@NotNull Object key) {
            Integer i = (Integer)super.remove(key);
            BukkitQuester.this.updateJournal();
            return i;
        }

        @Override
        public void clear() {
            super.clear();
            BukkitQuester.this.updateJournal();
        }

        @Override
        public void putAll(Map<? extends Quest, ? extends Integer> m) {
            super.putAll(m);
            BukkitQuester.this.updateJournal();
        }
    };
    protected ConcurrentSkipListSet<Quest> completedQuests = new ConcurrentSkipListSet<Quest>(){
        private static final long serialVersionUID = -269110128568487000L;

        @Override
        public boolean add(Quest e) {
            boolean b = super.add(e);
            BukkitQuester.this.updateJournal();
            return b;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Quest> c) {
            boolean b = super.addAll(c);
            BukkitQuester.this.updateJournal();
            return b;
        }

        @Override
        public void clear() {
            super.clear();
            BukkitQuester.this.updateJournal();
        }

        @Override
        public boolean remove(Object o) {
            boolean b = super.remove(o);
            BukkitQuester.this.updateJournal();
            return b;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean b = super.removeAll(c);
            BukkitQuester.this.updateJournal();
            return b;
        }
    };
    protected ConcurrentHashMap<Quest, Long> completedTimes = new ConcurrentHashMap();
    protected ConcurrentHashMap<Quest, Integer> amountsCompleted = new ConcurrentHashMap<Quest, Integer>(){
        private static final long serialVersionUID = 5475202358792520975L;

        @Override
        public Integer put(@NotNull Quest key, @NotNull Integer val) {
            Integer data = super.put(key, val);
            BukkitQuester.this.updateJournal();
            return data;
        }

        @Override
        public Integer remove(@NotNull Object key) {
            Integer i = (Integer)super.remove(key);
            BukkitQuester.this.updateJournal();
            return i;
        }

        @Override
        public void clear() {
            super.clear();
            BukkitQuester.this.updateJournal();
        }

        @Override
        public void putAll(Map<? extends Quest, ? extends Integer> m) {
            super.putAll(m);
            BukkitQuester.this.updateJournal();
        }
    };
    protected ConcurrentHashMap<Quest, BukkitQuestProgress> questProgress = new ConcurrentHashMap<Quest, BukkitQuestProgress>(){
        private static final long serialVersionUID = -4607112433003926066L;

        @Override
        public BukkitQuestProgress put(@NotNull Quest key, @NotNull BukkitQuestProgress val) {
            BukkitQuestProgress data = super.put(key, val);
            BukkitQuester.this.updateJournal();
            return data;
        }

        @Override
        public BukkitQuestProgress remove(@NotNull Object key) {
            BukkitQuestProgress data = (BukkitQuestProgress)super.remove(key);
            BukkitQuester.this.updateJournal();
            return data;
        }

        @Override
        public void clear() {
            super.clear();
            BukkitQuester.this.updateJournal();
        }

        @Override
        public void putAll(Map<? extends Quest, ? extends BukkitQuestProgress> m) {
            super.putAll(m);
            BukkitQuester.this.updateJournal();
        }
    };

    public BukkitQuester(BukkitQuestsPlugin plugin, UUID uuid) {
        this.plugin = plugin;
        this.id = uuid;
        this.lastKnownName = this.getPlayer() != null ? this.getPlayer().getName() : this.getOfflinePlayer().getName();
        if (this.lastKnownName == null) {
            this.lastKnownName = String.valueOf(System.currentTimeMillis());
        }
    }

    @Override
    public int compareTo(Quester quester) {
        return this.id.compareTo(quester.getUUID());
    }

    @Override
    public UUID getUUID() {
        return this.id;
    }

    @Override
    public void setUUID(UUID id) {
        this.id = id;
    }

    @Override
    public String getQuestIdToTake() {
        return this.questIdToTake;
    }

    @Override
    public void setQuestIdToTake(String questIdToTake) {
        this.questIdToTake = questIdToTake;
    }

    @Override
    public String getQuestIdToQuit() {
        return this.questIdToQuit;
    }

    @Override
    public void setQuestIdToQuit(String questIdToQuit) {
        this.questIdToQuit = questIdToQuit;
    }

    @Override
    public String getLastKnownName() {
        return this.lastKnownName;
    }

    @Override
    public void setLastKnownName(String lastKnownName) {
        this.lastKnownName = lastKnownName;
    }

    @Override
    public int getQuestPoints() {
        return this.questPoints;
    }

    @Override
    public void setQuestPoints(int questPoints) {
        this.questPoints = questPoints;
    }

    @Override
    public Quest getCompassTarget() {
        return this.compassTargetQuestId != null ? this.plugin.getQuestById(this.compassTargetQuestId) : null;
    }

    @Override
    public void setCompassTarget(Quest quest) {
        if (quest != null) {
            this.compassTargetQuestId = quest.getId();
        }
    }

    @Override
    public ConcurrentHashMap<Integer, Quest> getTimers() {
        return this.timers;
    }

    @Override
    public void setTimers(ConcurrentHashMap<Integer, Quest> timers) {
        this.timers = timers;
    }

    @Override
    public void removeTimer(Integer timerId) {
        this.timers.remove(timerId);
    }

    @Override
    public ConcurrentHashMap<Quest, Integer> getCurrentQuests() {
        ConcurrentHashMap<Quest, Integer> map = new ConcurrentHashMap<Quest, Integer>();
        for (Map.Entry<Quest, Integer> cq : this.currentQuests.entrySet()) {
            BukkitQuest q = (BukkitQuest)cq.getKey();
            map.put(q, cq.getValue());
        }
        return map;
    }

    @Override
    public void setCurrentQuests(ConcurrentHashMap<Quest, Integer> currentQuests) {
        this.currentQuests = currentQuests;
    }

    @Override
    public ConcurrentSkipListSet<Quest> getCompletedQuests() {
        ConcurrentSkipListSet<Quest> set = new ConcurrentSkipListSet<Quest>();
        for (Quest iq : this.completedQuests) {
            BukkitQuest q = (BukkitQuest)iq;
            set.add(q);
        }
        return set;
    }

    @Override
    public void setCompletedQuests(ConcurrentSkipListSet<Quest> completedQuests) {
        this.completedQuests = completedQuests;
    }

    @Override
    public ConcurrentHashMap<Quest, Long> getCompletedTimes() {
        return this.completedTimes;
    }

    @Override
    public void setCompletedTimes(ConcurrentHashMap<Quest, Long> completedTimes) {
        this.completedTimes = completedTimes;
    }

    @Override
    public ConcurrentHashMap<Quest, Integer> getAmountsCompleted() {
        return this.amountsCompleted;
    }

    @Override
    public void setAmountsCompleted(ConcurrentHashMap<Quest, Integer> amountsCompleted) {
        this.amountsCompleted = amountsCompleted;
    }

    public ConcurrentHashMap<Quest, BukkitQuestProgress> getQuestProgress() {
        return this.questProgress;
    }

    public void setQuestProgress(ConcurrentHashMap<Quest, BukkitQuestProgress> questProgress) {
        this.questProgress = questProgress;
    }

    @Override
    public Player getPlayer() {
        return this.plugin.getServer().getPlayer(this.id);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return this.plugin.getServer().getOfflinePlayer(this.id);
    }

    @Override
    public void sendMessage(String message) {
        if (this.getPlayer() == null || !this.getPlayer().isOnline() || message.trim().isEmpty()) {
            return;
        }
        this.getPlayer().sendMessage(message);
    }

    @Override
    public Stage getCurrentStage(Quest quest) {
        if (this.currentQuests.containsKey(quest)) {
            return quest.getStage(this.currentQuests.get(quest));
        }
        return null;
    }

    @Override
    public QuestProgress getQuestDataOrDefault(Quest quest) {
        return this.getQuestProgressOrDefault(quest);
    }

    @Override
    public QuestProgress getQuestProgressOrDefault(Quest quest) {
        if (this.questProgress.get(quest) != null) {
            return this.questProgress.get(quest);
        }
        if (this.currentQuests.get(quest) != null) {
            this.addEmptiesFor(quest, this.currentQuests.get(quest));
        }
        return new BukkitQuestProgress(this);
    }

    @Override
    public boolean hasJournal() {
        return this.getJournal() != null;
    }

    @Override
    public ItemStack getJournal() {
        if (this.getPlayer() == null || !this.getPlayer().isOnline()) {
            return null;
        }
        for (ItemStack is : this.getPlayer().getInventory().getContents()) {
            if (!BukkitItemUtil.isJournal(is)) continue;
            return is;
        }
        return null;
    }

    @Override
    public int getJournalIndex() {
        if (this.getPlayer() == null || !this.getPlayer().isOnline()) {
            return -1;
        }
        ItemStack[] arr = this.getPlayer().getInventory().getContents();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null || !BukkitItemUtil.isJournal(arr[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateJournal() {
        if (this.getPlayer() == null) {
            return;
        }
        if (!this.getPlayer().isOnline()) {
            this.plugin.getLogger().info("Could not update Quests Journal for " + this.getPlayer().getName() + " while offline");
            return;
        }
        int index = this.getJournalIndex();
        if (index != -1) {
            BukkitQuestJournal journal = new BukkitQuestJournal(this.plugin, this);
            this.getPlayer().getInventory().setItem(index, journal.toItemStack());
        }
    }

    @Override
    public boolean offerQuest(Quest quest, boolean giveReason) {
        if (quest == null) {
            return false;
        }
        QuestTakeEvent event = new QuestTakeEvent(quest, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (this.canAcceptOffer(quest, giveReason) && this.getPlayer() != null) {
            if (!this.getPlayer().isConversing()) {
                this.setQuestIdToTake(quest.getId());
                String s = ChatColor.GOLD + BukkitConfigUtil.parseString(BukkitLang.get("questObjectivesTitle") + "\n" + ChatColor.RESET + quest.getDescription(), quest, this.getPlayer());
                for (String msg : s.split("<br>")) {
                    this.sendMessage(msg);
                }
                if (!this.plugin.getConfigSettings().canConfirmAccept()) {
                    this.takeQuest(quest, false);
                } else {
                    this.plugin.getConversationFactory().buildConversation((Conversable)this.getPlayer()).begin();
                }
                return true;
            }
            this.sendMessage(ChatColor.YELLOW + BukkitLang.get(this.getPlayer(), "alreadyConversing"));
        }
        return false;
    }

    @Override
    public boolean canAcceptOffer(Quest quest, boolean giveReason) {
        String msg;
        if (quest == null) {
            return false;
        }
        BukkitQuest bukkitQuest = (BukkitQuest)quest;
        if (!this.plugin.getConfigSettings().canAllowCommandsForNpcQuests() && bukkitQuest.getNpcStart() != null && this.getPlayer().getLocation().getWorld() != null) {
            UUID uuid = bukkitQuest.getNpcStart();
            for (BukkitNpcDependency npcDependency : this.plugin.getDependencies().getNpcDependencies()) {
                Location npcLocation = npcDependency.getLocation(uuid);
                if (npcLocation == null || npcLocation.getWorld() == null || !npcLocation.getWorld().getName().equals(this.getPlayer().getLocation().getWorld().getName()) || !(npcLocation.distance(this.getPlayer().getLocation()) > 6.0)) continue;
                if (giveReason) {
                    String msg2 = BukkitLang.get(this.getPlayer(), "mustSpeakTo").replace("<npc>", this.plugin.getDependencies().getNpcName(uuid));
                    this.sendMessage(ChatColor.YELLOW + msg2);
                }
                return false;
            }
        }
        if (quest.getOptions().canGiveGloballyAtLogin() && !quest.getOptions().canOverrideMaxQuests() && this.getCurrentQuests().size() >= this.plugin.getConfigSettings().getMaxQuests()) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "questMaxAllowed").replace("<number>", String.valueOf(this.plugin.getConfigSettings().getMaxQuests()));
                this.sendMessage(ChatColor.RED + msg);
            }
            return false;
        }
        if (!quest.getOptions().canGiveGloballyAtLogin() && this.plugin.getConfigSettings().getMaxQuests() > 0 && this.getCurrentQuests().size() >= this.plugin.getConfigSettings().getMaxQuests()) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "questMaxAllowed").replace("<number>", String.valueOf(this.plugin.getConfigSettings().getMaxQuests()));
                this.sendMessage(ChatColor.YELLOW + msg);
            }
            return false;
        }
        if (this.getCurrentQuests().containsKey(bukkitQuest)) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "questAlreadyOn");
                this.sendMessage(ChatColor.YELLOW + msg);
            }
            return false;
        }
        if (bukkitQuest.getPlanner().getCooldown() < 0L && this.getCompletedQuests().contains(bukkitQuest)) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "questAlreadyCompleted").replace("<quest>", bukkitQuest.getName());
                this.sendMessage(ChatColor.YELLOW + msg);
            }
            return false;
        }
        if (bukkitQuest.getBlockStart() != null) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "noCommandStart").replace("<quest>", bukkitQuest.getName());
                this.sendMessage(ChatColor.YELLOW + msg);
            }
            return false;
        }
        if (this.getRemainingCooldown(bukkitQuest) > 0L && this.getCompletedQuests().contains(bukkitQuest) && !bukkitQuest.getPlanner().getOverride()) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "questTooEarly").replace("<quest>", bukkitQuest.getName()).replace("<time>", BukkitMiscUtil.getTime(this.getRemainingCooldown(bukkitQuest)));
                this.getPlayer().sendMessage(ChatColor.YELLOW + msg);
            }
            return false;
        }
        if (bukkitQuest.getRegionStart() != null && !bukkitQuest.isInRegionStart(this)) {
            if (giveReason) {
                msg = BukkitLang.get(this.getPlayer(), "questInvalidLocation").replace("<quest>", bukkitQuest.getName());
                this.getPlayer().sendMessage(ChatColor.YELLOW + msg);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isOnTime(Quest quest, boolean giveReason) {
        Planner pln = quest.getPlanner();
        long currentTime = System.currentTimeMillis();
        long start = pln.getStartInMillis();
        long end = pln.getEndInMillis();
        long duration = end - start;
        long repeat = pln.getRepeat();
        if (start != -1L && currentTime < start) {
            if (giveReason) {
                String early = BukkitLang.get("plnTooEarly");
                early = early.replace("<quest>", quest.getName());
                early = early.replace("<time>", BukkitMiscUtil.getTime(start - currentTime));
                this.sendMessage(ChatColor.YELLOW + early);
            }
            return false;
        }
        if (end != -1L && repeat == -1L && currentTime > end) {
            if (giveReason) {
                String late = BukkitLang.get("plnTooLate");
                late = late.replace("<quest>", quest.getName());
                late = late.replace("<time>", BukkitMiscUtil.getTime(currentTime - end));
                this.sendMessage(ChatColor.RED + late);
            }
            return false;
        }
        if (repeat != -1L && start != -1L && end != -1L) {
            if (currentTime <= end) {
                if (this.completedTimes.containsKey(quest) && quest.getPlanner().getCooldown() > -1L && this.getRemainingCooldown(quest) > 0L && giveReason) {
                    String early = BukkitLang.get("plnTooEarly").replace("<quest>", quest.getName()).replace("<time>", BukkitMiscUtil.getTime(end - currentTime));
                    this.sendMessage(ChatColor.YELLOW + early);
                    return false;
                }
            } else {
                int maxSize = 2;
                LinkedHashMap<Long, Long> mostRecent = new LinkedHashMap<Long, Long>(){
                    private static final long serialVersionUID = 3046838061019897713L;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                        return this.size() > 2;
                    }
                };
                long completedTime = 0L;
                if (this.getCompletedTimes().containsKey(quest)) {
                    completedTime = this.getCompletedTimes().get(quest);
                }
                long completedEnd = 0L;
                long nextStart = start;
                long nextEnd = end;
                while (currentTime >= nextStart) {
                    if (nextStart < completedTime && completedTime < nextEnd) {
                        completedEnd = nextEnd;
                    }
                    nextEnd = (nextStart += repeat) + duration;
                    mostRecent.put(nextStart, nextEnd);
                }
                boolean active = false;
                for (Map.Entry startEnd : mostRecent.entrySet()) {
                    if ((Long)startEnd.getKey() > currentTime || currentTime >= (Long)startEnd.getValue()) continue;
                    active = true;
                    break;
                }
                if (!active || quest.getPlanner().getOverride() && completedEnd > 0L && currentTime < completedEnd) {
                    if (giveReason) {
                        String early = BukkitLang.get("plnTooEarly").replace("<quest>", quest.getName()).replace("<time>", BukkitMiscUtil.getTime(completedEnd - currentTime));
                        this.sendMessage(ChatColor.YELLOW + early);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void takeQuest(Quest quest, boolean ignoreRequirements) {
        if (quest == null) {
            return;
        }
        BukkitQuest bukkitQuest = (BukkitQuest)quest;
        BukkitQuesterPreStartQuestEvent preEvent = new BukkitQuesterPreStartQuestEvent(this, bukkitQuest);
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        OfflinePlayer offlinePlayer = this.getOfflinePlayer();
        if (offlinePlayer.isOnline() && !this.isOnTime(bukkitQuest, true)) {
            return;
        }
        boolean isGlobalQuest = quest.getOptions().canGiveGloballyAtLogin();
        if (bukkitQuest.testRequirements(offlinePlayer) || ignoreRequirements) {
            this.addEmptiesFor(bukkitQuest, 0);
            try {
                this.currentQuests.put(bukkitQuest, 0);
                if (this.plugin.getConfigSettings().getConsoleLogging() > 1) {
                    if (isGlobalQuest) {
                        this.plugin.getLogger().info(this.getPlayer().getUniqueId() + " started global quest " + bukkitQuest.getName());
                    } else {
                        this.plugin.getLogger().info(this.getPlayer().getUniqueId() + " started quest " + bukkitQuest.getName());
                    }
                }
            }
            catch (NullPointerException npe) {
                this.plugin.getLogger().severe("Unable to add quest" + bukkitQuest.getName() + " for player " + offlinePlayer.getName() + ". Consider resetting player data or report on Github");
            }
            Stage stage = bukkitQuest.getStage(0);
            if (!ignoreRequirements) {
                Player p;
                BukkitRequirements requirements = (BukkitRequirements)bukkitQuest.getRequirements();
                if (requirements.getMoney() > 0 && this.plugin.getDependencies().getVaultEconomy() != null) {
                    this.plugin.getDependencies().getVaultEconomy().withdrawPlayer(this.getOfflinePlayer(), (double)requirements.getMoney());
                }
                if (offlinePlayer.isOnline() && (p = this.getPlayer()) != null) {
                    ItemStack[] original = (ItemStack[])p.getInventory().getContents().clone();
                    for (ItemStack is : requirements.getItems()) {
                        if (!requirements.getRemoveItems().get(requirements.getItems().indexOf(is)).booleanValue() || BukkitInventoryUtil.removeItem((Inventory)p.getInventory(), is) || p.getEquipment() == null || BukkitInventoryUtil.stripItem(p.getEquipment(), is)) continue;
                        p.getInventory().setContents(original);
                        p.updateInventory();
                        this.sendMessage(BukkitLang.get(p, "requirementsItemFail"));
                        this.hardQuit(bukkitQuest);
                        return;
                    }
                    if (!isGlobalQuest || quest.getOptions().canInformOnStart()) {
                        String accepted = BukkitLang.get(p, "questAccepted");
                        accepted = accepted.replace("<quest>", bukkitQuest.getName());
                        this.sendMessage(ChatColor.GREEN + accepted);
                        p.sendMessage("");
                        if (this.plugin.getConfigSettings().canShowQuestTitles()) {
                            String title = ChatColor.GOLD + BukkitLang.get(p, "quest") + " " + BukkitLang.get(p, "accepted");
                            String subtitle = ChatColor.YELLOW + bukkitQuest.getName();
                            BukkitTitleProvider.sendTitle(p, title, subtitle);
                        }
                    }
                }
            }
            if (offlinePlayer.isOnline()) {
                Player p = this.getPlayer();
                String title = BukkitLang.get(p, "objectives").replace("<quest>", bukkitQuest.getName());
                BukkitLang.send(p, ChatColor.GOLD + title);
                this.showCurrentObjectives(bukkitQuest, this, false);
                String stageStartMessage = stage.getStartMessage();
                if (stageStartMessage != null) {
                    p.sendMessage(BukkitConfigUtil.parseStringWithPossibleLineBreaks(stageStartMessage, bukkitQuest, this.getPlayer()));
                }
                this.showCurrentConditions(bukkitQuest, this);
            }
            if (bukkitQuest.getInitialAction() != null) {
                bukkitQuest.getInitialAction().fire(this, bukkitQuest);
            }
            if (stage.getStartAction() != null) {
                stage.getStartAction().fire(this, bukkitQuest);
            }
            this.saveData();
            this.setCompassTarget(bukkitQuest);
            bukkitQuest.updateCompass(this, stage);
        } else if ((!isGlobalQuest || quest.getOptions().canInformOnStart()) && offlinePlayer.isOnline()) {
            if (isGlobalQuest) {
                this.sendMessage(ChatColor.RED + BukkitConfigUtil.parseString(BukkitLang.get("questObjectivesTitle")).replace("<quest>", quest.getName()));
            }
            this.sendMessage(ChatColor.DARK_AQUA + BukkitLang.get("requirements"));
            for (String s : this.getCurrentRequirements(bukkitQuest, false)) {
                this.sendMessage("- " + ChatColor.GRAY + s);
            }
        }
        if (offlinePlayer.isOnline()) {
            BukkitQuesterPostStartQuestEvent postEvent = new BukkitQuesterPostStartQuestEvent(this, bukkitQuest);
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public boolean abandonQuest(Quest quest, String message) {
        return this.abandonQuest(quest, new String[]{message});
    }

    @Override
    public boolean abandonQuest(Quest quest, String[] messages) {
        if (quest == null) {
            return false;
        }
        QuestQuitEvent event = new QuestQuitEvent(quest, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BukkitConfigSettings settings = this.plugin.getConfigSettings();
        if (this.getPlayer() != null) {
            this.setQuestIdToQuit(quest.getId());
            if (settings.canConfirmAbandon()) {
                ConversationFactory cf = new ConversationFactory((Plugin)this.plugin).withModality(false).withPrefix(context -> ChatColor.GRAY.toString()).withFirstPrompt((Prompt)new QuestAbandonPrompt(this.plugin)).withTimeout(settings.getAcceptTimeout()).thatExcludesNonPlayersWithMessage("Console may not perform this conversation!").addConversationAbandonedListener((ConversationAbandonedListener)this.plugin.getConvoListener());
                cf.buildConversation((Conversable)this.getPlayer()).begin();
            } else {
                this.quitQuest(quest, messages);
            }
            return true;
        }
        return false;
    }

    @Override
    public void quitQuest(Quest quest, String message) {
        this.quitQuest(quest, new String[]{message});
    }

    @Override
    public void quitQuest(Quest quest, String[] messages) {
        if (quest == null) {
            return;
        }
        this.hardQuit(quest);
        if (this.plugin.getConfigSettings().getConsoleLogging() > 1) {
            this.plugin.getLogger().info(this.getOfflinePlayer().getUniqueId() + " quit quest " + quest.getName());
        }
        for (String message : messages) {
            if (!this.getOfflinePlayer().isOnline()) continue;
            BukkitLang.send(this.getPlayer(), message);
        }
        this.saveData();
        this.updateJournal();
        if (this.compassTargetQuestId != null && this.compassTargetQuestId.equals(quest.getId())) {
            this.compassTargetQuestId = null;
        }
    }

    @Override
    public void listQuests(Quester quester, int page) {
        int rows = 7;
        Player player = quester.getPlayer();
        Collection<Quest> quests = this.plugin.getLoadedQuests();
        if (this.plugin.getConfigSettings().canIgnoreLockedQuests()) {
            LinkedList<Quest> available = new LinkedList<Quest>();
            for (Quest q : quests) {
                if (!quester.getCompletedQuests().contains(q)) {
                    if (!q.testRequirements(quester)) continue;
                    available.add(q);
                    continue;
                }
                if (!q.getPlanner().hasCooldown() || quester.getRemainingCooldown(q) >= 0L || !q.testRequirements(quester)) continue;
                available.add(q);
            }
            if (available.size() + 7 <= page * 7 || available.isEmpty()) {
                BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "pageNotExist"));
            } else {
                BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questListTitle"));
                int fromOrder = (page - 1) * 7;
                List subQuests = available.size() >= fromOrder + 7 ? available.subList(fromOrder, fromOrder + 7) : available.subList(fromOrder, available.size());
                ++fromOrder;
                for (Quest q : subQuests) {
                    if (quester.canAcceptOffer(q, false)) {
                        quester.sendMessage(ChatColor.YELLOW + Integer.toString(fromOrder) + ". " + q.getName());
                    } else {
                        quester.sendMessage(ChatColor.GRAY + Integer.toString(fromOrder) + ". " + q.getName());
                    }
                    ++fromOrder;
                }
                int numPages = (int)Math.ceil((double)available.size() / 7.0);
                String msg = BukkitLang.get(player, "pageFooter");
                msg = msg.replace("<current>", String.valueOf(page));
                msg = msg.replace("<all>", String.valueOf(numPages));
                BukkitLang.send(player, ChatColor.GOLD + msg);
            }
        } else if (quests.size() + 7 <= page * 7 || quests.isEmpty()) {
            BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "pageNotExist"));
        } else {
            BukkitLang.send(player, ChatColor.GOLD + BukkitLang.get(player, "questListTitle"));
            int fromOrder = (page - 1) * 7;
            List subQuests = quests.size() >= fromOrder + 7 ? new LinkedList<Quest>(quests).subList(fromOrder, fromOrder + 7) : new LinkedList<Quest>(quests).subList(fromOrder, quests.size());
            ++fromOrder;
            for (Quest q : subQuests) {
                if (quester.canAcceptOffer(q, false)) {
                    BukkitLang.send(player, ChatColor.YELLOW + Integer.toString(fromOrder) + ". " + q.getName());
                } else {
                    BukkitLang.send(player, ChatColor.GRAY + Integer.toString(fromOrder) + ". " + q.getName());
                }
                ++fromOrder;
            }
            int numPages = (int)Math.ceil((double)quests.size() / 7.0);
            String msg = BukkitLang.get(player, "pageFooter");
            msg = msg.replace("<current>", String.valueOf(page));
            msg = msg.replace("<all>", String.valueOf(numPages));
            BukkitLang.send(player, ChatColor.GOLD + msg);
        }
    }

    @Override
    public LinkedList<String> getCurrentRequirements(Quest quest, boolean ignoreOverrides) {
        String msg;
        if (quest == null) {
            return new LinkedList<String>();
        }
        BukkitRequirements requirements = (BukkitRequirements)quest.getRequirements();
        if (!ignoreOverrides && requirements.getDetailsOverride() != null && !requirements.getDetailsOverride().isEmpty()) {
            LinkedList<String> current = new LinkedList<String>();
            for (String s : requirements.getDetailsOverride()) {
                String message = ChatColor.RED + BukkitConfigUtil.parseString(ChatColor.translateAlternateColorCodes((char)'&', (String)s), quest, this.getPlayer());
                if (this.plugin.getDependencies().getPlaceholderApi() != null) {
                    message = PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)message);
                }
                current.add(message);
            }
            return current;
        }
        LinkedList<String> unfinishedRequirements = new LinkedList<String>();
        LinkedList<String> finishedRequirements = new LinkedList<String>();
        LinkedList<String> current = new LinkedList<String>();
        Player player = this.getPlayer();
        if (requirements.getMoney() > 0 && this.plugin.getDependencies().getVaultEconomy() != null) {
            String currency;
            String string = currency = requirements.getMoney() > 1 ? this.plugin.getDependencies().getVaultEconomy().currencyNamePlural() : this.plugin.getDependencies().getVaultEconomy().currencyNameSingular();
            if (this.plugin.getDependencies().getVaultEconomy().getBalance((OfflinePlayer)player) >= (double)requirements.getMoney()) {
                unfinishedRequirements.add(ChatColor.GREEN + "" + requirements.getMoney() + " " + currency);
            } else {
                finishedRequirements.add(ChatColor.GRAY + "" + requirements.getMoney() + " " + currency);
            }
        }
        if (requirements.getQuestPoints() > 0) {
            if (this.getQuestPoints() >= requirements.getQuestPoints()) {
                unfinishedRequirements.add(ChatColor.GREEN + "" + requirements.getQuestPoints() + " " + BukkitLang.get("questPoints"));
            } else {
                finishedRequirements.add(ChatColor.GRAY + "" + requirements.getQuestPoints() + " " + BukkitLang.get("questPoints"));
            }
        }
        Map<String, String> completed = this.completedQuests.stream().collect(Collectors.toMap(Quest::getId, Quest::getName));
        for (String questId : requirements.getNeededQuestIds()) {
            if (completed.containsKey(questId)) {
                msg = BukkitLang.get("haveCompleted");
                msg = msg.replace("<quest>", completed.get(questId));
                finishedRequirements.add(ChatColor.GREEN + msg);
                continue;
            }
            msg = BukkitLang.get("mustComplete");
            msg = msg.replace("<quest>", this.plugin.getQuestById(questId).getName());
            unfinishedRequirements.add(ChatColor.GRAY + msg);
        }
        for (String questId : requirements.getBlockQuestIds()) {
            if (!completed.containsKey(questId)) continue;
            msg = BukkitLang.get("cannotComplete");
            msg = msg.replace("<quest>", quest.getName());
            current.add(ChatColor.RED + msg);
        }
        for (Quest q : this.currentQuests.keySet()) {
            if (q == null || !requirements.getBlockQuestIds().contains(q.getId())) continue;
            current.add(ChatColor.RED + quest.getName());
        }
        for (String s : requirements.getMcmmoSkills()) {
            SkillType st = this.plugin.getDependencies().getMcMMOSkill(s);
            int n = requirements.getMcmmoAmounts().get(requirements.getMcmmoSkills().indexOf(s));
            if (UserManager.getOfflinePlayer((OfflinePlayer)player).getProfile().getSkillLevel(st) >= n) {
                finishedRequirements.add(ChatColor.GREEN + "" + n + " " + s);
                continue;
            }
            unfinishedRequirements.add(ChatColor.GRAY + "" + n + " " + s);
        }
        if (requirements.getHeroesPrimaryClass() != null) {
            if (this.plugin.getDependencies().testPrimaryHeroesClass(requirements.getHeroesPrimaryClass(), player.getUniqueId())) {
                finishedRequirements.add(ChatColor.GREEN + BukkitLang.get("reqHeroesPrimaryDisplay") + " " + requirements.getHeroesPrimaryClass());
            } else {
                unfinishedRequirements.add(ChatColor.GRAY + BukkitLang.get("reqHeroesPrimaryDisplay") + " " + requirements.getHeroesPrimaryClass());
            }
        }
        if (requirements.getHeroesSecondaryClass() != null) {
            if (this.plugin.getDependencies().testSecondaryHeroesClass(requirements.getHeroesSecondaryClass(), player.getUniqueId())) {
                finishedRequirements.add(ChatColor.GREEN + BukkitLang.get("reqHeroesSecondaryDisplay") + " " + requirements.getHeroesSecondaryClass());
            } else {
                finishedRequirements.add(ChatColor.GRAY + BukkitLang.get("reqHeroesSecondaryDisplay") + " " + requirements.getHeroesSecondaryClass());
            }
        }
        if (player.isOnline()) {
            Inventory fakeInv = Bukkit.createInventory(null, (InventoryType)InventoryType.PLAYER);
            try {
                fakeInv.setContents((ItemStack[])this.getPlayer().getInventory().getContents().clone());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Most likely outdated server build, see SPIGOT-8070");
                this.getPlayer().sendMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            }
            int num = 0;
            for (ItemStack itemStack : requirements.getItems()) {
                if (BukkitInventoryUtil.canRemoveItem(fakeInv, itemStack)) {
                    BukkitInventoryUtil.removeItem(fakeInv, itemStack);
                    num += itemStack.getAmount();
                }
                if (num >= itemStack.getAmount()) {
                    finishedRequirements.add(ChatColor.GREEN + "" + itemStack.getAmount() + " " + BukkitItemUtil.getName(itemStack));
                } else {
                    unfinishedRequirements.add(ChatColor.GRAY + "" + itemStack.getAmount() + " " + BukkitItemUtil.getName(itemStack));
                }
                num = 0;
            }
            for (String string : requirements.getPermissions()) {
                if (this.getPlayer().hasPermission(string)) {
                    finishedRequirements.add(ChatColor.GREEN + BukkitLang.get("permissionDisplay") + " " + string);
                    continue;
                }
                unfinishedRequirements.add(ChatColor.GRAY + BukkitLang.get("permissionDisplay") + " " + string);
            }
            for (Map.Entry entry : requirements.getCustomRequirements().entrySet()) {
                for (CustomRequirement cr : this.plugin.getCustomRequirements()) {
                    if (!cr.getName().equalsIgnoreCase((String)entry.getKey())) continue;
                    String message = cr.getDisplay() != null ? cr.getDisplay() : (String)entry.getKey();
                    for (Map.Entry<String, Object> prompt : cr.getData().entrySet()) {
                        String replacement = "%" + prompt.getKey() + "%";
                        try {
                            if (!message.contains(replacement)) continue;
                            message = message.replace(replacement, String.valueOf(((Map)entry.getValue()).get(prompt.getKey())));
                        }
                        catch (NullPointerException ne) {
                            this.plugin.getLogger().severe("Unable to gather display for " + cr.getName() + " on " + quest.getName());
                            ne.printStackTrace();
                        }
                    }
                    if (cr.testRequirement(this.getPlayer().getUniqueId(), (Map)entry.getValue())) {
                        finishedRequirements.add(ChatColor.GREEN + "" + message);
                        continue;
                    }
                    unfinishedRequirements.add(ChatColor.GRAY + "" + message);
                }
            }
        }
        current.addAll(unfinishedRequirements);
        current.addAll(finishedRequirements);
        return current;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LinkedList<Objective> getCurrentObjectives(Quest quest, boolean ignoreOverrides, boolean formatNames) {
        String message;
        String message2;
        ChatColor color;
        String message3;
        Object level;
        ChatColor color2;
        String message4;
        int progress;
        int i;
        if (quest == null) {
            this.plugin.getLogger().severe("Quest was null when getting objectives for " + this.getLastKnownName());
            return new LinkedList<Objective>();
        }
        if (this.getQuestProgressOrDefault(quest) == null) {
            this.plugin.getLogger().warning("Quest data was null when getting objectives for " + quest.getName());
            return new LinkedList<Objective>();
        }
        BukkitStage stage = (BukkitStage)this.getCurrentStage(quest);
        if (stage == null) {
            return new LinkedList<Objective>();
        }
        BukkitDependencies depends = this.plugin.getDependencies();
        BukkitQuestProgress data = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        LinkedList<Objective> objectives = new LinkedList<Objective>();
        LinkedList<String> overrides = stage.getObjectiveOverrides();
        int objIndex = -1;
        for (i = 0; i < data.getBlocksBroken().size(); ++i) {
            String message42;
            ChatColor color3;
            ++objIndex;
            progress = data.getBlocksBroken().get(i);
            if (i >= stage.getBlocksToBreak().size()) break;
            BlockItemStack blockItemStack = stage.getBlocksToBreak().get(i);
            ChatColor chatColor = color3 = progress < blockItemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && objIndex < overrides.size()) {
                message4 = this.formatCurrentObjectiveMessage(color3, overrides.get(objIndex), progress, blockItemStack.getAmount());
            } else {
                message42 = this.formatCurrentObjectiveMessage(color3, BukkitLang.get(this.getPlayer(), "break"), progress, blockItemStack.getAmount());
            }
            if (formatNames) {
                message42 = message42.replace("<item>", BukkitItemUtil.getName(blockItemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.BREAK_BLOCK, message42, (Object)progress, blockItemStack));
        }
        for (i = 0; i < data.getBlocksDamaged().size(); ++i) {
            ++objIndex;
            progress = data.getBlocksDamaged().get(i);
            if (i >= stage.getBlocksToDamage().size()) break;
            BlockItemStack blockItemStack = stage.getBlocksToDamage().get(i);
            color2 = progress < blockItemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, blockItemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "damage"), progress, blockItemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(blockItemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.DAMAGE_BLOCK, message4, (Object)progress, blockItemStack));
        }
        for (i = 0; i < data.getBlocksPlaced().size(); ++i) {
            ++objIndex;
            progress = data.getBlocksPlaced().get(i);
            if (i >= stage.getBlocksToPlace().size()) break;
            BlockItemStack blockItemStack = stage.getBlocksToPlace().get(i);
            color2 = progress < blockItemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, blockItemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "place"), progress, blockItemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(blockItemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.PLACE_BLOCK, message4, (Object)progress, blockItemStack));
        }
        for (i = 0; i < data.getBlocksUsed().size(); ++i) {
            ++objIndex;
            progress = data.getBlocksUsed().get(i);
            if (i >= stage.getBlocksToUse().size()) break;
            BlockItemStack blockItemStack = stage.getBlocksToUse().get(i);
            color2 = progress < blockItemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, blockItemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "use"), progress, blockItemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(blockItemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.USE_BLOCK, message4, (Object)progress, blockItemStack));
        }
        for (i = 0; i < data.getBlocksCut().size(); ++i) {
            ++objIndex;
            progress = data.getBlocksCut().get(i);
            if (i >= stage.getBlocksToCut().size()) break;
            BlockItemStack blockItemStack = stage.getBlocksToCut().get(i);
            color2 = progress < blockItemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, blockItemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "cut"), progress, blockItemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(blockItemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.CUT_BLOCK, message4, (Object)progress, blockItemStack));
        }
        for (i = 0; i < data.getItemsCrafted().size(); ++i) {
            ++objIndex;
            progress = data.getItemsCrafted().get(i);
            if (i >= stage.getItemsToCraft().size()) break;
            ItemStack itemStack = stage.getItemsToCraft().get(i);
            color2 = progress < itemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, itemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "craftItem"), progress, itemStack.getAmount());
            if (itemStack.getType().name().equals("TIPPED_ARROW") && !((String)(level = BukkitItemUtil.getPrettyPotionLevel(itemStack.getItemMeta()))).isEmpty()) {
                message4 = message4.replace("<item>", "<item> " + (String)level);
            }
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(itemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.CRAFT_ITEM, message4, (Object)progress, itemStack));
        }
        for (i = 0; i < data.getItemsSmelted().size(); ++i) {
            ++objIndex;
            progress = data.getItemsSmelted().get(i);
            if (i >= stage.getItemsToSmelt().size()) break;
            ItemStack itemStack = stage.getItemsToSmelt().get(i);
            color2 = progress < itemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, itemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "smeltItem"), progress, itemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(itemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.SMELT_ITEM, message4, (Object)progress, itemStack));
        }
        for (i = 0; i < data.getItemsEnchanted().size(); ++i) {
            ++objIndex;
            progress = data.getItemsEnchanted().get(i);
            if (i >= stage.getItemsToEnchant().size()) break;
            ItemStack itemStack = stage.getItemsToEnchant().get(i);
            color2 = progress < itemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, itemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "enchItem"), progress, itemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(itemStack));
            }
            if (itemStack.getEnchantments().isEmpty()) {
                objectives.add(new BukkitObjective(ObjectiveType.ENCHANT_ITEM, message4.replace("<enchantment>", "").replace("<level>", "").replaceAll("\\s+", " "), (Object)progress, itemStack));
                continue;
            }
            level = itemStack.getEnchantments().entrySet().iterator();
            while (level.hasNext()) {
                Map.Entry e = (Map.Entry)level.next();
                objectives.add(new BukkitObjective(ObjectiveType.ENCHANT_ITEM, message4.replace("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).replace("<level>", RomanNumeral.getNumeral((Integer)e.getValue())), (Object)progress, itemStack));
            }
        }
        for (i = 0; i < data.getItemsBrewed().size(); ++i) {
            ++objIndex;
            progress = data.getItemsBrewed().get(i);
            if (i >= stage.getItemsToBrew().size()) break;
            ItemStack itemStack = stage.getItemsToBrew().get(i);
            color2 = progress < itemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, itemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "brewItem"), progress, itemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(itemStack));
            }
            message4 = ((String)(level = BukkitItemUtil.getPrettyPotionLevel(itemStack.getItemMeta()))).isEmpty() ? message4.replace(" <level>", (CharSequence)level) : message4.replace("<level>", (CharSequence)level);
            objectives.add(new BukkitObjective(ObjectiveType.BREW_ITEM, message4, (Object)progress, itemStack));
        }
        for (i = 0; i < data.getItemsConsumed().size(); ++i) {
            ++objIndex;
            progress = data.getItemsConsumed().get(i);
            if (i >= stage.getItemsToConsume().size()) break;
            ItemStack itemStack = stage.getItemsToConsume().get(i);
            color2 = progress < itemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            message4 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color2, overrides.get(objIndex), progress, itemStack.getAmount()) : this.formatCurrentObjectiveMessage(color2, BukkitLang.get(this.getPlayer(), "consumeItem"), progress, itemStack.getAmount());
            if (formatNames) {
                message4 = message4.replace("<item>", BukkitItemUtil.getName(itemStack));
            }
            message4 = ((String)(level = BukkitItemUtil.getPrettyPotionLevel(itemStack.getItemMeta()))).isEmpty() ? message4.replace(" <level>", (CharSequence)level) : message4.replace("<level>", (CharSequence)level);
            objectives.add(new BukkitObjective(ObjectiveType.CONSUME_ITEM, message4, (Object)progress, itemStack));
        }
        for (i = 0; i < data.getItemsDelivered().size(); ++i) {
            ChatColor color3;
            ++objIndex;
            progress = data.getItemsDelivered().get(i);
            if (i >= stage.getItemsToDeliver().size()) break;
            ItemStack itemStack = stage.getItemsToDeliver().get(i);
            UUID npc = stage.getItemDeliveryTargets().get(i);
            ChatColor chatColor = color3 = progress < itemStack.getAmount() ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && objIndex < overrides.size()) {
                String message32 = this.formatCurrentObjectiveMessage(color3, overrides.get(objIndex), progress, itemStack.getAmount());
            } else {
                message3 = this.formatCurrentObjectiveMessage(color3, BukkitLang.get(this.getPlayer(), "deliver").replace("<npc>", depends.getNpcName(npc)), progress, itemStack.getAmount());
            }
            if (formatNames) {
                message3 = message3.replace("<item>", BukkitItemUtil.getName(itemStack));
            }
            objectives.add(new BukkitObjective(ObjectiveType.DELIVER_ITEM, message3, (Object)progress, itemStack));
        }
        int interactIndex = 0;
        for (UUID uUID : stage.getNpcsToInteract()) {
            ++objIndex;
            if (data.getNpcsInteracted().size() > interactIndex) {
                ChatColor color22;
                boolean progress2 = data.getNpcsInteracted().get(interactIndex);
                ChatColor chatColor = color22 = !progress2 ? ChatColor.GREEN : ChatColor.GRAY;
                message3 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color22, overrides.get(objIndex), progress2 ? 1 : 0, 1) : color22 + BukkitLang.get(this.getPlayer(), "talkTo").replace("<npc>", depends.getNpcName(uUID));
                if (depends.getPlaceholderApi() != null) {
                    message3 = PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)message3);
                }
                objectives.add(new BukkitObjective(ObjectiveType.TALK_TO_NPC, message3, progress2 ? 1 : 0, 1));
            }
            ++interactIndex;
        }
        int npcKillIndex = 0;
        for (UUID n : stage.getNpcsToKill()) {
            String message5;
            int goal2;
            ChatColor color4;
            ++objIndex;
            int progress3 = 0;
            if (data.getNpcsNumKilled().size() > npcKillIndex) {
                progress3 = data.getNpcsNumKilled().get(npcKillIndex);
            }
            ChatColor chatColor = color4 = progress3 < (goal2 = stage.getNpcNumToKill().get(npcKillIndex).intValue()) ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && objIndex < overrides.size()) {
                String message6 = this.formatCurrentObjectiveMessage(color4, overrides.get(objIndex), progress3, goal2);
            } else {
                message5 = this.formatCurrentObjectiveMessage(color4, BukkitLang.get(this.getPlayer(), "kill"), progress3, goal2);
            }
            message5 = message5.contains("<mob>") ? message5.replace("<mob>", depends.getNpcName(n)) : message5 + " " + depends.getNpcName(n);
            objectives.add(new BukkitObjective(ObjectiveType.KILL_NPC, message5, progress3, goal2));
            ++npcKillIndex;
        }
        boolean bl = false;
        for (EntityType e : stage.getMobsToKill()) {
            int goal3;
            void var12_39;
            ++objIndex;
            int progress4 = 0;
            if (data.getMobNumKilled().size() > var12_39) {
                progress4 = data.getMobNumKilled().get((int)var12_39);
            }
            ChatColor color5 = progress4 < (goal3 = stage.getMobNumToKill().get((int)var12_39).intValue()) ? ChatColor.GREEN : ChatColor.GRAY;
            String message22 = color5 + "";
            if (!ignoreOverrides && objIndex < overrides.size()) {
                message22 = this.formatCurrentObjectiveMessage(color5, overrides.get(objIndex), progress4, goal3);
            } else if (stage.getLocationsToKillWithin().isEmpty()) {
                if ((message22 = message22 + BukkitLang.get(this.getPlayer(), "kill")).contains("<count>")) {
                    message22 = message22.replace("<count>", "" + color5 + progress4 + "/" + goal3);
                }
            } else {
                message22 = (message22 = message22 + BukkitLang.get(this.getPlayer(), "killAtLocation").replace("<location>", stage.getKillNames().get(stage.getMobsToKill().indexOf(e)))).contains("<count>") ? message22.replace("<count>", "" + color5 + progress4 + "/" + goal3) : message22 + color5 + ": " + progress4 + "/" + goal3;
            }
            if (depends.getPlaceholderApi() != null) {
                message22 = PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)message22);
            }
            if (formatNames) {
                message22 = message22.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(e.name()));
            }
            objectives.add(new BukkitObjective(ObjectiveType.KILL_MOB, message22, new BukkitCountableMob(e, progress4), new BukkitCountableMob(e, goal3)));
            ++var12_39;
        }
        int tameIndex = 0;
        for (EntityType e : stage.getMobsToTame()) {
            int goal4;
            ++objIndex;
            int progress5 = 0;
            if (data.getMobsTamed().size() > tameIndex) {
                progress5 = data.getMobsTamed().get(tameIndex);
            }
            color = progress5 < (goal4 = stage.getMobNumToTame().get(tameIndex).intValue()) ? ChatColor.GREEN : ChatColor.GRAY;
            message2 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color, overrides.get(objIndex), progress5, goal4) : this.formatCurrentObjectiveMessage(color, BukkitLang.get(this.getPlayer(), "tame"), progress5, goal4);
            if (!message2.contains("<mob>")) {
                message2 = message2 + " <mob>";
            }
            if (formatNames) {
                message2 = message2.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(stage.getMobsToTame().get(tameIndex).name()));
            }
            objectives.add(new BukkitObjective(ObjectiveType.TAME_MOB, message2, new BukkitCountableMob(e, progress5), new BukkitCountableMob(e, goal4)));
            ++tameIndex;
        }
        if (stage.getFishToCatch() != null) {
            String message6;
            int goal5;
            ChatColor color6;
            int progress6 = data.getFishCaught();
            ChatColor chatColor = color6 = progress6 < (goal5 = stage.getFishToCatch().intValue()) ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && ++objIndex < overrides.size()) {
                String message7 = this.formatCurrentObjectiveMessage(color6, overrides.get(objIndex), progress6, goal5);
            } else {
                message6 = this.formatCurrentObjectiveMessage(color6, BukkitLang.get(this.getPlayer(), "catchFish"), progress6, goal5);
            }
            objectives.add(new BukkitObjective(ObjectiveType.CATCH_FISH, message6, progress6, goal5));
        }
        if (stage.getCowsToMilk() != null) {
            String message7;
            int goal6;
            ChatColor color7;
            int progress7 = data.getCowsMilked();
            ChatColor chatColor = color7 = progress7 < (goal6 = stage.getCowsToMilk().intValue()) ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && ++objIndex < overrides.size()) {
                String message8 = this.formatCurrentObjectiveMessage(color7, overrides.get(objIndex), progress7, goal6);
            } else {
                message7 = this.formatCurrentObjectiveMessage(color7, BukkitLang.get(this.getPlayer(), "milkCow"), progress7, goal6);
            }
            objectives.add(new BukkitObjective(ObjectiveType.MILK_COW, message7, progress7, goal6));
        }
        int shearIndex = 0;
        Iterator goal6 = stage.getSheepNumToShear().iterator();
        while (goal6.hasNext()) {
            int goal7 = (Integer)goal6.next();
            ++objIndex;
            int progress8 = 0;
            if (data.getSheepSheared().size() > shearIndex) {
                progress8 = data.getSheepSheared().get(shearIndex);
            }
            color = progress8 < goal7 ? ChatColor.GREEN : ChatColor.GRAY;
            message2 = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color, overrides.get(objIndex), progress8, goal7) : this.formatCurrentObjectiveMessage(color, BukkitLang.get(this.getPlayer(), "shearSheep"), progress8, goal7);
            message2 = message2.replace("<color>", BukkitMiscUtil.getPrettyDyeColorName(stage.getSheepToShear().get(shearIndex)));
            objectives.add(new BukkitObjective(ObjectiveType.SHEAR_SHEEP, message2, progress8, goal7));
            ++shearIndex;
        }
        if (stage.getPlayersToKill() != null) {
            int progress9 = data.getPlayersKilled();
            int goal8 = stage.getPlayersToKill();
            ChatColor color8 = data.getPlayersKilled() < stage.getPlayersToKill() ? ChatColor.GREEN : ChatColor.GRAY;
            message = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color8, overrides.get(++objIndex), progress9, goal8) : this.formatCurrentObjectiveMessage(color8, BukkitLang.get(this.getPlayer(), "killPlayer"), progress9, goal8);
            objectives.add(new BukkitObjective(ObjectiveType.KILL_PLAYER, message, progress9, goal8));
        }
        for (int i2 = 0; i2 < stage.getLocationsToReach().size(); ++i2) {
            ChatColor color9;
            ++objIndex;
            if (i2 >= data.getLocationsReached().size()) continue;
            boolean progress10 = data.getLocationsReached().get(i2);
            ChatColor chatColor = color9 = !progress10 ? ChatColor.GREEN : ChatColor.GRAY;
            message = !ignoreOverrides && objIndex < overrides.size() ? this.formatCurrentObjectiveMessage(color9, overrides.get(objIndex), progress10 ? 1 : 0, 1) : this.formatCurrentObjectiveMessage(color9, BukkitLang.get(this.getPlayer(), "goTo"), progress10 ? 1 : 0, 1);
            message = message.replace("<location>", stage.getLocationNames().get(i2));
            objectives.add(new BukkitObjective(ObjectiveType.REACH_LOCATION, message, progress10 ? 1 : 0, 1));
        }
        int passIndex = 0;
        for (String s : stage.getPasswordDisplays()) {
            String message8;
            ChatColor color10;
            ++objIndex;
            boolean progress11 = false;
            if (data.getPasswordsSaid().size() > passIndex) {
                progress11 = data.getPasswordsSaid().get(passIndex);
            }
            ChatColor chatColor = color10 = !progress11 ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && objIndex < overrides.size()) {
                String message9 = this.formatCurrentObjectiveMessage(color10, overrides.get(objIndex), progress11 ? 1 : 0, 1);
            } else {
                message8 = this.formatCurrentObjectiveMessage(color10, s, progress11 ? 1 : 0, 1);
            }
            objectives.add(new BukkitObjective(ObjectiveType.PASSWORD, message8, progress11 ? 1 : 0, 1));
            ++passIndex;
        }
        int customIndex = 0;
        for (CustomObjective co : stage.getCustomObjectives()) {
            String message9;
            int goal9;
            ChatColor color11;
            ++objIndex;
            int progress12 = 0;
            if (data.getCustomObjectiveCounts().size() > customIndex) {
                progress12 = data.getCustomObjectiveCounts().get(customIndex);
            }
            ChatColor chatColor = color11 = progress12 < (goal9 = stage.getCustomObjectiveCounts().get(customIndex).intValue()) ? ChatColor.GREEN : ChatColor.GRAY;
            if (!ignoreOverrides && objIndex < overrides.size()) {
                String message10 = this.formatCurrentObjectiveMessage(color11, overrides.get(objIndex), progress12, goal9);
            } else {
                message9 = this.formatCurrentObjectiveMessage(color11, co.getDisplay(), progress12, goal9);
            }
            for (Map.Entry entry : co.getData()) {
                String replacement = "%" + (String)entry.getKey() + "%";
                try {
                    for (Map.Entry entry2 : stage.getCustomObjectiveData()) {
                        if (!((String)entry2.getKey()).equals(entry.getKey()) || !message9.contains(replacement)) continue;
                        message9 = message9.replace(replacement, String.valueOf(entry2.getValue()));
                    }
                }
                catch (NullPointerException ne) {
                    this.plugin.getLogger().severe("Unable to gather display for " + co.getName() + " on " + quest.getName());
                    ne.printStackTrace();
                }
            }
            if (co.canShowCount()) {
                message9 = message9.replace("%count%", progress12 + "/" + goal9);
            }
            message9 = BukkitConfigUtil.parseString(message9.trim().replaceAll("\\s{2,}", ""));
            objectives.add(new BukkitObjective(ObjectiveType.CUSTOM, message9, progress12, goal9));
            ++customIndex;
        }
        return objectives;
    }

    private String formatCurrentObjectiveMessage(ChatColor color, String message, int progress, int goal) {
        message = color + message;
        message = message.replace("<count>", "" + color + progress + "/" + goal);
        message = message.replace("%count%", "" + color + progress + "/" + goal);
        if (this.plugin.getDependencies().getPlaceholderApi() != null) {
            message = PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)message);
        }
        return message;
    }

    @Override
    public void showCurrentObjectives(Quest quest, Quester quester, boolean ignoreOverrides) {
        if (quest == null) {
            this.plugin.getLogger().severe("Quest was null when showing objectives for " + quester.getLastKnownName());
            return;
        }
        BukkitQuester q = (BukkitQuester)quester;
        Stage stage = quester.getCurrentStage(quest);
        if (stage == null) {
            this.plugin.getLogger().warning("Current stage was null when showing objectives for " + quest.getName());
            return;
        }
        LocaleManager localeManager = this.plugin.getLocaleManager();
        BukkitConfigSettings settings = this.plugin.getConfigSettings();
        if (localeManager == null && settings.canTranslateNames()) {
            settings.setTranslateNames(false);
            this.plugin.getLogger().severe("Problem with locale manager! Item name translation disabled.");
        }
        LinkedList<String> overrides = stage.getObjectiveOverrides();
        int objIndex = -1;
        for (Objective obj : q.getCurrentObjectives(quest, false, false)) {
            Object goal;
            BukkitObjective objective = (BukkitObjective)obj;
            if (!ignoreOverrides && ++objIndex < overrides.size()) {
                String s = stage.getObjectiveOverrides().get(objIndex);
                String message = (!s.trim().isEmpty() ? "- " : "") + ChatColor.GREEN + BukkitConfigUtil.parseString(s, quest, quester.getPlayer());
                message = message.replace("<count>", objective.getProgress() + "/" + objective.getGoal());
                message = message.replace("%count%", objective.getProgress() + "/" + objective.getGoal());
                if (this.plugin.getDependencies().getPlaceholderApi() != null) {
                    message = PlaceholderAPI.setPlaceholders((Player)quester.getPlayer(), (String)message);
                }
                quester.sendMessage(message);
                continue;
            }
            String message = "- " + BukkitLang.BukkitFormatToken.convertString(quester.getPlayer(), objective.getMessage());
            if (objective.getGoalAsBlockItem() != null) {
                int progress = objective.getProgress();
                goal = objective.getGoalAsBlockItem();
                if (!settings.canShowCompletedObjs() && progress >= goal.getAmount()) continue;
                if (localeManager != null && settings.canTranslateNames()) {
                    localeManager.sendMessage(quester.getPlayer(), message, goal.getType(), goal.getDurability(), null);
                }
            } else if (objective.getGoalAsItem() != null) {
                int progress = objective.getProgress();
                goal = objective.getGoalAsItem();
                if (!settings.canShowCompletedObjs() && progress >= goal.getAmount()) continue;
                if (localeManager != null && settings.canTranslateNames() && !goal.hasItemMeta() && Material.getMaterial((String)"LINGERING_POTION") == null) {
                    localeManager.sendMessage(quester.getPlayer(), message, (ItemStack)goal);
                } else if (localeManager != null && settings.canTranslateNames() && goal.getItemMeta() != null && !goal.getItemMeta().hasDisplayName() && !goal.getType().equals((Object)Material.WRITTEN_BOOK)) {
                    if (goal.getType().name().contains("POTION") && localeManager.hasBasePotionData()) {
                        String level = BukkitItemUtil.getPrettyPotionLevel(goal.getItemMeta());
                        message = level.isEmpty() ? message.replace(" <level>", level) : message.replace("<level>", level);
                    }
                    localeManager.sendMessage(quester.getPlayer(), message, (ItemStack)goal);
                } else if (goal.getEnchantments().isEmpty()) {
                    quester.sendMessage(message.replace("<item>", BukkitItemUtil.getName((ItemStack)goal)).replace("<enchantment>", "").replace("<level>", "").replaceAll("\\s+", " "));
                } else {
                    for (Map.Entry e : goal.getEnchantments().entrySet()) {
                        quester.sendMessage(message.replace("<item>", BukkitItemUtil.getName((ItemStack)goal)).replace("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).replace("<level>", RomanNumeral.getNumeral((Integer)e.getValue())));
                    }
                }
            } else if (objective.getProgressAsMob() != null && objective.getGoalAsMob() != null) {
                BukkitCountableMob progress = objective.getProgressAsMob();
                goal = objective.getGoalAsMob();
                if (!settings.canShowCompletedObjs() && progress.getCount() >= ((BukkitCountableMob)goal).getCount()) continue;
                if (localeManager != null && settings.canTranslateNames()) {
                    localeManager.sendMessage(quester.getPlayer(), message, ((BukkitCountableMob)goal).getEntityType(), null);
                } else {
                    quester.sendMessage(message.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(((BukkitCountableMob)goal).getEntityType().name())));
                }
            } else {
                if (!settings.canShowCompletedObjs() && objective.getProgress() >= objective.getGoal()) continue;
                if (obj.getType().equals((Object)ObjectiveType.CUSTOM)) {
                    quester.sendMessage(message.trim().replaceAll("\\s{2,}", ""));
                } else {
                    quester.sendMessage(message);
                }
            }
            if (ignoreOverrides || stage.getObjectiveOverrides().isEmpty()) continue;
            for (int i = objIndex; i < stage.getObjectiveOverrides().size(); ++i) {
                String msg = ChatColor.GREEN + BukkitConfigUtil.parseString(stage.getObjectiveOverrides().get(i), quest, this.getPlayer());
                if (this.plugin.getDependencies().getPlaceholderApi() != null) {
                    msg = PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)msg);
                }
                quester.sendMessage(msg);
            }
        }
    }

    @Override
    public boolean hasObjective(Quest quest, ObjectiveType type) {
        if (quest == null || this.getCurrentStage(quest) == null || type == null) {
            return false;
        }
        return this.getCurrentStage(quest).containsObjective(type);
    }

    @Override
    public boolean hasCustomObjective(Quest quest, String name) {
        if (quest == null || this.getCurrentStage(quest) == null || name == null) {
            return false;
        }
        for (CustomObjective co : this.getCurrentStage(quest).getCustomObjectives()) {
            if (!co.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void showCurrentConditions(Quest quest, Quester quester) {
        if (quest == null) {
            this.plugin.getLogger().severe("Quest was null when getting conditions for " + quester.getLastKnownName());
            return;
        }
        if (quester.getQuestProgressOrDefault(quest) == null) {
            this.plugin.getLogger().warning("Quest data was null when showing conditions for " + quest.getName());
            return;
        }
        Stage stage = quester.getCurrentStage(quest);
        if (stage == null) {
            this.plugin.getLogger().warning("Current stage was null when showing conditions for " + quest.getName());
            return;
        }
        BukkitCondition c = (BukkitCondition)stage.getCondition();
        if (c != null && stage.getObjectiveOverrides().isEmpty()) {
            quester.sendMessage(ChatColor.LIGHT_PURPLE + BukkitLang.get("stageEditorConditions"));
            StringBuilder msg = new StringBuilder("- " + ChatColor.YELLOW);
            if (!c.getEntitiesWhileRiding().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorRideEntity"));
                for (String e : c.getEntitiesWhileRiding()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(e);
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getNpcsWhileRiding().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorRideNPC"));
                for (UUID u : c.getNpcsWhileRiding()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ");
                    String name = u.toString();
                    for (BukkitNpcDependency npcDependency : this.plugin.getDependencies().getNpcDependencies()) {
                        String npcName = npcDependency.getName(u);
                        if (npcName == null) continue;
                        name = npcName;
                        break;
                    }
                    msg.append(name);
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getPermissions().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorPermissions"));
                for (String e : c.getPermissions()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(e);
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getItemsWhileHoldingMainHand().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorItemsInMainHand"));
                for (ItemStack is : c.getItemsWhileHoldingMainHand()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(BukkitItemUtil.getPrettyItemName(is.getType().name()));
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getItemsWhileWearing().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorItemsWear"));
                for (ItemStack is : c.getItemsWhileWearing()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(BukkitItemUtil.getPrettyItemName(is.getType().name()));
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getWorldsWhileStayingWithin().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorStayWithinWorld"));
                for (String w : c.getWorldsWhileStayingWithin()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(w);
                }
                quester.sendMessage(msg.toString());
            } else if (c.getTickStartWhileStayingWithin() > -1 && c.getTickEndWhileStayingWithin() > -1) {
                msg.append(BukkitLang.get("conditionEditorStayWithinTicks"));
                msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(c.getTickStartWhileStayingWithin()).append(" - ").append(c.getTickEndWhileStayingWithin());
                quester.sendMessage(msg.toString());
            } else if (!c.getBiomesWhileStayingWithin().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorStayWithinBiome"));
                for (String b : c.getBiomesWhileStayingWithin()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(BukkitMiscUtil.snakeCaseToUpperCamelCase(b));
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getRegionsWhileStayingWithin().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorStayWithinRegion"));
                for (String r : c.getRegionsWhileStayingWithin()) {
                    msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(r);
                }
                quester.sendMessage(msg.toString());
            } else if (!c.getPlaceholdersCheckIdentifier().isEmpty()) {
                msg.append(BukkitLang.get("conditionEditorCheckPlaceholder"));
                int index = 0;
                for (String r : c.getPlaceholdersCheckIdentifier()) {
                    if (c.getPlaceholdersCheckValue().size() > index) {
                        msg.append(ChatColor.AQUA).append("\n   \u2515 ").append(r).append(ChatColor.GRAY).append(" = ").append(ChatColor.AQUA).append(c.getPlaceholdersCheckValue().get(index));
                    }
                    ++index;
                }
                quester.sendMessage(msg.toString());
            }
        }
    }

    @Override
    public void breakBlock(Quest quest, ItemStack itemStack) {
        this.breakBlock(quest, BlockItemStack.of(itemStack));
    }

    @Override
    public void breakBlock(Quest quest, BlockItemStack broken) {
        BlockItemStack goal = null;
        for (BlockItemStack toBreak : ((BukkitStage)this.getCurrentStage(quest)).getBlocksToBreak()) {
            if (goal != null) break;
            if (!broken.matches(toBreak)) continue;
            goal = toBreak;
            if (broken.getType() != toBreak.getType()) continue;
            if (broken.getType().isSolid() && toBreak.getType().isSolid()) {
                if (broken.getDurability() == toBreak.getDurability()) {
                    goal = toBreak;
                    continue;
                }
                if (BukkitMiscUtil.isBelow113()) continue;
                goal = toBreak;
                continue;
            }
            if (Material.getMaterial((String)"CRAFTER") != null && broken.getType().isEdible()) {
                boolean toBreakAge = false;
                short brokenAge = broken.getDurability();
                goal = toBreak;
                continue;
            }
            if (broken.getType().name().equals("RED_ROSE")) {
                if (broken.getDurability() != toBreak.getDurability()) continue;
                goal = toBreak;
                continue;
            }
            goal = toBreak;
        }
        if (goal == null) {
            return;
        }
        ObjectiveType type = ObjectiveType.BREAK_BLOCK;
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, broken.getAmount(), goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        int breakIndex = this.getCurrentStage(quest).getBlocksToBreak().indexOf(goal);
        if (breakIndex >= bukkitQuestProgress.blocksBroken.size()) {
            return;
        }
        if (bukkitQuestProgress.blocksBroken.get(breakIndex) >= goal.getAmount()) {
            return;
        }
        int progress = bukkitQuestProgress.blocksBroken.get(breakIndex) + 1;
        bukkitQuestProgress.blocksBroken.set(breakIndex, progress);
        if (progress == goal.getAmount()) {
            this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
            BlockItemStack finalGoal = goal;
            this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).blocksBroken.set(breakIndex, progress);
                q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, finalGoal), null, null, null, null, null, null, null);
                return null;
            });
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress, goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void damageBlock(Quest quest, ItemStack itemStack) {
        this.damageBlock(quest, BlockItemStack.of(itemStack));
    }

    @Override
    public void damageBlock(Quest quest, BlockItemStack damaged) {
        BlockItemStack goal = null;
        for (BlockItemStack toDamage : ((BukkitStage)this.getCurrentStage(quest)).getBlocksToDamage()) {
            if (goal != null) break;
            if (damaged.getType() != toDamage.getType()) continue;
            if (damaged.getType().isSolid() && toDamage.getType().isSolid()) {
                if (damaged.getDurability() == toDamage.getDurability()) {
                    goal = toDamage;
                    continue;
                }
                if (BukkitMiscUtil.isBelow113()) continue;
                goal = toDamage;
                continue;
            }
            if (damaged.getType().name().equals("RED_ROSE")) {
                if (damaged.getDurability() != toDamage.getDurability()) continue;
                goal = toDamage;
                continue;
            }
            goal = toDamage;
        }
        if (goal == null) {
            return;
        }
        ObjectiveType type = ObjectiveType.DAMAGE_BLOCK;
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, damaged.getAmount(), goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        int damageIndex = this.getCurrentStage(quest).getBlocksToDamage().indexOf(goal);
        if (damageIndex >= bukkitQuestProgress.blocksDamaged.size()) {
            return;
        }
        if (bukkitQuestProgress.blocksDamaged.get(damageIndex) >= goal.getAmount()) {
            return;
        }
        int progress = bukkitQuestProgress.blocksDamaged.get(damageIndex) + 1;
        bukkitQuestProgress.blocksDamaged.set(damageIndex, progress);
        if (progress == goal.getAmount()) {
            this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
            BlockItemStack finalGoal = goal;
            this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).blocksDamaged.set(damageIndex, progress);
                q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, finalGoal), null, null, null, null, null, null, null);
                return null;
            });
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress, goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void placeBlock(Quest quest, ItemStack itemStack) {
        this.placeBlock(quest, BlockItemStack.of(itemStack));
    }

    @Override
    public void placeBlock(Quest quest, BlockItemStack placed) {
        BlockItemStack goal = null;
        for (BlockItemStack toPlace : ((BukkitStage)this.getCurrentStage(quest)).getBlocksToPlace()) {
            if (goal != null) break;
            if (placed.getType() != toPlace.getType()) continue;
            if (placed.getType().isSolid() && toPlace.getType().isSolid()) {
                if (placed.getDurability() == toPlace.getDurability()) {
                    goal = toPlace;
                    continue;
                }
                if (BukkitMiscUtil.isBelow113()) continue;
                goal = toPlace;
                continue;
            }
            if (placed.getType().name().equals("RED_ROSE")) {
                if (placed.getDurability() != toPlace.getDurability()) continue;
                goal = toPlace;
                continue;
            }
            goal = toPlace;
        }
        if (goal == null) {
            return;
        }
        ObjectiveType type = ObjectiveType.PLACE_BLOCK;
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, placed.getAmount(), goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        int placeIndex = this.getCurrentStage(quest).getBlocksToPlace().indexOf(goal);
        if (placeIndex >= bukkitQuestProgress.blocksPlaced.size()) {
            return;
        }
        if (bukkitQuestProgress.blocksPlaced.get(placeIndex) >= goal.getAmount()) {
            return;
        }
        int progress = bukkitQuestProgress.blocksPlaced.get(placeIndex) + 1;
        bukkitQuestProgress.blocksPlaced.set(placeIndex, progress);
        if (progress == goal.getAmount()) {
            this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
            BlockItemStack finalGoal = goal;
            this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).blocksPlaced.set(placeIndex, progress);
                q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, finalGoal), null, null, null, null, null, null, null);
                return null;
            });
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress, goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void useBlock(Quest quest, ItemStack itemStack) {
        this.useBlock(quest, BlockItemStack.of(itemStack));
    }

    @Override
    public void useBlock(Quest quest, BlockItemStack used) {
        BlockItemStack goal = null;
        for (BlockItemStack toUse : ((BukkitStage)this.getCurrentStage(quest)).getBlocksToUse()) {
            if (goal != null) break;
            if (used.getType() != toUse.getType()) continue;
            if (used.getType().isSolid() && toUse.getType().isSolid()) {
                if (used.getDurability() == toUse.getDurability()) {
                    goal = toUse;
                    continue;
                }
                if (BukkitMiscUtil.isBelow113()) continue;
                goal = toUse;
                continue;
            }
            if (used.getType().name().equals("RED_ROSE")) {
                if (used.getDurability() != toUse.getDurability()) continue;
                goal = toUse;
                continue;
            }
            goal = toUse;
        }
        if (goal == null) {
            return;
        }
        ObjectiveType type = ObjectiveType.USE_BLOCK;
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, used.getAmount(), goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        int useIndex = this.getCurrentStage(quest).getBlocksToUse().indexOf(goal);
        if (useIndex >= bukkitQuestProgress.blocksUsed.size()) {
            return;
        }
        if (bukkitQuestProgress.blocksUsed.get(useIndex) >= goal.getAmount()) {
            return;
        }
        int progress = bukkitQuestProgress.blocksUsed.get(useIndex) + 1;
        bukkitQuestProgress.blocksUsed.set(useIndex, progress);
        if (progress == goal.getAmount()) {
            this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
            BlockItemStack finalGoal = goal;
            this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).blocksUsed.set(useIndex, progress);
                q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, finalGoal), null, null, null, null, null, null, null);
                return null;
            });
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress, goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void cutBlock(Quest quest, ItemStack itemStack) {
        this.cutBlock(quest, BlockItemStack.of(itemStack));
    }

    @Override
    public void cutBlock(Quest quest, BlockItemStack cut) {
        BlockItemStack goal = null;
        for (BlockItemStack toCut : ((BukkitStage)this.getCurrentStage(quest)).getBlocksToCut()) {
            if (goal != null) break;
            if (cut.getType() != toCut.getType()) continue;
            if (cut.getType().isSolid() && toCut.getType().isSolid()) {
                if (cut.getDurability() == toCut.getDurability()) {
                    goal = toCut;
                    continue;
                }
                if (BukkitMiscUtil.isBelow113()) continue;
                goal = toCut;
                continue;
            }
            if (cut.getType().name().equals("RED_ROSE")) {
                if (cut.getDurability() != toCut.getDurability()) continue;
                goal = toCut;
                continue;
            }
            goal = toCut;
        }
        if (goal == null) {
            return;
        }
        ObjectiveType type = ObjectiveType.CUT_BLOCK;
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, cut.getAmount(), goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        int cutIndex = this.getCurrentStage(quest).getBlocksToCut().indexOf(goal);
        if (cutIndex >= bukkitQuestProgress.blocksCut.size()) {
            return;
        }
        if (bukkitQuestProgress.blocksCut.get(cutIndex) >= goal.getAmount()) {
            return;
        }
        int progress = bukkitQuestProgress.blocksCut.get(cutIndex) + 1;
        bukkitQuestProgress.blocksCut.set(cutIndex, progress);
        if (progress == goal.getAmount()) {
            this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
            BlockItemStack finalGoal = goal;
            this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).blocksCut.set(cutIndex, progress);
                q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, finalGoal), null, null, null, null, null, null, null);
                return null;
            });
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress, goal.getAmount()));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void craftItem(Quest quest, ItemStack crafted) {
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        for (ItemStack toCraft : ((BukkitStage)this.getCurrentStage(quest)).getItemsToCraft()) {
            ++currentIndex;
            if (BukkitItemUtil.compareItems(crafted, toCraft, true) != 0) continue;
            matches.add(currentIndex);
        }
        if (matches.isEmpty()) {
            return;
        }
        for (Integer match : matches) {
            int amount = bukkitQuestProgress.itemsCrafted.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToCraft().get(match);
            ObjectiveType type = ObjectiveType.CRAFT_ITEM;
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int progress = Math.min(crafted.getAmount() + amount, goal.getAmount());
            bukkitQuestProgress.itemsCrafted.set(match, progress);
            if (progress >= goal.getAmount()) {
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsCrafted.set(match, progress);
                    q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                    return null;
                });
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)progress, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void smeltItem(Quest quest, ItemStack smelted) {
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        for (ItemStack toSmelt : ((BukkitStage)this.getCurrentStage(quest)).getItemsToSmelt()) {
            ++currentIndex;
            if (BukkitItemUtil.compareItems(smelted, toSmelt, true) != 0) continue;
            matches.add(currentIndex);
        }
        if (matches.isEmpty()) {
            return;
        }
        for (Integer match : matches) {
            int amount = bukkitQuestProgress.itemsSmelted.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToSmelt().get(match);
            ObjectiveType type = ObjectiveType.SMELT_ITEM;
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int progress = Math.min(smelted.getAmount() + amount, goal.getAmount());
            bukkitQuestProgress.itemsSmelted.set(match, progress);
            if (progress >= goal.getAmount()) {
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsSmelted.set(match, progress);
                    q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                    return null;
                });
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)progress, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void enchantBook(Quest quest, ItemStack enchantedBook, Map<Enchantment, Integer> enchantsToAdd) {
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        for (ItemStack toEnchant : ((BukkitStage)this.getCurrentStage(quest)).getItemsToEnchant()) {
            ++currentIndex;
            if (!(toEnchant.getItemMeta() instanceof EnchantmentStorageMeta) || !((EnchantmentStorageMeta)toEnchant.getItemMeta()).getStoredEnchants().equals(enchantsToAdd)) continue;
            matches.add(currentIndex);
        }
        if (matches.isEmpty()) {
            return;
        }
        for (Integer match : matches) {
            int amount = bukkitQuestProgress.itemsEnchanted.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToEnchant().get(match);
            ObjectiveType type = ObjectiveType.ENCHANT_ITEM;
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int progress = Math.min(enchantedBook.getAmount() + amount, goal.getAmount());
            bukkitQuestProgress.itemsEnchanted.set(match, progress);
            if (progress >= goal.getAmount()) {
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsEnchanted.set(match, progress);
                    q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                    return null;
                });
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)(enchantedBook.getAmount() + amount), goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void enchantItem(Quest quest, ItemStack enchanted) {
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (!enchanted.getType().equals((Object)Material.BOOK)) {
            for (ItemStack toEnchant : ((BukkitStage)this.getCurrentStage(quest)).getItemsToEnchant()) {
                ++currentIndex;
                if (!toEnchant.getEnchantments().isEmpty()) {
                    if (BukkitItemUtil.compareItems(enchanted, toEnchant, true) != 0) continue;
                    matches.add(currentIndex);
                    continue;
                }
                if (BukkitItemUtil.compareItems(enchanted, toEnchant, true) != -4) continue;
                matches.add(currentIndex);
            }
        }
        if (matches.isEmpty()) {
            return;
        }
        for (Integer match : matches) {
            int amount = bukkitQuestProgress.itemsEnchanted.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToEnchant().get(match);
            ObjectiveType type = ObjectiveType.ENCHANT_ITEM;
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int progress = Math.min(enchanted.getAmount() + amount, goal.getAmount());
            bukkitQuestProgress.itemsEnchanted.set(match, progress);
            if (progress >= goal.getAmount()) {
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsEnchanted.set(match, progress);
                    q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                    return null;
                });
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)(enchanted.getAmount() + amount), goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void brewItem(Quest quest, ItemStack brewed) {
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        for (ItemStack toBrew : ((BukkitStage)this.getCurrentStage(quest)).getItemsToBrew()) {
            ++currentIndex;
            if (BukkitItemUtil.compareItems(brewed, toBrew, true) != 0) continue;
            matches.add(currentIndex);
        }
        if (matches.isEmpty()) {
            return;
        }
        for (Integer match : matches) {
            int amount = bukkitQuestProgress.itemsBrewed.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToBrew().get(match);
            ObjectiveType type = ObjectiveType.BREW_ITEM;
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int progress = Math.min(brewed.getAmount() + amount, goal.getAmount());
            bukkitQuestProgress.itemsBrewed.set(match, progress);
            if (progress >= goal.getAmount()) {
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsBrewed.set(match, progress);
                    q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                    return null;
                });
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)progress, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void consumeItem(Quest quest, ItemStack consumed) {
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        for (ItemStack toConsume : ((BukkitStage)this.getCurrentStage(quest)).getItemsToConsume()) {
            ++currentIndex;
            if (BukkitItemUtil.compareItems(consumed, toConsume, true) != 0) continue;
            matches.add(currentIndex);
        }
        if (matches.isEmpty()) {
            return;
        }
        for (Integer match : matches) {
            int amount = bukkitQuestProgress.itemsConsumed.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToConsume().get(match);
            ObjectiveType type = ObjectiveType.CONSUME_ITEM;
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int progress = Math.min(consumed.getAmount() + amount, 64);
            bukkitQuestProgress.itemsConsumed.set(match, progress);
            if (progress >= goal.getAmount()) {
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsConsumed.set(match, progress);
                    q.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
                    return null;
                });
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)progress, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void deliverToNPC(Quest quest, UUID npc, ItemStack delivered) {
        if (npc == null) {
            return;
        }
        int currentIndex = -1;
        LinkedList<Integer> matches = new LinkedList<Integer>();
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        for (ItemStack toDeliver : ((BukkitStage)this.getCurrentStage(quest)).getItemsToDeliver()) {
            ++currentIndex;
            if (BukkitItemUtil.compareItems(delivered, toDeliver, true) != 0) continue;
            matches.add(currentIndex);
        }
        if (matches.isEmpty()) {
            return;
        }
        Player player = this.getPlayer();
        for (Integer match : matches) {
            if (!this.getCurrentStage(quest).getItemDeliveryTargets().get(match).equals(npc)) continue;
            int amount = bukkitQuestProgress.itemsDelivered.get(match);
            ItemStack goal = ((BukkitStage)this.getCurrentStage(quest)).getItemsToDeliver().get(match);
            ObjectiveType type = ObjectiveType.DELIVER_ITEM;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)amount, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int index = player.getInventory().first(delivered);
            if (index == -1) {
                return;
            }
            int progress = Math.min(delivered.getAmount() + amount, goal.getAmount());
            bukkitQuestProgress.itemsDelivered.set(match, progress);
            if (progress >= goal.getAmount()) {
                ItemStack clone = delivered.clone();
                int newAmount = clone.getAmount() - (goal.getAmount() - amount);
                clone.setAmount(newAmount);
                player.getInventory().setItem(index, clone);
                player.updateInventory();
                this.finishObjective(quest, new BukkitObjective(type, null, (Object)progress, goal), null, null, null, null, null, null, null);
            } else {
                player.getInventory().setItem(index, null);
                player.updateInventory();
                String[] message = BukkitConfigUtil.parseStringWithPossibleLineBreaks(this.getCurrentStage(quest).getDeliverMessages().get(new Random().nextInt(this.getCurrentStage(quest).getDeliverMessages().size())), this.getCurrentStage(quest).getItemDeliveryTargets().get(match), goal.getAmount() - progress, this.plugin);
                player.sendMessage(message);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, ObjectiveType.DELIVER_ITEM, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).itemsDelivered.set(match, progress);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, (Object)progress, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void interactWithNPC(Quest quest, UUID npc) {
        if (!this.getCurrentStage(quest).getNpcsToInteract().contains(npc)) {
            return;
        }
        int index = this.getCurrentStage(quest).getNpcsToInteract().indexOf(npc);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        boolean npcsInteracted = bukkitQuestProgress.npcsInteracted.get(index);
        ObjectiveType type = ObjectiveType.TALK_TO_NPC;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, 1, 1));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        if (!npcsInteracted) {
            bukkitQuestProgress.npcsInteracted.set(index, true);
            this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, 1, (short)0)), null, null, npc, null, null, null, null);
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).npcsInteracted.set(index, true);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, 1, 1));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public void killNPC(Quest quest, UUID npc) {
        if (!this.getCurrentStage(quest).getNpcsToKill().contains(npc)) {
            return;
        }
        int index = this.getCurrentStage(quest).getNpcsToKill().indexOf(npc);
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        int npcsKilled = bukkitQuestProgress.npcsNumKilled.get(index);
        int npcsToKill = this.getCurrentStage(quest).getNpcNumToKill().get(index);
        ObjectiveType type = ObjectiveType.KILL_NPC;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, npcsKilled, npcsToKill));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newNpcsKilled = bukkitQuestProgress.npcsNumKilled.get(index) + 1;
        if (npcsKilled < npcsToKill) {
            bukkitQuestProgress.npcsNumKilled.set(index, newNpcsKilled);
            if (newNpcsKilled >= npcsToKill) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, npcsToKill, (short)0)), null, null, npc, null, null, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).npcsNumKilled.set(index, newNpcsKilled);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newNpcsKilled, npcsToKill));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void milkCow(Quest quest) {
        BukkitQuestProgress questProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (questProgress == null) {
            return;
        }
        Stage currentStage = this.getCurrentStage(quest);
        if (currentStage == null) {
            return;
        }
        if (currentStage.getCowsToMilk() == null) {
            return;
        }
        int cowsMilked = questProgress.getCowsMilked();
        int cowsToMilk = currentStage.getCowsToMilk();
        ObjectiveType type = ObjectiveType.MILK_COW;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, cowsMilked, cowsToMilk));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newCowsMilked = cowsMilked + 1;
        if (cowsMilked < cowsToMilk) {
            questProgress.setCowsMilked(newCowsMilked);
            if (newCowsMilked >= cowsToMilk) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, cowsToMilk, (short)0)), null, null, null, null, null, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    q.getQuestProgressOrDefault(quest).setCowsMilked(newCowsMilked);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newCowsMilked, cowsToMilk));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void catchFish(Quest quest) {
        BukkitQuestProgress questProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (questProgress == null) {
            return;
        }
        Stage currentStage = this.getCurrentStage(quest);
        if (currentStage == null) {
            return;
        }
        if (currentStage.getFishToCatch() == null) {
            return;
        }
        int fishCaught = questProgress.getFishCaught();
        int fishToCatch = currentStage.getFishToCatch();
        ObjectiveType type = ObjectiveType.CATCH_FISH;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, fishCaught, fishToCatch));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newFishCaught = fishCaught + 1;
        if (fishCaught < fishToCatch) {
            questProgress.setFishCaught(newFishCaught);
            if (newFishCaught >= fishToCatch) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, fishToCatch, (short)0)), null, null, null, null, null, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    q.getQuestProgressOrDefault(quest).setFishCaught(newFishCaught);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newFishCaught, fishToCatch));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void killMob(Quest quest, Location killedLocation, EntityType entityType) {
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (entityType == null) {
            return;
        }
        BukkitStage currentStage = (BukkitStage)this.getCurrentStage(quest);
        if (currentStage.getMobsToKill() == null) {
            return;
        }
        int index = currentStage.getMobsToKill().indexOf(entityType);
        if (index == -1) {
            return;
        }
        if (index >= bukkitQuestProgress.mobNumKilled.size()) {
            this.plugin.getLogger().severe(this.getPlayer().getName() + " presented invalid index for quest " + quest.getName());
            this.getPlayer().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            return;
        }
        int mobsKilled = bukkitQuestProgress.mobNumKilled.get(index);
        int mobsToKill = currentStage.getMobNumToKill().get(index);
        if (!currentStage.getLocationsToKillWithin().isEmpty()) {
            Location locationToKillWithin = currentStage.getLocationsToKillWithin().get(index);
            double radius = currentStage.getRadiiToKillWithin().get(index).intValue();
            if (killedLocation.getWorld() == null || locationToKillWithin.getWorld() == null) {
                return;
            }
            if (!killedLocation.getWorld().getName().equals(locationToKillWithin.getWorld().getName())) {
                return;
            }
            if (!(killedLocation.getX() < locationToKillWithin.getX() + radius) || !(killedLocation.getX() > locationToKillWithin.getX() - radius)) {
                return;
            }
            if (!(killedLocation.getZ() < locationToKillWithin.getZ() + radius) || !(killedLocation.getZ() > locationToKillWithin.getZ() - radius)) {
                return;
            }
            if (!(killedLocation.getY() < locationToKillWithin.getY() + radius) || !(killedLocation.getY() > locationToKillWithin.getY() - radius)) {
                return;
            }
        }
        ObjectiveType type = ObjectiveType.KILL_MOB;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, mobsKilled, mobsToKill));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newMobsKilled = mobsKilled + 1;
        if (mobsKilled < mobsToKill) {
            bukkitQuestProgress.mobNumKilled.set(index, newMobsKilled);
            if (newMobsKilled >= mobsToKill) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, mobsToKill, (short)0)), entityType, null, null, null, null, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    int i = q.getCurrentStage((Quest)cq).getMobsToKill().indexOf(entityType);
                    if (i == -1) {
                        return null;
                    }
                    int kills = q.getQuestProgressOrDefault(quest).getMobNumKilled().get(i);
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).mobNumKilled.set(index, kills + 1);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newMobsKilled, mobsToKill));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void killPlayer(Quest quest, Player player) {
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (bukkitQuestProgress == null) {
            return;
        }
        Stage currentStage = this.getCurrentStage(quest);
        if (currentStage == null) {
            return;
        }
        if (currentStage.getPlayersToKill() == null) {
            return;
        }
        int playersKilled = bukkitQuestProgress.getPlayersKilled();
        int playersToKill = currentStage.getPlayersToKill();
        ObjectiveType type = ObjectiveType.KILL_PLAYER;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, playersKilled, playersToKill));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newPlayersKilled = playersKilled + 1;
        if (playersKilled < playersToKill) {
            bukkitQuestProgress.setPlayersKilled(newPlayersKilled);
            if (newPlayersKilled >= playersToKill) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, playersToKill, (short)0)), null, null, null, null, null, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    int kills = q.getQuestProgressOrDefault(quest).getPlayersKilled();
                    q.getQuestProgressOrDefault(quest).setPlayersKilled(kills + 1);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newPlayersKilled, playersToKill));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void reachLocation(Quest quest, Location location) {
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (bukkitQuestProgress == null || bukkitQuestProgress.locationsReached == null || this.getCurrentStage(quest) == null || this.getCurrentStage(quest).getLocationsToReach() == null) {
            return;
        }
        LinkedList<Location> locationsToReach = ((BukkitStage)this.getCurrentStage(quest)).getLocationsToReach();
        int goal = locationsToReach.size();
        for (int i = 0; i < goal; ++i) {
            Location toReach = locationsToReach.get(i);
            if (location.getWorld() == null || toReach.getWorld() == null || !location.getWorld().getName().equals(toReach.getWorld().getName())) continue;
            double radius = this.getCurrentStage(quest).getRadiiToReachWithin().get(i).intValue();
            if (!(toReach.distanceSquared(location) <= radius * radius) || bukkitQuestProgress.locationsReached.get(i).booleanValue()) continue;
            int progress = 0;
            for (Boolean b : bukkitQuestProgress.locationsReached) {
                if (!b.booleanValue()) continue;
                ++progress;
            }
            ObjectiveType type = ObjectiveType.REACH_LOCATION;
            HashSet<String> dispatchedQuestIDs = new HashSet<String>();
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            bukkitQuestProgress.locationsReached.set(i, true);
            this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, 1, (short)0)), null, null, null, toReach, null, null, null);
            int finalIndex = i;
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).locationsReached.set(finalIndex, true);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, progress + 1, goal));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
            break;
        }
    }

    @Override
    public void tameMob(Quest quest, EntityType entityType) {
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (entityType == null) {
            return;
        }
        Stage currentStage = this.getCurrentStage(quest);
        if (currentStage.getMobsToTame() == null) {
            return;
        }
        int index = currentStage.getMobsToTame().indexOf(entityType);
        if (index == -1) {
            return;
        }
        if (index >= bukkitQuestProgress.mobsTamed.size()) {
            this.plugin.getLogger().severe(this.getPlayer().getName() + " presented invalid index for quest " + quest.getName());
            this.getPlayer().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            return;
        }
        int mobsTamed = bukkitQuestProgress.mobsTamed.get(index);
        int mobsToTame = currentStage.getMobNumToTame().get(index);
        ObjectiveType type = ObjectiveType.TAME_MOB;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, mobsTamed, mobsToTame));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newMobsTamed = mobsTamed + 1;
        if (mobsTamed < mobsToTame) {
            bukkitQuestProgress.mobsTamed.set(index, newMobsTamed);
            if (newMobsTamed >= mobsToTame) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, mobsToTame, (short)0)), entityType, null, null, null, null, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).mobsTamed.set(index, newMobsTamed);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newMobsTamed, mobsTamed));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void shearSheep(Quest quest, DyeColor color) {
        BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
        if (color == null) {
            return;
        }
        Stage currentStage = this.getCurrentStage(quest);
        if (currentStage.getSheepToShear() == null) {
            return;
        }
        int index = currentStage.getSheepToShear().indexOf(color);
        if (index == -1) {
            return;
        }
        if (index >= bukkitQuestProgress.sheepSheared.size()) {
            this.plugin.getLogger().severe(this.getPlayer().getName() + " presented invalid index for quest " + quest.getName());
            this.getPlayer().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            return;
        }
        int sheepSheared = bukkitQuestProgress.sheepSheared.get(index);
        int sheepToShear = this.getCurrentStage(quest).getSheepNumToShear().get(index);
        ObjectiveType type = ObjectiveType.SHEAR_SHEEP;
        HashSet<String> dispatchedQuestIDs = new HashSet<String>();
        BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, sheepSheared, sheepToShear));
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        int newSheepSheared = sheepSheared + 1;
        if (sheepSheared < sheepToShear) {
            bukkitQuestProgress.sheepSheared.set(index, newSheepSheared);
            if (newSheepSheared >= sheepToShear) {
                this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, sheepToShear, (short)0)), null, null, null, null, color, null, null);
            }
            dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                if (!dispatchedQuestIDs.contains(cq.getId())) {
                    ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).sheepSheared.set(index, newSheepSheared);
                    if (q.testComplete(quest)) {
                        quest.nextStage((Quester)q, false);
                    }
                }
                return null;
            }));
        }
        BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, newSheepSheared, sheepToShear));
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public void sayPassword(Quest quest, AsyncPlayerChatEvent evt) {
        ObjectiveType type = ObjectiveType.PASSWORD;
        HashSet dispatchedQuestIDs = new HashSet();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            BukkitQuesterPreUpdateObjectiveEvent preEvent = new BukkitQuesterPreUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, 1, 1));
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            int index = 0;
            BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
            for (String pass : this.getCurrentStage(quest).getPasswordPhrases()) {
                if (pass.equalsIgnoreCase(evt.getMessage())) {
                    String display = this.getCurrentStage(quest).getPasswordDisplays().get(index);
                    bukkitQuestProgress.passwordsSaid.set(index, true);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.finishObjective(quest, new BukkitObjective(type, null, BlockItemStack.of(Material.AIR, 1, (short)0), BlockItemStack.of(Material.AIR, 1, (short)0)), null, null, null, null, null, display, null));
                    int finalIndex = index;
                    dispatchedQuestIDs.addAll(this.dispatchMultiplayerEverything(quest, type, (q, cq) -> {
                        if (!dispatchedQuestIDs.contains(cq.getId())) {
                            ((BukkitQuestProgress)q.getQuestProgressOrDefault((Quest)quest)).passwordsSaid.set(finalIndex, true);
                            if (q.testComplete(quest)) {
                                quest.nextStage((Quester)q, false);
                            }
                        }
                        return null;
                    }));
                    break;
                }
                ++index;
            }
            BukkitQuesterPostUpdateObjectiveEvent postEvent = new BukkitQuesterPostUpdateObjectiveEvent(this, quest, new BukkitObjective(type, null, 1, 1));
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        });
    }

    @Override
    public void finishObjective(Quest quest, Objective objective, EntityType mob, String extra, UUID npc, Location location, DyeColor color, String pass, CustomObjective co) {
        BlockItemStack goalBlock;
        if (objective == null) {
            return;
        }
        Player p = this.getPlayer();
        ObjectiveType type = objective.getType();
        ItemStack goal = objective.getGoalObject() instanceof ItemStack ? (ItemStack)objective.getGoalObject() : new ItemStack(Material.AIR, objective.getGoal());
        BlockItemStack blockItemStack = goalBlock = objective.getGoalObject() instanceof BlockItemStack ? (BlockItemStack)objective.getGoalObject() : BlockItemStack.of(Material.AIR, objective.getGoal(), (short)0);
        if (!this.getCurrentStage(quest).getObjectiveOverrides().isEmpty()) {
            for (String s : this.getCurrentStage(quest).getObjectiveOverrides()) {
                String message = ChatColor.GREEN + "(" + BukkitLang.get(p, "completed") + ") " + BukkitConfigUtil.parseString(ChatColor.translateAlternateColorCodes((char)'&', (String)s), quest, p);
                message = message.replace("<count>", objective.getProgress() + "/" + objective.getGoal());
                message = message.replace("%count%", objective.getProgress() + "/" + objective.getGoal());
                if (this.plugin.getDependencies().getPlaceholderApi() != null) {
                    message = PlaceholderAPI.setPlaceholders((Player)p, (String)message);
                }
                this.sendMessage(message);
            }
        } else if (type.equals((Object)ObjectiveType.BREAK_BLOCK)) {
            String message = this.formatCompletedObjectiveMessage("break", goalBlock.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goalBlock.getType(), goalBlock.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
            }
        } else if (type.equals((Object)ObjectiveType.DAMAGE_BLOCK)) {
            String message = this.formatCompletedObjectiveMessage("damage", goalBlock.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goalBlock.getType(), goalBlock.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
            }
        } else if (type.equals((Object)ObjectiveType.PLACE_BLOCK)) {
            String message = this.formatCompletedObjectiveMessage("place", goalBlock.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goalBlock.getType(), goalBlock.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
            }
        } else if (type.equals((Object)ObjectiveType.USE_BLOCK)) {
            String message = this.formatCompletedObjectiveMessage("use", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goalBlock.getType(), goalBlock.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
            }
        } else if (type.equals((Object)ObjectiveType.CUT_BLOCK)) {
            String message = this.formatCompletedObjectiveMessage("cut", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goalBlock.getType(), goalBlock.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(goalBlock)));
            }
        } else if (type.equals((Object)ObjectiveType.CRAFT_ITEM)) {
            ItemStack is = ((BukkitStage)this.getCurrentStage(quest)).getItemsToCraft().get(this.getCurrentStage(quest).getItemsToCraft().indexOf(goal));
            String message = this.formatCompletedObjectiveMessage("craftItem", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames() && !goal.hasItemMeta() && !goal.getItemMeta().hasDisplayName()) {
                String level;
                if (goal.getType().name().equals("TIPPED_ARROW") && !(level = BukkitItemUtil.getPrettyPotionLevel(goal.getItemMeta())).isEmpty()) {
                    message = message.replace("<item>", "<item> " + level);
                }
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
            }
        } else if (type.equals((Object)ObjectiveType.SMELT_ITEM)) {
            ItemStack is = ((BukkitStage)this.getCurrentStage(quest)).getItemsToSmelt().get(this.getCurrentStage(quest).getItemsToSmelt().indexOf(goal));
            String message = this.formatCompletedObjectiveMessage("smeltItem", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames() && !goal.hasItemMeta() && !goal.getItemMeta().hasDisplayName()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
            }
        } else if (type.equals((Object)ObjectiveType.ENCHANT_ITEM)) {
            ItemStack is = ((BukkitStage)this.getCurrentStage(quest)).getItemsToEnchant().get(this.getCurrentStage(quest).getItemsToEnchant().indexOf(goal));
            String message = this.formatCompletedObjectiveMessage("enchItem", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames() && is.hasItemMeta() && !is.getItemMeta().hasDisplayName()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), goal.getEnchantments(), goal.getItemMeta())) {
                    for (Map.Entry e : is.getEnchantments().entrySet()) {
                        this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)).replace("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).replace("<level>", RomanNumeral.getNumeral((Integer)e.getValue())));
                    }
                }
            } else if (this.plugin.getConfigSettings().canTranslateNames() && !is.hasItemMeta() && Material.getMaterial((String)"LINGERING_POTION") == null) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), goal.getEnchantments())) {
                    for (Map.Entry e : is.getEnchantments().entrySet()) {
                        this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)).replace("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).replace("<level>", RomanNumeral.getNumeral((Integer)e.getValue())));
                    }
                }
            } else {
                for (Map.Entry e : is.getEnchantments().entrySet()) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)).replace("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).replace("<level>", RomanNumeral.getNumeral((Integer)e.getValue())));
                }
            }
        } else if (type.equals((Object)ObjectiveType.BREW_ITEM)) {
            ItemStack is = ((BukkitStage)this.getCurrentStage(quest)).getItemsToBrew().get(this.getCurrentStage(quest).getItemsToBrew().indexOf(goal));
            String message = this.formatCompletedObjectiveMessage("brewItem", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames() && is.hasItemMeta() && !is.getItemMeta().hasDisplayName()) {
                if (goal.getType().name().contains("POTION") && this.plugin.getLocaleManager().hasBasePotionData()) {
                    String level = BukkitItemUtil.getPrettyPotionLevel(goal.getItemMeta());
                    message = level.isEmpty() ? message.replace(" <level>", level) : message.replace("<level>", level);
                }
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), goal.getEnchantments(), goal.getItemMeta())) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
                }
            } else if (this.plugin.getConfigSettings().canTranslateNames() && !is.hasItemMeta() && Material.getMaterial((String)"LINGERING_POTION") == null) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), goal.getEnchantments())) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
            }
        } else if (type.equals((Object)ObjectiveType.CONSUME_ITEM)) {
            ItemStack is = ((BukkitStage)this.getCurrentStage(quest)).getItemsToConsume().get(this.getCurrentStage(quest).getItemsToConsume().indexOf(goal));
            String message = this.formatCompletedObjectiveMessage("consumeItem", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames() && !goal.hasItemMeta() && !goal.getItemMeta().hasDisplayName()) {
                if (goal.getType().name().contains("POTION") && this.plugin.getLocaleManager().hasBasePotionData()) {
                    String level = BukkitItemUtil.getPrettyPotionLevel(goal.getItemMeta());
                    message = level.isEmpty() ? message.replace(" <level>", level) : message.replace("<level>", level);
                }
                if (!this.plugin.getLocaleManager().sendMessage(p, message, goal.getType(), goal.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
            }
        } else if (type.equals((Object)ObjectiveType.DELIVER_ITEM)) {
            ItemStack is = ((BukkitStage)this.getCurrentStage(quest)).getItemsToDeliver().get(this.getCurrentStage(quest).getItemsToDeliver().indexOf(goal));
            String message = this.formatCompletedObjectiveMessage("deliver", goal.getAmount()).replace("<npc>", this.plugin.getDependencies().getNpcName(this.getCurrentStage(quest).getItemDeliveryTargets().get(this.getCurrentStage(quest).getItemsToDeliver().indexOf(goal))));
            if (this.plugin.getConfigSettings().canTranslateNames() && !goal.hasItemMeta() && !goal.getItemMeta().hasDisplayName()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, is.getType(), is.getDurability(), null)) {
                    this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
                }
            } else {
                this.sendMessage(message.replace("<item>", BukkitItemUtil.getName(is)));
            }
        } else if (type.equals((Object)ObjectiveType.MILK_COW)) {
            String message = this.formatCompletedObjectiveMessage("milkCow", goal.getAmount());
            this.sendMessage(message);
        } else if (type.equals((Object)ObjectiveType.CATCH_FISH)) {
            String message = this.formatCompletedObjectiveMessage("catchFish", goal.getAmount());
            this.sendMessage(message);
        } else if (type.equals((Object)ObjectiveType.KILL_MOB)) {
            String message = this.formatCompletedObjectiveMessage("kill", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, mob, extra)) {
                    this.sendMessage(message.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(mob.name())));
                }
            } else {
                this.sendMessage(message.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(mob.name())));
            }
        } else if (type.equals((Object)ObjectiveType.KILL_PLAYER)) {
            String message = this.formatCompletedObjectiveMessage("killPlayer", goal.getAmount());
            this.sendMessage(message);
        } else if (type.equals((Object)ObjectiveType.TALK_TO_NPC)) {
            String message = this.formatCompletedObjectiveMessage("talkTo", goal.getAmount()).replace("<npc>", this.plugin.getDependencies().getNpcName(npc));
            this.sendMessage(message);
        } else if (type.equals((Object)ObjectiveType.KILL_NPC)) {
            String message = this.formatCompletedObjectiveMessage("kill", goal.getAmount());
            this.sendMessage(message.replace("<mob>", this.plugin.getDependencies().getNpcName(npc)));
        } else if (type.equals((Object)ObjectiveType.TAME_MOB)) {
            String message = this.formatCompletedObjectiveMessage("tame", goal.getAmount());
            if (this.plugin.getConfigSettings().canTranslateNames()) {
                if (!this.plugin.getLocaleManager().sendMessage(p, message, mob, extra)) {
                    this.sendMessage(message.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(mob.name())));
                }
            } else {
                this.sendMessage(message.replace("<mob>", BukkitMiscUtil.snakeCaseToUpperCamelCase(mob.name())));
            }
        } else if (type.equals((Object)ObjectiveType.SHEAR_SHEEP)) {
            String message = this.formatCompletedObjectiveMessage("shearSheep", goal.getAmount()).replace("<color>", BukkitMiscUtil.getPrettyDyeColorName(color));
            this.sendMessage(message);
        } else if (type.equals((Object)ObjectiveType.REACH_LOCATION)) {
            String obj = BukkitLang.get(p, "goTo");
            try {
                obj = obj.replace("<location>", this.getCurrentStage(quest).getLocationNames().get(this.getCurrentStage(quest).getLocationsToReach().indexOf(location)));
            }
            catch (IndexOutOfBoundsException e) {
                this.plugin.getLogger().severe("Unable to get final location " + location + " for quest ID " + quest.getId() + ", please report on Github");
                obj = obj.replace("<location>", "ERROR");
            }
            String message = ChatColor.GREEN + "(" + BukkitLang.get(p, "completed") + ") " + obj;
            this.sendMessage(message);
        } else if (type.equals((Object)ObjectiveType.PASSWORD)) {
            this.sendMessage(ChatColor.GREEN + "(" + BukkitLang.get(p, "completed") + ") " + pass);
        } else if (co != null) {
            String message = ChatColor.GREEN + "(" + BukkitLang.get(p, "completed") + ") " + co.getDisplay();
            int index = -1;
            for (int i = 0; i < this.getCurrentStage(quest).getCustomObjectives().size(); ++i) {
                if (!this.getCurrentStage(quest).getCustomObjectives().get(i).getName().equals(co.getName())) continue;
                index = i;
                break;
            }
            LinkedList sub = new LinkedList(this.getCurrentStage(quest).getCustomObjectiveData().subList(index, this.getCurrentStage(quest).getCustomObjectiveData().size()));
            LinkedList end = new LinkedList(sub);
            sub.clear();
            for (Map.Entry dataMap : end) {
                message = message.replace("%" + (String)dataMap.getKey() + "%", String.valueOf(dataMap.getValue()));
            }
            if (co.canShowCount()) {
                message = message.replace("%count%", objective.getGoal() + "/" + objective.getGoal());
            }
            this.sendMessage(BukkitConfigUtil.parseString(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
        }
        this.dispatchMultiplayerObjectives(quest, this.getCurrentStage(quest), q -> {
            q.finishObjective(quest, objective, mob, extra, npc, location, color, pass, co);
            return null;
        });
        if (this.testComplete(quest)) {
            quest.nextStage(this, true);
        }
    }

    private String formatCompletedObjectiveMessage(String langKey, int goal) {
        String message = ChatColor.GREEN + "(" + BukkitLang.get(this.getPlayer(), "completed") + ") " + BukkitLang.get(langKey);
        if (message.contains("<count>")) {
            message = message.replace("<count>", goal + "/" + goal);
        }
        if (this.plugin.getDependencies().getPlaceholderApi() != null) {
            message = PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)message);
        }
        return message;
    }

    @Override
    public boolean testComplete(Quest quest) {
        for (Objective objective : this.getCurrentObjectives(quest, true, false)) {
            if (objective.getProgress() >= objective.getGoal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addEmptiesFor(Quest quest, int stage) {
        BukkitQuestProgress data = new BukkitQuestProgress(this);
        data.setDoJournalUpdate(false);
        if (quest == null) {
            this.plugin.getLogger().warning("Unable to find quest for player " + this.lastKnownName);
            return;
        }
        if (quest.getStage(stage) == null) {
            this.plugin.getLogger().severe("Unable to find Stage " + stage + " of quest ID " + quest.getId());
            return;
        }
        BukkitStage bukkitStage = (BukkitStage)quest.getStage(stage);
        if (!bukkitStage.getBlocksToBreak().isEmpty()) {
            for (BlockItemStack blockItemStack : bukkitStage.getBlocksToBreak()) {
                data.blocksBroken.add(0);
            }
        }
        if (!bukkitStage.getBlocksToDamage().isEmpty()) {
            for (BlockItemStack blockItemStack : bukkitStage.getBlocksToDamage()) {
                data.blocksDamaged.add(0);
            }
        }
        if (!bukkitStage.getBlocksToPlace().isEmpty()) {
            for (BlockItemStack blockItemStack : bukkitStage.getBlocksToPlace()) {
                data.blocksPlaced.add(0);
            }
        }
        if (!bukkitStage.getBlocksToUse().isEmpty()) {
            for (BlockItemStack blockItemStack : bukkitStage.getBlocksToUse()) {
                data.blocksUsed.add(0);
            }
        }
        if (!bukkitStage.getBlocksToCut().isEmpty()) {
            for (BlockItemStack blockItemStack : bukkitStage.getBlocksToCut()) {
                data.blocksCut.add(0);
            }
        }
        if (!bukkitStage.getItemsToCraft().isEmpty()) {
            for (ItemStack itemStack : bukkitStage.getItemsToCraft()) {
                data.itemsCrafted.add(0);
            }
        }
        if (!bukkitStage.getItemsToSmelt().isEmpty()) {
            for (ItemStack itemStack : bukkitStage.getItemsToSmelt()) {
                data.itemsSmelted.add(0);
            }
        }
        if (!bukkitStage.getItemsToEnchant().isEmpty()) {
            for (ItemStack itemStack : bukkitStage.getItemsToEnchant()) {
                data.itemsEnchanted.add(0);
            }
        }
        if (!bukkitStage.getItemsToBrew().isEmpty()) {
            for (ItemStack itemStack : bukkitStage.getItemsToBrew()) {
                data.itemsBrewed.add(0);
            }
        }
        if (!bukkitStage.getItemsToConsume().isEmpty()) {
            for (ItemStack itemStack : bukkitStage.getItemsToConsume()) {
                data.itemsConsumed.add(0);
            }
        }
        if (!bukkitStage.getItemsToDeliver().isEmpty()) {
            for (ItemStack itemStack : bukkitStage.getItemsToDeliver()) {
                data.itemsDelivered.add(0);
            }
        }
        if (!quest.getStage(stage).getNpcsToInteract().isEmpty()) {
            for (UUID uUID : quest.getStage(stage).getNpcsToInteract()) {
                data.npcsInteracted.add(false);
            }
        }
        if (!quest.getStage(stage).getNpcsToKill().isEmpty()) {
            for (UUID uUID : quest.getStage(stage).getNpcsToKill()) {
                data.npcsNumKilled.add(0);
            }
        }
        if (!quest.getStage(stage).getMobsToKill().isEmpty()) {
            for (EntityType entityType : bukkitStage.getMobsToKill()) {
                data.mobNumKilled.add(0);
            }
        }
        data.setCowsMilked(0);
        data.setFishCaught(0);
        data.setPlayersKilled(0);
        if (!quest.getStage(stage).getLocationsToReach().isEmpty()) {
            for (Location location : bukkitStage.getLocationsToReach()) {
                data.locationsReached.add(false);
            }
        }
        if (!quest.getStage(stage).getMobsToTame().isEmpty()) {
            for (EntityType entityType : bukkitStage.getMobsToTame()) {
                data.mobsTamed.add(0);
            }
        }
        if (!quest.getStage(stage).getSheepToShear().isEmpty()) {
            for (DyeColor dyeColor : bukkitStage.getSheepToShear()) {
                data.sheepSheared.add(0);
            }
        }
        if (!quest.getStage(stage).getPasswordDisplays().isEmpty()) {
            for (String string : bukkitStage.getPasswordDisplays()) {
                data.passwordsSaid.add(false);
            }
        }
        if (!quest.getStage(stage).getCustomObjectives().isEmpty()) {
            for (CustomObjective customObjective : quest.getStage(stage).getCustomObjectives()) {
                data.customObjectiveCounts.add(0);
            }
        }
        data.setDoJournalUpdate(true);
        this.hardDataPut(quest, data);
    }

    @Override
    public boolean saveData() {
        try {
            this.plugin.getStorage().saveQuester(this).get();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public long getCompletionDifference(Quest quest) {
        long lastTime;
        long currentTime = System.currentTimeMillis();
        if (!this.completedTimes.containsKey(quest)) {
            lastTime = System.currentTimeMillis();
            this.completedTimes.put(quest, System.currentTimeMillis());
        } else {
            lastTime = this.completedTimes.get(quest);
        }
        return currentTime - lastTime;
    }

    @Override
    public long getRemainingCooldown(Quest quest) {
        return quest.getPlanner().getCooldown() - this.getCompletionDifference(quest);
    }

    @Override
    public FileConfiguration getBaseData() {
        Player representedPlayer;
        LinkedList<String> questIds;
        YamlConfiguration data = new YamlConfiguration();
        ArrayList<String> currentQuestIds = new ArrayList<String>();
        ArrayList<Integer> currentQuestStages = new ArrayList<Integer>();
        if (!this.currentQuests.isEmpty()) {
            for (Iterator<Quest> quest : this.currentQuests.keySet()) {
                currentQuestIds.add(quest.getId());
                currentQuestStages.add(this.currentQuests.get(quest));
            }
            ConfigurationSection dataSec = data.createSection("questData");
            for (Quest quest : this.currentQuests.keySet()) {
                Stage stage;
                if (quest.getName() == null || quest.getName().isEmpty()) {
                    this.plugin.getLogger().severe("Quest name was null or empty while loading data");
                    return null;
                }
                ConfigurationSection configurationSection = dataSec.createSection(quest.getId());
                BukkitQuestProgress questProgress = (BukkitQuestProgress)this.getQuestProgressOrDefault(quest);
                if (questProgress == null) continue;
                if (!questProgress.blocksBroken.isEmpty()) {
                    configurationSection.set("blocks-broken-amounts", questProgress.blocksBroken);
                }
                if (!questProgress.blocksDamaged.isEmpty()) {
                    configurationSection.set("blocks-damaged-amounts", questProgress.blocksDamaged);
                }
                if (!questProgress.blocksPlaced.isEmpty()) {
                    configurationSection.set("blocks-placed-amounts", questProgress.blocksPlaced);
                }
                if (!questProgress.blocksUsed.isEmpty()) {
                    configurationSection.set("blocks-used-amounts", questProgress.blocksUsed);
                }
                if (!questProgress.blocksCut.isEmpty()) {
                    configurationSection.set("blocks-cut-amounts", questProgress.blocksCut);
                }
                if (!questProgress.itemsCrafted.isEmpty()) {
                    configurationSection.set("item-craft-amounts", questProgress.itemsCrafted);
                }
                if (!questProgress.itemsSmelted.isEmpty()) {
                    configurationSection.set("item-smelt-amounts", questProgress.itemsSmelted);
                }
                if (!questProgress.itemsEnchanted.isEmpty()) {
                    configurationSection.set("item-enchant-amounts", questProgress.itemsEnchanted);
                }
                if (!questProgress.itemsBrewed.isEmpty()) {
                    configurationSection.set("item-brew-amounts", questProgress.itemsBrewed);
                }
                if (!questProgress.itemsConsumed.isEmpty()) {
                    configurationSection.set("item-consume-amounts", questProgress.itemsConsumed);
                }
                if (!questProgress.itemsDelivered.isEmpty()) {
                    configurationSection.set("item-delivery-amounts", questProgress.itemsDelivered);
                }
                if (!questProgress.npcsInteracted.isEmpty()) {
                    configurationSection.set("has-talked-to", questProgress.npcsInteracted);
                }
                if (!questProgress.npcsNumKilled.isEmpty()) {
                    configurationSection.set("npc-killed-amounts", questProgress.npcsNumKilled);
                }
                if (!questProgress.mobNumKilled.isEmpty()) {
                    configurationSection.set("mobs-killed-amounts", questProgress.mobNumKilled);
                }
                if (!questProgress.mobsTamed.isEmpty()) {
                    configurationSection.set("mob-tame-amounts", questProgress.mobsTamed);
                }
                if ((stage = this.getCurrentStage(quest)) != null) {
                    if (stage.getFishToCatch() != null) {
                        configurationSection.set("fish-caught", (Object)questProgress.getFishCaught());
                    }
                    if (stage.getCowsToMilk() != null) {
                        configurationSection.set("cows-milked", (Object)questProgress.getCowsMilked());
                    }
                    if (stage.getPlayersToKill() != null) {
                        configurationSection.set("players-killed", (Object)questProgress.getPlayersKilled());
                    }
                }
                if (!questProgress.sheepSheared.isEmpty()) {
                    configurationSection.set("sheep-sheared", questProgress.sheepSheared);
                }
                if (!questProgress.locationsReached.isEmpty()) {
                    configurationSection.set("has-reached-location", questProgress.locationsReached);
                }
                if (!questProgress.passwordsSaid.isEmpty()) {
                    configurationSection.set("passwords-said", questProgress.passwordsSaid);
                }
                if (!questProgress.customObjectiveCounts.isEmpty()) {
                    configurationSection.set("custom-objective-counts", questProgress.customObjectiveCounts);
                }
                if (questProgress.getDelayTimeLeft() <= 0L) continue;
                configurationSection.set("stage-delay", (Object)questProgress.getDelayTimeLeft());
            }
        }
        data.set("currentQuests", currentQuestIds);
        data.set("currentStages", currentQuestStages);
        data.set("quest-points", (Object)this.questPoints);
        if (!this.completedQuests.isEmpty()) {
            questIds = new LinkedList<String>();
            for (Quest quest : this.completedQuests) {
                questIds.add(quest.getId());
            }
            data.set("completed-Quests", questIds);
        }
        if (!this.completedTimes.isEmpty()) {
            questIds = new LinkedList();
            LinkedList<Long> questTimes = new LinkedList<Long>();
            for (Map.Entry<Quest, Long> entry : this.completedTimes.entrySet()) {
                questIds.add(entry.getKey().getId());
                questTimes.add(entry.getValue());
            }
            data.set("completedRedoableQuests", questIds);
            data.set("completedQuestTimes", questTimes);
        }
        if (!this.amountsCompleted.isEmpty()) {
            questIds = new LinkedList();
            LinkedList<Integer> questAmounts = new LinkedList<Integer>();
            for (Map.Entry<Quest, Number> entry : this.amountsCompleted.entrySet()) {
                questIds.add(entry.getKey().getId());
                questAmounts.add((Integer)entry.getValue());
            }
            data.set("amountsCompletedQuests", questIds);
            data.set("amountsCompleted", questAmounts);
        }
        if ((representedPlayer = this.getPlayer()) == null) {
            representedPlayer = this.getOfflinePlayer();
        }
        data.set("lastKnownName", (Object)representedPlayer.getName());
        return data;
    }

    @Deprecated
    public boolean loadData() {
        return this.plugin.getStorage().loadQuester(this.id) != null;
    }

    @Override
    public boolean hasData() {
        return this.plugin.getStorage().loadQuester(this.id) != null;
    }

    @Override
    public boolean hasBaseData() {
        return !this.currentQuests.isEmpty() || !this.questProgress.isEmpty() || !this.completedQuests.isEmpty();
    }

    @Override
    public void startStageTimer(Quest quest) {
        if (this.getQuestProgressOrDefault(quest).getDelayTimeLeft() > -1L) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new BukkitStageTimer(this.plugin, this, quest), (long)((double)this.getQuestProgressOrDefault(quest).getDelayTimeLeft() * 0.02));
        } else {
            Player p;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new BukkitStageTimer(this.plugin, this, quest), (long)((double)this.getCurrentStage(quest).getDelay() * 0.02));
            if (this.getCurrentStage(quest).getDelayMessage() != null && (p = this.plugin.getServer().getPlayer(this.id)) != null) {
                p.sendMessage(BukkitConfigUtil.parseStringWithPossibleLineBreaks(this.getCurrentStage(quest).getDelayMessage(), quest, p));
            }
        }
        this.getQuestProgressOrDefault(quest).setDelayStartTime(System.currentTimeMillis());
    }

    @Override
    public void stopStageTimer(Quest quest) {
        if (this.getQuestProgressOrDefault(quest).getDelayTimeLeft() > -1L) {
            this.getQuestProgressOrDefault(quest).setDelayTimeLeft(this.getQuestProgressOrDefault(quest).getDelayTimeLeft() - (System.currentTimeMillis() - this.getQuestProgressOrDefault(quest).getDelayStartTime()));
        } else {
            this.getQuestProgressOrDefault(quest).setDelayTimeLeft(this.getCurrentStage(quest).getDelay() - (System.currentTimeMillis() - this.getQuestProgressOrDefault(quest).getDelayStartTime()));
        }
    }

    @Override
    public long getStageTime(Quest quest) {
        if (this.getQuestProgressOrDefault(quest).getDelayTimeLeft() > -1L) {
            return this.getQuestProgressOrDefault(quest).getDelayTimeLeft() - (System.currentTimeMillis() - this.getQuestProgressOrDefault(quest).getDelayStartTime());
        }
        return this.getCurrentStage(quest).getDelay() - (System.currentTimeMillis() - this.getQuestProgressOrDefault(quest).getDelayStartTime());
    }

    @Override
    public void checkQuest(Quest quest) {
        if (quest != null) {
            boolean exists = false;
            for (Quest q : this.plugin.getLoadedQuests()) {
                if (!q.getId().equalsIgnoreCase(quest.getId())) continue;
                Stage stage = this.getCurrentStage(quest);
                if (stage != null) {
                    quest.updateCompass(this, stage);
                }
                exists = true;
                break;
            }
            if (!exists) {
                this.sendMessage(ChatColor.RED + BukkitLang.get("questNotExist").replace("<quest>", quest.getName()));
            }
        }
    }

    @Override
    public void showGUIDisplay(UUID npc, LinkedList<Quest> quests) {
        if (npc == null || quests == null) {
            return;
        }
        String name = this.plugin.getDependencies().getNpcName(npc);
        LinkedList<BukkitQuest> qs = new LinkedList<BukkitQuest>();
        for (Quest q : quests) {
            qs.add((BukkitQuest)q);
        }
        BukkitQuesterPreOpenGUIEvent preEvent = new BukkitQuesterPreOpenGUIEvent(this, npc, qs);
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        Player player = this.getPlayer();
        Inventory inv = this.plugin.getServer().createInventory((InventoryHolder)player, (quests.size() / 9 + 1) * 9, BukkitLang.get(player, "quests") + " | " + name);
        int i = 0;
        for (Quest quest : quests) {
            BukkitQuest bukkitQuest = (BukkitQuest)quest;
            if (bukkitQuest.getGUIDisplay() == null) continue;
            if (i > 53) break;
            inv.setItem(i, bukkitQuest.prepareDisplay(this));
            ++i;
        }
        player.openInventory(inv);
    }

    @Override
    public void hardQuit(Quest quest) {
        try {
            if (this.compassTargetQuestId != null && this.compassTargetQuestId.equals(quest.getId())) {
                this.compassTargetQuestId = null;
            }
            this.currentQuests.remove(quest);
            this.questProgress.remove(quest);
            if (!this.timers.isEmpty()) {
                for (Map.Entry<Integer, Quest> entry : this.timers.entrySet()) {
                    if (!entry.getValue().getName().equals(quest.getName())) continue;
                    this.plugin.getServer().getScheduler().cancelTask(entry.getKey().intValue());
                    this.timers.remove(entry.getKey());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void hardRemove(Quest quest) {
        try {
            this.completedQuests.remove(quest);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void hardClear() {
        try {
            this.currentQuests.clear();
            this.questProgress.clear();
            this.amountsCompleted.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void hardStagePut(Quest key, Integer val) {
        try {
            this.currentQuests.put(key, val);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void hardDataPut(Quest key, QuestProgress val) {
        try {
            this.questProgress.put(key, (BukkitQuestProgress)val);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean canUseCompass() {
        if (this.getPlayer() != null && !this.getPlayer().hasPermission("worldedit.navigation.jumpto")) {
            return this.getPlayer().hasPermission("quests.compass");
        }
        return false;
    }

    @Override
    public void resetCompass() {
        this.compassTargetQuestId = null;
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.canUseCompass()) {
            return;
        }
        Location defaultLocation = player.getBedSpawnLocation();
        if (defaultLocation == null) {
            defaultLocation = player.getWorld().getSpawnLocation();
        }
        player.setCompassTarget(defaultLocation);
    }

    @Override
    public void findCompassTarget() {
        if (this.getPlayer() == null || !this.getPlayer().hasPermission("quests.compass")) {
            return;
        }
        for (Quest quest : this.currentQuests.keySet()) {
            Stage stage = this.getCurrentStage(quest);
            if (stage == null) continue;
            if (stage.hasLocatableObjective()) {
                quest.updateCompass(this, stage);
                break;
            }
            this.resetCompass();
            this.setCompassTarget(quest);
            break;
        }
    }

    @Override
    public void findNextCompassTarget(boolean notify) {
        if (this.getPlayer() == null || !this.getPlayer().hasPermission("quests.compass")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            LinkedList list = this.currentQuests.keySet().stream().sorted(Comparator.comparing(Quest::getName)).map(Quest::getId).collect(Collectors.toCollection(LinkedList::new));
            int index = 0;
            if (this.compassTargetQuestId != null) {
                if (!list.contains(this.compassTargetQuestId) && notify) {
                    return;
                }
                index = list.indexOf(this.compassTargetQuestId) + 1;
                if (index >= list.size()) {
                    index = 0;
                }
            }
            if (!list.isEmpty()) {
                Quest quest = this.plugin.getQuestById((String)list.get(index));
                this.compassTargetQuestId = quest.getId();
                Stage stage = this.getCurrentStage(quest);
                if (stage != null) {
                    if (stage.hasLocatableObjective()) {
                        quest.updateCompass(this, stage);
                        if (notify) {
                            this.sendMessage(ChatColor.YELLOW + BukkitLang.get(this.getPlayer(), "compassSet").replace("<quest>", quest.getName()));
                        }
                    } else {
                        this.resetCompass();
                        this.setCompassTarget(quest);
                        if (notify) {
                            this.sendMessage(ChatColor.RED + BukkitLang.get(this.getPlayer(), "compassNone").replace("<quest>", quest.getName()));
                        }
                    }
                }
            } else {
                this.sendMessage(ChatColor.RED + BukkitLang.get(this.getPlayer(), "journalNoQuests").replace("<journal>", BukkitLang.get(this.getPlayer(), "journalTitle")));
            }
        });
    }

    @Override
    public boolean hasItem(ItemStack is) {
        PlayerInventory inv = this.getPlayer().getInventory();
        int playerAmount = 0;
        for (ItemStack stack : inv.getContents()) {
            if (stack == null || BukkitItemUtil.compareItems(is, stack, false) != 0) continue;
            playerAmount += stack.getAmount();
        }
        return playerAmount >= is.getAmount();
    }

    @Override
    public Set<String> dispatchMultiplayerEverything(Quest quest, ObjectiveType type, BiFunction<Quester, Quest, Void> fun) {
        HashSet<String> appliedQuestIDs = new HashSet<String>();
        if (quest != null) {
            try {
                if (quest.getOptions().canGiveGloballyAtLogin()) {
                    List<Quester> mq = this.getGlobalQuesters(quest);
                    if (mq == null) {
                        return appliedQuestIDs;
                    }
                    for (Quester q : mq) {
                        if (q == null) continue;
                        q.getCurrentQuests().forEach((otherQuest, i) -> {
                            if (otherQuest.getStage((int)i).containsObjective(type)) {
                                fun.apply(q, (Quest)otherQuest);
                                appliedQuestIDs.add(otherQuest.getId());
                            }
                        });
                    }
                } else if (quest.getOptions().getShareProgressLevel() == 1) {
                    List<Quester> mq = this.getMultiplayerQuesters(quest);
                    if (mq == null) {
                        return appliedQuestIDs;
                    }
                    for (Quester q : mq) {
                        if (q == null) continue;
                        if (quest.getOptions().canShareSameQuestOnly() && q.getCurrentStage(quest) != null) {
                            fun.apply(q, quest);
                            appliedQuestIDs.add(quest.getId());
                        }
                        q.getCurrentQuests().forEach((otherQuest, i) -> {
                            if (otherQuest.getStage((int)i).containsObjective(type) && !otherQuest.getOptions().canShareSameQuestOnly()) {
                                fun.apply(q, (Quest)otherQuest);
                                appliedQuestIDs.add(otherQuest.getId());
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error occurred while dispatching " + type.name() + " for quest ID " + quest.getId());
                e.printStackTrace();
            }
        }
        return appliedQuestIDs;
    }

    @Override
    public Set<String> dispatchMultiplayerObjectives(Quest quest, Stage currentStage, Function<Quester, Void> fun) {
        HashSet<String> appliedQuestIDs = new HashSet<String>();
        if (quest.getOptions().getShareProgressLevel() == 2) {
            List<Quester> mq = this.getMultiplayerQuesters(quest);
            if (mq == null) {
                return appliedQuestIDs;
            }
            for (Quester q : mq) {
                if (q == null || !q.getCurrentQuests().containsKey(quest) || !currentStage.equals(q.getCurrentStage(quest))) continue;
                fun.apply(q);
            }
        }
        return appliedQuestIDs;
    }

    @Override
    public List<Quester> getMultiplayerQuesters(Quest quest) {
        Party party;
        PartyPlayer partyPlayer;
        if (quest == null) {
            return null;
        }
        LinkedList<Quester> mq = new LinkedList<Quester>();
        if (this.plugin.getDependencies().getPartyProvider() != null) {
            PartyProvider partyProvider = this.plugin.getDependencies().getPartyProvider();
            if (partyProvider != null && (quest.getOptions().canUsePartiesPlugin() || quest.getOptions().getExternalPartyPlugin() != null) && this.getUUID() != null && partyProvider.getPartyId(this.getUUID()) != null) {
                String partyId = partyProvider.getPartyId(this.getUUID());
                double distanceSquared = quest.getOptions().getShareDistance() * quest.getOptions().getShareDistance();
                boolean offlinePlayers = quest.getOptions().canHandleOfflinePlayers();
                if (offlinePlayers) {
                    for (UUID id : partyProvider.getMembers(partyId)) {
                        if (id.equals(this.getUUID())) continue;
                        mq.add(this.plugin.getQuester(id));
                    }
                } else {
                    for (UUID id : partyProvider.getOnlineMembers(partyId)) {
                        if (id.equals(this.getUUID())) continue;
                        if (distanceSquared > 0.0) {
                            Player player = Bukkit.getPlayer((UUID)id);
                            if (player == null) continue;
                            Location locationOne = this.getPlayer().getLocation();
                            Location locationTwo = player.getLocation();
                            if (locationOne.getWorld() == null || locationTwo.getWorld() == null || !locationOne.getWorld().getName().equals(locationTwo.getWorld().getName()) || !(distanceSquared >= this.getPlayer().getLocation().distanceSquared(player.getLocation()))) continue;
                            mq.add(this.plugin.getQuester(id));
                            continue;
                        }
                        mq.add(this.plugin.getQuester(id));
                    }
                }
                if (this.plugin.getConfigSettings().getConsoleLogging() > 3) {
                    this.plugin.getLogger().info("Found " + mq.size() + " party members for quest ID " + quest.getId() + " via Unite plugin");
                }
                return mq;
            }
        } else if (this.plugin.getDependencies().getPartiesApi() != null && quest.getOptions().canUsePartiesPlugin() && (partyPlayer = this.plugin.getDependencies().getPartiesApi().getPartyPlayer(this.getUUID())) != null && partyPlayer.getPartyId() != null && (party = this.plugin.getDependencies().getPartiesApi().getParty(partyPlayer.getPartyId())) != null) {
            double distanceSquared = quest.getOptions().getShareDistance() * quest.getOptions().getShareDistance();
            boolean offlinePlayers = quest.getOptions().canHandleOfflinePlayers();
            if (offlinePlayers) {
                for (UUID id : party.getMembers()) {
                    if (id.equals(this.getUUID())) continue;
                    mq.add(this.plugin.getQuester(id));
                }
            } else {
                for (PartyPlayer pp : party.getOnlineMembers(true)) {
                    if (pp.getPlayerUUID().equals(this.getUUID())) continue;
                    if (distanceSquared > 0.0) {
                        Player player = Bukkit.getPlayer((UUID)pp.getPlayerUUID());
                        if (player == null) continue;
                        Location locationOne = this.getPlayer().getLocation();
                        Location locationTwo = player.getLocation();
                        if (locationOne.getWorld() == null || locationTwo.getWorld() == null || !locationOne.getWorld().getName().equals(locationTwo.getWorld().getName()) || !(distanceSquared >= this.getPlayer().getLocation().distanceSquared(player.getLocation()))) continue;
                        mq.add(this.plugin.getQuester(pp.getPlayerUUID()));
                        continue;
                    }
                    mq.add(this.plugin.getQuester(pp.getPlayerUUID()));
                }
            }
            if (this.plugin.getConfigSettings().getConsoleLogging() > 3) {
                this.plugin.getLogger().info("Found " + mq.size() + " party members for quest ID " + quest.getId() + " via Parties plugin");
            }
            return mq;
        }
        return mq;
    }

    public List<Quester> getGlobalQuesters(Quest quest) {
        if (quest == null) {
            return null;
        }
        LinkedList<Quester> mq = new LinkedList<Quester>();
        if (quest.getOptions().canGiveGloballyAtLogin()) {
            for (Quester oq : this.plugin.getOnlineQuesters()) {
                if (oq.getUUID().equals(this.getUUID()) || !oq.getCurrentQuests().containsKey(quest)) continue;
                mq.add(oq);
            }
            if (!mq.isEmpty() && this.plugin.getConfigSettings().getConsoleLogging() > 3) {
                this.plugin.getLogger().info("Found " + mq.size() + " global members for quest ID " + quest.getId());
            }
        }
        return mq;
    }

    @Override
    public boolean meetsCondition(Quest quest, boolean giveReason) {
        Stage stage = this.getCurrentStage(quest);
        if (stage != null && stage.getCondition() != null && !stage.getCondition().check(this, quest)) {
            if (stage.getCondition().isFailQuest()) {
                if (giveReason) {
                    this.getPlayer().sendMessage(ChatColor.RED + BukkitLang.get(this.getPlayer(), "conditionFailQuit").replace("<quest>", quest.getName()));
                }
                if (stage.getFailAction() != null) {
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> stage.getFailAction().fire(this, quest));
                }
                this.hardQuit(quest);
            } else if (giveReason && System.currentTimeMillis() - this.lastNotifiedCondition > (long)this.plugin.getConfigSettings().getConditionInterval() * 1000L) {
                BukkitActionBarProvider.sendActionBar(this.getPlayer(), ChatColor.YELLOW + BukkitLang.get(this.getPlayer(), "conditionFailRetry").replace("<quest>", quest.getName()));
                this.lastNotifiedCondition = System.currentTimeMillis();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectingBlock() {
        UUID uuid = this.getPlayer().getUniqueId();
        return this.plugin.getQuestFactory().getSelectedBlockStarts().containsKey(uuid) || this.plugin.getQuestFactory().getSelectedKillLocations().containsKey(uuid) || this.plugin.getQuestFactory().getSelectedReachLocations().containsKey(uuid) || this.plugin.getActionFactory().getSelectedExplosionLocations().containsKey(uuid) || this.plugin.getActionFactory().getSelectedEffectLocations().containsKey(uuid) || this.plugin.getActionFactory().getSelectedMobLocations().containsKey(uuid) || this.plugin.getActionFactory().getSelectedLightningLocations().containsKey(uuid) || this.plugin.getActionFactory().getSelectedTeleportLocations().containsKey(uuid);
    }

    @Override
    public boolean isInRegion(String regionID) {
        if (this.getPlayer() == null) {
            return false;
        }
        return this.plugin.getDependencies().getWorldGuardApi().getApplicableRegionsIDs(this.getPlayer().getWorld(), this.getPlayer().getLocation()).contains(regionID);
    }

    @Override
    public boolean canAcceptQuest(UUID npc) {
        for (Quest q : this.plugin.getLoadedQuests()) {
            boolean ignoreLockedQuests;
            if (q.getNpcStart() == null || this.getCompletedQuests().contains(q) || !q.getNpcStart().equals(npc) || (ignoreLockedQuests = this.plugin.getConfigSettings().canIgnoreLockedQuests()) && !q.testRequirements(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAcceptCompletedQuest(UUID npc) {
        for (Quest q : this.plugin.getLoadedQuests()) {
            boolean ignoreLockedQuests;
            if (q.getNpcStart() == null || !this.getCompletedQuests().contains(q) || !q.getNpcStart().equals(npc) || (ignoreLockedQuests = this.plugin.getConfigSettings().canIgnoreLockedQuests()) && !q.testRequirements(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAcceptCompletedRedoableQuest(UUID npc) {
        for (Quest q : this.plugin.getLoadedQuests()) {
            boolean ignoreLockedQuests;
            if (q.getNpcStart() == null || !this.getCompletedQuests().contains(q) || q.getPlanner().getCooldown() <= -1L || !q.getNpcStart().equals(npc) || (ignoreLockedQuests = this.plugin.getConfigSettings().canIgnoreLockedQuests()) && !q.testRequirements(this)) continue;
            return true;
        }
        return false;
    }
}

