/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.player;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.pikamug.quests.enums.ObjectiveType;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.player.QuestProgress;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.Objective;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.stack.BlockItemStack;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

public interface Quester
extends Comparable<Quester> {
    public UUID getUUID();

    public void setUUID(UUID var1);

    public String getQuestIdToTake();

    public void setQuestIdToTake(String var1);

    public String getQuestIdToQuit();

    public void setQuestIdToQuit(String var1);

    public String getLastKnownName();

    public void setLastKnownName(String var1);

    public int getQuestPoints();

    public void setQuestPoints(int var1);

    public Quest getCompassTarget();

    public void setCompassTarget(Quest var1);

    public ConcurrentHashMap<Integer, Quest> getTimers();

    public void setTimers(ConcurrentHashMap<Integer, Quest> var1);

    public void removeTimer(Integer var1);

    public ConcurrentHashMap<Quest, Integer> getCurrentQuests();

    public void setCurrentQuests(ConcurrentHashMap<Quest, Integer> var1);

    public ConcurrentSkipListSet<Quest> getCompletedQuests();

    public void setCompletedQuests(ConcurrentSkipListSet<Quest> var1);

    public ConcurrentHashMap<Quest, Long> getCompletedTimes();

    public void setCompletedTimes(ConcurrentHashMap<Quest, Long> var1);

    public ConcurrentHashMap<Quest, Integer> getAmountsCompleted();

    public void setAmountsCompleted(ConcurrentHashMap<Quest, Integer> var1);

    public Player getPlayer();

    public OfflinePlayer getOfflinePlayer();

    public void sendMessage(String var1);

    public Stage getCurrentStage(Quest var1);

    public QuestProgress getQuestDataOrDefault(Quest var1);

    public QuestProgress getQuestProgressOrDefault(Quest var1);

    public boolean hasJournal();

    public ItemStack getJournal();

    public int getJournalIndex();

    public void updateJournal();

    public boolean offerQuest(Quest var1, boolean var2);

    public boolean canAcceptOffer(Quest var1, boolean var2);

    public boolean isOnTime(Quest var1, boolean var2);

    public void takeQuest(Quest var1, boolean var2);

    public boolean abandonQuest(Quest var1, String var2);

    public boolean abandonQuest(Quest var1, String[] var2);

    public void quitQuest(Quest var1, String var2);

    public void quitQuest(Quest var1, String[] var2);

    public void listQuests(Quester var1, int var2);

    public LinkedList<String> getCurrentRequirements(Quest var1, boolean var2);

    public LinkedList<Objective> getCurrentObjectives(Quest var1, boolean var2, boolean var3);

    public void showCurrentObjectives(Quest var1, Quester var2, boolean var3);

    public boolean hasObjective(Quest var1, ObjectiveType var2);

    public boolean hasCustomObjective(Quest var1, String var2);

    public void showCurrentConditions(Quest var1, Quester var2);

    @Deprecated
    public void breakBlock(Quest var1, ItemStack var2);

    public void breakBlock(Quest var1, BlockItemStack var2);

    @Deprecated
    public void damageBlock(Quest var1, ItemStack var2);

    public void damageBlock(Quest var1, BlockItemStack var2);

    @Deprecated
    public void placeBlock(Quest var1, ItemStack var2);

    public void placeBlock(Quest var1, BlockItemStack var2);

    @Deprecated
    public void useBlock(Quest var1, ItemStack var2);

    public void useBlock(Quest var1, BlockItemStack var2);

    @Deprecated
    public void cutBlock(Quest var1, ItemStack var2);

    public void cutBlock(Quest var1, BlockItemStack var2);

    public void craftItem(Quest var1, ItemStack var2);

    public void smeltItem(Quest var1, ItemStack var2);

    public void enchantBook(Quest var1, ItemStack var2, Map<Enchantment, Integer> var3);

    public void enchantItem(Quest var1, ItemStack var2);

    public void brewItem(Quest var1, ItemStack var2);

    public void consumeItem(Quest var1, ItemStack var2);

    public void deliverToNPC(Quest var1, UUID var2, ItemStack var3);

    public void interactWithNPC(Quest var1, UUID var2);

    public void killNPC(Quest var1, UUID var2);

    public void milkCow(Quest var1);

    public void catchFish(Quest var1);

    public void killMob(Quest var1, Location var2, EntityType var3);

    public void killPlayer(Quest var1, Player var2);

    public void reachLocation(Quest var1, Location var2);

    public void tameMob(Quest var1, EntityType var2);

    public void shearSheep(Quest var1, DyeColor var2);

    public void sayPassword(Quest var1, AsyncPlayerChatEvent var2);

    public void finishObjective(Quest var1, Objective var2, EntityType var3, String var4, UUID var5, Location var6, DyeColor var7, String var8, CustomObjective var9);

    public boolean testComplete(Quest var1);

    public void addEmptiesFor(Quest var1, int var2);

    public boolean saveData();

    public long getCompletionDifference(Quest var1);

    public long getRemainingCooldown(Quest var1);

    public FileConfiguration getBaseData();

    public boolean hasData();

    public boolean hasBaseData();

    public void startStageTimer(Quest var1);

    public void stopStageTimer(Quest var1);

    public long getStageTime(Quest var1);

    public void checkQuest(Quest var1);

    public void showGUIDisplay(UUID var1, LinkedList<Quest> var2);

    public void hardQuit(Quest var1);

    public void hardRemove(Quest var1);

    public void hardClear();

    public void hardStagePut(Quest var1, Integer var2);

    public void hardDataPut(Quest var1, QuestProgress var2);

    public boolean canUseCompass();

    public void resetCompass();

    public void findCompassTarget();

    public void findNextCompassTarget(boolean var1);

    public boolean hasItem(ItemStack var1);

    public Set<String> dispatchMultiplayerEverything(Quest var1, ObjectiveType var2, BiFunction<Quester, Quest, Void> var3);

    public Set<String> dispatchMultiplayerObjectives(Quest var1, Stage var2, Function<Quester, Void> var3);

    public List<Quester> getMultiplayerQuesters(Quest var1);

    public boolean meetsCondition(Quest var1, boolean var2);

    public boolean isSelectingBlock();

    public boolean isInRegion(String var1);

    public boolean canAcceptQuest(UUID var1);

    public boolean canAcceptCompletedQuest(UUID var1);

    public boolean canAcceptCompletedRedoableQuest(UUID var1);
}

