/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.quests;

import com.alessiodp.parties.api.interfaces.Party;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.util.player.UserManager;
import com.herocraftonline.heroes.characters.Hero;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.actions.BukkitAction;
import me.pikamug.quests.dependencies.BukkitDependencies;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.events.quest.QuestUpdateCompassEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPostChangeStageEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPostCompleteQuestEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPostFailQuestEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreChangeStageEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreCompleteQuestEvent;
import me.pikamug.quests.events.quester.BukkitQuesterPreFailQuestEvent;
import me.pikamug.quests.module.CustomRequirement;
import me.pikamug.quests.module.CustomReward;
import me.pikamug.quests.nms.BukkitTitleProvider;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitOptions;
import me.pikamug.quests.quests.components.BukkitPlanner;
import me.pikamug.quests.quests.components.BukkitRequirements;
import me.pikamug.quests.quests.components.BukkitRewards;
import me.pikamug.quests.quests.components.Options;
import me.pikamug.quests.quests.components.Planner;
import me.pikamug.quests.quests.components.Requirements;
import me.pikamug.quests.quests.components.Rewards;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitInventoryUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.RomanNumeral;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BukkitQuest
implements Quest {
    protected BukkitQuestsPlugin plugin;
    protected String id;
    private String name;
    protected String description;
    protected String finished;
    protected ItemStack guiDisplay = null;
    private final LinkedList<Stage> orderedStages = new LinkedList();
    protected UUID npcStart;
    protected Location blockStart;
    protected String regionStart = null;
    protected BukkitAction initialAction;
    private BukkitRequirements requirements = new BukkitRequirements();
    private BukkitPlanner planner = new BukkitPlanner();
    private BukkitRewards rewards = new BukkitRewards();
    private BukkitOptions options = new BukkitOptions();

    public BukkitQuest(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public int compareTo(Quest quest) {
        return this.id.compareTo(quest.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.plugin != null) {
            this.id = id;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFinished() {
        return this.finished;
    }

    @Override
    public void setFinished(String finished) {
        this.finished = finished;
    }

    @Override
    public String getRegionStart() {
        return this.regionStart;
    }

    @Override
    public void setRegionStart(String regionStart) {
        this.regionStart = regionStart;
    }

    public ItemStack getGUIDisplay() {
        return this.guiDisplay;
    }

    public void setGUIDisplay(ItemStack guiDisplay) {
        this.guiDisplay = guiDisplay;
    }

    @Override
    public Stage getStage(int index) {
        try {
            return this.orderedStages.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public LinkedList<Stage> getStages() {
        return this.orderedStages;
    }

    @Override
    public UUID getNpcStart() {
        return this.npcStart;
    }

    @Override
    public void setNpcStart(UUID npcStart) {
        this.npcStart = npcStart;
    }

    @Override
    public String getNpcStartName() {
        return this.plugin.getDependencies().getNpcName(this.getNpcStart());
    }

    public Location getBlockStart() {
        return this.blockStart;
    }

    public void setBlockStart(Location blockStart) {
        this.blockStart = blockStart;
    }

    @Override
    public Action getInitialAction() {
        return this.initialAction;
    }

    @Override
    public void setInitialAction(Action initialAction) {
        this.initialAction = (BukkitAction)initialAction;
    }

    @Override
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Override
    public void setRequirements(Requirements requirements) {
        this.requirements = (BukkitRequirements)requirements;
    }

    @Override
    public Planner getPlanner() {
        return this.planner;
    }

    @Override
    public void setPlanner(Planner planner) {
        this.planner = (BukkitPlanner)planner;
    }

    @Override
    public Rewards getRewards() {
        return this.rewards;
    }

    @Override
    public void setRewards(Rewards rewards) {
        this.rewards = (BukkitRewards)rewards;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        this.options = (BukkitOptions)options;
    }

    @Override
    public void nextStage(Quester quester, boolean allowSharedProgress) {
        Stage currentStage = quester.getCurrentStage(this);
        if (currentStage == null) {
            this.plugin.getLogger().severe("Current stage was null for quester " + quester.getPlayer().getUniqueId());
            return;
        }
        String stageCompleteMessage = currentStage.getCompleteMessage();
        if (stageCompleteMessage != null && quester.getOfflinePlayer().isOnline()) {
            quester.getPlayer().sendMessage(BukkitConfigUtil.parseStringWithPossibleLineBreaks(stageCompleteMessage, this, quester.getPlayer()));
        }
        if (currentStage.getDelay() < 0L) {
            this.doNextStage(quester, allowSharedProgress);
        } else {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.doNextStage(quester, allowSharedProgress), (long)((double)currentStage.getDelay() * 0.02));
        }
        quester.updateJournal();
    }

    private void doNextStage(Quester quester, boolean allowSharedProgress) {
        Stage currentStage = quester.getCurrentStage(this);
        if (currentStage == null) {
            return;
        }
        if (currentStage.getFinishAction() != null) {
            currentStage.getFinishAction().fire(quester, this);
        }
        if (quester.getCurrentQuests().get(this) == this.orderedStages.size() - 1) {
            if (currentStage.getScript() != null) {
                this.plugin.getDenizenTrigger().runDenizenScript(currentStage.getScript(), quester, null);
            }
            this.completeQuest(quester);
        } else {
            this.setStage(quester, quester.getCurrentQuests().get(this) + 1);
        }
        if (quester.getQuestProgressOrDefault(this) != null) {
            quester.getQuestProgressOrDefault(this).setDelayStartTime(0L);
            quester.getQuestProgressOrDefault(this).setDelayTimeLeft(-1L);
        }
        if (allowSharedProgress && this.options.getShareProgressLevel() == 3) {
            List<Quester> mq = quester.getMultiplayerQuesters(this);
            for (Quester qq : mq) {
                if (!currentStage.equals(qq.getCurrentStage(this))) continue;
                this.nextStage(qq, true);
            }
        }
    }

    @Override
    public void setStage(Quester quester, int stage) throws IndexOutOfBoundsException {
        OfflinePlayer player = quester.getOfflinePlayer();
        if (this.orderedStages.size() - 1 < stage) {
            String msg = "Tried to set invalid stage number of " + stage + " for quest " + this.getName() + " on " + player.getName();
            throw new IndexOutOfBoundsException(msg);
        }
        Stage currentStage = quester.getCurrentStage(this);
        Stage nextStage = this.getStage(stage);
        if (currentStage == null || nextStage == null) {
            return;
        }
        if (player.isOnline()) {
            BukkitQuesterPreChangeStageEvent preEvent = new BukkitQuesterPreChangeStageEvent((BukkitQuester)quester, this, currentStage, nextStage);
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                return;
            }
        }
        quester.hardQuit(this);
        quester.hardStagePut(this, stage);
        quester.addEmptiesFor(this, stage);
        if (currentStage.getScript() != null) {
            this.plugin.getDenizenTrigger().runDenizenScript(currentStage.getScript(), quester, null);
        }
        if (nextStage.getStartAction() != null) {
            nextStage.getStartAction().fire(quester, this);
        }
        this.updateCompass(quester, nextStage);
        if (player.isOnline()) {
            Player p = quester.getPlayer();
            String title = BukkitLang.get(p, "objectives").replace("<quest>", this.name);
            BukkitLang.send(p, ChatColor.GOLD + title);
            quester.showCurrentObjectives(this, quester, false);
            if (quester.getCurrentStage(this) == null) {
                quester.sendMessage(ChatColor.RED + "itemCreateCriticalError");
                this.plugin.getLogger().severe("Could not set stage for quest ID " + this.getId() + " because the current stage for player " + quester.getLastKnownName() + " was null");
                return;
            }
            String stageStartMessage = quester.getCurrentStage(this).getStartMessage();
            if (stageStartMessage != null) {
                p.sendMessage(BukkitConfigUtil.parseStringWithPossibleLineBreaks(stageStartMessage, this, p));
            }
            quester.showCurrentConditions(this, quester);
        }
        quester.updateJournal();
        quester.saveData();
        if (player.isOnline()) {
            BukkitQuesterPostChangeStageEvent postEvent = new BukkitQuesterPostChangeStageEvent((BukkitQuester)quester, this, currentStage, nextStage);
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
    }

    @Override
    public boolean updateCompass(Quester quester, Stage stage) {
        if (quester == null) {
            return false;
        }
        if (stage == null) {
            return false;
        }
        if (!quester.getOfflinePlayer().isOnline()) {
            return false;
        }
        if (!quester.getPlayer().hasPermission("quests.compass")) {
            return false;
        }
        BukkitQuest quest = this;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Location nearest;
            Location source;
            Location targetLocation = null;
            if (stage.getNpcsToInteract() != null && stage.getNpcsToInteract().size() > 0) {
                targetLocation = this.plugin.getDependencies().getNpcLocation(stage.getNpcsToInteract().getFirst());
            } else if (stage.getNpcsToKill() != null && stage.getNpcsToKill().size() > 0) {
                targetLocation = this.plugin.getDependencies().getNpcLocation(stage.getNpcsToKill().getFirst());
            } else if (stage.getLocationsToReach() != null && stage.getLocationsToReach().size() > 0) {
                targetLocation = (Location)stage.getLocationsToReach().getFirst();
            } else if (stage.getItemDeliveryTargets() != null && stage.getItemDeliveryTargets().size() > 0) {
                UUID uuid = stage.getItemDeliveryTargets().getFirst();
                for (BukkitNpcDependency npcDependency : this.plugin.getDependencies().getNpcDependencies()) {
                    Location npcLocation = npcDependency.getLocation(uuid);
                    if (npcLocation == null) continue;
                    targetLocation = npcLocation;
                    break;
                }
            } else if (stage.getPlayersToKill() != null && stage.getPlayersToKill() > 0) {
                if (quester.getPlayer() == null) {
                    return;
                }
                source = quester.getPlayer().getLocation();
                nearest = null;
                double old_distance = 3.0E7;
                if (source.getWorld() == null) {
                    return;
                }
                for (Player p : source.getWorld().getPlayers()) {
                    double new_distance;
                    if (p.getUniqueId().equals(quester.getUUID()) || !((new_distance = p.getLocation().distanceSquared(source)) < old_distance)) continue;
                    nearest = p.getLocation();
                    old_distance = new_distance;
                }
                if (nearest != null) {
                    targetLocation = nearest;
                }
            } else if (stage.getMobsToKill() != null && stage.getMobsToKill().size() > 0) {
                if (quester.getPlayer() == null) {
                    return;
                }
                source = quester.getPlayer().getLocation();
                nearest = null;
                double old_distance = 3.0E7;
                EntityType et = (EntityType)stage.getMobsToKill().getFirst();
                if (source.getWorld() == null) {
                    return;
                }
                for (Entity e : source.getWorld().getEntities()) {
                    double new_distance;
                    if (!e.getType().equals((Object)et) || !((new_distance = e.getLocation().distanceSquared(source)) < old_distance)) continue;
                    nearest = e.getLocation();
                    old_distance = new_distance;
                }
                if (nearest != null) {
                    targetLocation = nearest;
                }
            } else if (stage.getMobsToTame() != null && stage.getMobsToTame().size() > 0) {
                if (quester.getPlayer() == null) {
                    return;
                }
                source = quester.getPlayer().getLocation();
                nearest = null;
                double old_distance = 3.0E7;
                EntityType et = (EntityType)stage.getMobsToTame().getFirst();
                if (source.getWorld() == null) {
                    return;
                }
                for (Entity e : source.getWorld().getEntities()) {
                    double new_distance;
                    if (!e.getType().equals((Object)et) || !((new_distance = e.getLocation().distanceSquared(source)) < old_distance)) continue;
                    nearest = e.getLocation();
                    old_distance = new_distance;
                }
                if (nearest != null) {
                    targetLocation = nearest;
                }
            } else if (stage.getSheepToShear() != null && stage.getSheepToShear().size() > 0) {
                if (quester.getPlayer() == null) {
                    return;
                }
                source = quester.getPlayer().getLocation();
                nearest = null;
                double old_distance = 3.0E7;
                DyeColor dc = (DyeColor)stage.getSheepToShear().getFirst();
                if (source.getWorld() == null) {
                    return;
                }
                for (Entity e : source.getWorld().getEntities()) {
                    double new_distance;
                    Sheep s;
                    if (!e.getType().equals((Object)EntityType.SHEEP) || (s = (Sheep)e).getColor() != null && s.getColor().equals((Object)dc) || !((new_distance = e.getLocation().distanceSquared(source)) < old_distance)) continue;
                    nearest = e.getLocation();
                    old_distance = new_distance;
                }
                if (nearest != null) {
                    targetLocation = nearest;
                }
            }
            if (targetLocation != null && targetLocation.getWorld() != null) {
                if (quester.getPlayer() == null) {
                    return;
                }
                if (targetLocation.getWorld().getName().equals(quester.getPlayer().getWorld().getName())) {
                    Location lockedTarget = new Location(targetLocation.getWorld(), targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                    QuestUpdateCompassEvent event = new QuestUpdateCompassEvent(quest, quester, lockedTarget);
                    this.plugin.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    quester.setCompassTarget(this);
                    quester.getPlayer().setCompassTarget(lockedTarget);
                }
            }
        });
        return true;
    }

    public ItemStack prepareDisplay(BukkitQuester quester) {
        ItemStack display = this.getGUIDisplay().clone();
        ItemMeta meta = display.getItemMeta();
        if (meta != null) {
            Player player = quester.getPlayer();
            if (quester.getCompletedQuests().contains(this)) {
                meta.setDisplayName(ChatColor.DARK_PURPLE + BukkitConfigUtil.parseString(this.getName() + " " + ChatColor.GREEN + BukkitLang.get(player, "redoCompleted"), this.getNpcStart(), this.plugin));
            } else {
                meta.setDisplayName(ChatColor.DARK_PURPLE + BukkitConfigUtil.parseString(this.getName(), this.getNpcStart(), this.plugin));
            }
            if (!meta.hasLore()) {
                String desc = this.getDescription();
                if (this.plugin.getDependencies().getPlaceholderApi() != null) {
                    desc = PlaceholderAPI.setPlaceholders((Player)player, (String)desc);
                }
                LinkedList<String> lines = desc.equals(ChatColor.stripColor((String)desc)) ? BukkitMiscUtil.makeLines(desc, " ", 40, ChatColor.DARK_GREEN) : BukkitMiscUtil.makeLines(desc, " ", 40, null);
                meta.setLore(lines);
            }
            meta.addItemFlags(ItemFlag.values());
            display.setItemMeta(meta);
        }
        return display;
    }

    @Override
    public boolean testRequirements(Quester quester) {
        return this.testRequirements(quester.getOfflinePlayer());
    }

    public boolean testRequirements(OfflinePlayer player) {
        BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
        if (this.requirements.getMoney() != 0 && this.plugin.getDependencies().getVaultEconomy() != null && this.plugin.getDependencies().getVaultEconomy().getBalance(player) < (double)this.requirements.getMoney()) {
            return false;
        }
        if (quester.getQuestPoints() < this.requirements.getQuestPoints()) {
            return false;
        }
        Set completed = quester.getCompletedQuests().stream().map(Quest::getId).collect(Collectors.toSet());
        if (!this.requirements.getNeededQuestIds().isEmpty() && !completed.containsAll(this.requirements.getNeededQuestIds())) {
            return false;
        }
        if (!this.requirements.getBlockQuestIds().isEmpty()) {
            for (String questId : this.requirements.getBlockQuestIds()) {
                if (!completed.contains(questId)) continue;
                return false;
            }
            for (Quest q : quester.getCurrentQuests().keySet()) {
                if (this.requirements.getBlockQuestIds().contains(q.getId())) continue;
                return false;
            }
        }
        for (String s : this.requirements.getMcmmoSkills()) {
            SkillType st = this.plugin.getDependencies().getMcMMOSkill(s);
            int lvl = this.requirements.getMcmmoAmounts().get(this.requirements.getMcmmoSkills().indexOf(s));
            if (UserManager.getOfflinePlayer((OfflinePlayer)player).getProfile().getSkillLevel(st) >= lvl) continue;
            return false;
        }
        if (this.requirements.getHeroesPrimaryClass() != null && !this.plugin.getDependencies().testPrimaryHeroesClass(this.requirements.getHeroesPrimaryClass(), player.getUniqueId())) {
            return false;
        }
        if (this.requirements.getHeroesSecondaryClass() != null && !this.plugin.getDependencies().testSecondaryHeroesClass(this.requirements.getHeroesSecondaryClass(), player.getUniqueId())) {
            return false;
        }
        if (player.isOnline()) {
            Player p = (Player)player;
            if (p.getTotalExperience() < this.requirements.getExp()) {
                return false;
            }
            Inventory fakeInv = Bukkit.createInventory(null, (InventoryType)InventoryType.PLAYER);
            try {
                fakeInv.setContents((ItemStack[])p.getInventory().getContents().clone());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Most likely outdated server build, see SPIGOT-8070");
                p.sendMessage(ChatColor.RED + BukkitLang.get("unknownError"));
                return false;
            }
            for (ItemStack is : this.requirements.getItems()) {
                if (BukkitInventoryUtil.canRemoveItem(fakeInv, is)) {
                    BukkitInventoryUtil.removeItem(fakeInv, is);
                    continue;
                }
                return false;
            }
            for (String s : this.requirements.getPermissions()) {
                if (p.hasPermission(s)) continue;
                return false;
            }
            for (String s : this.requirements.getCustomRequirements().keySet()) {
                CustomRequirement found = null;
                for (CustomRequirement cr : this.plugin.getCustomRequirements()) {
                    if (!cr.getName().equalsIgnoreCase(s)) continue;
                    found = cr;
                    break;
                }
                if (found != null) {
                    if (found.testRequirement(p.getUniqueId(), this.requirements.getCustomRequirements().get(s))) continue;
                    return false;
                }
                this.plugin.getLogger().warning("Quester \"" + p.getName() + "\" attempted to take Quest \"" + this.name + "\", but the Custom Requirement \"" + s + "\" could not be found. Does it still exist?");
            }
        }
        return true;
    }

    @Override
    public void completeQuest(Quester quester) {
        this.completeQuest(quester, true);
    }

    @Override
    public void completeQuest(Quester quester, boolean allowMultiplayer) {
        Party party;
        Object partyPlayer;
        OfflinePlayer player = quester.getOfflinePlayer();
        boolean cancelled = false;
        if (player.isOnline()) {
            if (Bukkit.isPrimaryThread()) {
                BukkitQuesterPreCompleteQuestEvent preEvent = new BukkitQuesterPreCompleteQuestEvent((BukkitQuester)quester, this, false);
                this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    return;
                }
            } else {
                CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
                    BukkitQuesterPreCompleteQuestEvent preEvent = new BukkitQuesterPreCompleteQuestEvent((BukkitQuester)quester, this, true);
                    this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                    return preEvent.isCancelled();
                });
                try {
                    cancelled = future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (cancelled) {
            return;
        }
        quester.hardQuit(this);
        ConcurrentSkipListSet<Quest> completedQuests = quester.getCompletedQuests();
        completedQuests.add(this);
        quester.setCompletedQuests(completedQuests);
        for (Map.Entry<Integer, Quest> entry : quester.getTimers().entrySet()) {
            if (!entry.getValue().getName().equals(this.getName())) continue;
            this.plugin.getServer().getScheduler().cancelTask(entry.getKey().intValue());
            quester.getTimers().remove(entry.getKey());
        }
        if (player.isOnline()) {
            Player p = (Player)player;
            String[] ps = BukkitConfigUtil.parseStringWithPossibleLineBreaks(ChatColor.AQUA + this.finished, this, p);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> p.sendMessage(ps), 40L);
        }
        if (this.planner.getCooldown() > -1L) {
            quester.getCompletedTimes().put(this, System.currentTimeMillis());
            if (quester.getAmountsCompleted().containsKey(this)) {
                quester.getAmountsCompleted().put(this, quester.getAmountsCompleted().get(this) + 1);
            } else {
                quester.getAmountsCompleted().put(this, 1);
            }
        }
        BukkitDependencies depends = this.plugin.getDependencies();
        boolean issuedReward = false;
        if (this.rewards.getMoney() > 0 && depends.getVaultEconomy() != null) {
            depends.getVaultEconomy().depositPlayer(player, (double)this.rewards.getMoney());
            issuedReward = true;
            if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded " + depends.getVaultEconomy().format((double)this.rewards.getMoney()));
            }
        }
        if (player.isOnline()) {
            for (ItemStack i : this.rewards.getItems()) {
                try {
                    BukkitInventoryUtil.addItem(player.getPlayer(), i);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Unable to add null reward item to inventory of " + player.getName() + " upon completion of quest " + this.name);
                    quester.sendMessage(ChatColor.RED + "Quests encountered a problem with an item. Please contact an administrator.");
                }
                issuedReward = true;
                if (this.plugin.getConfigSettings().getConsoleLogging() <= 2) continue;
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded " + i.getType().name() + " x " + i.getAmount());
            }
        }
        for (String s : this.rewards.getCommands()) {
            if (player.getName() == null) continue;
            String temp = s.replace("<player>", player.getName());
            if (depends.getPlaceholderApi() != null && player.isOnline()) {
                temp = PlaceholderAPI.setPlaceholders((Player)((Player)player), (String)temp);
            }
            String command = temp;
            if (Bukkit.isPrimaryThread()) {
                Bukkit.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command);
            } else {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command));
            }
            issuedReward = true;
            if (this.plugin.getConfigSettings().getConsoleLogging() <= 2) continue;
            this.plugin.getLogger().info(player.getUniqueId() + " was rewarded command " + s);
        }
        for (int i = 0; i < this.rewards.getPermissions().size(); ++i) {
            if (depends.getVaultPermission() == null) continue;
            String perm = this.rewards.getPermissions().get(i);
            String world = null;
            if (i < this.rewards.getPermissionWorlds().size()) {
                world = this.rewards.getPermissionWorlds().get(i);
            }
            if (world == null || world.equals("null")) {
                depends.getVaultPermission().playerAdd(null, player, perm);
            } else {
                depends.getVaultPermission().playerAdd(world, player, perm);
            }
            if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded permission " + perm);
            }
            issuedReward = true;
        }
        for (String s : this.rewards.getMcmmoSkills()) {
            int max;
            int levels = this.rewards.getMcmmoAmounts().get(this.rewards.getMcmmoSkills().indexOf(s));
            SkillType type = this.plugin.getDependencies().getMcMMOSkill(s);
            int current = UserManager.getOfflinePlayer((OfflinePlayer)player).getProfile().getSkillLevel(type);
            if (current + levels > (max = Config.getInstance().getLevelCap(type))) {
                UserManager.getOfflinePlayer((OfflinePlayer)player).getProfile().modifySkill(type, max);
            } else {
                UserManager.getOfflinePlayer((OfflinePlayer)player).getProfile().addLevels(type, levels);
            }
            if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded " + s + " x " + levels);
            }
            issuedReward = true;
        }
        if (player.isOnline()) {
            for (String s : this.rewards.getHeroesClasses()) {
                Hero hero = this.plugin.getDependencies().getHero(player.getUniqueId());
                double expChange = this.rewards.getHeroesAmounts().get(this.rewards.getHeroesClasses().indexOf(s));
                hero.addExp(expChange, this.plugin.getDependencies().getHeroes().getClassManager().getClass(s), ((Player)player).getLocation());
                if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                    this.plugin.getLogger().info(player.getUniqueId() + " was rewarded " + s + " x " + expChange);
                }
                issuedReward = true;
            }
        }
        if (this.rewards.getPartiesExperience() > 0 && depends.getPartiesApi() != null && (partyPlayer = depends.getPartiesApi().getPartyPlayer(player.getUniqueId())) != null && partyPlayer.getPartyId() != null && (party = depends.getPartiesApi().getParty(partyPlayer.getPartyId())) != null) {
            party.giveExperience((double)this.rewards.getPartiesExperience());
            issuedReward = true;
            if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded " + this.rewards.getPartiesExperience() + " party experience");
            }
        }
        if (this.rewards.getExp() > 0 && player.isOnline()) {
            ((Player)player).giveExp(this.rewards.getExp());
            if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded exp " + this.rewards.getExp());
            }
            issuedReward = true;
        }
        if (this.rewards.getQuestPoints() > 0) {
            quester.setQuestPoints(quester.getQuestPoints() + this.rewards.getQuestPoints());
            if (this.plugin.getConfigSettings().getConsoleLogging() > 2) {
                this.plugin.getLogger().info(player.getUniqueId() + " was rewarded " + this.rewards.getQuestPoints() + " " + BukkitLang.get("questPoints"));
            }
            issuedReward = true;
        }
        for (String s : this.rewards.getCustomRewards().keySet()) {
            CustomReward found = null;
            for (CustomReward cr : this.plugin.getCustomRewards()) {
                if (!cr.getName().equalsIgnoreCase(s)) continue;
                found = cr;
                break;
            }
            if (found != null) {
                found.giveReward(player.getUniqueId(), this.rewards.getCustomRewards().get(s));
                issuedReward = true;
                if (this.plugin.getConfigSettings().getConsoleLogging() <= 2) continue;
                this.plugin.getLogger().info(player.getUniqueId() + " was custom rewarded " + s);
                continue;
            }
            this.plugin.getLogger().warning("Quester \"" + player.getName() + "\" completed the Quest \"" + this.name + "\", but the Custom Reward \"" + s + "\" could not be found. Does it still exist?");
        }
        if (player.isOnline()) {
            Player p = (Player)player;
            BukkitLang.send(p, ChatColor.GOLD + BukkitLang.get(p, "questCompleteTitle").replace("<quest>", this.name));
            if (this.plugin.getConfigSettings().canShowQuestTitles()) {
                Iterator<ItemStack> title = ChatColor.GOLD + BukkitLang.get(p, "quest") + " " + BukkitLang.get(p, "complete");
                String subtitle = ChatColor.YELLOW + this.name;
                BukkitTitleProvider.sendTitle(p, (String)((Object)title), subtitle);
            }
            BukkitLang.send(p, ChatColor.GREEN + BukkitLang.get(p, "questRewardsTitle"));
            if (!issuedReward) {
                p.sendMessage(ChatColor.GRAY + "- (" + BukkitLang.get("none") + ")");
            } else if (!this.rewards.getDetailsOverride().isEmpty()) {
                for (String s : this.rewards.getDetailsOverride()) {
                    String message = ChatColor.DARK_GREEN + BukkitConfigUtil.parseString(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
                    if (this.plugin.getDependencies().getPlaceholderApi() != null) {
                        message = PlaceholderAPI.setPlaceholders((Player)p, (String)message);
                    }
                    quester.sendMessage("- " + message);
                }
            } else {
                if (this.rewards.getExp() > 0) {
                    quester.sendMessage("- " + ChatColor.DARK_GREEN + this.rewards.getExp() + " " + BukkitLang.get(p, "experience"));
                }
                if (this.rewards.getQuestPoints() > 0) {
                    quester.sendMessage("- " + ChatColor.DARK_GREEN + this.rewards.getQuestPoints() + " " + BukkitLang.get(p, "questPoints"));
                }
                for (ItemStack i : this.rewards.getItems()) {
                    StringBuilder text;
                    if (i.getItemMeta() != null && i.getItemMeta().hasDisplayName()) {
                        if (i.getEnchantments().isEmpty()) {
                            text = new StringBuilder("- " + ChatColor.DARK_AQUA + ChatColor.ITALIC + i.getItemMeta().getDisplayName() + ChatColor.RESET + ChatColor.GRAY + " x " + i.getAmount());
                        } else {
                            text = new StringBuilder("- " + ChatColor.DARK_AQUA + ChatColor.ITALIC + i.getItemMeta().getDisplayName() + ChatColor.RESET);
                            try {
                                if (!i.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                                    text.append(ChatColor.GRAY).append(" ").append(BukkitLang.get(p, "with")).append(ChatColor.DARK_PURPLE);
                                    for (Map.Entry e : i.getEnchantments().entrySet()) {
                                        text.append(" ").append(BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).append(":").append(e.getValue());
                                    }
                                }
                            }
                            catch (Throwable cr) {
                                // empty catch block
                            }
                            text.append(ChatColor.GRAY).append(" x ").append(i.getAmount());
                        }
                    } else if (i.getDurability() != 0) {
                        text = new StringBuilder("- " + ChatColor.DARK_GREEN + "<item>:" + i.getDurability());
                        if (!i.getEnchantments().isEmpty()) {
                            text.append(ChatColor.GRAY).append(" ").append(BukkitLang.get(p, "with"));
                            for (int iz = 0; iz < i.getEnchantments().size(); ++iz) {
                                text.append(" <enchantment> <level>");
                            }
                        }
                        text.append(ChatColor.GRAY).append(" x ").append(i.getAmount());
                    } else {
                        text = new StringBuilder("- " + ChatColor.DARK_GREEN + "<item>");
                        if (!i.getEnchantments().isEmpty()) {
                            try {
                                if (!i.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                                    text.append(ChatColor.GRAY).append(" ").append(BukkitLang.get(p, "with"));
                                    for (int iz = 0; iz < i.getEnchantments().size(); ++iz) {
                                        text.append(" <enchantment> <level>");
                                    }
                                }
                            }
                            catch (Throwable iz) {
                                // empty catch block
                            }
                        }
                        text.append(ChatColor.GRAY).append(" x ").append(i.getAmount());
                    }
                    if (this.plugin.getConfigSettings().canTranslateNames() && text.toString().contains("<item>")) {
                        if (this.plugin.getLocaleManager().sendMessage(p, text.toString(), i.getType(), i.getDurability(), i.getEnchantments())) continue;
                        for (Map.Entry e : i.getEnchantments().entrySet()) {
                            text = new StringBuilder(text.toString().replaceFirst("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())));
                            text = new StringBuilder(text.toString().replaceFirst("<level>", RomanNumeral.getNumeral((Integer)e.getValue())));
                        }
                        quester.sendMessage(text.toString().replace("<item>", BukkitItemUtil.getName(i)));
                        continue;
                    }
                    for (Map.Entry e : i.getEnchantments().entrySet()) {
                        text = new StringBuilder(text.toString().replaceFirst("<enchantment>", BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())));
                        text = new StringBuilder(text.toString().replaceFirst("<level>", RomanNumeral.getNumeral((Integer)e.getValue())));
                    }
                    quester.sendMessage(text.toString().replace("<item>", BukkitItemUtil.getName(i)));
                }
                if (this.rewards.getMoney() > 0 && depends.getVaultEconomy() != null) {
                    quester.sendMessage("- " + ChatColor.DARK_GREEN + depends.getVaultEconomy().format((double)this.rewards.getMoney()));
                }
                if (!this.rewards.getCommands().isEmpty()) {
                    int index = 0;
                    for (String s : this.rewards.getCommands()) {
                        if (!this.rewards.getCommandsOverrideDisplay().isEmpty() && this.rewards.getCommandsOverrideDisplay().size() > index) {
                            if (!this.rewards.getCommandsOverrideDisplay().get(index).trim().isEmpty()) {
                                quester.sendMessage("- " + ChatColor.DARK_GREEN + this.rewards.getCommandsOverrideDisplay().get(index));
                            }
                        } else {
                            quester.sendMessage("- " + ChatColor.DARK_GREEN + s);
                        }
                        ++index;
                    }
                }
                if (!this.rewards.getPermissions().isEmpty()) {
                    int index = 0;
                    for (String s : this.rewards.getPermissions()) {
                        if (this.rewards.getPermissionWorlds() != null && this.rewards.getPermissionWorlds().size() > index) {
                            quester.sendMessage("- " + ChatColor.DARK_GREEN + s + " (" + this.rewards.getPermissionWorlds().get(index) + ")");
                        } else {
                            quester.sendMessage("- " + ChatColor.DARK_GREEN + s);
                        }
                        ++index;
                    }
                }
                if (!this.rewards.getMcmmoSkills().isEmpty()) {
                    for (String s : this.rewards.getMcmmoSkills()) {
                        quester.sendMessage("- " + ChatColor.DARK_GREEN + this.rewards.getMcmmoAmounts().get(this.rewards.getMcmmoSkills().indexOf(s)) + " " + ChatColor.DARK_PURPLE + s + " " + BukkitLang.get(p, "experience"));
                    }
                }
                if (!this.rewards.getHeroesClasses().isEmpty()) {
                    for (String s : this.rewards.getHeroesClasses()) {
                        quester.sendMessage("- " + ChatColor.AQUA + this.rewards.getHeroesAmounts().get(this.rewards.getHeroesClasses().indexOf(s)) + " " + ChatColor.BLUE + s + " " + BukkitLang.get(p, "experience"));
                    }
                }
                if (this.rewards.getPartiesExperience() > 0) {
                    p.sendMessage("- " + ChatColor.DARK_GREEN + this.rewards.getPartiesExperience() + ChatColor.DARK_PURPLE + " " + BukkitLang.get(p, "partiesExperience"));
                }
                for (String s : this.rewards.getCustomRewards().keySet()) {
                    CustomReward found = null;
                    for (CustomReward cr : this.plugin.getCustomRewards()) {
                        if (!cr.getName().equalsIgnoreCase(s)) continue;
                        found = cr;
                        break;
                    }
                    if (found == null) continue;
                    Map<String, Object> dataMap = this.rewards.getCustomRewards().get(found.getName());
                    String message = found.getDisplay();
                    if (message != null) {
                        for (String key : dataMap.keySet()) {
                            message = message.replace("%" + key + "%", dataMap.get(key).toString());
                        }
                        quester.sendMessage("- " + ChatColor.GOLD + message);
                        continue;
                    }
                    this.plugin.getLogger().warning("Failed to notify player: Custom Reward does not have an assigned name");
                }
            }
        }
        quester.saveData();
        if (player.isOnline() && player.getPlayer() != null) {
            player.getPlayer().updateInventory();
        }
        quester.updateJournal();
        quester.findCompassTarget();
        if (player.isOnline()) {
            BukkitQuesterPostCompleteQuestEvent postEvent = new BukkitQuesterPostCompleteQuestEvent((BukkitQuester)quester, this);
            this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
        }
        if (allowMultiplayer && this.options.getShareProgressLevel() == 4) {
            List<Quester> mq = quester.getMultiplayerQuesters(this);
            for (Quester qq : mq) {
                if (qq.getQuestProgressOrDefault(this) == null) continue;
                this.completeQuest(qq, false);
            }
        }
    }

    @Override
    public void failQuest(Quester quester) {
        this.failQuest(quester, false);
    }

    @Override
    public void failQuest(Quester quester, boolean ignoreFailAction) {
        Stage stage;
        BukkitQuesterPreFailQuestEvent preEvent = new BukkitQuesterPreFailQuestEvent((BukkitQuester)quester, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        for (Map.Entry<Integer, Quest> entry : quester.getTimers().entrySet()) {
            if (!entry.getValue().getId().equals(this.getId())) continue;
            this.plugin.getServer().getScheduler().cancelTask(entry.getKey().intValue());
            quester.getTimers().remove(entry.getKey());
        }
        OfflinePlayer player = quester.getOfflinePlayer();
        if (!ignoreFailAction && (stage = quester.getCurrentStage(this)) != null && stage.getFailAction() != null) {
            quester.getCurrentStage(this).getFailAction().fire(quester, this);
        }
        String[] messages = new String[]{ChatColor.RED + BukkitLang.get(player.isOnline() ? (Player)player : null, "questFailed").replace("<quest>", this.name)};
        quester.quitQuest((Quest)this, messages);
        if (player.isOnline()) {
            ((Player)player).updateInventory();
        }
        BukkitQuesterPostFailQuestEvent postEvent = new BukkitQuesterPostFailQuestEvent((BukkitQuester)quester, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    @Override
    public boolean isInRegionStart(Quester quester) {
        if (this.regionStart == null) {
            return false;
        }
        Player player = quester.getPlayer();
        return this.plugin.getDependencies().getWorldGuardApi().getApplicableRegionsIDs(player.getWorld(), player.getLocation()).contains(this.regionStart);
    }
}

