/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.quests;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.main.QuestMainPrompt;
import me.pikamug.quests.convo.quests.menu.QuestMenuPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMenuPrompt;
import me.pikamug.quests.interfaces.ReloadCallback;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.QuestFactory;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.quests.components.Options;
import me.pikamug.quests.quests.components.Planner;
import me.pikamug.quests.quests.components.Requirements;
import me.pikamug.quests.quests.components.Rewards;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitFakeConversable;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.stack.BlockItemStack;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitQuestFactory
implements QuestFactory,
ConversationAbandonedListener {
    private final BukkitQuestsPlugin plugin;
    private final ConversationFactory conversationFactory;
    private ConcurrentHashMap<UUID, Block> selectedBlockStarts = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Block> selectedKillLocations = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Block> selectedReachLocations = new ConcurrentHashMap();
    private ConcurrentSkipListSet<UUID> selectingNpcs = new ConcurrentSkipListSet();
    private List<String> editingQuestNames = new LinkedList<String>();

    public BukkitQuestFactory(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
        this.conversationFactory = new ConversationFactory((Plugin)plugin).withModality(false).withLocalEcho(false).withFirstPrompt((Prompt)new QuestMenuPrompt(new ConversationContext((Plugin)plugin, (Conversable)new BukkitFakeConversable(){

            @Override
            public void sendRawMessage(@Nullable UUID uuid, @NotNull String s) {
            }
        }, new HashMap()))).withTimeout(3600).withPrefix((ConversationPrefix)new LineBreakPrefix()).addConversationAbandonedListener((ConversationAbandonedListener)this);
    }

    public ConcurrentHashMap<UUID, Block> getSelectedBlockStarts() {
        return this.selectedBlockStarts;
    }

    public void setSelectedBlockStarts(ConcurrentHashMap<UUID, Block> selectedBlockStarts) {
        this.selectedBlockStarts = selectedBlockStarts;
    }

    public ConcurrentHashMap<UUID, Block> getSelectedKillLocations() {
        return this.selectedKillLocations;
    }

    public void setSelectedKillLocations(ConcurrentHashMap<UUID, Block> selectedKillLocations) {
        this.selectedKillLocations = selectedKillLocations;
    }

    public ConcurrentHashMap<UUID, Block> getSelectedReachLocations() {
        return this.selectedReachLocations;
    }

    public void setSelectedReachLocations(ConcurrentHashMap<UUID, Block> selectedReachLocations) {
        this.selectedReachLocations = selectedReachLocations;
    }

    @Override
    public ConcurrentSkipListSet<UUID> getSelectingNpcs() {
        return this.selectingNpcs;
    }

    @Override
    public void setSelectingNpcs(ConcurrentSkipListSet<UUID> selectingNpcs) {
        this.selectingNpcs = selectingNpcs;
    }

    @Override
    public List<String> getNamesOfQuestsBeingEdited() {
        return this.editingQuestNames;
    }

    @Override
    public void setNamesOfQuestsBeingEdited(List<String> questNames) {
        this.editingQuestNames = questNames;
    }

    @Override
    public ConversationFactory getConversationFactory() {
        return this.conversationFactory;
    }

    public void conversationAbandoned(ConversationAbandonedEvent abandonedEvent) {
        if (abandonedEvent.getContext().getSessionData((Object)"questName") != null) {
            this.editingQuestNames.remove((String)abandonedEvent.getContext().getSessionData((Object)"questName"));
        }
        if (abandonedEvent.getContext().getForWhom() instanceof Player) {
            UUID uuid = ((Player)abandonedEvent.getContext().getForWhom()).getUniqueId();
            this.selectedBlockStarts.remove(uuid);
            this.selectedKillLocations.remove(uuid);
            this.selectedReachLocations.remove(uuid);
        }
    }

    @Override
    public Prompt returnToMenu(ConversationContext context) {
        return new QuestMainPrompt(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadQuest(ConversationContext context, Quest quest) {
        BukkitQuest bukkitQuest = (BukkitQuest)quest;
        try {
            Planner pln;
            Rewards rewards;
            Requirements requirements;
            context.setSessionData((Object)"edit", (Object)bukkitQuest.getName());
            context.setSessionData((Object)"questId", (Object)bukkitQuest.getId());
            context.setSessionData((Object)"questName", (Object)bukkitQuest.getName());
            context.setSessionData((Object)"askMessage", (Object)bukkitQuest.getDescription());
            context.setSessionData((Object)"finishMessage", (Object)bukkitQuest.getFinished());
            if (this.plugin.getDependencies().hasAnyNpcDependencies() && bukkitQuest.getNpcStart() != null) {
                context.setSessionData((Object)"npcStart", (Object)bukkitQuest.getNpcStart().toString());
            }
            context.setSessionData((Object)"blockStart", (Object)bukkitQuest.getBlockStart());
            if (bukkitQuest.getInitialAction() != null) {
                context.setSessionData((Object)"initialEvent", (Object)bukkitQuest.getInitialAction().getName());
            }
            if (bukkitQuest.getRegionStart() != null) {
                context.setSessionData((Object)"region", (Object)bukkitQuest.getRegionStart());
            }
            if (bukkitQuest.getGUIDisplay() != null) {
                context.setSessionData((Object)"guiDisplay", (Object)bukkitQuest.getGUIDisplay());
            }
            if ((requirements = bukkitQuest.getRequirements()).getMoney() != 0) {
                context.setSessionData((Object)"moneyReq", (Object)requirements.getMoney());
            }
            if (requirements.getQuestPoints() != 0) {
                context.setSessionData((Object)"questPointsReq", (Object)requirements.getQuestPoints());
            }
            if (requirements.getExp() != 0) {
                context.setSessionData((Object)"expReq", (Object)requirements.getExp());
            }
            if (!requirements.getItems().isEmpty()) {
                context.setSessionData((Object)"itemReqs", requirements.getItems());
                context.setSessionData((Object)"removeItemReqs", requirements.getRemoveItems());
            }
            if (!requirements.getNeededQuestIds().isEmpty()) {
                context.setSessionData((Object)"questReqs", requirements.getNeededQuestIds());
            }
            if (!requirements.getBlockQuestIds().isEmpty()) {
                context.setSessionData((Object)"questBlocks", requirements.getBlockQuestIds());
            }
            if (!requirements.getMcmmoSkills().isEmpty()) {
                context.setSessionData((Object)"mcMMOSkillReqs", requirements.getMcmmoAmounts());
                context.setSessionData((Object)"mcMMOSkillAmountReqs", requirements.getMcmmoAmounts());
            }
            if (!requirements.getPermissions().isEmpty()) {
                context.setSessionData((Object)"permissionReqs", requirements.getPermissions());
            }
            if (requirements.getHeroesPrimaryClass() != null) {
                context.setSessionData((Object)"heroesPrimaryClassReq", (Object)requirements.getHeroesPrimaryClass());
            }
            if (requirements.getHeroesSecondaryClass() != null) {
                context.setSessionData((Object)"heroesSecondaryClassReq", (Object)requirements.getHeroesSecondaryClass());
            }
            if (!requirements.getCustomRequirements().isEmpty()) {
                LinkedList<String> list = new LinkedList<String>();
                LinkedList<Map<String, Object>> dataMapList = new LinkedList<Map<String, Object>>();
                for (Map.Entry<String, Map<String, Object>> entry : requirements.getCustomRequirements().entrySet()) {
                    list.add(entry.getKey());
                    dataMapList.add(entry.getValue());
                }
                context.setSessionData((Object)"customReqs", list);
                context.setSessionData((Object)"customReqData", dataMapList);
            }
            if (!requirements.getDetailsOverride().isEmpty()) {
                context.setSessionData((Object)"failMessage", requirements.getDetailsOverride());
            }
            if ((rewards = bukkitQuest.getRewards()).getMoney() != 0) {
                context.setSessionData((Object)"moneyRew", (Object)rewards.getMoney());
            }
            if (rewards.getQuestPoints() != 0) {
                context.setSessionData((Object)"questPointsRew", (Object)rewards.getQuestPoints());
            }
            if (rewards.getExp() != 0) {
                context.setSessionData((Object)"expRew", (Object)rewards.getExp());
            }
            if (!rewards.getItems().isEmpty()) {
                context.setSessionData((Object)"itemRews", rewards.getItems());
            }
            if (!rewards.getCommands().isEmpty()) {
                context.setSessionData((Object)"commandRews", rewards.getCommands());
            }
            if (!rewards.getCommandsOverrideDisplay().isEmpty()) {
                context.setSessionData((Object)"commandOverrideDisplay", rewards.getCommandsOverrideDisplay());
            }
            if (!rewards.getPermissions().isEmpty()) {
                context.setSessionData((Object)"permissionRews", rewards.getPermissions());
            }
            if (!rewards.getPermissions().isEmpty()) {
                context.setSessionData((Object)"permissionWorlds", rewards.getPermissionWorlds());
            }
            if (!rewards.getMcmmoSkills().isEmpty()) {
                context.setSessionData((Object)"mcMMOSkillRews", rewards.getMcmmoSkills());
                context.setSessionData((Object)"mcMMOSkillAmounts", rewards.getMcmmoAmounts());
            }
            if (!rewards.getHeroesClasses().isEmpty()) {
                context.setSessionData((Object)"heroesClassRews", rewards.getHeroesClasses());
                context.setSessionData((Object)"heroesAmountRews", rewards.getHeroesAmounts());
            }
            if (rewards.getPartiesExperience() != 0) {
                context.setSessionData((Object)"partiesExperienceRews", (Object)rewards.getPartiesExperience());
            }
            if (!rewards.getPhatLoots().isEmpty()) {
                context.setSessionData((Object)"phatLootRews", rewards.getPhatLoots());
            }
            if (!rewards.getCustomRewards().isEmpty()) {
                context.setSessionData((Object)"customRews", new LinkedList<String>(rewards.getCustomRewards().keySet()));
                context.setSessionData((Object)"customRewData", new LinkedList<Map<String, Object>>(rewards.getCustomRewards().values()));
            }
            if (!rewards.getDetailsOverride().isEmpty()) {
                context.setSessionData((Object)"detailsOverrideRew", rewards.getDetailsOverride());
            }
            if ((pln = bukkitQuest.getPlanner()).getStart() != null) {
                context.setSessionData((Object)"startDatePln", (Object)pln.getStart());
            }
            if (pln.getEnd() != null) {
                context.setSessionData((Object)"endDatePln", (Object)pln.getEnd());
            }
            if (pln.getRepeat() != -1L) {
                context.setSessionData((Object)"repeatCyclePln", (Object)pln.getRepeat());
            }
            if (pln.getCooldown() != -1L) {
                context.setSessionData((Object)"cooldownPln", (Object)pln.getCooldown());
            }
            context.setSessionData((Object)"overridePln", (Object)pln.getOverride());
            Options opt = bukkitQuest.getOptions();
            context.setSessionData((Object)"allowCommandsOpt", (Object)opt.canAllowCommands());
            context.setSessionData((Object)"allowQuittingOpt", (Object)opt.canAllowQuitting());
            context.setSessionData((Object)"ignoreSilkTouchOpt", (Object)opt.canIgnoreSilkTouch());
            context.setSessionData((Object)"externalPartyPluginOpt", (Object)opt.getExternalPartyPlugin());
            context.setSessionData((Object)"usePartiesPluginOpt", (Object)opt.canUsePartiesPlugin());
            context.setSessionData((Object)"shareProgressLevelOpt", (Object)opt.getShareProgressLevel());
            context.setSessionData((Object)"shareSameQuestOnlyOpt", (Object)opt.canShareSameQuestOnly());
            context.setSessionData((Object)"shareDistanceOpt", (Object)opt.getShareDistance());
            context.setSessionData((Object)"handleOfflinePlayersOpt", (Object)opt.canHandleOfflinePlayers());
            context.setSessionData((Object)"ignoreBlockReplaceOpt", (Object)opt.canIgnoreBlockReplace());
            context.setSessionData((Object)"giveGloballyAtLoginOpt", (Object)opt.canGiveGloballyAtLogin());
            context.setSessionData((Object)"allowStackingGlobalOpt", (Object)opt.canAllowStackingGlobal());
            context.setSessionData((Object)"informQuestStartOpt", (Object)opt.canInformOnStart());
            int index = 1;
            for (Stage stage : bukkitQuest.getStages()) {
                LinkedList<String> mobs;
                LinkedList<String> npcs;
                LinkedList<ItemStack> items;
                LinkedList<Integer> amounts;
                LinkedList<String> names;
                BukkitStage bukkitStage = (BukkitStage)stage;
                String pref = "stage" + index;
                ++index;
                context.setSessionData((Object)pref, (Object)Boolean.TRUE);
                if (!bukkitStage.getBlocksToBreak().isEmpty()) {
                    names = new LinkedList<String>();
                    amounts = new LinkedList<Integer>();
                    LinkedList<Short> linkedList = new LinkedList<Short>();
                    for (BlockItemStack e : bukkitStage.getBlocksToBreak()) {
                        names.add(e.getType().name());
                        amounts.add(e.getAmount());
                        linkedList.add(e.getDurability());
                    }
                    context.setSessionData((Object)(pref + "breakNames"), names);
                    context.setSessionData((Object)(pref + "breakAmounts"), amounts);
                    context.setSessionData((Object)(pref + "breakDurability"), linkedList);
                }
                if (!bukkitStage.getBlocksToDamage().isEmpty()) {
                    names = new LinkedList();
                    amounts = new LinkedList();
                    LinkedList<Short> linkedList = new LinkedList<Short>();
                    for (BlockItemStack e : bukkitStage.getBlocksToDamage()) {
                        names.add(e.getType().name());
                        amounts.add(e.getAmount());
                        linkedList.add(e.getDurability());
                    }
                    context.setSessionData((Object)(pref + "damageNames"), names);
                    context.setSessionData((Object)(pref + "damageAmounts"), amounts);
                    context.setSessionData((Object)(pref + "damageDurability"), linkedList);
                }
                if (!bukkitStage.getBlocksToPlace().isEmpty()) {
                    names = new LinkedList();
                    amounts = new LinkedList();
                    LinkedList<Short> linkedList = new LinkedList<Short>();
                    for (BlockItemStack e : bukkitStage.getBlocksToPlace()) {
                        names.add(e.getType().name());
                        amounts.add(e.getAmount());
                        linkedList.add(e.getDurability());
                    }
                    context.setSessionData((Object)(pref + "placeNames"), names);
                    context.setSessionData((Object)(pref + "placeAmounts"), amounts);
                    context.setSessionData((Object)(pref + "placeDurability"), linkedList);
                }
                if (!bukkitStage.getBlocksToUse().isEmpty()) {
                    names = new LinkedList();
                    amounts = new LinkedList();
                    LinkedList<Short> linkedList = new LinkedList<Short>();
                    for (BlockItemStack e : bukkitStage.getBlocksToUse()) {
                        names.add(e.getType().name());
                        amounts.add(e.getAmount());
                        linkedList.add(e.getDurability());
                    }
                    context.setSessionData((Object)(pref + "useNames"), names);
                    context.setSessionData((Object)(pref + "useAmounts"), amounts);
                    context.setSessionData((Object)(pref + "useDurability"), linkedList);
                }
                if (!bukkitStage.getBlocksToCut().isEmpty()) {
                    names = new LinkedList();
                    amounts = new LinkedList();
                    LinkedList<Short> linkedList = new LinkedList<Short>();
                    for (BlockItemStack e : bukkitStage.getBlocksToCut()) {
                        names.add(e.getType().name());
                        amounts.add(e.getAmount());
                        linkedList.add(e.getDurability());
                    }
                    context.setSessionData((Object)(pref + "cutNames"), names);
                    context.setSessionData((Object)(pref + "cutAmounts"), amounts);
                    context.setSessionData((Object)(pref + "cutDurability"), linkedList);
                }
                if (!bukkitStage.getItemsToCraft().isEmpty()) {
                    items = new LinkedList<ItemStack>(bukkitStage.getItemsToCraft());
                    context.setSessionData((Object)(pref + "craftItems"), items);
                }
                if (!bukkitStage.getItemsToSmelt().isEmpty()) {
                    items = new LinkedList<ItemStack>(bukkitStage.getItemsToSmelt());
                    context.setSessionData((Object)(pref + "smeltItems"), items);
                }
                if (!bukkitStage.getItemsToEnchant().isEmpty()) {
                    items = new LinkedList<ItemStack>(bukkitStage.getItemsToEnchant());
                    context.setSessionData((Object)(pref + "enchantItems"), items);
                }
                if (!bukkitStage.getItemsToBrew().isEmpty()) {
                    items = new LinkedList<ItemStack>(bukkitStage.getItemsToBrew());
                    context.setSessionData((Object)(pref + "brewItems"), items);
                }
                if (!bukkitStage.getItemsToConsume().isEmpty()) {
                    items = new LinkedList<ItemStack>(bukkitStage.getItemsToConsume());
                    context.setSessionData((Object)(pref + "consumeItems"), items);
                }
                if (bukkitStage.getCowsToMilk() != null) {
                    context.setSessionData((Object)(pref + "cowMilk"), (Object)bukkitStage.getCowsToMilk());
                }
                if (bukkitStage.getFishToCatch() != null) {
                    context.setSessionData((Object)(pref + "fish"), (Object)bukkitStage.getFishToCatch());
                }
                if (bukkitStage.getPlayersToKill() != null) {
                    context.setSessionData((Object)(pref + "playerKill"), (Object)bukkitStage.getPlayersToKill());
                }
                if (!bukkitStage.getItemsToDeliver().isEmpty()) {
                    items = new LinkedList<ItemStack>(bukkitStage.getItemsToDeliver());
                    Iterator<String> npcs2 = new LinkedList();
                    for (UUID uuid : bukkitStage.getItemDeliveryTargets()) {
                        ((LinkedList)((Object)npcs2)).add(uuid.toString());
                    }
                    context.setSessionData((Object)(pref + "deliveryItems"), items);
                    context.setSessionData((Object)(pref + "deliveryNPCs"), npcs2);
                    context.setSessionData((Object)(pref + "deliveryMessages"), bukkitStage.getDeliverMessages());
                }
                if (!bukkitStage.getNpcsToInteract().isEmpty()) {
                    npcs = new LinkedList<String>();
                    for (UUID uUID : bukkitStage.getNpcsToInteract()) {
                        npcs.add(uUID.toString());
                    }
                    context.setSessionData((Object)(pref + "npcIdsToTalkTo"), npcs);
                }
                if (!bukkitStage.getNpcsToKill().isEmpty()) {
                    npcs = new LinkedList();
                    for (UUID uUID : bukkitStage.getNpcsToKill()) {
                        npcs.add(uUID.toString());
                    }
                    context.setSessionData((Object)(pref + "npcIdsToKill"), npcs);
                    context.setSessionData((Object)(pref + "npcAmountsToKill"), bukkitStage.getNpcNumToKill());
                }
                if (!bukkitStage.getMobsToKill().isEmpty()) {
                    mobs = new LinkedList<String>();
                    for (EntityType entityType : bukkitStage.getMobsToKill()) {
                        mobs.add(BukkitMiscUtil.getPrettyMobName(entityType));
                    }
                    context.setSessionData((Object)(pref + "mobTypes"), mobs);
                    context.setSessionData((Object)(pref + "mobAmounts"), bukkitStage.getMobNumToKill());
                    if (!bukkitStage.getLocationsToKillWithin().isEmpty()) {
                        LinkedList locations = new LinkedList();
                        for (Location l : bukkitStage.getLocationsToKillWithin()) {
                            locations.add(BukkitConfigUtil.getLocationInfo(l));
                        }
                        context.setSessionData((Object)(pref + "killLocations"), (Object)locations);
                        context.setSessionData((Object)(pref + "killLocationRadii"), bukkitStage.getRadiiToKillWithin());
                        context.setSessionData((Object)(pref + "killLocationNames"), bukkitStage.getKillNames());
                    }
                }
                if (!bukkitStage.getLocationsToReach().isEmpty()) {
                    LinkedList<String> locations = new LinkedList<String>();
                    for (Location location : bukkitStage.getLocationsToReach()) {
                        locations.add(BukkitConfigUtil.getLocationInfo(location));
                    }
                    context.setSessionData((Object)(pref + "reachLocations"), locations);
                    context.setSessionData((Object)(pref + "reachLocationRadii"), bukkitStage.getRadiiToReachWithin());
                    context.setSessionData((Object)(pref + "reachLocationNames"), bukkitStage.getLocationNames());
                }
                if (!bukkitStage.getMobsToTame().isEmpty()) {
                    mobs = new LinkedList();
                    for (EntityType entityType : bukkitStage.getMobsToTame()) {
                        mobs.add(BukkitMiscUtil.getPrettyMobName(entityType));
                    }
                    amounts = new LinkedList<Integer>(bukkitStage.getMobNumToTame());
                    context.setSessionData((Object)(pref + "tameTypes"), mobs);
                    context.setSessionData((Object)(pref + "tameAmounts"), amounts);
                }
                if (!bukkitStage.getSheepToShear().isEmpty()) {
                    LinkedList<String> colors = new LinkedList<String>();
                    for (DyeColor dyeColor : bukkitStage.getSheepToShear()) {
                        colors.add(BukkitMiscUtil.getPrettyDyeColorName(dyeColor));
                    }
                    amounts = new LinkedList<Integer>(bukkitStage.getSheepNumToShear());
                    context.setSessionData((Object)(pref + "shearColors"), colors);
                    context.setSessionData((Object)(pref + "shearAmounts"), amounts);
                }
                if (!bukkitStage.getPasswordDisplays().isEmpty()) {
                    context.setSessionData((Object)(pref + "passwordDisplays"), bukkitStage.getPasswordDisplays());
                    context.setSessionData((Object)(pref + "passwordPhrases"), bukkitStage.getPasswordPhrases());
                }
                if (!bukkitStage.getCustomObjectives().isEmpty()) {
                    void var15_32;
                    LinkedList<String> list = new LinkedList<String>();
                    LinkedList<Integer> countList = new LinkedList<Integer>();
                    boolean bl = false;
                    while (var15_32 < bukkitStage.getCustomObjectives().size()) {
                        list.add(bukkitStage.getCustomObjectives().get((int)var15_32).getName());
                        countList.add(bukkitStage.getCustomObjectiveCounts().get((int)var15_32));
                        ++var15_32;
                    }
                    LinkedList<Map.Entry<String, Object>> linkedList = new LinkedList<Map.Entry<String, Object>>(bukkitStage.getCustomObjectiveData());
                    context.setSessionData((Object)(pref + "customObjectives"), list);
                    context.setSessionData((Object)(pref + "customObjectiveCounts"), countList);
                    context.setSessionData((Object)(pref + "customObjectiveData"), linkedList);
                }
                if (bukkitStage.getStartAction() != null) {
                    context.setSessionData((Object)(pref + "startEvent"), (Object)bukkitStage.getStartAction().getName());
                }
                if (bukkitStage.getFinishAction() != null) {
                    context.setSessionData((Object)(pref + "finishEvent"), (Object)bukkitStage.getFinishAction().getName());
                }
                if (bukkitStage.getFailAction() != null) {
                    context.setSessionData((Object)(pref + "failEvent"), (Object)bukkitStage.getFailAction().getName());
                }
                if (bukkitStage.getDeathAction() != null) {
                    context.setSessionData((Object)(pref + "deathEvent"), (Object)bukkitStage.getDeathAction().getName());
                }
                if (bukkitStage.getDisconnectAction() != null) {
                    context.setSessionData((Object)(pref + "disconnectEvent"), (Object)bukkitStage.getDisconnectAction().getName());
                }
                if (!bukkitStage.getChatActions().isEmpty()) {
                    LinkedList<String> chatEvents = new LinkedList<String>();
                    LinkedList<String> chatEventTriggers = new LinkedList<String>();
                    for (String s : bukkitStage.getChatActions().keySet()) {
                        chatEventTriggers.add(s);
                        chatEvents.add(bukkitStage.getChatActions().get(s).getName());
                    }
                    context.setSessionData((Object)(pref + "chatEvents"), chatEvents);
                    context.setSessionData((Object)(pref + "chatEventTriggers"), chatEventTriggers);
                }
                if (!bukkitStage.getCommandActions().isEmpty()) {
                    LinkedList<String> commandEvents = new LinkedList<String>();
                    LinkedList<String> commandEventTriggers = new LinkedList<String>();
                    for (String s : bukkitStage.getCommandActions().keySet()) {
                        commandEventTriggers.add(s);
                        commandEvents.add(bukkitStage.getCommandActions().get(s).getName());
                    }
                    context.setSessionData((Object)(pref + "commandEvents"), commandEvents);
                    context.setSessionData((Object)(pref + "commandEventTriggers"), commandEventTriggers);
                }
                if (bukkitStage.getCondition() != null) {
                    context.setSessionData((Object)(pref + "condition"), (Object)bukkitStage.getCondition().getName());
                }
                if (bukkitStage.getDelay() != -1L) {
                    context.setSessionData((Object)(pref + "delay"), (Object)bukkitStage.getDelay());
                    if (bukkitStage.getDelayMessage() != null) {
                        context.setSessionData((Object)(pref + "delayMessage"), (Object)bukkitStage.getDelayMessage());
                    }
                }
                if (bukkitStage.getScript() != null) {
                    context.setSessionData((Object)(pref + "denizen"), (Object)bukkitStage.getScript());
                }
                if (bukkitStage.getCompleteMessage() != null) {
                    context.setSessionData((Object)(pref + "completeMessage"), (Object)bukkitStage.getCompleteMessage());
                }
                if (bukkitStage.getStartMessage() != null) {
                    context.setSessionData((Object)(pref + "startMessage"), (Object)bukkitStage.getStartMessage());
                }
                if (bukkitStage.getObjectiveOverrides().isEmpty()) continue;
                context.setSessionData((Object)(pref + "overrideDisplay"), bukkitStage.getObjectiveOverrides());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteQuest(ConversationContext context) {
        ConfigurationSection sec;
        YamlConfiguration data = new YamlConfiguration();
        File questsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "quests.yml");
        try {
            data.load(questsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questErrorReadingFile").replace("<quest>", questsFile.getName()));
            return;
        }
        String delete = (String)context.getSessionData((Object)"delQuest");
        if (delete != null && this.plugin.getQuest(delete) != null && (sec = data.getConfigurationSection("quests")) != null) {
            for (String key : sec.getKeys(false)) {
                String name = sec.getString(key + ".name");
                if (name == null || this.plugin.getQuest(name) == null || !this.plugin.getQuest(name).getId().equals(this.plugin.getQuest(delete).getId())) continue;
                sec.set(key, null);
                context.getForWhom().sendRawMessage(ChatColor.GREEN + BukkitLang.get("questDeleted"));
                if (this.plugin.getConfigSettings().getConsoleLogging() <= 0) break;
                String identifier = context.getForWhom() instanceof Player ? "Player " + ((Player)context.getForWhom()).getUniqueId() : "CONSOLE";
                this.plugin.getLogger().info(identifier + " deleted quest " + delete);
                break;
            }
        }
        try {
            data.save(questsFile);
        }
        catch (IOException e) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questSaveError"));
            return;
        }
        ReloadCallback<Boolean> callback = response -> {
            if (!response.booleanValue()) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            }
        };
        this.plugin.reload(callback);
    }

    @Override
    public void saveQuest(ConversationContext context, ConfigurationSection section) {
        ConfigurationSection questList;
        String edit = (String)context.getSessionData((Object)"edit");
        if (edit != null && this.plugin.getQuest(edit) != null && (questList = section.getParent()) != null) {
            for (String key : questList.getKeys(false)) {
                String name = questList.getString(key + ".name");
                if (name == null || this.plugin.getQuest(name) == null || !this.plugin.getQuest(name).getId().equals(this.plugin.getQuest(edit).getId())) continue;
                questList.set(key, null);
                break;
            }
        }
        section.set("name", context.getSessionData((Object)"questName") != null ? context.getSessionData((Object)"questName") : null);
        section.set("ask-message", context.getSessionData((Object)"askMessage") != null ? context.getSessionData((Object)"askMessage") : null);
        section.set("finish-message", context.getSessionData((Object)"finishMessage") != null ? context.getSessionData((Object)"finishMessage") : null);
        section.set("npc-giver-uuid", context.getSessionData((Object)"npcStart") != null ? context.getSessionData((Object)"npcStart") : null);
        section.set("block-start", context.getSessionData((Object)"blockStart") != null ? BukkitConfigUtil.getLocationInfo((Location)Objects.requireNonNull(context.getSessionData((Object)"blockStart"))) : null);
        section.set("event", context.getSessionData((Object)"initialEvent") != null ? context.getSessionData((Object)"initialEvent") : null);
        section.set("region", context.getSessionData((Object)"region") != null ? context.getSessionData((Object)"region") : null);
        section.set("gui-display", context.getSessionData((Object)"guiDisplay") != null ? context.getSessionData((Object)"guiDisplay") : null);
        this.saveRequirements(context, section);
        this.saveStages(context, section);
        this.saveRewards(context, section);
        this.savePlanner(context, section);
        this.saveOptions(context, section);
        if (this.plugin.getConfigSettings().getConsoleLogging() > 0) {
            String identifier = context.getForWhom() instanceof Player ? "Player " + ((Player)context.getForWhom()).getUniqueId() : "CONSOLE";
            this.plugin.getLogger().info(identifier + " saved quest " + context.getSessionData((Object)"questName"));
        }
    }

    private void saveRequirements(ConversationContext context, ConfigurationSection section) {
        LinkedList customRequirementsData;
        ConfigurationSection requirements = section.createSection("requirements");
        requirements.set("money", context.getSessionData((Object)"moneyReq") != null ? context.getSessionData((Object)"moneyReq") : null);
        requirements.set("quest-points", context.getSessionData((Object)"questPointsReq") != null ? context.getSessionData((Object)"questPointsReq") : null);
        requirements.set("exp", context.getSessionData((Object)"expReq") != null ? context.getSessionData((Object)"expReq") : null);
        requirements.set("items", context.getSessionData((Object)"itemReqs") != null ? context.getSessionData((Object)"itemReqs") : null);
        requirements.set("remove-items", context.getSessionData((Object)"removeItemReqs") != null ? context.getSessionData((Object)"removeItemReqs") : null);
        requirements.set("permissions", context.getSessionData((Object)"permissionReqs") != null ? context.getSessionData((Object)"permissionReqs") : null);
        requirements.set("quests", context.getSessionData((Object)"questReqs") != null ? context.getSessionData((Object)"questReqs") : null);
        requirements.set("quest-blocks", context.getSessionData((Object)"questBlocks") != null ? context.getSessionData((Object)"questBlocks") : null);
        requirements.set("mcmmo-skills", context.getSessionData((Object)"mcMMOSkillReqs") != null ? context.getSessionData((Object)"mcMMOSkillReqs") : null);
        requirements.set("mcmmo-amounts", context.getSessionData((Object)"mcMMOSkillAmountReqs") != null ? context.getSessionData((Object)"mcMMOSkillAmountReqs") : null);
        requirements.set("heroes-primary-class", context.getSessionData((Object)"heroesPrimaryClassReq") != null ? context.getSessionData((Object)"heroesPrimaryClassReq") : null);
        requirements.set("heroes-secondary-class", context.getSessionData((Object)"heroesSecondaryClassReq") != null ? context.getSessionData((Object)"heroesSecondaryClassReq") : null);
        LinkedList customRequirements = context.getSessionData((Object)"customReqs") != null ? (LinkedList)context.getSessionData((Object)"customReqs") : null;
        LinkedList linkedList = customRequirementsData = context.getSessionData((Object)"customReqData") != null ? (LinkedList)context.getSessionData((Object)"customReqData") : null;
        if (customRequirements != null && customRequirementsData != null) {
            ConfigurationSection customRequirementsSec = requirements.createSection("custom-requirements");
            for (int i = 0; i < customRequirements.size(); ++i) {
                ConfigurationSection customReqSec = customRequirementsSec.createSection("req" + (i + 1));
                customReqSec.set("name", customRequirements.get(i));
                customReqSec.set("data", customRequirementsData.get(i));
            }
        }
        requirements.set("fail-requirement-message", context.getSessionData((Object)"failMessage") != null ? context.getSessionData((Object)"failMessage") : null);
        if (requirements.getKeys(false).isEmpty()) {
            section.set("requirements", null);
        }
    }

    private void saveStages(ConversationContext context, ConfigurationSection section) {
        ConfigurationSection stages = section.createSection("stages");
        ConfigurationSection ordered = stages.createSection("ordered");
        for (int i = 1; i <= new QuestStageMenuPrompt(context).getStages(context); ++i) {
            String completeMessage;
            String startMessage;
            String delayMessage;
            String pref = "stage" + i;
            ConfigurationSection stage = ordered.createSection("" + i);
            stage.set("break-block-names", context.getSessionData((Object)(pref + "breakNames")) != null ? context.getSessionData((Object)(pref + "breakNames")) : null);
            stage.set("break-block-amounts", context.getSessionData((Object)(pref + "breakAmounts")) != null ? context.getSessionData((Object)(pref + "breakAmounts")) : null);
            stage.set("break-block-durability", context.getSessionData((Object)(pref + "breakDurability")) != null ? context.getSessionData((Object)(pref + "breakDurability")) : null);
            stage.set("damage-block-names", context.getSessionData((Object)(pref + "damageNames")) != null ? context.getSessionData((Object)(pref + "damageNames")) : null);
            stage.set("damage-block-amounts", context.getSessionData((Object)(pref + "damageAmounts")) != null ? context.getSessionData((Object)(pref + "damageAmounts")) : null);
            stage.set("damage-block-durability", context.getSessionData((Object)(pref + "damageDurability")) != null ? context.getSessionData((Object)(pref + "damageDurability")) : null);
            stage.set("place-block-names", context.getSessionData((Object)(pref + "placeNames")) != null ? context.getSessionData((Object)(pref + "placeNames")) : null);
            stage.set("place-block-amounts", context.getSessionData((Object)(pref + "placeAmounts")) != null ? context.getSessionData((Object)(pref + "placeAmounts")) : null);
            stage.set("place-block-durability", context.getSessionData((Object)(pref + "placeDurability")) != null ? context.getSessionData((Object)(pref + "placeDurability")) : null);
            stage.set("use-block-names", context.getSessionData((Object)(pref + "useNames")) != null ? context.getSessionData((Object)(pref + "useNames")) : null);
            stage.set("use-block-amounts", context.getSessionData((Object)(pref + "useAmounts")) != null ? context.getSessionData((Object)(pref + "useAmounts")) : null);
            stage.set("use-block-durability", context.getSessionData((Object)(pref + "useDurability")) != null ? context.getSessionData((Object)(pref + "useDurability")) : null);
            stage.set("cut-block-names", context.getSessionData((Object)(pref + "cutNames")) != null ? context.getSessionData((Object)(pref + "cutNames")) : null);
            stage.set("cut-block-amounts", context.getSessionData((Object)(pref + "cutAmounts")) != null ? context.getSessionData((Object)(pref + "cutAmounts")) : null);
            stage.set("cut-block-durability", context.getSessionData((Object)(pref + "cutDurability")) != null ? context.getSessionData((Object)(pref + "cutDurability")) : null);
            stage.set("items-to-craft", context.getSessionData((Object)(pref + "craftItems")) != null ? context.getSessionData((Object)(pref + "craftItems")) : null);
            stage.set("items-to-smelt", context.getSessionData((Object)(pref + "smeltItems")) != null ? context.getSessionData((Object)(pref + "smeltItems")) : null);
            stage.set("items-to-enchant", context.getSessionData((Object)(pref + "enchantItems")) != null ? context.getSessionData((Object)(pref + "enchantItems")) : null);
            stage.set("items-to-brew", context.getSessionData((Object)(pref + "brewItems")) != null ? context.getSessionData((Object)(pref + "brewItems")) : null);
            stage.set("items-to-consume", context.getSessionData((Object)(pref + "consumeItems")) != null ? context.getSessionData((Object)(pref + "consumeItems")) : null);
            stage.set("cows-to-milk", context.getSessionData((Object)(pref + "cowMilk")) != null ? context.getSessionData((Object)(pref + "cowMilk")) : null);
            stage.set("fish-to-catch", context.getSessionData((Object)(pref + "fish")) != null ? context.getSessionData((Object)(pref + "fish")) : null);
            stage.set("players-to-kill", context.getSessionData((Object)(pref + "playerKill")) != null ? context.getSessionData((Object)(pref + "playerKill")) : null);
            stage.set("items-to-deliver", context.getSessionData((Object)(pref + "deliveryItems")) != null ? context.getSessionData((Object)(pref + "deliveryItems")) : null);
            stage.set("npc-delivery-uuids", context.getSessionData((Object)(pref + "deliveryNPCs")) != null ? context.getSessionData((Object)(pref + "deliveryNPCs")) : null);
            stage.set("delivery-messages", context.getSessionData((Object)(pref + "deliveryMessages")) != null ? context.getSessionData((Object)(pref + "deliveryMessages")) : null);
            stage.set("npc-uuids-to-talk-to", context.getSessionData((Object)(pref + "npcIdsToTalkTo")) != null ? context.getSessionData((Object)(pref + "npcIdsToTalkTo")) : null);
            stage.set("npc-uuids-to-kill", context.getSessionData((Object)(pref + "npcIdsToKill")) != null ? context.getSessionData((Object)(pref + "npcIdsToKill")) : null);
            stage.set("npc-kill-amounts", context.getSessionData((Object)(pref + "npcAmountsToKill")) != null ? context.getSessionData((Object)(pref + "npcAmountsToKill")) : null);
            stage.set("mobs-to-kill", context.getSessionData((Object)(pref + "mobTypes")) != null ? context.getSessionData((Object)(pref + "mobTypes")) : null);
            stage.set("mob-amounts", context.getSessionData((Object)(pref + "mobAmounts")) != null ? context.getSessionData((Object)(pref + "mobAmounts")) : null);
            stage.set("locations-to-kill", context.getSessionData((Object)(pref + "killLocations")) != null ? context.getSessionData((Object)(pref + "killLocations")) : null);
            stage.set("kill-location-radii", context.getSessionData((Object)(pref + "killLocationRadii")) != null ? context.getSessionData((Object)(pref + "killLocationRadii")) : null);
            stage.set("kill-location-names", context.getSessionData((Object)(pref + "killLocationNames")) != null ? context.getSessionData((Object)(pref + "killLocationNames")) : null);
            stage.set("locations-to-reach", context.getSessionData((Object)(pref + "reachLocations")) != null ? context.getSessionData((Object)(pref + "reachLocations")) : null);
            stage.set("reach-location-radii", context.getSessionData((Object)(pref + "reachLocationRadii")) != null ? context.getSessionData((Object)(pref + "reachLocationRadii")) : null);
            stage.set("reach-location-names", context.getSessionData((Object)(pref + "reachLocationNames")) != null ? context.getSessionData((Object)(pref + "reachLocationNames")) : null);
            stage.set("mobs-to-tame", context.getSessionData((Object)(pref + "tameTypes")) != null ? context.getSessionData((Object)(pref + "tameTypes")) : null);
            stage.set("mob-tame-amounts", context.getSessionData((Object)(pref + "tameAmounts")) != null ? context.getSessionData((Object)(pref + "tameAmounts")) : null);
            stage.set("sheep-to-shear", context.getSessionData((Object)(pref + "shearColors")) != null ? context.getSessionData((Object)(pref + "shearColors")) : null);
            stage.set("sheep-amounts", context.getSessionData((Object)(pref + "shearAmounts")) != null ? context.getSessionData((Object)(pref + "shearAmounts")) : null);
            stage.set("password-displays", context.getSessionData((Object)(pref + "passwordDisplays")) != null ? context.getSessionData((Object)(pref + "passwordDisplays")) : null);
            stage.set("password-phrases", context.getSessionData((Object)(pref + "passwordPhrases")) != null ? context.getSessionData((Object)(pref + "passwordPhrases")) : null);
            LinkedList customObj = (LinkedList)context.getSessionData((Object)(pref + "customObjectives"));
            LinkedList customObjCounts = (LinkedList)context.getSessionData((Object)(pref + "customObjectiveCounts"));
            LinkedList customObjData = (LinkedList)context.getSessionData((Object)(pref + "customObjectiveData"));
            if (context.getSessionData((Object)(pref + "customObjectives")) != null) {
                ConfigurationSection sec = stage.createSection("custom-objectives");
                if (customObj == null || customObjCounts == null || customObjData == null) continue;
                for (int index = 0; index < customObj.size(); ++index) {
                    ConfigurationSection sec2 = sec.createSection("custom" + (index + 1));
                    sec2.set("name", customObj.get(index));
                    sec2.set("count", customObjCounts.get(index));
                    CustomObjective found = null;
                    for (CustomObjective co : this.plugin.getCustomObjectives()) {
                        if (!co.getName().equals(customObj.get(index))) continue;
                        found = co;
                        break;
                    }
                    if (found == null) continue;
                    ConfigurationSection sec3 = sec2.createSection("data");
                    for (Map.Entry entry : found.getData()) {
                        for (Map.Entry e : customObjData) {
                            if (!((String)e.getKey()).equals(entry.getKey())) continue;
                            sec3.set((String)e.getKey(), e.getValue());
                        }
                    }
                }
            }
            stage.set("script-to-run", context.getSessionData((Object)(pref + "denizen")) != null ? context.getSessionData((Object)(pref + "denizen")) : null);
            stage.set("start-event", context.getSessionData((Object)(pref + "startEvent")) != null ? context.getSessionData((Object)(pref + "startEvent")) : null);
            stage.set("finish-event", context.getSessionData((Object)(pref + "finishEvent")) != null ? context.getSessionData((Object)(pref + "finishEvent")) : null);
            stage.set("fail-event", context.getSessionData((Object)(pref + "failEvent")) != null ? context.getSessionData((Object)(pref + "failEvent")) : null);
            stage.set("death-event", context.getSessionData((Object)(pref + "deathEvent")) != null ? context.getSessionData((Object)(pref + "deathEvent")) : null);
            stage.set("disconnect-event", context.getSessionData((Object)(pref + "disconnectEvent")) != null ? context.getSessionData((Object)(pref + "disconnectEvent")) : null);
            stage.set("chat-events", context.getSessionData((Object)(pref + "chatEvents")) != null ? context.getSessionData((Object)(pref + "chatEvents")) : null);
            stage.set("chat-event-triggers", context.getSessionData((Object)(pref + "chatEventTriggers")) != null ? context.getSessionData((Object)(pref + "chatEventTriggers")) : null);
            stage.set("command-events", context.getSessionData((Object)(pref + "commandEvents")) != null ? context.getSessionData((Object)(pref + "commandEvents")) : null);
            stage.set("command-event-triggers", context.getSessionData((Object)(pref + "commandEventTriggers")) != null ? context.getSessionData((Object)(pref + "commandEventTriggers")) : null);
            stage.set("condition", context.getSessionData((Object)(pref + "condition")) != null ? context.getSessionData((Object)(pref + "condition")) : null);
            Long delay = (Long)context.getSessionData((Object)(pref + "delay"));
            if (delay != null) {
                stage.set("delay", (Object)(delay.intValue() / 1000));
            }
            if ((delayMessage = (String)context.getSessionData((Object)(pref + "delayMessage"))) != null) {
                stage.set("delay-message", (Object)delayMessage.replace("\\n", "\n"));
            }
            if ((startMessage = (String)context.getSessionData((Object)(pref + "startMessage"))) != null) {
                stage.set("start-message", (Object)startMessage.replace("\\n", "\n"));
            }
            if ((completeMessage = (String)context.getSessionData((Object)(pref + "completeMessage"))) != null) {
                stage.set("complete-message", (Object)completeMessage.replace("\\n", "\n"));
            }
            stage.set("objective-override", context.getSessionData((Object)(pref + "overrideDisplay")) != null ? context.getSessionData((Object)(pref + "overrideDisplay")) : null);
        }
    }

    private void saveRewards(ConversationContext context, ConfigurationSection section) {
        LinkedList customRewardsData;
        ConfigurationSection rewards = section.createSection("rewards");
        rewards.set("items", context.getSessionData((Object)"itemRews") != null ? context.getSessionData((Object)"itemRews") : null);
        rewards.set("money", context.getSessionData((Object)"moneyRew") != null ? context.getSessionData((Object)"moneyRew") : null);
        rewards.set("quest-points", context.getSessionData((Object)"questPointsRew") != null ? context.getSessionData((Object)"questPointsRew") : null);
        rewards.set("exp", context.getSessionData((Object)"expRew") != null ? context.getSessionData((Object)"expRew") : null);
        rewards.set("commands", context.getSessionData((Object)"commandRews") != null ? context.getSessionData((Object)"commandRews") : null);
        rewards.set("commands-override-display", context.getSessionData((Object)"commandOverrideDisplay") != null ? context.getSessionData((Object)"commandOverrideDisplay") : null);
        rewards.set("permissions", context.getSessionData((Object)"permissionRews") != null ? context.getSessionData((Object)"permissionRews") : null);
        rewards.set("permission-worlds", context.getSessionData((Object)"permissionWorlds") != null ? context.getSessionData((Object)"permissionWorlds") : null);
        rewards.set("mcmmo-skills", context.getSessionData((Object)"mcMMOSkillRews") != null ? context.getSessionData((Object)"mcMMOSkillRews") : null);
        rewards.set("mcmmo-levels", context.getSessionData((Object)"mcMMOSkillAmounts") != null ? context.getSessionData((Object)"mcMMOSkillAmounts") : null);
        rewards.set("heroes-exp-classes", context.getSessionData((Object)"heroesClassRews") != null ? context.getSessionData((Object)"heroesClassRews") : null);
        rewards.set("heroes-exp-amounts", context.getSessionData((Object)"heroesAmountRews") != null ? context.getSessionData((Object)"heroesAmountRews") : null);
        rewards.set("parties-experience", context.getSessionData((Object)"partiesExperienceRews") != null ? context.getSessionData((Object)"partiesExperienceRews") : null);
        rewards.set("phat-loots", context.getSessionData((Object)"phatLootRews") != null ? context.getSessionData((Object)"phatLootRews") : null);
        LinkedList customRewards = context.getSessionData((Object)"customRews") != null ? (LinkedList)context.getSessionData((Object)"customRews") : null;
        LinkedList linkedList = customRewardsData = context.getSessionData((Object)"customRewData") != null ? (LinkedList)context.getSessionData((Object)"customRewData") : null;
        if (customRewards != null && customRewardsData != null) {
            ConfigurationSection customRewardsSec = rewards.createSection("custom-rewards");
            for (int i = 0; i < customRewards.size(); ++i) {
                ConfigurationSection customRewSec = customRewardsSec.createSection("req" + (i + 1));
                customRewSec.set("name", customRewards.get(i));
                customRewSec.set("data", customRewardsData.get(i));
            }
        }
        rewards.set("details-override", context.getSessionData((Object)"detailsOverrideRew") != null ? context.getSessionData((Object)"detailsOverrideRew") : null);
        if (rewards.getKeys(false).isEmpty()) {
            section.set("rewards", null);
        }
    }

    private void savePlanner(ConversationContext context, ConfigurationSection section) {
        ConfigurationSection pln = section.createSection("planner");
        pln.set("start", context.getSessionData((Object)"startDatePln") != null ? context.getSessionData((Object)"startDatePln") : null);
        pln.set("end", context.getSessionData((Object)"endDatePln") != null ? context.getSessionData((Object)"endDatePln") : null);
        Long repeatCycle = (Long)context.getSessionData((Object)"repeatCyclePln");
        pln.set("repeat", repeatCycle != null ? Long.valueOf(repeatCycle / 1000L) : null);
        Long cooldown = (Long)context.getSessionData((Object)"cooldownPln");
        pln.set("cooldown", cooldown != null ? Long.valueOf(cooldown / 1000L) : null);
        pln.set("override", context.getSessionData((Object)"overridePln") != null ? context.getSessionData((Object)"overridePln") : null);
        if (pln.getKeys(false).isEmpty()) {
            section.set("planner", null);
        }
    }

    private void saveOptions(ConversationContext context, ConfigurationSection section) {
        ConfigurationSection opts = section.createSection("options");
        opts.set("allow-commands", context.getSessionData((Object)"allowCommandsOpt") != null ? context.getSessionData((Object)"allowCommandsOpt") : null);
        opts.set("allow-quitting", context.getSessionData((Object)"allowQuittingOpt") != null ? context.getSessionData((Object)"allowQuittingOpt") : null);
        opts.set("ignore-silk-touch", context.getSessionData((Object)"ignoreSilkTouchOpt") != null ? context.getSessionData((Object)"ignoreSilkTouchOpt") : null);
        opts.set("external-party-plugin", context.getSessionData((Object)"externalPartyPluginOpt") != null ? context.getSessionData((Object)"externalPartyPluginOpt") : null);
        opts.set("use-parties-plugin", context.getSessionData((Object)"usePartiesPluginOpt") != null ? context.getSessionData((Object)"usePartiesPluginOpt") : null);
        opts.set("share-progress-level", context.getSessionData((Object)"shareProgressLevelOpt") != null ? context.getSessionData((Object)"shareProgressLevelOpt") : null);
        opts.set("same-quest-only", context.getSessionData((Object)"shareSameQuestOnlyOpt") != null ? context.getSessionData((Object)"shareSameQuestOnlyOpt") : null);
        opts.set("share-distance", context.getSessionData((Object)"shareDistanceOpt") != null ? context.getSessionData((Object)"shareDistanceOpt") : null);
        opts.set("handle-offline-players", context.getSessionData((Object)"handleOfflinePlayersOpt") != null ? context.getSessionData((Object)"handleOfflinePlayersOpt") : null);
        opts.set("ignore-block-replace", context.getSessionData((Object)"ignoreBlockReplaceOpt") != null ? context.getSessionData((Object)"ignoreBlockReplaceOpt") : null);
        opts.set("give-at-login", context.getSessionData((Object)"giveGloballyAtLoginOpt") != null ? context.getSessionData((Object)"giveGloballyAtLoginOpt") : null);
        opts.set("allow-stacking-global", context.getSessionData((Object)"allowStackingGlobalOpt") != null ? context.getSessionData((Object)"allowStackingGlobalOpt") : null);
        opts.set("inform-on-start", context.getSessionData((Object)"informQuestStartOpt") != null ? context.getSessionData((Object)"informQuestStartOpt") : null);
        opts.set("override-max-quests", context.getSessionData((Object)"overrideMaxQuestsOpt") != null ? context.getSessionData((Object)"overrideMaxQuestsOpt") : null);
        if (opts.getKeys(false).isEmpty()) {
            section.set("options", null);
        }
    }

    public static class LineBreakPrefix
    implements ConversationPrefix {
        @NotNull
        public String getPrefix(@NotNull ConversationContext context) {
            return "\n";
        }
    }
}

