/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage;

import java.io.File;
import java.util.HashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.enums.StorageType;
import me.pikamug.quests.storage.QuesterStorage;
import me.pikamug.quests.storage.implementation.QuesterStorageImpl;
import me.pikamug.quests.storage.implementation.custom.CustomStorageProviders;
import me.pikamug.quests.storage.implementation.file.BukkitQuesterYamlStorage;
import me.pikamug.quests.storage.implementation.sql.BukkitQuesterSqlStorage;
import me.pikamug.quests.storage.implementation.sql.connection.hikari.MySqlConnectionFactory;
import me.pikamug.quests.storage.misc.StorageCredentials;
import org.bukkit.configuration.file.FileConfiguration;

public class BukkitStorageFactory {
    private final BukkitQuestsPlugin plugin;

    public BukkitStorageFactory(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    public QuesterStorage getInstance() {
        StorageType type = StorageType.parse(this.plugin.getConfig().getString("storage-method.player-data", "yaml"), StorageType.YAML);
        this.plugin.getLogger().info("Loading storage implementation: " + type.name());
        QuesterStorage storage = new QuesterStorage(this.plugin, this.createNewImplementation(type));
        storage.init();
        return storage;
    }

    public QuesterStorageImpl createNewImplementation(StorageType method) {
        switch (method) {
            case CUSTOM: {
                return CustomStorageProviders.getProvider().provide(this.plugin);
            }
            case MYSQL: {
                return new BukkitQuesterSqlStorage(this.plugin, new MySqlConnectionFactory(this.getDatabaseValues(this.plugin.getConfig())), this.plugin.getConfig().getString("storage-data.table_prefix"));
            }
            case YAML: {
                return new BukkitQuesterYamlStorage(this.plugin, this.plugin.getDataFolder() + File.separator + "data");
            }
        }
        throw new RuntimeException("Unknown method: " + (Object)((Object)method));
    }

    private StorageCredentials getDatabaseValues(FileConfiguration fc) {
        int maxPoolSize = fc.getInt("storage-data.pool-settings.max-pool-size", fc.getInt("storage-data.pool-size", 10));
        int minIdle = fc.getInt("storage-data.pool-settings.min-idle", maxPoolSize);
        int maxLifetime = fc.getInt("storage-data.pool-settings.max-lifetime", 1800000);
        int keepAliveTime = fc.getInt("storage-data.pool-settings.keepalive-time", 0);
        int connectionTimeout = fc.getInt("storage-data.pool-settings.connection-timeout", 5000);
        boolean useUnicode = fc.getBoolean("storage-data.pool-settings.properties.useUnicode", true);
        String characterEncoding = fc.getString("storage-data.pool-settings.properties.characterEncoding", "utf8");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("useUnicode", String.valueOf(useUnicode));
        props.put("characterEncoding", characterEncoding);
        return new StorageCredentials(fc.getString("storage-data.address", null), fc.getString("storage-data.database", null), fc.getString("storage-data.username", null), fc.getString("storage-data.password", null), maxPoolSize, minIdle, maxLifetime, keepAliveTime, connectionTimeout, props);
    }
}

