/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.Quests;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.storage.implementation.QuesterStorageImpl;

public class QuesterStorage {
    private final Quests plugin;
    private final QuesterStorageImpl implementation;

    public QuesterStorage(Quests plugin, QuesterStorageImpl implementation) {
        this.plugin = plugin;
        this.implementation = implementation;
    }

    public QuesterStorageImpl getImplementation() {
        return this.implementation;
    }

    public Collection<QuesterStorageImpl> getImplementations() {
        return Collections.singleton(this.implementation);
    }

    private <T> CompletableFuture<T> makeFuture(Callable<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.call();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        });
    }

    private CompletableFuture<Void> makeFuture(Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
        });
    }

    public String getName() {
        return this.implementation.getImplementationName();
    }

    public void init() {
        try {
            this.implementation.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.implementation.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<Quester> loadQuester(UUID uniqueId) {
        return this.makeFuture(() -> this.implementation.loadQuester(uniqueId));
    }

    public CompletableFuture<Void> saveQuester(Quester quester) {
        return this.makeFuture(() -> {
            try {
                this.implementation.saveQuester(quester);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<Collection<Quester>> loadOfflineQuesters() {
        ConcurrentSkipListSet<Quester> questers = new ConcurrentSkipListSet<Quester>();
        try {
            for (UUID uniqueId : this.implementation.getSavedUniqueIds()) {
                questers.add(this.implementation.loadQuester(uniqueId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.makeFuture(() -> questers);
    }

    public CompletableFuture<Void> saveOfflineQuesters() {
        return this.makeFuture(() -> {
            try {
                for (Quester quester : this.plugin.getOfflineQuesters()) {
                    this.implementation.saveQuester(quester);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> deleteQuester(UUID uniqueId) {
        return this.makeFuture(() -> {
            try {
                this.implementation.deleteQuester(uniqueId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<String> getQuesterLastKnownName(UUID uniqueId) {
        return this.makeFuture(() -> this.implementation.getQuesterLastKnownName(uniqueId));
    }
}

