/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.actions.BukkitAction;
import me.pikamug.quests.entity.BukkitQuestMob;
import me.pikamug.quests.entity.QuestMob;
import me.pikamug.quests.exceptions.ActionFormatException;
import me.pikamug.quests.storage.implementation.ActionStorageImpl;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BukkitActionYamlStorage
implements ActionStorageImpl {
    private final BukkitQuestsPlugin plugin;

    public BukkitActionYamlStorage(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BukkitQuestsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "YAML";
    }

    @Override
    public void init() {
        YamlConfiguration config = new YamlConfiguration();
        File legacyFile = new File(this.plugin.getDataFolder(), "events.yml");
        File actionsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "actions.yml");
        if (legacyFile.isFile()) {
            try {
                if (legacyFile.renameTo(actionsFile)) {
                    this.plugin.getLogger().log(Level.INFO, "Renamed legacy events.yml to actions.yml");
                }
                if (actionsFile.isFile()) {
                    this.plugin.getLogger().log(Level.INFO, "Successfully deleted legacy events.yml");
                    if (legacyFile.delete()) {
                        this.plugin.getLogger().log(Level.INFO, "Done!");
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Unable to convert events.yml to actions.yml");
                e.printStackTrace();
            }
        }
        if (actionsFile.length() != 0L) {
            try {
                if (actionsFile.isFile()) {
                    config.load(actionsFile);
                } else {
                    config.load(legacyFile);
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            ConfigurationSection sec = config.getConfigurationSection("actions");
            if (sec == null) {
                this.plugin.getLogger().log(Level.INFO, "Could not find section \"actions\" from actions.yml. Trying legacy \"events\"...");
                sec = config.getConfigurationSection("events");
            }
            if (sec != null) {
                for (String s : sec.getKeys(false)) {
                    BukkitAction action = null;
                    try {
                        action = this.loadAction(s);
                    }
                    catch (ActionFormatException e) {
                        e.printStackTrace();
                    }
                    if (action != null) {
                        Collection<Action> actions = this.plugin.getLoadedActions();
                        actions.add(action);
                        this.plugin.setLoadedActions(actions);
                        continue;
                    }
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to load Action \"" + s + "\". Skipping.");
                }
            } else {
                this.plugin.getLogger().log(Level.SEVERE, "Could not find beginning section from actions.yml. Skipping.");
            }
        } else {
            this.plugin.getLogger().log(Level.WARNING, "Empty file actions.yml was not loaded.");
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BukkitAction loadAction(String name) throws ActionFormatException {
        ConfigurationSection section;
        String world;
        Object loc;
        if (name == null) {
            return null;
        }
        File legacy = new File(this.plugin.getDataFolder(), "events.yml");
        File actions = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "actions.yml");
        YamlConfiguration data = new YamlConfiguration();
        try {
            if (actions.isFile()) {
                data.load(actions);
            } else {
                data.load(legacy);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        String legacyName = "events." + name;
        String actionKey = "actions." + name + ".";
        if (data.contains(legacyName)) {
            actionKey = legacyName + ".";
        }
        BukkitAction action = new BukkitAction(this.plugin);
        action.setName(name);
        if (data.contains(actionKey + "message")) {
            action.setMessage(BukkitConfigUtil.parseString(data.getString(actionKey + "message")));
        }
        if (data.contains(actionKey + "open-book")) {
            action.setBook(data.getString(actionKey + "open-book"));
        }
        if (data.contains(actionKey + "clear-inventory")) {
            if (!data.isBoolean(actionKey + "clear-inventory")) throw new ActionFormatException("'clear-inventory' is not a true/false value", actionKey);
            action.setClearInv(data.getBoolean(actionKey + "clear-inventory"));
        }
        if (data.contains(actionKey + "fail-quest")) {
            if (!data.isBoolean(actionKey + "fail-quest")) throw new ActionFormatException("'fail-quest' is not a true/false value", actionKey);
            action.setFailQuest(data.getBoolean(actionKey + "fail-quest"));
        }
        if (data.contains(actionKey + "explosions")) {
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "explosions"), String.class)) throw new ActionFormatException("'explosions' is not a list of locations", actionKey);
            LinkedList<Location> explosions = new LinkedList<Location>();
            for (String s : data.getStringList(actionKey + "explosions")) {
                loc = BukkitConfigUtil.getLocation(s);
                if (loc == null) {
                    throw new ActionFormatException("'explosions' is not in proper \"WorldName x y z\" format", actionKey);
                }
                explosions.add((Location)loc);
            }
            action.setExplosions(explosions);
        }
        if (data.contains(actionKey + "effects")) {
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "effects"), String.class)) throw new ActionFormatException("'effects' is not a list of effects", actionKey);
            if (!data.contains(actionKey + "effect-locations")) throw new ActionFormatException("'effect-locations' is missing", actionKey);
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "effect-locations"), String.class)) throw new ActionFormatException("'effect-locations' is not a list of locations", actionKey);
            List effectList = data.getStringList(actionKey + "effects");
            List effectLocs = data.getStringList(actionKey + "effect-locations");
            Iterator effects = new HashMap();
            for (String s : effectList) {
                Effect effect;
                try {
                    effect = Effect.valueOf((String)s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new ActionFormatException(s + " is not a valid effect name", actionKey);
                }
                Location l = BukkitConfigUtil.getLocation((String)effectLocs.get(effectList.indexOf(s)));
                if (l == null) {
                    throw new ActionFormatException("'effect-locations' is not in proper \"WorldName x y z\"format", actionKey);
                }
                effects.put(l, effect);
            }
            action.setEffects((Map<Location, Effect>)((Object)effects));
        }
        if (data.contains(actionKey + "items")) {
            Object stack;
            LinkedList<ItemStack> temp = new LinkedList<ItemStack>();
            List itemList = (List)data.get(actionKey + "items");
            if (BukkitConfigUtil.checkList(itemList, ItemStack.class)) {
                for (Object item : itemList) {
                    stack = (ItemStack)item;
                    if (stack == null) continue;
                    temp.add((ItemStack)stack);
                }
            } else {
                if (!BukkitConfigUtil.checkList(itemList, String.class)) throw new ActionFormatException("'items' is not a list of items", actionKey);
                for (Object item : itemList) {
                    stack = (String)item;
                    if (stack == null) continue;
                    String[] result = ((String)stack).split(":");
                    if (result.length < 1) {
                        throw new ActionFormatException("'items' has invalid length", actionKey);
                    }
                    String itemName = result[0].replace("name-", "");
                    Material itemMat = Material.matchMaterial((String)itemName);
                    int itemAmt = Integer.parseInt(result[1].replace("amount-", ""));
                    if (itemMat == null) throw new ActionFormatException("'items' has invalid name " + itemName, actionKey);
                    temp.add(new ItemStack(itemMat, itemAmt));
                }
            }
            action.setItems(temp);
        }
        if (data.contains(actionKey + "storm-world")) {
            world = data.getString(actionKey + "storm-world");
            if (world == null) throw new ActionFormatException("'storm-world' is not a valid world", actionKey);
            World stormWorld = this.plugin.getServer().getWorld(world);
            if (stormWorld == null) {
                throw new ActionFormatException("'storm-world' is not a valid world name", actionKey);
            }
            if (!data.contains(actionKey + "storm-duration")) throw new ActionFormatException("'storm-duration' is missing", actionKey);
            if (data.getInt(actionKey + "storm-duration", -999) == -999) {
                throw new ActionFormatException("'storm-duration' is not a number", actionKey);
            }
            action.setStormDuration(data.getInt(actionKey + "storm-duration") * 1000);
            action.setStormWorld(stormWorld);
        }
        if (data.contains(actionKey + "thunder-world")) {
            world = data.getString(actionKey + "thunder-world");
            if (world == null) throw new ActionFormatException("'thunder-world' is not a valid world", actionKey);
            World thunderWorld = this.plugin.getServer().getWorld(world);
            if (thunderWorld == null) {
                throw new ActionFormatException("'thunder-world' is not a valid world name", actionKey);
            }
            if (!data.contains(actionKey + "thunder-duration")) throw new ActionFormatException("'thunder-duration' is missing", actionKey);
            if (data.getInt(actionKey + "thunder-duration", -999) == -999) {
                throw new ActionFormatException("'thunder-duration' is not a number", actionKey);
            }
            action.setThunderDuration(data.getInt(actionKey + "thunder-duration"));
            action.setThunderWorld(thunderWorld);
        }
        if (data.contains(actionKey + "mob-spawns") && (section = data.getConfigurationSection(actionKey + "mob-spawns")) != null) {
            Iterator<BukkitQuestMob> mobSpawns = new LinkedList<QuestMob>();
            for (String s : section.getKeys(false)) {
                String mobName = section.getString(s + ".name");
                String location = section.getString(s + ".spawn-location");
                if (location == null) throw new ActionFormatException("'mob-spawn-locations' contains an invalid location", actionKey);
                Location spawnLocation = BukkitConfigUtil.getLocation(location);
                EntityType type = BukkitMiscUtil.getProperMobType(section.getString(s + ".mob-type"));
                int mobAmount = section.getInt(s + ".spawn-amounts");
                if (spawnLocation == null) {
                    throw new ActionFormatException("'mob-spawn-locations' is not in proper \"WorldName x y z\" format", actionKey);
                }
                if (type == null) {
                    throw new ActionFormatException("'mob-spawn-types' is not a list of mob types", actionKey);
                }
                ItemStack[] inventory = new ItemStack[5];
                Float[] dropChances = new Float[5];
                inventory[0] = this.loadMobItem(section, s + ".held-item");
                dropChances[0] = Float.valueOf((float)section.getDouble(s + ".held-item-drop-chance"));
                inventory[1] = this.loadMobItem(section, s + ".boots");
                dropChances[1] = Float.valueOf((float)section.getDouble(s + ".boots-drop-chance"));
                inventory[2] = this.loadMobItem(section, s + ".leggings");
                dropChances[2] = Float.valueOf((float)section.getDouble(s + ".leggings-drop-chance"));
                inventory[3] = this.loadMobItem(section, s + ".chest-plate");
                dropChances[3] = Float.valueOf((float)section.getDouble(s + ".chest-plate-drop-chance"));
                inventory[4] = this.loadMobItem(section, s + ".helmet");
                dropChances[4] = Float.valueOf((float)section.getDouble(s + ".helmet-drop-chance"));
                BukkitQuestMob questMob = new BukkitQuestMob(type, spawnLocation, mobAmount);
                questMob.setInventory(inventory);
                questMob.setDropChances(dropChances);
                questMob.setName(mobName);
                ((LinkedList)((Object)mobSpawns)).add(questMob);
            }
            action.setMobSpawns((LinkedList<QuestMob>)((Object)mobSpawns));
        }
        if (data.contains(actionKey + "lightning-strikes")) {
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "lightning-strikes"), String.class)) throw new ActionFormatException("'lightning-strikes' is not a list of locations", actionKey);
            LinkedList<Location> lightningStrikes = new LinkedList<Location>();
            for (String s : data.getStringList(actionKey + "lightning-strikes")) {
                loc = BukkitConfigUtil.getLocation(s);
                if (loc == null) {
                    throw new ActionFormatException("'lightning-strikes' is not in proper \"WorldName x y z\" format", actionKey);
                }
                lightningStrikes.add((Location)loc);
            }
            action.setLightningStrikes(lightningStrikes);
        }
        if (data.contains(actionKey + "commands")) {
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "commands"), String.class)) throw new ActionFormatException("'commands' is not a list of commands", actionKey);
            LinkedList<String> commands = new LinkedList<String>();
            for (String s : data.getStringList(actionKey + "commands")) {
                if (s.startsWith("/")) {
                    s = s.replaceFirst("/", "");
                }
                commands.add(s);
            }
            action.setCommands(commands);
        }
        if (data.contains(actionKey + "potion-effect-types")) {
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "potion-effect-types"), String.class)) throw new ActionFormatException("'potion-effect-types' is not a list of potion effects", actionKey);
            if (!data.contains(actionKey + "potion-effect-durations")) throw new ActionFormatException("'potion-effect-durations' is missing", actionKey);
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "potion-effect-durations"), Integer.class)) throw new ActionFormatException("'potion-effect-durations' is not a list of numbers", actionKey);
            if (!data.contains(actionKey + "potion-effect-amplifiers")) throw new ActionFormatException("'potion-effect-amplifiers' is missing", actionKey);
            if (!BukkitConfigUtil.checkList(data.getList(actionKey + "potion-effect-amplifiers"), Integer.class)) throw new ActionFormatException("'potion-effect-amplifiers' is not a list of numbers", actionKey);
            List types = data.getStringList(actionKey + "potion-effect-types");
            List durations = data.getIntegerList(actionKey + "potion-effect-durations");
            List amplifiers = data.getIntegerList(actionKey + "potion-effect-amplifiers");
            LinkedList<PotionEffect> potionEffects = new LinkedList<PotionEffect>();
            for (String s : types) {
                PotionEffectType type = PotionEffectType.getByName((String)s);
                if (type == null) {
                    throw new ActionFormatException("potion-effect-types is not a list of potion effect types", actionKey);
                }
                PotionEffect effect = new PotionEffect(type, ((Integer)durations.get(types.indexOf(s))).intValue(), ((Integer)amplifiers.get(types.indexOf(s))).intValue());
                potionEffects.add(effect);
            }
            action.setPotionEffects(potionEffects);
        }
        if (data.contains(actionKey + "hunger")) {
            if (data.getInt(actionKey + "hunger", -999) == -999) throw new ActionFormatException("'hunger' is not a number", actionKey);
            action.setHunger(data.getInt(actionKey + "hunger"));
        }
        if (data.contains(actionKey + "saturation")) {
            if (data.getInt(actionKey + "saturation", -999) == -999) throw new ActionFormatException("'saturation' is not a number", actionKey);
            action.setSaturation(data.getInt(actionKey + "saturation"));
        }
        if (data.contains(actionKey + "health")) {
            if (data.getInt(actionKey + "health", -999) == -999) throw new ActionFormatException("'health' is not a number", actionKey);
            action.setHealth(data.getInt(actionKey + "health"));
        }
        if (data.contains(actionKey + "teleport-location")) {
            if (!data.isString(actionKey + "teleport-location")) throw new ActionFormatException("'teleport-location' is not a location", actionKey);
            String location = data.getString(actionKey + "teleport-location");
            if (location == null) throw new ActionFormatException("'teleport-location' has invalid location", actionKey);
            Location teleport = BukkitConfigUtil.getLocation(location);
            if (teleport == null) {
                throw new ActionFormatException("'teleport-location' is not in proper \"WorldName x y z\" format", actionKey);
            }
            action.setTeleport(teleport);
        }
        if (data.contains(actionKey + "timer")) {
            if (!data.isInt(actionKey + "timer")) throw new ActionFormatException("'timer' is not a number", actionKey);
            action.setTimer(data.getInt(actionKey + "timer"));
        }
        if (data.contains(actionKey + "cancel-timer")) {
            if (!data.isBoolean(actionKey + "cancel-timer")) throw new ActionFormatException("'cancel-timer' is not a true/false value", actionKey);
            action.setCancelTimer(data.getBoolean(actionKey + "cancel-timer"));
        }
        if (!data.contains(actionKey + "denizen-script")) return action;
        action.setDenizenScript(data.getString(actionKey + "denizen-script"));
        return action;
    }

    private ItemStack loadMobItem(ConfigurationSection section, String node) {
        try {
            return (ItemStack)section.get(node);
        }
        catch (Exception e) {
            return BukkitItemUtil.readItemStack(section.getString(node));
        }
    }
}

