/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.conditions.BukkitCondition;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.exceptions.ConditionFormatException;
import me.pikamug.quests.storage.implementation.ConditionStorageImpl;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitMiscUtil;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class BukkitConditionYamlStorage
implements ConditionStorageImpl {
    private final BukkitQuestsPlugin plugin;

    public BukkitConditionYamlStorage(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BukkitQuestsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "YAML";
    }

    @Override
    public void init() {
        YamlConfiguration config = new YamlConfiguration();
        File conditionsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "conditions.yml");
        if (conditionsFile.length() != 0L) {
            try {
                if (conditionsFile.isFile()) {
                    config.load(conditionsFile);
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            ConfigurationSection sec = config.getConfigurationSection("conditions");
            if (sec != null) {
                for (String s : sec.getKeys(false)) {
                    BukkitCondition condition = null;
                    try {
                        condition = this.loadCondition(s);
                    }
                    catch (ConditionFormatException e) {
                        e.printStackTrace();
                    }
                    if (condition != null) {
                        Collection<Condition> conditions = this.plugin.getLoadedConditions();
                        conditions.add(condition);
                        this.plugin.setLoadedConditions(conditions);
                        continue;
                    }
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to load Condition \"" + s + "\". Skipping.");
                }
            } else {
                this.plugin.getLogger().log(Level.SEVERE, "Could not find beginning section from conditions.yml. Skipping.");
            }
        } else {
            this.plugin.getLogger().log(Level.WARNING, "Empty file conditions.yml was not loaded.");
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BukkitCondition loadCondition(String name) throws ConditionFormatException {
        List stackList;
        LinkedList<ItemStack> temp;
        LinkedList<UUID> npcList;
        if (name == null) {
            return null;
        }
        File conditions = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "conditions.yml");
        YamlConfiguration data = new YamlConfiguration();
        try {
            if (conditions.isFile()) {
                data.load(conditions);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        String conditionKey = "conditions." + name + ".";
        BukkitCondition condition = new BukkitCondition(this.plugin);
        condition.setName(name);
        if (data.contains(conditionKey + "fail-quest")) {
            if (!data.isBoolean(conditionKey + "fail-quest")) throw new ConditionFormatException("'fail-quest' is not a true/false value", conditionKey);
            condition.setFailQuest(data.getBoolean(conditionKey + "fail-quest"));
        }
        if (data.contains(conditionKey + "ride-entity")) {
            if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "ride-entity"), String.class)) throw new ConditionFormatException("'ride-entity' is not a list of entity types", conditionKey);
            LinkedList<String> entities = new LinkedList<String>();
            for (String s : data.getStringList(conditionKey + "ride-entity")) {
                EntityType e = BukkitMiscUtil.getProperMobType(s);
                if (e == null) {
                    throw new ConditionFormatException("'ride-entity' is not a valid entity type", conditionKey);
                }
                entities.add(s);
            }
            condition.setEntitiesWhileRiding(entities);
        }
        if (data.contains(conditionKey + "ride-npc-uuid")) {
            if (BukkitConfigUtil.checkList(data.getList(conditionKey + "ride-npc-uuid"), String.class)) {
                npcList = new LinkedList<UUID>();
                for (String s : data.getStringList(conditionKey + "ride-npc-uuid")) {
                    UUID u = UUID.fromString(s);
                    npcList.add(u);
                }
                condition.setNpcsWhileRiding(npcList);
            }
        } else if (data.contains(conditionKey + "ride-npc")) {
            if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "ride-npc"), Integer.class)) throw new ConditionFormatException("'ride-npc' is not a list of NPC IDs", conditionKey);
            npcList = new LinkedList();
            if (this.plugin.getDependencies().getNpcDependency("Citizens") == null) throw new ConditionFormatException("Citizens not found for 'ride-npc'", conditionKey);
            Iterator iterator = data.getIntegerList(conditionKey + "ride-npc").iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                NPC npc = CitizensAPI.getNPCRegistry().getById(i);
                if (npc == null) throw new ConditionFormatException("'ride-npc' is not a valid NPC ID", conditionKey);
                npcList.add(npc.getUniqueId());
            }
            condition.setNpcsWhileRiding(npcList);
        }
        if (data.contains(conditionKey + "permission")) {
            if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "permission"), String.class)) throw new ConditionFormatException("'permission' is not a list of permissions", conditionKey);
            LinkedList<String> permissions = new LinkedList<String>(data.getStringList(conditionKey + "permission"));
            condition.setPermissions(permissions);
        }
        if (data.contains(conditionKey + "hold-main-hand")) {
            temp = new LinkedList<ItemStack>();
            stackList = (List)data.get(conditionKey + "hold-main-hand");
            if (BukkitConfigUtil.checkList(stackList, ItemStack.class)) {
                for (ItemStack stack : stackList) {
                    if (stack == null) continue;
                    temp.add(stack);
                }
            }
            condition.setItemsWhileHoldingMainHand(temp);
        }
        if (data.contains(conditionKey + "wear")) {
            temp = new LinkedList();
            stackList = (List)data.get(conditionKey + "wear");
            if (BukkitConfigUtil.checkList(stackList, ItemStack.class)) {
                for (ItemStack stack : stackList) {
                    if (stack == null) continue;
                    temp.add(stack);
                }
            }
            condition.setItemsWhileWearing(temp);
        }
        if (data.contains(conditionKey + "stay-within-world")) {
            if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "stay-within-world"), String.class)) throw new ConditionFormatException("'stay-within-world' is not a list of worlds", conditionKey);
            LinkedList<String> worlds = new LinkedList<String>();
            for (String s : data.getStringList(conditionKey + "stay-within-world")) {
                World w = this.plugin.getServer().getWorld(s);
                if (w == null) {
                    throw new ConditionFormatException("'stay-within-world' is not a valid world", conditionKey);
                }
                worlds.add(s);
            }
            condition.setWorldsWhileStayingWithin(worlds);
        }
        if (data.contains(conditionKey + "stay-within-ticks")) {
            if (!data.isInt(conditionKey + "stay-within-ticks.start")) {
                throw new ConditionFormatException("'start' tick is not a number", conditionKey);
            }
            condition.setTickStartWhileStayingWithin(data.getInt(conditionKey + "stay-within-ticks.start"));
            if (!data.isInt(conditionKey + "stay-within-ticks.end")) throw new ConditionFormatException("'end' tick is not a number", conditionKey);
            condition.setTickEndWhileStayingWithin(data.getInt(conditionKey + "stay-within-ticks.end"));
        }
        if (data.contains(conditionKey + "stay-within-biome")) {
            if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "stay-within-biome"), String.class)) throw new ConditionFormatException("'stay-within-biome' is not a list of biomes", conditionKey);
            LinkedList<String> biomes = new LinkedList<String>();
            for (String s : data.getStringList(conditionKey + "stay-within-biome")) {
                Biome b = BukkitMiscUtil.getProperBiome(s);
                if (b == null) {
                    throw new ConditionFormatException("'stay-within-biome' is not a valid biome", conditionKey);
                }
                biomes.add(s);
            }
            condition.setBiomesWhileStayingWithin(biomes);
        }
        if (data.contains(conditionKey + "stay-within-region")) {
            if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "stay-within-region"), String.class)) throw new ConditionFormatException("'stay-within-region' is not a list of regions", conditionKey);
            LinkedList<String> regions = new LinkedList<String>();
            for (String region : data.getStringList(conditionKey + "stay-within-region")) {
                if (region == null) throw new ConditionFormatException("'region' has invalid WorldGuard region", conditionKey);
                boolean exists = false;
                for (World world : this.plugin.getServer().getWorlds()) {
                    if (world == null || this.plugin.getDependencies().getWorldGuardApi().getRegionManager(world) == null || !Objects.requireNonNull(this.plugin.getDependencies().getWorldGuardApi().getRegionManager(world)).hasRegion(region)) continue;
                    regions.add(region);
                    exists = true;
                    break;
                }
                if (exists) continue;
                throw new ConditionFormatException("'region' has invalid WorldGuard region name", conditionKey);
            }
            condition.setRegionsWhileStayingWithin(regions);
        }
        if (!data.contains(conditionKey + "check-placeholder-id")) return condition;
        if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "check-placeholder-id"), String.class)) {
            throw new ConditionFormatException("'check-placeholder-id' is not a list of identifiers", conditionKey);
        }
        LinkedList<String> id = new LinkedList<String>(data.getStringList(conditionKey + "check-placeholder-id"));
        condition.setPlaceholdersCheckIdentifier(id);
        if (!BukkitConfigUtil.checkList(data.getList(conditionKey + "check-placeholder-value"), String.class)) throw new ConditionFormatException("'check-placeholder-value' is not a list of values", conditionKey);
        LinkedList<String> val = new LinkedList<String>(data.getStringList(conditionKey + "check-placeholder-value"));
        condition.setPlaceholdersCheckValue(val);
        return condition;
    }
}

