/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.dependencies.BukkitDependencies;
import me.pikamug.quests.exceptions.ActionFormatException;
import me.pikamug.quests.exceptions.ConditionFormatException;
import me.pikamug.quests.exceptions.QuestFormatException;
import me.pikamug.quests.exceptions.StageFormatException;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitRequirements;
import me.pikamug.quests.quests.components.BukkitRewards;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.quests.components.Options;
import me.pikamug.quests.quests.components.Planner;
import me.pikamug.quests.storage.implementation.QuestStorageImpl;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.stack.BlockItemStack;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;

public class BukkitQuestYamlStorage
implements QuestStorageImpl {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestYamlStorage(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BukkitQuestsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "YAML";
    }

    @Override
    public void init() {
        boolean needsSaving = false;
        YamlConfiguration config = null;
        File file = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "quests.yml");
        try {
            config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (config != null) {
            ConfigurationSection questsSection;
            if (config.contains("quests")) {
                questsSection = config.getConfigurationSection("quests");
            } else {
                questsSection = config.createSection("quests");
                needsSaving = true;
            }
            if (questsSection == null) {
                this.plugin.getLogger().severe("Missing 'quests' section marker within quests.yml, canceled loading");
                return;
            }
            for (String questKey : questsSection.getKeys(false)) {
                try {
                    Quest quest = this.loadQuest(questKey);
                    if (config.contains("quests." + questKey + ".requirements")) {
                        this.loadQuestRequirements((FileConfiguration)config, questsSection, quest, questKey);
                    }
                    if (config.contains("quests." + questKey + ".planner")) {
                        this.loadQuestPlanner((FileConfiguration)config, quest, questKey);
                    }
                    if (config.contains("quests." + questKey + ".options")) {
                        this.loadQuestOptions((FileConfiguration)config, quest, questKey);
                    }
                    this.loadQuestStages(quest, (FileConfiguration)config, questKey);
                    this.loadQuestRewards((FileConfiguration)config, quest, questKey);
                    Collection<Quest> loadedQuests = this.plugin.getLoadedQuests();
                    loadedQuests.add(quest);
                    this.plugin.setLoadedQuests(loadedQuests);
                    if (!needsSaving) continue;
                    try {
                        config.save(file);
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to save Quest \"" + questKey + "\"");
                        e.printStackTrace();
                    }
                }
                catch (ActionFormatException | ConditionFormatException | QuestFormatException | StageFormatException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.plugin.getLogger().severe("Unable to load quests.yml");
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Quest loadQuest(String questId) throws QuestFormatException {
        String actionName;
        if (questId == null) {
            return null;
        }
        YamlConfiguration config = null;
        File file = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "quests.yml");
        try {
            config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (config == null) {
            return null;
        }
        BukkitQuest quest = new BukkitQuest(this.plugin);
        BukkitDependencies depends = this.plugin.getDependencies();
        quest.setId(questId);
        if (!config.contains("quests." + questId + ".name")) {
            throw new QuestFormatException("'name' is missing", questId);
        }
        quest.setName(BukkitConfigUtil.parseString(config.getString("quests." + questId + ".name"), quest));
        if (!config.contains("quests." + questId + ".ask-message")) {
            throw new QuestFormatException("'ask-message' is missing", questId);
        }
        quest.setDescription(BukkitConfigUtil.parseString(config.getString("quests." + questId + ".ask-message"), quest));
        if (!config.contains("quests." + questId + ".finish-message")) {
            throw new QuestFormatException("'finish-message' is missing", questId);
        }
        quest.setFinished(BukkitConfigUtil.parseString(config.getString("quests." + questId + ".finish-message"), quest));
        if (config.contains("quests." + questId + ".npc-giver-uuid")) {
            UUID uuid = UUID.fromString(Objects.requireNonNull(config.getString("quests." + questId + ".npc-giver-uuid")));
            quest.setNpcStart(uuid);
            Collection<UUID> npcUuids = this.plugin.getQuestNpcUuids();
            npcUuids.add(uuid);
            this.plugin.setQuestNpcUuids(npcUuids);
        } else if (depends.getNpcDependency("Citizens") != null && config.contains("quests." + questId + ".npc-giver-id")) {
            int id = config.getInt("quests." + questId + ".npc-giver-id");
            if (CitizensAPI.getNPCRegistry().getById(id) == null) throw new QuestFormatException("'npc-giver-id' has invalid NPC ID " + id, questId);
            NPC npc = CitizensAPI.getNPCRegistry().getById(id);
            quest.setNpcStart(npc.getUniqueId());
            Collection<UUID> npcUuids = this.plugin.getQuestNpcUuids();
            npcUuids.add(npc.getUniqueId());
            this.plugin.setQuestNpcUuids(npcUuids);
        }
        if (config.contains("quests." + questId + ".block-start")) {
            String blockStart = config.getString("quests." + questId + ".block-start");
            if (blockStart == null) throw new QuestFormatException("'block-start' has invalid location format", questId);
            Location location = BukkitConfigUtil.getLocation(blockStart);
            if (location == null) throw new QuestFormatException("'block-start' has invalid location", questId);
            quest.setBlockStart(location);
        }
        if (config.contains("quests." + questId + ".region") && depends.getWorldGuardApi() != null) {
            String region = config.getString("quests." + questId + ".region");
            if (region == null) throw new QuestFormatException("'region' has invalid WorldGuard region", questId);
            boolean exists = false;
            for (World world : this.plugin.getServer().getWorlds()) {
                if (world == null || depends.getWorldGuardApi().getRegionManager(world) == null || !Objects.requireNonNull(depends.getWorldGuardApi().getRegionManager(world)).hasRegion(region)) continue;
                quest.setRegionStart(region);
                exists = true;
                break;
            }
            if (!exists) {
                throw new QuestFormatException("'region' has invalid WorldGuard region name", questId);
            }
        }
        if (config.contains("quests." + questId + ".gui-display")) {
            ItemStack stack = config.getItemStack("quests." + questId + ".gui-display");
            if (stack == null) throw new QuestFormatException("'gui-display' has invalid item format", questId);
            quest.setGUIDisplay(stack);
        }
        if (config.contains("quests." + questId + ".redo-delay")) {
            if (config.getInt("quests." + questId + ".redo-delay", -999) == -999) throw new QuestFormatException("'redo-delay' is not a number", questId);
            quest.getPlanner().setCooldown((long)config.getInt("quests." + questId + ".redo-delay") * 1000L);
        }
        if (config.contains("quests." + questId + ".action")) {
            actionName = config.getString("quests." + questId + ".action");
            Optional<Action> action = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
            if (!action.isPresent()) throw new QuestFormatException("'action' failed to load", questId);
            quest.setInitialAction(action.get());
            return quest;
        } else {
            if (!config.contains("quests." + questId + ".event")) return quest;
            actionName = config.getString("quests." + questId + ".event");
            Optional<Action> action = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
            if (!action.isPresent()) throw new QuestFormatException("'event' failed to load", questId);
            quest.setInitialAction(action.get());
        }
        return quest;
    }

    public void importQuests() {
        File f = new File(this.plugin.getDataFolder(), "import");
        if (f.exists() && f.isDirectory()) {
            File[] imports = f.listFiles();
            if (imports != null) {
                for (File file : imports) {
                    if (file.isDirectory() || !file.getName().endsWith(".yml")) continue;
                    this.importQuest(file);
                }
            }
        } else if (!f.mkdir()) {
            this.plugin.getLogger().warning("Unable to create import directory");
        }
    }

    private void importQuest(File file) {
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (config != null) {
            ConfigurationSection questsSection = config.getConfigurationSection("quests");
            if (questsSection == null) {
                this.plugin.getLogger().severe("Missing 'quests' section marker, canceled import of file " + file.getName());
                return;
            }
            int count = 0;
            for (String questId : questsSection.getKeys(false)) {
                try {
                    for (Quest lq : this.plugin.getLoadedQuests()) {
                        if (!lq.getId().equals(questId)) continue;
                        throw new QuestFormatException("id already exists", questId);
                    }
                    Quest quest = this.loadQuest(questId);
                    if (config.contains("quests." + questId + ".requirements")) {
                        this.loadQuestRequirements((FileConfiguration)config, questsSection, quest, questId);
                    }
                    if (config.contains("quests." + questId + ".planner")) {
                        this.loadQuestPlanner((FileConfiguration)config, quest, questId);
                    }
                    if (config.contains("quests." + questId + ".options")) {
                        this.loadQuestOptions((FileConfiguration)config, quest, questId);
                    }
                    this.loadQuestStages(quest, (FileConfiguration)config, questId);
                    this.loadQuestRewards((FileConfiguration)config, quest, questId);
                    Collection<Quest> loadedQuests = this.plugin.getLoadedQuests();
                    loadedQuests.add(quest);
                    this.plugin.setLoadedQuests(loadedQuests);
                    ++count;
                }
                catch (ActionFormatException | ConditionFormatException | QuestFormatException | StageFormatException e) {
                    e.printStackTrace();
                }
            }
            if (count > 0) {
                this.plugin.getLogger().info("Imported " + count + " Quests from " + file.getName());
            }
        } else {
            this.plugin.getLogger().severe("Unable to import quest file " + file.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadQuestRewards(FileConfiguration config, Quest quest, String questKey) throws QuestFormatException {
        BukkitRewards rewards = (BukkitRewards)quest.getRewards();
        BukkitDependencies depends = this.plugin.getDependencies();
        if (config.contains("quests." + questKey + ".rewards.items")) {
            Object stack;
            LinkedList<ItemStack> temp = new LinkedList<ItemStack>();
            List itemList = (List)config.get("quests." + questKey + ".rewards.items");
            if (BukkitConfigUtil.checkList(itemList, ItemStack.class)) {
                for (Object item : itemList) {
                    stack = (ItemStack)item;
                    if (stack == null) continue;
                    temp.add((ItemStack)stack);
                }
            } else {
                if (!BukkitConfigUtil.checkList(itemList, String.class)) throw new QuestFormatException("Reward 'items' has invalid formatting", questKey);
                for (Object item : itemList) {
                    stack = (String)item;
                    if (stack == null) continue;
                    String[] result = ((String)stack).split(":");
                    if (result.length < 2) {
                        throw new QuestFormatException("Reward 'items' has invalid length", questKey);
                    }
                    String itemName = result[0].replace("name-", "");
                    Material itemMat = Material.matchMaterial((String)itemName);
                    int itemAmt = Integer.parseInt(result[1].replace("amount-", ""));
                    if (itemMat == null) throw new QuestFormatException("Reward 'items' has invalid name or amount " + itemName + ":" + itemAmt, questKey);
                    temp.add(new ItemStack(itemMat, itemAmt));
                }
            }
            rewards.setItems(temp);
        }
        if (config.contains("quests." + questKey + ".rewards.money")) {
            if (config.getInt("quests." + questKey + ".rewards.money", -999) == -999) throw new QuestFormatException("Reward 'money' is not a number", questKey);
            rewards.setMoney(config.getInt("quests." + questKey + ".rewards.money"));
        }
        if (config.contains("quests." + questKey + ".rewards.quest-points")) {
            if (config.getInt("quests." + questKey + ".rewards.quest-points", -999) == -999) throw new QuestFormatException("Reward 'quest-points' is not a number", questKey);
            rewards.setQuestPoints(config.getInt("quests." + questKey + ".rewards.quest-points"));
        }
        if (config.contains("quests." + questKey + ".rewards.exp")) {
            if (config.getInt("quests." + questKey + ".rewards.exp", -999) == -999) throw new QuestFormatException("Reward 'exp' is not a number", questKey);
            rewards.setExp(config.getInt("quests." + questKey + ".rewards.exp"));
        }
        if (config.contains("quests." + questKey + ".rewards.commands")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.commands"), String.class)) throw new QuestFormatException("Reward 'commands' is not a list of commands", questKey);
            rewards.setCommands(config.getStringList("quests." + questKey + ".rewards.commands"));
        }
        if (config.contains("quests." + questKey + ".rewards.commands-override-display")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.commands-override-display"), String.class)) throw new QuestFormatException("Reward 'commands-override-display' is not a list of strings", questKey);
            rewards.setCommandsOverrideDisplay(config.getStringList("quests." + questKey + ".rewards.commands-override-display"));
        }
        if (config.contains("quests." + questKey + ".rewards.permissions")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.permissions"), String.class)) throw new QuestFormatException("Reward 'permissions' is not a list of permissions", questKey);
            rewards.setPermissions(config.getStringList("quests." + questKey + ".rewards.permissions"));
        }
        if (config.contains("quests." + questKey + ".rewards.permission-worlds")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.permission-worlds"), String.class)) throw new QuestFormatException("Reward 'permission-worlds' is not a list of worlds", questKey);
            rewards.setPermissionWorlds(config.getStringList("quests." + questKey + ".rewards.permission-worlds"));
        }
        if (depends.isPluginAvailable("mcMMO") && config.contains("quests." + questKey + ".rewards.mcmmo-skills")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.mcmmo-skills"), String.class)) throw new QuestFormatException("Reward 'mcmmo-skills' is not a list of mcMMO skill names", questKey);
            if (!config.contains("quests." + questKey + ".rewards.mcmmo-levels")) throw new QuestFormatException("Reward 'mcmmo-levels' is missing!", questKey);
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.mcmmo-levels"), Integer.class)) throw new QuestFormatException("Reward 'mcmmo-levels' is not a list of numbers", questKey);
            for (String skill : config.getStringList("quests." + questKey + ".rewards.mcmmo-skills")) {
                if (depends.getMcmmoClassic() == null) {
                    throw new QuestFormatException("mcMMO not found for 'mcmmo-skills'", questKey);
                }
                if (depends.getMcMMOSkill(skill) != null) continue;
                throw new QuestFormatException("Reward 'mcmmo-skills' has invalid skill name " + skill, questKey);
            }
            rewards.setMcmmoSkills(config.getStringList("quests." + questKey + ".rewards.mcmmo-skills"));
            rewards.setMcmmoAmounts(config.getIntegerList("quests." + questKey + ".rewards.mcmmo-levels"));
        }
        if (depends.isPluginAvailable("Heroes") && config.contains("quests." + questKey + ".rewards.heroes-exp-classes")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.heroes-exp-classes"), String.class)) throw new QuestFormatException("Reward 'heroes-exp-classes' is not a list of Heroes classes", questKey);
            if (!config.contains("quests." + questKey + ".rewards.heroes-exp-amounts")) throw new QuestFormatException("Reward 'heroes-exp-amounts' is missing", questKey);
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.heroes-exp-amounts"), Double.class)) throw new QuestFormatException("Reward 'heroes-exp-amounts' is not a list of decimal numbers", questKey);
            for (String heroClass : config.getStringList("quests." + questKey + ".rewards.heroes-exp-classes")) {
                if (depends.getHeroes() == null) {
                    throw new QuestFormatException("Heroes not found for 'heroes-exp-classes'", questKey);
                }
                if (depends.getHeroes().getClassManager().getClass(heroClass) != null) continue;
                throw new QuestFormatException("Reward 'heroes-exp-classes' has invalid class name " + heroClass, questKey);
            }
            rewards.setHeroesClasses(config.getStringList("quests." + questKey + ".rewards.heroes-exp-classes"));
            rewards.setHeroesAmounts(config.getDoubleList("quests." + questKey + ".rewards.heroes-exp-amounts"));
        }
        if (depends.isPluginAvailable("Parties") && config.contains("quests." + questKey + ".rewards.parties-experience")) {
            if (config.getInt("quests." + questKey + ".rewards.parties-experience", -999) == -999) throw new QuestFormatException("Reward 'parties-experience' is not a number", questKey);
            rewards.setPartiesExperience(config.getInt("quests." + questKey + ".rewards.parties-experience"));
        }
        if (config.contains("quests." + questKey + ".rewards.phat-loots")) {
            throw new QuestFormatException("PhatLoots support has been removed. Use the module instead!", questKey);
        }
        if (!config.contains("quests." + questKey + ".rewards.details-override")) return;
        if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".rewards.details-override"), String.class)) throw new QuestFormatException("Reward 'details-override' is not a list of strings", questKey);
        rewards.setDetailsOverride(config.getStringList("quests." + questKey + ".rewards.details-override"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadQuestRequirements(FileConfiguration config, ConfigurationSection questsSection, Quest quest, String questKey) throws QuestFormatException {
        String className;
        LinkedList<String> temp;
        String failedQuest;
        List nodes;
        BukkitRequirements requires = (BukkitRequirements)quest.getRequirements();
        BukkitDependencies depends = this.plugin.getDependencies();
        if (config.contains("quests." + questKey + ".requirements.fail-requirement-message")) {
            Object o = config.get("quests." + questKey + ".requirements.fail-requirement-message");
            if (o instanceof List) {
                requires.setDetailsOverride(config.getStringList("quests." + questKey + ".requirements.fail-requirement-message"));
            } else {
                LinkedList<String> override = new LinkedList<String>();
                override.add((String)o);
                requires.setDetailsOverride(override);
            }
        }
        if (config.contains("quests." + questKey + ".requirements.items")) {
            Object stack;
            LinkedList<ItemStack> temp2 = new LinkedList<ItemStack>();
            List itemList = (List)config.get("quests." + questKey + ".requirements.items");
            if (BukkitConfigUtil.checkList(itemList, ItemStack.class)) {
                for (Object item : itemList) {
                    stack = (ItemStack)item;
                    if (stack == null) continue;
                    temp2.add((ItemStack)stack);
                }
            } else {
                if (!BukkitConfigUtil.checkList(itemList, String.class)) throw new QuestFormatException("Requirement 'items' has invalid formatting", questKey);
                for (Object item : itemList) {
                    stack = (String)item;
                    if (stack == null) continue;
                    String[] result = ((String)stack).split(":");
                    if (result.length < 1) {
                        throw new QuestFormatException("Requirement 'items' has invalid length", questKey);
                    }
                    String itemName = result[0].replace("name-", "");
                    Material itemMat = Material.matchMaterial((String)itemName);
                    int itemAmt = Integer.parseInt(result[1].replace("amount-", ""));
                    if (itemMat == null) throw new QuestFormatException("Requirement 'items' has invalid name " + itemName, questKey);
                    temp2.add(new ItemStack(itemMat, itemAmt));
                }
            }
            requires.setItems(temp2);
            if (!config.contains("quests." + questKey + ".requirements.remove-items")) throw new QuestFormatException("Requirement 'remove-items' is missing", questKey);
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.remove-items"), Boolean.class)) throw new QuestFormatException("Requirement 'remove-items' is not a list of true/false values", questKey);
            requires.setRemoveItems(config.getBooleanList("quests." + questKey + ".requirements.remove-items"));
        }
        if (config.contains("quests." + questKey + ".requirements.money")) {
            if (config.getInt("quests." + questKey + ".requirements.money", -999) == -999) throw new QuestFormatException("Requirement 'money' is not a number", questKey);
            requires.setMoney(config.getInt("quests." + questKey + ".requirements.money"));
        }
        if (config.contains("quests." + questKey + ".requirements.quest-points")) {
            if (config.getInt("quests." + questKey + ".requirements.quest-points", -999) == -999) throw new QuestFormatException("Requirement 'quest-points' is not a number", questKey);
            requires.setQuestPoints(config.getInt("quests." + questKey + ".requirements.quest-points"));
        }
        if (config.contains("quests." + questKey + ".requirements.exp")) {
            if (config.getInt("quests." + questKey + ".requirements.exp", -999) == -999) throw new QuestFormatException("Requirement 'exp' is not a number", questKey);
            requires.setExp(config.getInt("quests." + questKey + ".requirements.exp"));
        }
        if (config.contains("quests." + questKey + ".requirements.quest-blocks")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.quest-blocks"), String.class)) throw new QuestFormatException("Requirement 'quest-blocks' is not a list of quest names", questKey);
            nodes = config.getStringList("quests." + questKey + ".requirements.quest-blocks");
            boolean failed = false;
            failedQuest = "NULL";
            temp = new LinkedList<String>();
            for (String node : nodes) {
                boolean done = false;
                for (String id : questsSection.getKeys(false)) {
                    if (!id.equals(node)) continue;
                    temp.add(node);
                    done = true;
                    break;
                }
                if (done) continue;
                failed = true;
                failedQuest = node;
                break;
            }
            requires.setBlockQuestIds(temp);
            if (failed) {
                throw new QuestFormatException("Requirement 'quest-blocks' has invalid quest ID " + failedQuest, questKey);
            }
        }
        if (config.contains("quests." + questKey + ".requirements.quests")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.quests"), String.class)) throw new QuestFormatException("Requirement 'quests' is not a list of quest names", questKey);
            nodes = config.getStringList("quests." + questKey + ".requirements.quests");
            boolean failed = false;
            failedQuest = "NULL";
            temp = new LinkedList();
            for (String node : nodes) {
                boolean done = false;
                for (String id : questsSection.getKeys(false)) {
                    if (!id.equals(node)) continue;
                    temp.add(node);
                    done = true;
                    break;
                }
                if (done) continue;
                failed = true;
                failedQuest = node;
                break;
            }
            requires.setNeededQuestIds(temp);
            if (failed) {
                throw new QuestFormatException("Requirement 'quests' has invalid quest ID " + failedQuest, questKey);
            }
        }
        if (config.contains("quests." + questKey + ".requirements.permissions")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.permissions"), String.class)) throw new QuestFormatException("Requirement 'permissions' is not a list of permissions", questKey);
            requires.setPermissions(config.getStringList("quests." + questKey + ".requirements.permissions"));
        }
        if (config.contains("quests." + questKey + ".requirements.mcmmo-skills")) {
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.mcmmo-skills"), String.class)) throw new QuestFormatException("Requirement 'mcmmo-skills' is not a list of skills", questKey);
            if (!config.contains("quests." + questKey + ".requirements.mcmmo-amounts")) throw new QuestFormatException("Requirement 'mcmmo-amounts' is missing", questKey);
            if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.mcmmo-amounts"), Integer.class)) throw new QuestFormatException("Requirement 'mcmmo-amounts' is not a list of numbers", questKey);
            List skills = config.getStringList("quests." + questKey + ".requirements.mcmmo-skills");
            List amounts = config.getIntegerList("quests." + questKey + ".requirements.mcmmo-amounts");
            if (skills.size() != amounts.size()) {
                throw new QuestFormatException("Requirement 'mcmmo-skills' and 'mcmmo-amounts' are not the same size", questKey);
            }
            requires.setMcmmoSkills(skills);
            requires.setMcmmoAmounts(amounts);
        }
        if (config.contains("quests." + questKey + ".requirements.heroes-primary-class")) {
            className = config.getString("quests." + questKey + ".requirements.heroes-primary-class");
            if (depends.getHeroClass(className) != null && depends.getHeroClass(className).isPrimary()) {
                requires.setHeroesPrimaryClass(depends.getHeroClass(className).getName());
            } else {
                if (depends.getHeroClass(className) == null) throw new QuestFormatException("Requirement 'heroes-primary-class' has invalid Heroes class", questKey);
                throw new QuestFormatException("Requirement 'heroes-primary-class' is not a primary Heroes class", questKey);
            }
        }
        if (config.contains("quests." + questKey + ".requirements.heroes-secondary-class")) {
            className = config.getString("quests." + questKey + ".requirements.heroes-secondary-class");
            if (depends.getHeroClass(className) != null && depends.getHeroClass(className).isSecondary()) {
                requires.setHeroesSecondaryClass(depends.getHeroClass(className).getName());
            } else {
                if (depends.getHeroClass(className) == null) throw new QuestFormatException("Requirement 'heroes-secondary-class' has invalid Heroes class", questKey);
                throw new QuestFormatException("Requirement 'heroes-secondary-class' is not a secondary Heroes class", questKey);
            }
        }
        if (!config.contains("quests." + questKey + ".requirements.details-override")) return;
        if (!BukkitConfigUtil.checkList(config.getList("quests." + questKey + ".requirements.details-override"), String.class)) throw new QuestFormatException("Requirement 'details-override' is not a list of strings", questKey);
        requires.setDetailsOverride(config.getStringList("quests." + questKey + ".requirements.details-override"));
    }

    private void loadQuestPlanner(FileConfiguration config, Quest quest, String questKey) throws QuestFormatException {
        Planner pln = quest.getPlanner();
        if (config.contains("quests." + questKey + ".planner.start")) {
            pln.setStart(config.getString("quests." + questKey + ".planner.start"));
        }
        if (config.contains("quests." + questKey + ".planner.end")) {
            pln.setEnd(config.getString("quests." + questKey + ".planner.end"));
        }
        if (config.contains("quests." + questKey + ".planner.repeat")) {
            if (config.getInt("quests." + questKey + ".planner.repeat", -999) != -999) {
                pln.setRepeat((long)config.getInt("quests." + questKey + ".planner.repeat") * 1000L);
            } else {
                throw new QuestFormatException("Planner 'repeat' is not a number", questKey);
            }
        }
        if (config.contains("quests." + questKey + ".planner.cooldown")) {
            if (config.getInt("quests." + questKey + ".planner.cooldown", -999) != -999) {
                pln.setCooldown((long)config.getInt("quests." + questKey + ".planner.cooldown") * 1000L);
            } else {
                throw new QuestFormatException("Planner 'cooldown' is not a number", questKey);
            }
        }
        if (config.contains("quests." + questKey + ".planner.override")) {
            pln.setOverride(config.getBoolean("quests." + questKey + ".planner.override"));
        }
    }

    private void loadQuestOptions(FileConfiguration config, Quest quest, String questKey) throws QuestFormatException {
        Options opts = quest.getOptions();
        if (config.contains("quests." + questKey + ".options.allow-commands")) {
            opts.setAllowCommands(config.getBoolean("quests." + questKey + ".options.allow-commands"));
        }
        if (config.contains("quests." + questKey + ".options.allow-quitting")) {
            opts.setAllowQuitting(config.getBoolean("quests." + questKey + ".options.allow-quitting"));
        } else if (this.plugin.getConfig().contains("allow-quitting")) {
            opts.setAllowQuitting(this.plugin.getConfig().getBoolean("allow-quitting"));
        }
        if (config.contains("quests." + questKey + ".options.ignore-silk-touch")) {
            opts.setIgnoreSilkTouch(config.getBoolean("quests." + questKey + ".options.ignore-silk-touch"));
        }
        if (config.contains("quests." + questKey + ".options.external-party-plugin")) {
            opts.setExternalPartyPlugin(config.getString("quests." + questKey + ".options.external-party-plugin"));
        }
        if (config.contains("quests." + questKey + ".options.use-parties-plugin")) {
            opts.setUsePartiesPlugin(config.getBoolean("quests." + questKey + ".options.use-parties-plugin"));
        }
        if (config.contains("quests." + questKey + ".options.share-progress-level")) {
            opts.setShareProgressLevel(config.getInt("quests." + questKey + ".options.share-progress-level"));
        }
        if (config.contains("quests." + questKey + ".options.same-quest-only")) {
            opts.setShareSameQuestOnly(config.getBoolean("quests." + questKey + ".options.same-quest-only"));
        }
        if (config.contains("quests." + questKey + ".options.share-distance")) {
            opts.setShareDistance(config.getDouble("quests." + questKey + ".options.share-distance"));
        }
        if (config.contains("quests." + questKey + ".options.handle-offline-players")) {
            opts.setHandleOfflinePlayers(config.getBoolean("quests." + questKey + ".options.handle-offline-players"));
        }
        if (config.contains("quests." + questKey + ".options.ignore-block-replace")) {
            opts.setIgnoreBlockReplace(config.getBoolean("quests." + questKey + ".options.ignore-block-replace"));
        }
        if (config.contains("quests." + questKey + ".options.give-at-login")) {
            opts.setGiveGloballyAtLogin(config.getBoolean("quests." + questKey + ".options.give-at-login"));
        }
        if (config.contains("quests." + questKey + ".options.allow-stacking-global")) {
            opts.setAllowStackingGlobal(config.getBoolean("quests." + questKey + ".options.allow-stacking-global"));
        }
        if (config.contains("quests." + questKey + ".options.inform-on-start")) {
            opts.setInformOnStart(config.getBoolean("quests." + questKey + ".options.inform-on-start"));
        }
        if (config.contains("quests." + questKey + ".options.override-max-quests")) {
            opts.setOverrideMaxQuests(config.getBoolean("quests." + questKey + ".options.override-max-quests"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadQuestStages(Quest quest, FileConfiguration config, String questKey) throws StageFormatException, ActionFormatException, ConditionFormatException {
        ConfigurationSection ordered = config.getConfigurationSection("quests." + questKey + ".stages.ordered");
        if (ordered == null) {
            this.plugin.getLogger().severe(ChatColor.RED + questKey + " must have at least one stage!");
            return;
        }
        for (String stageKey : ordered.getKeys(false)) {
            Optional<Action> action;
            String actionName;
            Object locationName;
            List npcAmountsToKill;
            Collection<UUID> npcUuids;
            NPC npc;
            List itemsToConsume;
            BlockItemStack is;
            String name;
            int i;
            int stageNum;
            try {
                stageNum = Integer.parseInt(stageKey);
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().severe("Stage key " + stageKey + " must be a number!");
                continue;
            }
            BukkitStage bukkitStage = new BukkitStage();
            List breakNames = new LinkedList();
            List breakAmounts = new LinkedList();
            List breakDurability = new LinkedList();
            List damageNames = new LinkedList();
            List damageAmounts = new LinkedList();
            List damageDurability = new LinkedList();
            List placeNames = new LinkedList();
            List placeAmounts = new LinkedList();
            List placeDurability = new LinkedList();
            List useNames = new LinkedList();
            List useAmounts = new LinkedList();
            List useDurability = new LinkedList();
            List cutNames = new LinkedList();
            List cutAmounts = new LinkedList();
            List cutDurability = new LinkedList();
            LinkedList<EntityType> mobsToKill = new LinkedList<EntityType>();
            LinkedList mobNumsToKill = new LinkedList();
            LinkedList<Location> locationsToKillWithin = new LinkedList<Location>();
            LinkedList radiiToKillWithin = new LinkedList();
            LinkedList areaNames = new LinkedList();
            ConfigurationSection obj = config.getConfigurationSection(ordered.getCurrentPath() + "." + stageNum);
            if (obj == null || obj.getKeys(false).isEmpty()) {
                bukkitStage.addPasswordDisplay("2 + 2 = ?");
                bukkitStage.addPasswordPhrase("4");
                this.plugin.getLogger().severe("Stage cannot be empty, see quest " + quest.getName() + " stage " + stageNum);
                this.plugin.getLogger().severe("A generic objective has been added for you to prevent future error.");
                continue;
            }
            String path = obj.getCurrentPath();
            if (config.contains(path + ".script-to-run")) {
                if (!this.plugin.getDependencies().getDenizenApi().containsScript(config.getString(path + ".script-to-run"))) throw new StageFormatException("'script-to-run' is not a valid Denizen script", quest, stageNum);
                bukkitStage.setScript(config.getString(path + ".script-to-run"));
            }
            if (config.contains(path + ".break-block-names")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".break-block-names"), String.class)) {
                    throw new StageFormatException("'break-block-names' is not a list of strings", quest, stageNum);
                }
                breakNames = config.getStringList(path + ".break-block-names");
                if (!config.contains(path + ".break-block-amounts")) throw new StageFormatException("'break-block-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".break-block-amounts"), Integer.class)) {
                    throw new StageFormatException("'break-block-amounts' is not a list of numbers", quest, stageNum);
                }
                breakAmounts = config.getIntegerList(path + ".break-block-amounts");
                if (!config.contains(path + ".break-block-durability")) throw new StageFormatException("'break-block-durability' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".break-block-durability"), Integer.class)) throw new StageFormatException("'break-block-durability' is not a list of numbers", quest, stageNum);
                breakDurability = config.getShortList(path + ".break-block-durability");
            }
            for (i = 0; i < breakNames.size(); ++i) {
                name = (String)breakNames.get(i);
                is = i < breakDurability.size() && (Short)breakDurability.get(i) != -1 ? BukkitItemUtil.processBlockItemStack(name, (Integer)breakAmounts.get(i), (Short)breakDurability.get(i)) : BukkitItemUtil.processBlockItemStack(name, (Integer)breakAmounts.get(i), (short)0);
                if (is == null || Material.matchMaterial((String)name) == null) {
                    throw new StageFormatException("'break-block-names' has invalid item name " + name, quest, stageNum);
                }
                bukkitStage.addBlockToBreak(is);
            }
            if (config.contains(path + ".damage-block-names")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".damage-block-names"), String.class)) {
                    throw new StageFormatException("'damage-block-names' is not a list of strings", quest, stageNum);
                }
                damageNames = config.getStringList(path + ".damage-block-names");
                if (!config.contains(path + ".damage-block-amounts")) throw new StageFormatException("'damage-block-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".damage-block-amounts"), Integer.class)) {
                    throw new StageFormatException("'damage-block-amounts' is not a list of numbers", quest, stageNum);
                }
                damageAmounts = config.getIntegerList(path + ".damage-block-amounts");
                if (!config.contains(path + ".damage-block-durability")) throw new StageFormatException("'damage-block-durability' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".damage-block-durability"), Integer.class)) throw new StageFormatException("'damage-block-durability' is not a list of numbers", quest, stageNum);
                damageDurability = config.getShortList(path + ".damage-block-durability");
            }
            for (i = 0; i < damageNames.size(); ++i) {
                name = (String)damageNames.get(i);
                is = i < damageDurability.size() && (Short)damageDurability.get(i) != -1 ? BukkitItemUtil.processBlockItemStack(name, (Integer)damageAmounts.get(i), (Short)damageDurability.get(i)) : BukkitItemUtil.processBlockItemStack(name, (Integer)damageAmounts.get(i), (short)0);
                if (is == null || Material.matchMaterial((String)name) == null) {
                    throw new StageFormatException("'damage-block-names' has invalid item name " + name, quest, stageNum);
                }
                bukkitStage.addBlockToDamage(is);
            }
            if (config.contains(path + ".place-block-names")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".place-block-names"), String.class)) {
                    throw new StageFormatException("'place-block-names' is not a list of strings", quest, stageNum);
                }
                placeNames = config.getStringList(path + ".place-block-names");
                if (!config.contains(path + ".place-block-amounts")) throw new StageFormatException("'place-block-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".place-block-amounts"), Integer.class)) {
                    throw new StageFormatException("'place-block-amounts' is not a list of numbers", quest, stageNum);
                }
                placeAmounts = config.getIntegerList(path + ".place-block-amounts");
                if (!config.contains(path + ".place-block-durability")) throw new StageFormatException("'place-block-durability' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".place-block-durability"), Integer.class)) throw new StageFormatException("'place-block-durability' is not a list of numbers", quest, stageNum);
                placeDurability = config.getShortList(path + ".place-block-durability");
            }
            for (i = 0; i < placeNames.size(); ++i) {
                name = (String)placeNames.get(i);
                is = i < placeDurability.size() && (Short)placeDurability.get(i) != -1 ? BukkitItemUtil.processBlockItemStack(name, (Integer)placeAmounts.get(i), (Short)placeDurability.get(i)) : BukkitItemUtil.processBlockItemStack(name, (Integer)placeAmounts.get(i), (short)0);
                if (is == null || Material.matchMaterial((String)name) == null) {
                    throw new StageFormatException("'place-block-names' has invalid item name " + name, quest, stageNum);
                }
                bukkitStage.addBlockToPlace(is);
            }
            if (config.contains(path + ".use-block-names")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".use-block-names"), String.class)) {
                    throw new StageFormatException("'use-block-names' is not a list of strings", quest, stageNum);
                }
                useNames = config.getStringList(path + ".use-block-names");
                if (!config.contains(path + ".use-block-amounts")) throw new StageFormatException("'use-block-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".use-block-amounts"), Integer.class)) {
                    throw new StageFormatException("'use-block-amounts' is not a list of numbers", quest, stageNum);
                }
                useAmounts = config.getIntegerList(path + ".use-block-amounts");
                if (!config.contains(path + ".use-block-durability")) throw new StageFormatException("'use-block-durability' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".use-block-durability"), Integer.class)) throw new StageFormatException("'use-block-durability' is not a list of numbers", quest, stageNum);
                useDurability = config.getShortList(path + ".use-block-durability");
            }
            for (i = 0; i < useNames.size(); ++i) {
                name = (String)useNames.get(i);
                is = i < useDurability.size() && (Short)useDurability.get(i) != -1 ? BukkitItemUtil.processBlockItemStack(name, (Integer)useAmounts.get(i), (Short)useDurability.get(i)) : BukkitItemUtil.processBlockItemStack(name, (Integer)useAmounts.get(i), (short)0);
                if (is == null || Material.matchMaterial((String)name) == null) {
                    throw new StageFormatException("'use-block-names' has invalid item name " + name, quest, stageNum);
                }
                bukkitStage.addBlockToUse(is);
            }
            if (config.contains(path + ".cut-block-names")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".cut-block-names"), String.class)) {
                    throw new StageFormatException("'cut-block-names' is not a list of strings", quest, stageNum);
                }
                cutNames = config.getStringList(path + ".cut-block-names");
                if (!config.contains(path + ".cut-block-amounts")) throw new StageFormatException("'cut-block-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".cut-block-amounts"), Integer.class)) {
                    throw new StageFormatException("'cut-block-amounts' is not a list of numbers", quest, stageNum);
                }
                cutAmounts = config.getIntegerList(path + ".cut-block-amounts");
                if (!config.contains(path + ".cut-block-durability")) throw new StageFormatException("'cut-block-durability' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".cut-block-durability"), Integer.class)) throw new StageFormatException("'cut-block-durability' is not a list of numbers", quest, stageNum);
                cutDurability = config.getShortList(path + ".cut-block-durability");
            }
            for (i = 0; i < cutNames.size(); ++i) {
                name = (String)cutNames.get(i);
                is = i < cutDurability.size() && (Short)cutDurability.get(i) != -1 ? BukkitItemUtil.processBlockItemStack(name, (Integer)cutAmounts.get(i), (Short)cutDurability.get(i)) : BukkitItemUtil.processBlockItemStack(name, (Integer)cutAmounts.get(i), (short)0);
                if (is == null || Material.matchMaterial((String)name) == null) {
                    throw new StageFormatException("'cut-block-names' has invalid item name " + name, quest, stageNum);
                }
                bukkitStage.addBlockToCut(is);
            }
            if (config.contains(path + ".items-to-craft")) {
                List itemsToCraft = (List)config.get(path + ".items-to-craft");
                if (!BukkitConfigUtil.checkList(itemsToCraft, ItemStack.class)) throw new StageFormatException("'items-to-craft' is not formatted properly", quest, stageNum);
                for (ItemStack stack : itemsToCraft) {
                    if (stack == null) throw new StageFormatException("'items-to-craft' has invalid formatting", quest, stageNum);
                    bukkitStage.addItemToCraft(stack);
                }
            }
            if (config.contains(path + ".items-to-smelt")) {
                List itemsToSmelt = (List)config.get(path + ".items-to-smelt");
                if (!BukkitConfigUtil.checkList(itemsToSmelt, ItemStack.class)) throw new StageFormatException("'items-to-smelt' is not formatted properly", quest, stageNum);
                for (ItemStack stack : itemsToSmelt) {
                    if (stack == null) throw new StageFormatException("'items-to-smelt' has invalid formatting", quest, stageNum);
                    bukkitStage.addItemToSmelt(stack);
                }
            }
            if (config.contains(path + ".items-to-enchant")) {
                List itemsToEnchant = (List)config.get(path + ".items-to-enchant");
                if (BukkitConfigUtil.checkList(itemsToEnchant, ItemStack.class)) {
                    for (ItemStack stack : itemsToEnchant) {
                        if (stack == null) throw new StageFormatException("'items-to-enchant' has invalid formatting", quest, stageNum);
                        bukkitStage.addItemToEnchant(stack);
                    }
                } else {
                    LinkedList<Material> types = new LinkedList<Material>();
                    LinkedList<Enchantment> enchs = new LinkedList<Enchantment>();
                    if (config.contains(path + ".enchantments")) {
                        if (!BukkitConfigUtil.checkList(config.getList(path + ".enchantments"), String.class)) throw new StageFormatException("'enchantments' is not a list of enchantment names", quest, stageNum);
                        for (String enchant : config.getStringList(path + ".enchantments")) {
                            Enchantment e = BukkitItemUtil.getEnchantmentFromProperName(enchant);
                            if (e == null) throw new StageFormatException("'enchantments' has invalid enchantment " + enchant, quest, stageNum);
                            enchs.add(e);
                        }
                        if (!config.contains(path + ".enchantment-item-names")) throw new StageFormatException("'enchantment-item-names' is missing", quest, stageNum);
                        if (!BukkitConfigUtil.checkList(config.getList(path + ".enchantment-item-names"), String.class)) throw new StageFormatException("'enchantment-item-names' has invalid item name", quest, stageNum);
                        for (String item : config.getStringList(path + ".enchantment-item-names")) {
                            if (Material.matchMaterial((String)item) == null) throw new StageFormatException("'enchantment-item-names' has invalid item name " + item, quest, stageNum);
                            types.add(Material.matchMaterial((String)item));
                        }
                        if (!config.contains(path + ".enchantment-amounts")) throw new StageFormatException("'enchantment-amounts' is missing", quest, stageNum);
                        if (!BukkitConfigUtil.checkList(config.getList(path + ".enchantment-amounts"), Integer.class)) {
                            throw new StageFormatException("'enchantment-amounts' is not a list of numbers", quest, stageNum);
                        }
                        LinkedList amts = new LinkedList(config.getIntegerList(path + ".enchantment-amounts"));
                        if (!(enchs.isEmpty() || types.isEmpty() || amts.isEmpty())) {
                            for (int i2 = 0; i2 < enchs.size(); ++i2) {
                                ItemStack stack = new ItemStack((Material)types.get(i2), ((Integer)amts.get(i2)).intValue());
                                stack.addEnchantment((Enchantment)enchs.get(0), 1);
                                bukkitStage.addItemToEnchant(stack);
                            }
                        }
                    }
                }
            }
            if (config.contains(path + ".items-to-brew")) {
                List itemsToBrew = (List)config.get(path + ".items-to-brew");
                if (!BukkitConfigUtil.checkList(itemsToBrew, ItemStack.class)) throw new StageFormatException("'items-to-brew' has invalid formatting", quest, stageNum);
                for (ItemStack stack : itemsToBrew) {
                    if (stack == null) throw new StageFormatException("'items-to-brew' has invalid formatting", quest, stageNum);
                    bukkitStage.addItemsToBrew(stack);
                }
            }
            if (config.contains(path + ".items-to-consume") && BukkitConfigUtil.checkList(itemsToConsume = (List)config.get(path + ".items-to-consume"), ItemStack.class)) {
                for (ItemStack stack : itemsToConsume) {
                    if (stack == null) throw new StageFormatException("'items-to-consume' has invalid formatting", quest, stageNum);
                    bukkitStage.addItemToConsume(stack);
                }
            }
            if (config.contains(path + ".cows-to-milk")) {
                if (config.getInt(path + ".cows-to-milk", -999) == -999) throw new StageFormatException("'cows-to-milk' is not a number", quest, stageNum);
                bukkitStage.setCowsToMilk(config.getInt(path + ".cows-to-milk"));
            }
            if (config.contains(path + ".fish-to-catch")) {
                if (config.getInt(path + ".fish-to-catch", -999) == -999) throw new StageFormatException("'fish-to-catch' is not a number", quest, stageNum);
                bukkitStage.setFishToCatch(config.getInt(path + ".fish-to-catch"));
            }
            if (config.contains(path + ".players-to-kill")) {
                if (config.getInt(path + ".players-to-kill", -999) == -999) throw new StageFormatException("'players-to-kill' is not a number", quest, stageNum);
                bukkitStage.setPlayersToKill(config.getInt(path + ".players-to-kill"));
            }
            if (config.contains(path + ".npc-uuids-to-talk-to")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".npc-uuids-to-talk-to"), String.class)) throw new StageFormatException("'npc-uuids-to-talk-to' is not a list of numbers", quest, stageNum);
                List npcUuidsToTalkTo = config.getStringList(path + ".npc-uuids-to-talk-to");
                for (String s : npcUuidsToTalkTo) {
                    UUID uuid = UUID.fromString(s);
                    bukkitStage.addNpcToInteract(uuid);
                    Collection<UUID> npcUuids2 = this.plugin.getQuestNpcUuids();
                    npcUuids2.add(uuid);
                    this.plugin.setQuestNpcUuids(npcUuids2);
                }
            } else if (config.contains(path + ".npc-ids-to-talk-to")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".npc-ids-to-talk-to"), Integer.class)) throw new StageFormatException("'npc-ids-to-talk-to' is not a list of numbers", quest, stageNum);
                List npcIdsToTalkTo = config.getIntegerList(path + ".npc-ids-to-talk-to");
                Iterator types = npcIdsToTalkTo.iterator();
                while (types.hasNext()) {
                    int i3 = (Integer)types.next();
                    if (this.plugin.getDependencies().getNpcDependency("Citizens") == null) throw new StageFormatException("Citizens not found for 'npc-ids-to-talk-to'", quest, stageNum);
                    npc = CitizensAPI.getNPCRegistry().getById(i3);
                    if (npc == null) throw new StageFormatException("'npc-ids-to-talk-to' has invalid NPC ID of " + i3, quest, stageNum);
                    UUID npcUuid = npc.getUniqueId();
                    bukkitStage.addNpcToInteract(npcUuid);
                    npcUuids = this.plugin.getQuestNpcUuids();
                    npcUuids.add(npcUuid);
                    this.plugin.setQuestNpcUuids(npcUuids);
                }
            }
            if (config.contains(path + ".items-to-deliver")) {
                String msg;
                List deliveryMessages;
                List itemsToDeliver;
                if (config.contains(path + ".npc-delivery-uuids")) {
                    if (!BukkitConfigUtil.checkList(config.getList(path + ".npc-delivery-uuids"), String.class)) throw new StageFormatException("'npc-delivery-uuids' is not a list of numbers", quest, stageNum);
                    if (config.contains(path + ".delivery-messages")) {
                        itemsToDeliver = (List)config.get(path + ".items-to-deliver");
                        List itemDeliveryTargetUuids = config.getStringList(path + ".npc-delivery-uuids");
                        deliveryMessages = config.getStringList(path + ".delivery-messages");
                        int index = 0;
                        if (!BukkitConfigUtil.checkList(itemsToDeliver, ItemStack.class)) throw new StageFormatException("'items-to-deliver' has invalid formatting", quest, stageNum);
                        for (ItemStack stack : itemsToDeliver) {
                            if (stack == null) continue;
                            UUID npcUuid = UUID.fromString((String)itemDeliveryTargetUuids.get(index));
                            msg = deliveryMessages.size() > index ? (String)deliveryMessages.get(index) : (String)deliveryMessages.get(deliveryMessages.size() - 1);
                            ++index;
                            bukkitStage.addItemToDeliver(stack);
                            bukkitStage.addItemDeliveryTarget(npcUuid);
                            bukkitStage.addDeliverMessage(msg);
                        }
                    }
                } else {
                    if (!config.contains(path + ".npc-delivery-ids")) throw new StageFormatException("'npc-delivery-uuid' is missing", quest, stageNum);
                    if (!BukkitConfigUtil.checkList(config.getList(path + ".npc-delivery-ids"), Integer.class)) throw new StageFormatException("'npc-delivery-ids' is not a list of numbers", quest, stageNum);
                    if (config.contains(path + ".delivery-messages")) {
                        itemsToDeliver = (List)config.get(path + ".items-to-deliver");
                        List itemDeliveryTargetIds = config.getIntegerList(path + ".npc-delivery-ids");
                        deliveryMessages = config.getStringList(path + ".delivery-messages");
                        int index = 0;
                        if (!BukkitConfigUtil.checkList(itemsToDeliver, ItemStack.class)) throw new StageFormatException("'items-to-deliver' has invalid formatting", quest, stageNum);
                        for (ItemStack stack : itemsToDeliver) {
                            if (stack == null) continue;
                            int npcId = (Integer)itemDeliveryTargetIds.get(index);
                            msg = deliveryMessages.size() > index ? (String)deliveryMessages.get(index) : (String)deliveryMessages.get(deliveryMessages.size() - 1);
                            ++index;
                            if (this.plugin.getDependencies().getNpcDependency("Citizens") == null) throw new StageFormatException("Citizens not found for 'npc-delivery-ids'", quest, stageNum);
                            NPC npc2 = CitizensAPI.getNPCRegistry().getById(npcId);
                            if (npc2 == null) throw new StageFormatException("'npc-delivery-ids' has invalid NPC ID of " + npcId, quest, stageNum);
                            bukkitStage.addItemToDeliver(stack);
                            bukkitStage.addItemDeliveryTarget(npc2.getUniqueId());
                            bukkitStage.addDeliverMessage(msg);
                        }
                    }
                }
            }
            if (config.contains(path + ".npc-uuids-to-kill")) {
                if (BukkitConfigUtil.checkList(config.getList(path + ".npc-uuids-to-kill"), String.class)) {
                    if (!config.contains(path + ".npc-kill-amounts")) throw new StageFormatException("'npc-kill-amounts' is missing", quest, stageNum);
                    if (!BukkitConfigUtil.checkList(config.getList(path + ".npc-kill-amounts"), Integer.class)) throw new StageFormatException("'npc-kill-amounts' is not a list of numbers", quest, stageNum);
                    List npcUuidsToKill = config.getStringList(path + ".npc-uuids-to-kill");
                    npcAmountsToKill = config.getIntegerList(path + ".npc-kill-amounts");
                    for (String s : npcUuidsToKill) {
                        UUID npcUuid = UUID.fromString(s);
                        if ((Integer)npcAmountsToKill.get(npcUuidsToKill.indexOf(s)) <= 0) throw new StageFormatException("'npc-kill-amounts' is not a positive number", quest, stageNum);
                        bukkitStage.addNpcToKill(npcUuid);
                        bukkitStage.addNpcNumToKill((Integer)npcAmountsToKill.get(npcUuidsToKill.indexOf(s)));
                        Collection<UUID> npcUuids3 = this.plugin.getQuestNpcUuids();
                        npcUuids3.add(npcUuid);
                        this.plugin.setQuestNpcUuids(npcUuids3);
                    }
                }
            } else if (config.contains(path + ".npc-ids-to-kill") && BukkitConfigUtil.checkList(config.getList(path + ".npc-ids-to-kill"), Integer.class)) {
                if (!config.contains(path + ".npc-kill-amounts")) throw new StageFormatException("'npc-kill-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".npc-kill-amounts"), Integer.class)) throw new StageFormatException("'npc-kill-amounts' is not a list of numbers", quest, stageNum);
                List npcIdsToKill = config.getIntegerList(path + ".npc-ids-to-kill");
                npcAmountsToKill = config.getIntegerList(path + ".npc-kill-amounts");
                Iterator index = npcIdsToKill.iterator();
                while (index.hasNext()) {
                    int i4 = (Integer)index.next();
                    if (this.plugin.getDependencies().getNpcDependency("Citizens") == null) throw new StageFormatException("Citizens not found for 'npc-ids-to-kill'", quest, stageNum);
                    npc = CitizensAPI.getNPCRegistry().getById(i4);
                    if (npc == null) throw new StageFormatException("'npc-ids-to-kill' has invalid NPC ID of " + i4, quest, stageNum);
                    if ((Integer)npcAmountsToKill.get(npcIdsToKill.indexOf(i4)) <= 0) throw new StageFormatException("'npc-kill-amounts' is not a positive number", quest, stageNum);
                    UUID npcUuid = npc.getUniqueId();
                    bukkitStage.addNpcToKill(npcUuid);
                    bukkitStage.addNpcNumToKill((Integer)npcAmountsToKill.get(npcIdsToKill.indexOf(i4)));
                    npcUuids = this.plugin.getQuestNpcUuids();
                    npcUuids.add(npcUuid);
                    this.plugin.setQuestNpcUuids(npcUuids);
                }
            }
            if (config.contains(path + ".mobs-to-kill")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".mobs-to-kill"), String.class)) throw new StageFormatException("'mobs-to-kill' is not a list of mob names", quest, stageNum);
                List mobNames = config.getStringList(path + ".mobs-to-kill");
                for (String mob : mobNames) {
                    EntityType type = BukkitMiscUtil.getProperMobType(mob);
                    if (type == null) throw new StageFormatException("'mobs-to-kill' has invalid mob name " + mob, quest, stageNum);
                    mobsToKill.add(type);
                }
                if (!config.contains(path + ".mob-amounts")) throw new StageFormatException("'mob-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".mob-amounts"), Integer.class)) throw new StageFormatException("'mob-amounts' is not a list of numbers", quest, stageNum);
                mobNumsToKill.addAll(config.getIntegerList(path + ".mob-amounts"));
            }
            if (config.contains(path + ".locations-to-kill")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".locations-to-kill"), String.class)) throw new StageFormatException("'locations-to-kill' is not a list of locations", quest, stageNum);
                List locations = config.getStringList(path + ".locations-to-kill");
                for (String loc : locations) {
                    if (BukkitConfigUtil.getLocation(loc) == null) throw new StageFormatException("'locations-to-kill' has invalid formatting " + loc, quest, stageNum);
                    locationsToKillWithin.add(BukkitConfigUtil.getLocation(loc));
                }
                if (!config.contains(path + ".kill-location-radii")) throw new StageFormatException("'kill-location-radii' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".kill-location-radii"), Integer.class)) {
                    throw new StageFormatException("'kill-location-radii' is not a list of numbers", quest, stageNum);
                }
                List radii = config.getIntegerList(path + ".kill-location-radii");
                radiiToKillWithin.addAll(radii);
                if (!config.contains(path + ".kill-location-names")) throw new StageFormatException("'kill-location-names' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".kill-location-names"), String.class)) throw new StageFormatException("'kill-location-names' is not a list of names", quest, stageNum);
                List locationNames = config.getStringList(path + ".kill-location-names");
                areaNames.addAll(locationNames);
            }
            for (EntityType mobToKill : mobsToKill) {
                bukkitStage.addMobToKill(mobToKill);
            }
            for (Integer mobNumToKill : mobNumsToKill) {
                bukkitStage.addMobNumToKill(mobNumToKill);
            }
            for (Location locationToKillWithin : locationsToKillWithin) {
                bukkitStage.addLocationToKillWithin(locationToKillWithin);
            }
            for (Integer radiusToKillWithin : radiiToKillWithin) {
                bukkitStage.addRadiusToKillWithin(radiusToKillWithin);
            }
            for (String killName : areaNames) {
                bukkitStage.addKillName(killName);
            }
            if (config.contains(path + ".locations-to-reach")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".locations-to-reach"), String.class)) throw new StageFormatException("'locations-to-reach' is not a list of locations", quest, stageNum);
                List locations = config.getStringList(path + ".locations-to-reach");
                for (String loc : locations) {
                    if (BukkitConfigUtil.getLocation(loc) == null) throw new StageFormatException("'locations-to-reach' has invalid formatting" + loc, quest, stageNum);
                    bukkitStage.addLocationToReach(BukkitConfigUtil.getLocation(loc));
                }
                if (!config.contains(path + ".reach-location-radii")) throw new StageFormatException("'reach-location-radii' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".reach-location-radii"), Integer.class)) throw new StageFormatException("'reach-location-radii' is not a list of numbers", quest, stageNum);
                List radii = config.getIntegerList(path + ".reach-location-radii");
                for (Integer radius : radii) {
                    bukkitStage.addRadiusToReachWithin(radius);
                }
                if (!config.contains(path + ".reach-location-names")) throw new StageFormatException("'reach-location-names' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".reach-location-names"), String.class)) throw new StageFormatException("'reach-location-names' is not a list of names", quest, stageNum);
                List locationNames = config.getStringList(path + ".reach-location-names");
                Iterator killName = locationNames.iterator();
                while (killName.hasNext()) {
                    locationName = (String)killName.next();
                    bukkitStage.addLocationName((String)locationName);
                }
            }
            if (config.contains(path + ".mobs-to-tame")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".mobs-to-tame"), String.class)) throw new StageFormatException("'mobs-to-tame' is not a list of mob names", quest, stageNum);
                if (!config.contains(path + ".mob-tame-amounts")) throw new StageFormatException("'mob-tame-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".mob-tame-amounts"), Integer.class)) throw new StageFormatException("'mob-tame-amounts' is not a list of numbers", quest, stageNum);
                List mobs = config.getStringList(path + ".mobs-to-tame");
                List mobAmounts = config.getIntegerList(path + ".mob-tame-amounts");
                for (String mob : mobs) {
                    EntityType type = BukkitMiscUtil.getProperMobType(mob);
                    if (type == null) throw new StageFormatException("'mobs-to-tame' has invalid mob name " + mob, quest, stageNum);
                    Class ec = type.getEntityClass();
                    if (ec == null || !Tameable.class.isAssignableFrom(ec)) throw new StageFormatException("'mobs-to-tame' has invalid tameable mob " + mob, quest, stageNum);
                    bukkitStage.addMobToTame(type);
                    bukkitStage.addMobNumToTame((Integer)mobAmounts.get(mobs.indexOf(mob)));
                }
            }
            if (config.contains(path + ".sheep-to-shear")) {
                if (!BukkitConfigUtil.checkList(config.getList(path + ".sheep-to-shear"), String.class)) throw new StageFormatException("'sheep-to-shear' is not a list of colors", quest, stageNum);
                if (!config.contains(path + ".sheep-amounts")) throw new StageFormatException("'sheep-amounts' is missing", quest, stageNum);
                if (!BukkitConfigUtil.checkList(config.getList(path + ".sheep-amounts"), Integer.class)) throw new StageFormatException("'sheep-amounts' is not a list of numbers", quest, stageNum);
                List sheep = config.getStringList(path + ".sheep-to-shear");
                List shearAmounts = config.getIntegerList(path + ".sheep-amounts");
                locationName = sheep.iterator();
                while (locationName.hasNext()) {
                    DyeColor dc;
                    String originalColor;
                    String sheepColor;
                    block149: {
                        originalColor = sheepColor = (String)locationName.next();
                        dc = null;
                        if (sheepColor.equalsIgnoreCase("NULL")) {
                            dc = DyeColor.WHITE;
                        }
                        sheepColor = sheepColor.replace(" ", "_");
                        try {
                            if (dc != null) break block149;
                            for (DyeColor val : DyeColor.values()) {
                                if (!val.name().replace("_", "").equalsIgnoreCase(sheepColor.replace("_", ""))) continue;
                                dc = val;
                                break;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (dc != null) {
                        bukkitStage.addSheepToShear(dc);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_BLACK"))) {
                        bukkitStage.addSheepToShear(DyeColor.BLACK);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_BLUE"))) {
                        bukkitStage.addSheepToShear(DyeColor.BLUE);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_BROWN"))) {
                        bukkitStage.addSheepToShear(DyeColor.BROWN);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_CYAN"))) {
                        bukkitStage.addSheepToShear(DyeColor.CYAN);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_GRAY"))) {
                        bukkitStage.addSheepToShear(DyeColor.GRAY);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_GREEN"))) {
                        bukkitStage.addSheepToShear(DyeColor.GREEN);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_LIGHT_BLUE"))) {
                        bukkitStage.addSheepToShear(DyeColor.LIGHT_BLUE);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_LIME"))) {
                        bukkitStage.addSheepToShear(DyeColor.LIME);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_MAGENTA"))) {
                        bukkitStage.addSheepToShear(DyeColor.MAGENTA);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_ORANGE"))) {
                        bukkitStage.addSheepToShear(DyeColor.ORANGE);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_PINK"))) {
                        bukkitStage.addSheepToShear(DyeColor.PINK);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_PURPLE"))) {
                        bukkitStage.addSheepToShear(DyeColor.PURPLE);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_RED"))) {
                        bukkitStage.addSheepToShear(DyeColor.RED);
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_SILVER"))) {
                        bukkitStage.addSheepToShear(DyeColor.getByColor((Color)Color.SILVER));
                    } else if (sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_WHITE"))) {
                        bukkitStage.addSheepToShear(DyeColor.WHITE);
                    } else {
                        if (!sheepColor.equalsIgnoreCase(BukkitLang.get("COLOR_YELLOW"))) throw new StageFormatException("'sheep-to-shear' has invalid color " + sheepColor, quest, stageNum);
                        bukkitStage.addSheepToShear(DyeColor.YELLOW);
                    }
                    bukkitStage.addSheepNumToShear((Integer)shearAmounts.get(sheep.indexOf(originalColor)));
                }
            }
            if (config.contains(path + ".password-displays")) {
                List displays = config.getStringList(path + ".password-displays");
                if (!config.contains(path + ".password-phrases")) throw new StageFormatException("'password-phrases' is missing", quest, stageNum);
                List phrases = config.getStringList(path + ".password-phrases");
                if (displays.size() != phrases.size()) throw new StageFormatException("'password-displays' and 'password-phrases' are not the same size", quest, stageNum);
                for (int passIndex = 0; passIndex < displays.size(); ++passIndex) {
                    bukkitStage.addPasswordDisplay((String)displays.get(passIndex));
                    bukkitStage.addPasswordPhrase((String)phrases.get(passIndex));
                }
            }
            if (config.contains(path + ".objective-override")) {
                Object o = config.get(path + ".objective-override");
                if (o instanceof List) {
                    for (String objectiveOverride : config.getStringList(path + ".objective-override")) {
                        bukkitStage.addObjectiveOverride(objectiveOverride);
                    }
                } else {
                    String s = config.getString(path + ".objective-override");
                    bukkitStage.addObjectiveOverride(s);
                }
            }
            if (config.contains(path + ".start-event")) {
                actionName = config.getString(path + ".start-event");
                Optional<Action> action2 = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
                if (!action2.isPresent()) throw new StageFormatException("'start-event' failed to load", quest, stageNum);
                bukkitStage.setStartAction(action2.get());
            }
            if (config.contains(path + ".finish-event")) {
                actionName = config.getString(path + ".finish-event");
                Optional<Action> action3 = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
                if (!action3.isPresent()) throw new StageFormatException("'finish-event' failed to load", quest, stageNum);
                bukkitStage.setFinishAction(action3.get());
            }
            if (config.contains(path + ".fail-event")) {
                actionName = config.getString(path + ".fail-event");
                Optional<Action> action4 = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
                if (!action4.isPresent()) throw new StageFormatException("'fail-event' failed to load", quest, stageNum);
                bukkitStage.setFailAction(action4.get());
            }
            if (config.contains(path + ".death-event")) {
                actionName = config.getString(path + ".death-event");
                Optional<Action> action5 = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
                if (!action5.isPresent()) throw new StageFormatException("'death-event' failed to load", quest, stageNum);
                bukkitStage.setDeathAction(action5.get());
            }
            if (config.contains(path + ".disconnect-event")) {
                actionName = config.getString(path + ".disconnect-event");
                Optional<Action> action6 = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName)).findAny();
                if (!action6.isPresent()) throw new StageFormatException("'disconnect-event' failed to load", quest, stageNum);
                bukkitStage.setDisconnectAction(action6.get());
            }
            if (config.contains(path + ".chat-events")) {
                if (!config.isList(path + ".chat-events")) throw new StageFormatException("'chat-events' is not in list format", quest, stageNum);
                if (!config.contains(path + ".chat-event-triggers")) throw new StageFormatException("'chat-event-triggers' is missing", quest, stageNum);
                if (!config.isList(path + ".chat-event-triggers")) throw new StageFormatException("'chat-event-triggers' is not in list format", quest, stageNum);
                List chatEvents = config.getStringList(path + ".chat-events");
                List chatEventTriggers = config.getStringList(path + ".chat-event-triggers");
                for (int i5 = 0; i5 < chatEvents.size(); ++i5) {
                    String actionName2 = (String)chatEvents.get(i5);
                    action = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName2)).findAny();
                    if (!action.isPresent()) throw new StageFormatException("'chat-events' failed to load " + (String)chatEvents.get(i5), quest, stageNum);
                    if (i5 >= chatEventTriggers.size()) {
                        throw new StageFormatException("'chat-event-triggers' list is too small", quest, stageNum);
                    }
                    bukkitStage.addChatAction(new AbstractMap.SimpleEntry<String, Action>((String)chatEventTriggers.get(i5), action.get()));
                }
            }
            if (config.contains(path + ".command-events")) {
                if (!config.isList(path + ".command-events")) throw new StageFormatException("'command-events' is not in list format", quest, stageNum);
                if (!config.contains(path + ".command-event-triggers")) throw new StageFormatException("'command-event-triggers' is missing", quest, stageNum);
                if (!config.isList(path + ".command-event-triggers")) throw new StageFormatException("'command-event-triggers' is not in list format", quest, stageNum);
                List commandEvents = config.getStringList(path + ".command-events");
                List commandEventTriggers = config.getStringList(path + ".command-event-triggers");
                for (int i6 = 0; i6 < commandEvents.size(); ++i6) {
                    String actionName3 = (String)commandEvents.get(i6);
                    action = this.plugin.getLoadedActions().stream().filter(a -> a.getName().equals(actionName3)).findAny();
                    if (!action.isPresent()) throw new StageFormatException("'command-events' failed to load " + (String)commandEvents.get(i6), quest, stageNum);
                    if (i6 >= commandEventTriggers.size()) {
                        throw new StageFormatException("'command-event-triggers' list is too small", quest, stageNum);
                    }
                    bukkitStage.addCommandAction(new AbstractMap.SimpleEntry<String, Action>((String)commandEventTriggers.get(i6), action.get()));
                }
            }
            if (config.contains(path + ".condition")) {
                String conditionName = config.getString(path + ".condition");
                Optional<Condition> condition = this.plugin.getLoadedConditions().stream().filter(c -> c.getName().equals(conditionName)).findAny();
                if (!condition.isPresent()) throw new StageFormatException("'condition' failed to load", quest, stageNum);
                bukkitStage.setCondition(condition.get());
            }
            if (config.contains(path + ".delay")) {
                int delay = config.getInt(path + ".delay", -999);
                if (delay > 0) {
                    bukkitStage.setDelay((long)delay * 1000L);
                } else if (delay != -999) {
                    throw new StageFormatException("'delay' is not a positive number", quest, stageNum);
                }
            }
            if (config.contains(path + ".delay-message")) {
                bukkitStage.setDelayMessage(config.getString(path + ".delay-message"));
            }
            if (config.contains(path + ".start-message")) {
                bukkitStage.setStartMessage(config.getString(path + ".start-message"));
            }
            if (config.contains(path + ".complete-message")) {
                bukkitStage.setCompleteMessage(config.getString(path + ".complete-message"));
            }
            quest.getStages().add(bukkitStage);
        }
    }
}

