/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.player.BukkitQuestProgress;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.storage.implementation.QuesterStorageImpl;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitQuesterYamlStorage
implements QuesterStorageImpl {
    private final BukkitQuestsPlugin plugin;
    private final String directoryPath;

    public BukkitQuesterYamlStorage(BukkitQuestsPlugin plugin, String directoryPath) {
        this.plugin = plugin;
        this.directoryPath = directoryPath;
    }

    @Override
    public BukkitQuestsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "YAML";
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void close() {
    }

    @Override
    public Quester loadQuester(UUID uniqueId) throws IOException, InvalidConfigurationException {
        int i;
        List questIds;
        YamlConfiguration data = new YamlConfiguration();
        BukkitQuester quester = this.plugin.getQuester(uniqueId);
        if (quester != null) {
            quester.hardClear();
        } else {
            quester = new BukkitQuester(this.plugin, uniqueId);
        }
        File dataFile = this.getDataFile(quester);
        if (dataFile == null) {
            return null;
        }
        data.load(dataFile);
        if (data.contains("completedRedoableQuests")) {
            questIds = data.getStringList("completedRedoableQuests");
            List questTimes = data.getLongList("completedQuestTimes");
            ConcurrentHashMap<Quest, Long> completedTimes = quester.getCompletedTimes();
            for (i = 0; i < questIds.size(); ++i) {
                if (questTimes.size() < questIds.size()) {
                    this.plugin.getLogger().warning("completedQuestTimes was less than completedRedoableQuests while loading quester of UUID " + quester.getUUID());
                }
                if (this.plugin.getQuestById((String)questIds.get(i)) != null) {
                    completedTimes.put(this.plugin.getQuestById((String)questIds.get(i)), (Long)questTimes.get(i));
                    continue;
                }
                if (this.plugin.getQuest((String)questIds.get(i)) == null) continue;
                completedTimes.put(this.plugin.getQuest((String)questIds.get(i)), (Long)questTimes.get(i));
            }
            quester.setCompletedTimes(completedTimes);
        }
        if (data.contains("amountsCompletedQuests")) {
            questIds = data.getStringList("amountsCompletedQuests");
            List questAmounts = data.getIntegerList("amountsCompleted");
            ConcurrentHashMap<Quest, Integer> amountsCompleted = quester.getAmountsCompleted();
            for (i = 0; i < questIds.size(); ++i) {
                if (questAmounts.size() < questIds.size()) {
                    this.plugin.getLogger().warning("amountsCompleted was less than amountsCompletedQuests while loading quester of UUID " + quester.getUUID());
                }
                if (this.plugin.getQuestById((String)questIds.get(i)) != null) {
                    amountsCompleted.put(this.plugin.getQuestById((String)questIds.get(i)), (Integer)questAmounts.get(i));
                    continue;
                }
                if (this.plugin.getQuest((String)questIds.get(i)) == null) continue;
                amountsCompleted.put(this.plugin.getQuest((String)questIds.get(i)), (Integer)questAmounts.get(i));
            }
            quester.setAmountsCompleted(amountsCompleted);
        }
        quester.setLastKnownName(data.getString("lastKnownName"));
        quester.setQuestPoints(data.getInt("quest-points"));
        ConcurrentSkipListSet<Quest> completedQuests = quester.getCompletedQuests();
        if (data.isList("completed-Quests")) {
            block2: for (String s : data.getStringList("completed-Quests")) {
                for (Quest q : this.plugin.getLoadedQuests()) {
                    if (q.getId().equals(s)) {
                        if (quester.getCompletedQuests().contains(q)) continue block2;
                        completedQuests.add(q);
                        continue block2;
                    }
                    if (!q.getName().equalsIgnoreCase(s)) continue;
                    if (quester.getCompletedQuests().contains(q)) continue block2;
                    completedQuests.add(q);
                    continue block2;
                }
            }
        }
        quester.setCompletedQuests(completedQuests);
        if (!data.isString("currentQuests")) {
            List questIds2 = data.getStringList("currentQuests");
            List questStages = data.getIntegerList("currentStages");
            int maxSize = Math.min(questIds2.size(), questStages.size());
            ConcurrentHashMap<Quest, Integer> currentQuests = quester.getCurrentQuests();
            for (int i2 = 0; i2 < maxSize; ++i2) {
                if (questStages.size() < questIds2.size()) {
                    this.plugin.getLogger().warning("currentStages was less than currentQuests while loading quester of UUID " + quester.getUUID());
                }
                if (this.plugin.getQuestById((String)questIds2.get(i2)) != null) {
                    currentQuests.put(this.plugin.getQuestById((String)questIds2.get(i2)), (Integer)questStages.get(i2));
                    continue;
                }
                if (this.plugin.getQuest((String)questIds2.get(i2)) == null) continue;
                currentQuests.put(this.plugin.getQuest((String)questIds2.get(i2)), (Integer)questStages.get(i2));
            }
            quester.setCurrentQuests(currentQuests);
            ConfigurationSection dataSec = data.getConfigurationSection("questData");
            if (dataSec == null || dataSec.getKeys(false).isEmpty()) {
                return quester;
            }
            ConcurrentHashMap<Quest, BukkitQuestProgress> questProgress = new ConcurrentHashMap<Quest, BukkitQuestProgress>();
            for (String key : dataSec.getKeys(false)) {
                List npcAmounts;
                ConfigurationSection questSec = dataSec.getConfigurationSection(key);
                Quest quest = this.plugin.getQuestById(key) != null ? this.plugin.getQuestById(key) : this.plugin.getQuest(key);
                if (quest == null || !quester.getCurrentQuests().containsKey(quest)) continue;
                BukkitStage stage = (BukkitStage)quester.getCurrentStage(quest);
                if (stage == null) {
                    quest.completeQuest(quester);
                    this.plugin.getLogger().severe("[Quests] Invalid stage number for player: \"" + uniqueId + "\" on Quest \"" + quest.getName() + "\". Quest ended.");
                    continue;
                }
                quester.addEmptiesFor(quest, quester.getCurrentQuests().get(quest));
                if (questSec == null) continue;
                BukkitQuestProgress bukkitQuestProgress = (BukkitQuestProgress)quester.getQuestProgressOrDefault(quest);
                if (questSec.contains("blocks-broken-amounts")) {
                    List brokenAmounts = questSec.getIntegerList("blocks-broken-amounts");
                    bukkitQuestProgress.setBlocksBroken(new LinkedList<Integer>(brokenAmounts));
                }
                if (questSec.contains("blocks-damaged-amounts")) {
                    List damagedAmounts = questSec.getIntegerList("blocks-damaged-amounts");
                    bukkitQuestProgress.setBlocksDamaged(new LinkedList<Integer>(damagedAmounts));
                }
                if (questSec.contains("blocks-placed-amounts")) {
                    List placedAmounts = questSec.getIntegerList("blocks-placed-amounts");
                    bukkitQuestProgress.setBlocksPlaced(new LinkedList<Integer>(placedAmounts));
                }
                if (questSec.contains("blocks-used-amounts")) {
                    List usedAmounts = questSec.getIntegerList("blocks-used-amounts");
                    bukkitQuestProgress.setBlocksUsed(new LinkedList<Integer>(usedAmounts));
                }
                if (questSec.contains("blocks-cut-amounts")) {
                    List cutAmounts = questSec.getIntegerList("blocks-cut-amounts");
                    bukkitQuestProgress.setBlocksCut(new LinkedList<Integer>(cutAmounts));
                }
                if (questSec.contains("item-craft-amounts")) {
                    List craftAmounts = questSec.getIntegerList("item-craft-amounts");
                    bukkitQuestProgress.setItemsCrafted(new LinkedList<Integer>(craftAmounts));
                }
                if (questSec.contains("item-smelt-amounts")) {
                    List smeltAmounts = questSec.getIntegerList("item-smelt-amounts");
                    bukkitQuestProgress.setItemsSmelted(new LinkedList<Integer>(smeltAmounts));
                }
                if (questSec.contains("item-enchant-amounts")) {
                    List enchantAmounts = questSec.getIntegerList("item-enchant-amounts");
                    bukkitQuestProgress.setItemsEnchanted(new LinkedList<Integer>(enchantAmounts));
                }
                if (questSec.contains("item-brew-amounts")) {
                    List brewAmounts = questSec.getIntegerList("item-brew-amounts");
                    bukkitQuestProgress.setItemsBrewed(new LinkedList<Integer>(brewAmounts));
                }
                if (questSec.contains("item-consume-amounts")) {
                    List consumeAmounts = questSec.getIntegerList("item-consume-amounts");
                    bukkitQuestProgress.setItemsConsumed(new LinkedList<Integer>(consumeAmounts));
                }
                if (questSec.contains("item-delivery-amounts")) {
                    List deliveryAmounts = questSec.getIntegerList("item-delivery-amounts");
                    bukkitQuestProgress.setItemsDelivered(new LinkedList<Integer>(deliveryAmounts));
                }
                if (questSec.contains("has-talked-to")) {
                    List talkAmount = questSec.getBooleanList("has-talked-to");
                    bukkitQuestProgress.setNpcsInteracted(new LinkedList<Boolean>(talkAmount));
                }
                if (questSec.contains("npc-killed-amounts")) {
                    npcAmounts = questSec.getIntegerList("npc-killed-amounts");
                    bukkitQuestProgress.setNpcsNumKilled(new LinkedList<Integer>(npcAmounts));
                } else if (questSec.contains("citizen-amounts-killed")) {
                    npcAmounts = questSec.getIntegerList("citizen-amounts-killed");
                    bukkitQuestProgress.setNpcsNumKilled(new LinkedList<Integer>(npcAmounts));
                }
                if (questSec.contains("cows-milked")) {
                    bukkitQuestProgress.setCowsMilked(questSec.getInt("cows-milked"));
                }
                if (questSec.contains("fish-caught")) {
                    bukkitQuestProgress.setFishCaught(questSec.getInt("fish-caught"));
                }
                if (questSec.contains("players-killed")) {
                    bukkitQuestProgress.setPlayersKilled(questSec.getInt("players-killed"));
                }
                if (questSec.contains("mobs-killed-amounts")) {
                    List mobAmounts = questSec.getIntegerList("mobs-killed-amounts");
                    bukkitQuestProgress.setMobNumKilled(new LinkedList<Integer>(mobAmounts));
                }
                if (questSec.contains("has-reached-location")) {
                    List hasReached = questSec.getBooleanList("has-reached-location");
                    bukkitQuestProgress.setLocationsReached(new LinkedList<Boolean>(hasReached));
                }
                if (questSec.contains("mob-tame-amounts")) {
                    List tameAmounts = questSec.getIntegerList("mob-tame-amounts");
                    bukkitQuestProgress.setMobsTamed(new LinkedList<Integer>(tameAmounts));
                }
                if (questSec.contains("sheep-sheared")) {
                    List sheepAmounts = questSec.getIntegerList("sheep-sheared");
                    bukkitQuestProgress.setSheepSheared(new LinkedList<Integer>(sheepAmounts));
                }
                if (questSec.contains("passwords-said")) {
                    List passAmounts = questSec.getBooleanList("passwords-said");
                    bukkitQuestProgress.setPasswordsSaid(new LinkedList<Boolean>(passAmounts));
                }
                if (questSec.contains("custom-objective-counts")) {
                    List customObjCounts = questSec.getIntegerList("custom-objective-counts");
                    bukkitQuestProgress.setCustomObjectiveCounts(new LinkedList<Integer>(customObjCounts));
                }
                if (questSec.contains("stage-delay")) {
                    bukkitQuestProgress.setDelayTimeLeft(questSec.getLong("stage-delay"));
                }
                questProgress.put(quest, bukkitQuestProgress);
            }
            quester.setQuestProgress(questProgress);
        }
        return quester;
    }

    @Override
    public void saveQuester(Quester quester) throws IOException {
        FileConfiguration data = quester.getBaseData();
        data.save(new File(this.directoryPath + File.separator + quester.getUUID() + ".yml"));
    }

    @Override
    public void deleteQuester(UUID uniqueId) {
        File f = new File(this.directoryPath + File.separator + uniqueId + ".yml");
        f.delete();
    }

    @Override
    public String getQuesterLastKnownName(UUID uniqueId) {
        BukkitQuester quester = this.plugin.getQuester(uniqueId);
        if (quester != null) {
            quester.hardClear();
        } else {
            quester = new BukkitQuester(this.plugin, uniqueId);
        }
        return quester.getLastKnownName();
    }

    @Override
    public Collection<UUID> getSavedUniqueIds() {
        ConcurrentSkipListSet<UUID> ids = new ConcurrentSkipListSet<UUID>();
        File folder = new File(this.directoryPath);
        if (!folder.exists()) {
            return ids;
        }
        File[] listOfFiles = folder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (listOfFiles == null) {
            return ids;
        }
        for (File listOfFile : listOfFiles) {
            UUID id;
            if (!listOfFile.isFile()) continue;
            String name2 = listOfFile.getName().substring(0, listOfFile.getName().lastIndexOf("."));
            try {
                id = UUID.fromString(name2);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            ids.add(id);
        }
        return ids;
    }

    public File getDataFile(Quester quester) {
        File dataFile = new File(this.plugin.getDataFolder(), "data" + File.separator + quester.getUUID().toString() + ".yml");
        if (!dataFile.exists()) {
            OfflinePlayer p = quester.getOfflinePlayer();
            dataFile = new File(this.plugin.getDataFolder(), "data" + File.separator + p.getName() + ".yml");
            if (!dataFile.exists()) {
                return null;
            }
        }
        return dataFile;
    }
}

