/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.exceptions.QuestFormatException;
import me.pikamug.quests.exceptions.StageFormatException;
import me.pikamug.quests.module.BukkitCustomObjective;
import me.pikamug.quests.module.BukkitCustomRequirement;
import me.pikamug.quests.module.BukkitCustomReward;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.module.CustomRequirement;
import me.pikamug.quests.module.CustomReward;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitStage;
import me.pikamug.quests.quests.components.Requirements;
import me.pikamug.quests.quests.components.Rewards;
import me.pikamug.quests.storage.implementation.ModuleStorageImpl;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BukkitModuleJarStorage
implements ModuleStorageImpl {
    private final BukkitQuestsPlugin plugin;

    public BukkitModuleJarStorage(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BukkitQuestsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "JAR";
    }

    @Override
    public void init() {
        File f = new File(this.plugin.getDataFolder(), "modules");
        if (f.exists() && f.isDirectory()) {
            File[] modules = f.listFiles();
            if (modules != null) {
                for (File module : modules) {
                    if (module.isDirectory() || !module.getName().endsWith(".jar")) continue;
                    this.loadModule(module);
                }
            }
        } else if (!f.mkdir()) {
            this.plugin.getLogger().warning("Unable to create module directory");
        }
        YamlConfiguration config = null;
        File file = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "quests.yml");
        try {
            config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (config != null) {
            ConfigurationSection questsSection;
            if (config.contains("quests") && (questsSection = config.getConfigurationSection("quests")) != null) {
                for (String questKey : questsSection.getKeys(false)) {
                    try {
                        if (config.contains("quests." + questKey)) {
                            this.loadCustomSections(this.plugin.getQuestById(questKey), (FileConfiguration)config, questKey);
                            continue;
                        }
                        throw new QuestFormatException("Unable to load custom sections", questKey);
                    }
                    catch (QuestFormatException | StageFormatException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        } else {
            this.plugin.getLogger().severe("Unable to load module data from quests.yml");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void loadModule(File jar) {
        try {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> entry = jarFile.entries();
            URL[] urls = new URL[]{new URL("jar:file:" + jar.getPath() + "!/")};
            URLClassLoader cl = URLClassLoader.newInstance(urls, this.plugin.getClass().getClassLoader());
            int count = 0;
            while (entry.hasMoreElements()) {
                String author;
                String name;
                Optional<Object> oo;
                Constructor<Object> constructor;
                JarEntry je = entry.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                String className = je.getName().substring(0, je.getName().length() - 6).replace('/', '.');
                Class<?> c = null;
                try {
                    c = Class.forName(className, true, cl);
                }
                catch (NoClassDefFoundError e) {
                    this.plugin.getLogger().severe("Module error! Seek help from developer of jar " + jar.getName());
                    e.printStackTrace();
                }
                if (c == null) continue;
                if (BukkitCustomRequirement.class.isAssignableFrom(c)) {
                    Class<BukkitCustomRequirement> requirementClass = c.asSubclass(BukkitCustomRequirement.class);
                    constructor = requirementClass.getConstructor(new Class[0]);
                    BukkitCustomRequirement requirement = constructor.newInstance(new Object[0]);
                    oo = this.plugin.getCustomRequirement(requirement.getClass().getName());
                    List<CustomRequirement> customRequirementList = this.plugin.getCustomRequirements();
                    oo.ifPresent(customRequirementList::remove);
                    customRequirementList.add(requirement);
                    this.plugin.setCustomRequirements(customRequirementList);
                    name = requirement.getName() == null ? "[" + jar.getName() + "]" : requirement.getName();
                    author = requirement.getAuthor() == null ? "[Unknown]" : requirement.getAuthor();
                    ++count;
                    this.plugin.getLogger().info("Loaded \"" + name + "\" by " + author);
                    continue;
                }
                if (BukkitCustomReward.class.isAssignableFrom(c)) {
                    Class<BukkitCustomReward> rewardClass = c.asSubclass(BukkitCustomReward.class);
                    constructor = rewardClass.getConstructor(new Class[0]);
                    BukkitCustomReward reward = (BukkitCustomReward)constructor.newInstance(new Object[0]);
                    oo = this.plugin.getCustomReward(reward.getClass().getName());
                    List<CustomReward> customRewardList = this.plugin.getCustomRewards();
                    oo.ifPresent(customRewardList::remove);
                    customRewardList.add(reward);
                    this.plugin.setCustomRewards(customRewardList);
                    name = reward.getName() == null ? "[" + jar.getName() + "]" : reward.getName();
                    author = reward.getAuthor() == null ? "[Unknown]" : reward.getAuthor();
                    ++count;
                    this.plugin.getLogger().info("Loaded \"" + name + "\" by " + author);
                    continue;
                }
                if (!CustomObjective.class.isAssignableFrom(c)) continue;
                Class<BukkitCustomObjective> objectiveClass = c.asSubclass(BukkitCustomObjective.class);
                constructor = objectiveClass.getConstructor(new Class[0]);
                BukkitCustomObjective objective = (BukkitCustomObjective)constructor.newInstance(new Object[0]);
                oo = this.plugin.getCustomObjective(objective.getClass().getName());
                List<CustomObjective> customObjectiveList = this.plugin.getCustomObjectives();
                if (oo.isPresent() && oo.get() instanceof BukkitCustomObjective) {
                    HandlerList.unregisterAll((Listener)((BukkitCustomObjective)oo.get()));
                    customObjectiveList.remove(oo.get());
                }
                customObjectiveList.add(objective);
                this.plugin.setCustomObjectives(customObjectiveList);
                name = objective.getName() == null ? "[" + jar.getName() + "]" : objective.getName();
                author = objective.getAuthor() == null ? "[Unknown]" : objective.getAuthor();
                ++count;
                this.plugin.getLogger().info("Loaded \"" + name + "\" by " + author);
                try {
                    this.plugin.getServer().getPluginManager().registerEvents((Listener)objective, (Plugin)this.plugin);
                }
                catch (Exception ex) {
                    this.plugin.getLogger().warning("Failed to register events for custom objective \"" + name + "\". Does the objective class listen for events?");
                    ex.printStackTrace();
                }
            }
            if (count == 0) {
                this.plugin.getLogger().severe("Unable to load module from file " + jar.getName() + " (not a valid module)!");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Unable to load module from file " + jar.getName() + " (contact module developer)!");
            e.printStackTrace();
        }
    }

    private void loadCustomSections(Quest quest, FileConfiguration config, String questKey) throws StageFormatException, QuestFormatException {
        ConfigurationSection questStages = config.getConfigurationSection("quests." + questKey + ".stages.ordered");
        if (questStages != null) {
            String name;
            for (String stageNum : questStages.getKeys(false)) {
                ConfigurationSection sec;
                if (quest == null) {
                    this.plugin.getLogger().warning("Unable to consider custom objectives because quest for " + questKey + " was null");
                    return;
                }
                if (quest.getStage(Integer.parseInt(stageNum) - 1) == null) {
                    this.plugin.getLogger().severe("Unable to load custom objectives because stage" + (Integer.parseInt(stageNum) - 1) + " for " + quest.getName() + " was null");
                    return;
                }
                BukkitStage oStage = (BukkitStage)quest.getStage(Integer.parseInt(stageNum) - 1);
                oStage.clearCustomObjectives();
                oStage.clearCustomObjectiveCounts();
                oStage.clearCustomObjectiveData();
                oStage.clearCustomObjectiveDisplays();
                if (!config.contains("quests." + questKey + ".stages.ordered." + stageNum + ".custom-objectives") || (sec = config.getConfigurationSection("quests." + questKey + ".stages.ordered." + stageNum + ".custom-objectives")) == null) continue;
                for (String path : sec.getKeys(false)) {
                    name = sec.getString(path + ".name");
                    int count = sec.getInt(path + ".count");
                    Optional<Object> found = Optional.empty();
                    for (CustomObjective cr : this.plugin.getCustomObjectives()) {
                        if (!cr.getName().equalsIgnoreCase(name)) continue;
                        found = Optional.of(cr);
                        break;
                    }
                    if (found.isPresent()) {
                        oStage.addCustomObjectives((CustomObjective)found.get());
                        oStage.addCustomObjectiveCounts(Math.max(count, 0));
                        ConfigurationSection sec2 = sec.getConfigurationSection(path + ".data");
                        for (Map.Entry entry : ((CustomObjective)found.get()).getData()) {
                            Map.Entry<String, Object> data = BukkitModuleJarStorage.populateCustoms(sec2, entry);
                            oStage.addCustomObjectiveData(data);
                        }
                        continue;
                    }
                    throw new QuestFormatException(name + " custom objective not found for Stage " + stageNum, questKey);
                }
            }
            Rewards rews = quest.getRewards();
            if (config.contains("quests." + questKey + ".rewards.custom-rewards")) {
                ConfigurationSection sec = config.getConfigurationSection("quests." + questKey + ".rewards.custom-rewards");
                HashMap<String, Map<String, Object>> temp = new HashMap<String, Map<String, Object>>();
                if (sec != null) {
                    for (String path : sec.getKeys(false)) {
                        String name2 = sec.getString(path + ".name");
                        Optional<Object> found = Optional.empty();
                        for (CustomReward cr : this.plugin.getCustomRewards()) {
                            if (!cr.getName().equalsIgnoreCase(name2)) continue;
                            found = Optional.of(cr);
                            break;
                        }
                        if (found.isPresent()) {
                            ConfigurationSection sec2 = sec.getConfigurationSection(path + ".data");
                            Map<String, Object> data = BukkitModuleJarStorage.populateCustoms(sec2, ((CustomReward)found.get()).getData());
                            temp.put(name2, data);
                            continue;
                        }
                        throw new QuestFormatException(name2 + " custom reward not found", questKey);
                    }
                }
                rews.setCustomRewards(temp);
            }
            Requirements reqs = quest.getRequirements();
            if (config.contains("quests." + questKey + ".requirements.custom-requirements")) {
                ConfigurationSection sec = config.getConfigurationSection("quests." + questKey + ".requirements.custom-requirements");
                HashMap<String, Map<String, Object>> temp = new HashMap<String, Map<String, Object>>();
                if (sec != null) {
                    for (String path : sec.getKeys(false)) {
                        name = sec.getString(path + ".name");
                        Optional<Object> found = Optional.empty();
                        for (CustomRequirement cr : this.plugin.getCustomRequirements()) {
                            if (!cr.getName().equalsIgnoreCase(name)) continue;
                            found = Optional.of(cr);
                            break;
                        }
                        if (found.isPresent()) {
                            ConfigurationSection sec2 = sec.getConfigurationSection(path + ".data");
                            Map<String, Object> data = BukkitModuleJarStorage.populateCustoms(sec2, ((CustomRequirement)found.get()).getData());
                            temp.put(name, data);
                            continue;
                        }
                        throw new QuestFormatException(name + " custom requirement not found", questKey);
                    }
                }
                reqs.setCustomRequirements(temp);
            }
        }
    }

    private static Map<String, Object> populateCustoms(ConfigurationSection section, Map<String, Object> dataMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (section != null) {
            for (String key : dataMap.keySet()) {
                data.put(key, section.contains(key) ? section.get(key) : (dataMap.get(key) != null ? dataMap.get(key) : ""));
            }
        }
        return data;
    }

    private static Map.Entry<String, Object> populateCustoms(ConfigurationSection section, Map.Entry<String, Object> dataMap) {
        AbstractMap.SimpleEntry<String, Object> data = null;
        if (section != null) {
            String key = dataMap.getKey();
            Object value = dataMap.getValue();
            data = new AbstractMap.SimpleEntry<String, Object>(key, section.contains(key) ? section.get(key) : (value != null ? value : ""));
        }
        return data;
    }
}

