/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.player.BukkitQuestProgress;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.storage.implementation.QuesterStorageImpl;
import me.pikamug.quests.storage.implementation.sql.connection.ConnectionFactory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitQuesterSqlStorage
implements QuesterStorageImpl {
    private static final String PLAYER_SELECT = "SELECT lastknownname, questpoints FROM '{prefix}players' WHERE uuid=?";
    private static final String PLAYER_SELECT_UUID = "SELECT DISTINCT uuid FROM '{prefix}players'";
    private static final String PLAYER_SELECT_USERNAME = "SELECT lastknownname FROM '{prefix}players' WHERE uuid=? LIMIT 1";
    private static final String PLAYER_UPDATE_USERNAME = "UPDATE '{prefix}players' SET lastknownname=? WHERE uuid=?";
    private static final String PLAYER_INSERT = "INSERT INTO '{prefix}players' (uuid, lastknownname, questpoints) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE uuid=uuid, lastknownname=VALUES(lastknownname), questpoints=VALUES(questpoints)";
    private static final String PLAYER_DELETE = "DELETE FROM '{prefix}players' WHERE uuid=?";
    private static final String PLAYER_CURRENT_QUESTS_SELECT_BY_UUID = "SELECT questid, stageNum FROM '{prefix}player_currentquests' WHERE uuid=?";
    private static final String PLAYER_CURRENT_QUESTS_DELETE_FOR_UUID_AND_QUEST = "DELETE FROM '{prefix}player_currentquests' WHERE uuid=? AND questid=?";
    private static final String PLAYER_CURRENT_QUESTS_INSERT = "INSERT INTO '{prefix}player_currentquests' (uuid, questid, stageNum) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE uuid=uuid, questid=questid, stageNum=VALUES(stageNum)";
    private static final String PLAYER_CURRENT_QUESTS_DELETE = "DELETE FROM '{prefix}player_currentquests' WHERE uuid=?";
    private static final String PLAYER_COMPLETED_QUESTS_SELECT_BY_UUID = "SELECT questid FROM '{prefix}player_completedquests' WHERE uuid=?";
    private static final String PLAYER_COMPLETED_QUESTS_DELETE_FOR_UUID_AND_QUEST = "DELETE FROM '{prefix}player_completedquests' WHERE uuid=? AND questid=?";
    private static final String PLAYER_COMPLETED_QUESTS_INSERT = "INSERT INTO '{prefix}player_completedquests' (uuid, questid) VALUES(?, ?) ON DUPLICATE KEY UPDATE uuid=uuid, questid=questid";
    private static final String PLAYER_COMPLETED_QUESTS_DELETE = "DELETE FROM '{prefix}player_completedquests' WHERE uuid=?";
    private static final String PLAYER_REDOABLE_QUESTS_SELECT_BY_UUID = "SELECT questid, lasttime, amount FROM '{prefix}player_redoablequests' WHERE uuid=?";
    private static final String PLAYER_REDOABLE_QUESTS_DELETE_FOR_UUID_AND_QUEST = "DELETE FROM '{prefix}player_redoablequests' WHERE uuid=? AND questid=?";
    private static final String PLAYER_REDOABLE_QUESTS_INSERT = "INSERT INTO '{prefix}player_redoablequests' (uuid, questid, lasttime, amount) VALUES(?, ?, ?, ?) ON DUPLICATE KEY UPDATE uuid=uuid, questid=questid, lasttime=VALUES(lasttime), amount=VALUES(amount)";
    private static final String PLAYER_REDOABLE_QUESTS_DELETE = "DELETE FROM '{prefix}player_redoablequests' WHERE uuid=?";
    private static final String PLAYER_QUEST_PROGRESS_SELECT_BY_UUID = "SELECT * FROM '{prefix}player_questdata' WHERE uuid=?";
    private static final String PLAYER_QUEST_PROGRESS_DELETE_FOR_UUID_AND_QUEST = "DELETE FROM '{prefix}player_questdata' WHERE uuid=? AND quest_id=?";
    private static final String PLAYER_QUEST_PROGRESS_INSERT = "INSERT INTO '{prefix}player_questdata' (uuid, quest_id, blocks_broken, blocks_damaged, blocks_placed, blocks_used, blocks_cut, items_crafted, items_smelted, items_enchanted, items_brewed, items_consumed, items_delivered, npcs_interacted, npcs_killed, mobs_killed, mobs_tamed, fish_caught, cows_milked, sheep_sheared, players_killed, locations_reached, passwords_said, custom_counts, delay_start_time, delay_time_left) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE uuid=uuid, quest_id=quest_id, blocks_broken=VALUES(blocks_broken), blocks_damaged=VALUES(blocks_damaged), blocks_placed=VALUES(blocks_placed), blocks_used=VALUES(blocks_used), blocks_cut=VALUES(blocks_cut), items_crafted=VALUES(items_crafted), items_smelted=VALUES(items_smelted), items_enchanted=VALUES(items_enchanted), items_brewed=VALUES(items_brewed), items_consumed=VALUES(items_consumed), items_delivered=VALUES(items_delivered), npcs_interacted=VALUES(npcs_interacted), npcs_killed=VALUES(npcs_killed), mobs_killed=VALUES(mobs_killed), mobs_tamed=VALUES(mobs_tamed), fish_caught=VALUES(fish_caught), cows_milked=VALUES(cows_milked), sheep_sheared=VALUES(sheep_sheared), players_killed=VALUES(players_killed), locations_reached=VALUES(locations_reached), passwords_said=VALUES(passwords_said), custom_counts=VALUES(custom_counts), delay_start_time=VALUES(delay_start_time), delay_time_left=VALUES(delay_time_left)";
    private static final String PLAYER_QUEST_PROGRESS_DELETE = "DELETE FROM '{prefix}player_questdata' WHERE uuid=?";
    private final BukkitQuestsPlugin plugin;
    private final ConnectionFactory connectionFactory;
    private final Function<String, String> statementProcessor;

    public BukkitQuesterSqlStorage(BukkitQuestsPlugin plugin, ConnectionFactory connectionFactory, String tablePrefix) {
        this.plugin = plugin;
        this.connectionFactory = connectionFactory;
        this.statementProcessor = connectionFactory.getStatementProcessor().compose(s -> s.replace("{prefix}", tablePrefix));
    }

    @Override
    public BukkitQuestsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return this.connectionFactory.getImplementationName();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Function<String, String> getStatementProcessor() {
        return this.statementProcessor;
    }

    @Override
    public void init() throws Exception {
        this.connectionFactory.init(this.plugin);
        try (Connection c = this.connectionFactory.getConnection();){
            String[] queries = new String[]{"CREATE TABLE IF NOT EXISTS `" + this.statementProcessor.apply("{prefix}players") + "` (`uuid` VARCHAR(36) NOT NULL, `lastknownname` VARCHAR(16) NOT NULL, `questpoints` BIGINT NOT NULL, PRIMARY KEY (`uuid`)) DEFAULT CHARSET = utf8mb4", "CREATE TABLE IF NOT EXISTS `" + this.statementProcessor.apply("{prefix}player_currentquests") + "` (id INT AUTO_INCREMENT NOT NULL,`uuid` VARCHAR(36) NOT NULL, `questid` VARCHAR(100) NOT NULL,`stageNum` INT NOT NULL,PRIMARY KEY (`id`),UNIQUE KEY (`uuid`, `questid`)) DEFAULT CHARSET = utf8mb4", "CREATE TABLE IF NOT EXISTS `" + this.statementProcessor.apply("{prefix}player_completedquests") + "` (id INT AUTO_INCREMENT NOT NULL,`uuid` VARCHAR(36) NOT NULL, `questid` VARCHAR(100) NOT NULL,PRIMARY KEY (`id`),UNIQUE KEY (`uuid`, `questid`)) DEFAULT CHARSET = utf8mb4", "CREATE TABLE IF NOT EXISTS `" + this.statementProcessor.apply("{prefix}player_redoablequests") + "` (id INT AUTO_INCREMENT NOT NULL,`uuid` VARCHAR(36) NOT NULL, `questid` VARCHAR(100) NOT NULL,`lasttime` BIGINT NOT NULL,`amount` INT NOT NULL,PRIMARY KEY (`id`),UNIQUE KEY (`uuid`, `questid`)) DEFAULT CHARSET = utf8mb4", "CREATE TABLE IF NOT EXISTS `" + this.statementProcessor.apply("{prefix}player_questdata") + "` (id INT AUTO_INCREMENT NOT NULL,`uuid` VARCHAR(36) NOT NULL,  `quest_id` VARCHAR(100) NOT NULL,`blocks_broken` VARCHAR(100) NULL,`blocks_damaged` VARCHAR(100) NULL,`blocks_placed` VARCHAR(100) NULL,`blocks_used` VARCHAR(100) NULL,`blocks_cut` VARCHAR(100) NULL,`items_crafted` VARCHAR(100) NULL,`items_smelted` VARCHAR(100) NULL,`items_enchanted` VARCHAR(100) NULL,`items_brewed` VARCHAR(100) NULL,`items_consumed` VARCHAR(100) NULL,`items_delivered` VARCHAR(100) NULL,`npcs_interacted` VARCHAR(100) NULL,`npcs_killed` VARCHAR(100) NULL,`mobs_killed` VARCHAR(100) NULL,`mobs_tamed` VARCHAR(100) NULL,`fish_caught` INT NULL,`cows_milked` INT NULL,`sheep_sheared` VARCHAR(100) NULL,`players_killed` INT NULL,`locations_reached` VARCHAR(100) NULL,`passwords_said` VARCHAR(100) NULL,`custom_counts` VARCHAR(100) NULL,`delay_start_time` BIGINT NULL,`delay_time_left` BIGINT NULL,PRIMARY KEY (`id`),UNIQUE KEY (`uuid`, `quest_id`)) DEFAULT CHARSET = utf8mb4"};
            try (Statement s = c.createStatement();){
                for (String query : queries) {
                    try {
                        s.execute(query);
                    }
                    catch (SQLException e) {
                        if (e.getMessage().contains("Unknown character set")) {
                            s.execute(query.replace("utf8mb4", "utf8"));
                            continue;
                        }
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        try {
            this.connectionFactory.close();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Problem occurred while closing SQL storage");
            e.printStackTrace();
        }
    }

    @Override
    public Quester loadQuester(@NotNull UUID uniqueId) throws Exception {
        BukkitQuester quester = this.plugin.getQuester(uniqueId);
        if (quester == null) {
            return null;
        }
        try (Connection c = this.connectionFactory.getConnection();){
            try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT));){
                ps.setString(1, uniqueId.toString());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        quester.setLastKnownName(rs.getString("lastknownname"));
                        quester.setQuestPoints(rs.getInt("questpoints"));
                    }
                }
            }
            quester.setCurrentQuests(this.getQuesterCurrentQuests(uniqueId));
            quester.setCompletedQuests(this.getQuesterCompletedQuests(uniqueId));
            quester.setCompletedTimes(this.getQuesterCompletedTimes(uniqueId));
            quester.setAmountsCompleted(this.getQuesterAmountsCompleted(uniqueId));
            quester.setQuestProgress(this.getQuesterQuestProgress(uniqueId));
        }
        return quester;
    }

    @Override
    public void saveQuester(Quester quester) throws SQLException {
        block79: {
            BukkitQuester bukkitQuester = (BukkitQuester)quester;
            UUID uniqueId = bukkitQuester.getUUID();
            String lastKnownName = bukkitQuester.getLastKnownName();
            String oldLastKnownName = this.getQuesterLastKnownName(uniqueId);
            Set currentQuests = bukkitQuester.getCurrentQuests().keySet().stream().map(Quest::getId).collect(Collectors.toSet());
            Set oldCurrentQuests = this.getQuesterCurrentQuests(uniqueId).keySet().stream().map(Quest::getId).collect(Collectors.toSet());
            oldCurrentQuests.removeAll(currentQuests);
            Set completedQuests = bukkitQuester.getCompletedQuests().stream().map(Quest::getId).collect(Collectors.toSet());
            Set oldCompletedQuests = this.getQuesterCompletedQuests(uniqueId).stream().map(Quest::getId).collect(Collectors.toSet());
            oldCompletedQuests.removeAll(completedQuests);
            Set redoableQuests = bukkitQuester.getCompletedTimes().keySet().stream().map(Quest::getId).collect(Collectors.toSet());
            Set oldRedoableQuests = this.getQuesterCompletedTimes(uniqueId).keySet().stream().map(Quest::getId).collect(Collectors.toSet());
            oldRedoableQuests.removeAll(redoableQuests);
            Set questProgress = bukkitQuester.getQuestProgress().keySet().stream().map(Quest::getId).collect(Collectors.toSet());
            Set oldQuestData = this.getQuesterQuestProgress(uniqueId).keySet().stream().map(Quest::getId).collect(Collectors.toSet());
            oldQuestData.removeAll(questProgress);
            try (Connection c = this.connectionFactory.getConnection();){
                PreparedStatement ps;
                if (oldLastKnownName != null && lastKnownName != null && !lastKnownName.equals(oldLastKnownName)) {
                    try (PreparedStatement ps2 = c.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_USERNAME));){
                        ps2.setString(1, lastKnownName);
                        ps2.setString(2, uniqueId.toString());
                        ps2.execute();
                    }
                }
                try (PreparedStatement ps2 = c.prepareStatement(this.statementProcessor.apply(PLAYER_INSERT));){
                    ps2.setString(1, uniqueId.toString());
                    ps2.setString(2, lastKnownName != null ? lastKnownName : "unspecified");
                    ps2.setInt(3, bukkitQuester.getQuestPoints());
                    ps2.execute();
                }
                if (!oldCurrentQuests.isEmpty()) {
                    for (String string : oldCurrentQuests) {
                        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_CURRENT_QUESTS_DELETE_FOR_UUID_AND_QUEST));
                        try {
                            ps.setString(1, uniqueId.toString());
                            ps.setString(2, string);
                            ps.execute();
                        }
                        finally {
                            if (ps == null) continue;
                            ps.close();
                        }
                    }
                } else {
                    for (Map.Entry entry : bukkitQuester.getCurrentQuests().entrySet()) {
                        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_CURRENT_QUESTS_INSERT));
                        try {
                            ps.setString(1, uniqueId.toString());
                            ps.setString(2, ((Quest)entry.getKey()).getId());
                            ps.setInt(3, (Integer)entry.getValue());
                            ps.execute();
                        }
                        finally {
                            if (ps == null) continue;
                            ps.close();
                        }
                    }
                }
                if (!oldCompletedQuests.isEmpty()) {
                    for (String string : oldCompletedQuests) {
                        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_COMPLETED_QUESTS_DELETE_FOR_UUID_AND_QUEST));
                        try {
                            ps.setString(1, uniqueId.toString());
                            ps.setString(2, string);
                            ps.execute();
                        }
                        finally {
                            if (ps == null) continue;
                            ps.close();
                        }
                    }
                } else {
                    for (Quest quest : bukkitQuester.getCompletedQuests()) {
                        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_COMPLETED_QUESTS_INSERT));
                        try {
                            ps.setString(1, uniqueId.toString());
                            ps.setString(2, quest.getId());
                            ps.execute();
                        }
                        finally {
                            if (ps == null) continue;
                            ps.close();
                        }
                    }
                }
                if (!oldRedoableQuests.isEmpty()) {
                    for (String string : oldRedoableQuests) {
                        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_REDOABLE_QUESTS_DELETE_FOR_UUID_AND_QUEST));
                        try {
                            ps.setString(1, uniqueId.toString());
                            ps.setString(2, string);
                            ps.execute();
                        }
                        finally {
                            if (ps == null) continue;
                            ps.close();
                        }
                    }
                } else {
                    for (Map.Entry entry : bukkitQuester.getCompletedTimes().entrySet()) {
                        if (entry.getKey() == null) {
                            this.plugin.getLogger().severe("Quest was null for completed times of quester " + bukkitQuester.getUUID());
                            return;
                        }
                        if (!bukkitQuester.getAmountsCompleted().containsKey(entry.getKey()) || bukkitQuester.getAmountsCompleted().get(entry.getKey()) == null) {
                            this.plugin.getLogger().warning("Quester " + bukkitQuester.getUUID() + " is missing amounts completed for quest ID " + ((Quest)entry.getKey()).getId());
                            return;
                        }
                        int amount = bukkitQuester.getAmountsCompleted().get(entry.getKey());
                        PreparedStatement ps3 = c.prepareStatement(this.statementProcessor.apply(PLAYER_REDOABLE_QUESTS_INSERT));
                        try {
                            ps3.setString(1, uniqueId.toString());
                            ps3.setString(2, ((Quest)entry.getKey()).getId());
                            ps3.setLong(3, (Long)entry.getValue());
                            ps3.setInt(4, amount);
                            ps3.execute();
                        }
                        finally {
                            if (ps3 == null) continue;
                            ps3.close();
                        }
                    }
                }
                if (!oldQuestData.isEmpty()) {
                    for (String string : oldQuestData) {
                        PreparedStatement ps4 = c.prepareStatement(this.statementProcessor.apply(PLAYER_QUEST_PROGRESS_DELETE_FOR_UUID_AND_QUEST));
                        try {
                            ps4.setString(1, uniqueId.toString());
                            ps4.setString(2, string);
                            ps4.execute();
                        }
                        finally {
                            if (ps4 == null) continue;
                            ps4.close();
                        }
                    }
                    break block79;
                }
                for (Map.Entry entry : bukkitQuester.getQuestProgress().entrySet()) {
                    PreparedStatement ps5 = c.prepareStatement(this.statementProcessor.apply(PLAYER_QUEST_PROGRESS_INSERT));
                    try {
                        ps5.setString(1, uniqueId.toString());
                        ps5.setString(2, ((Quest)entry.getKey()).getId());
                        ps5.setString(3, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getBlocksBroken()));
                        ps5.setString(4, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getBlocksDamaged()));
                        ps5.setString(5, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getBlocksPlaced()));
                        ps5.setString(6, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getBlocksUsed()));
                        ps5.setString(7, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getBlocksCut()));
                        ps5.setString(8, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getItemsCrafted()));
                        ps5.setString(9, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getItemsSmelted()));
                        ps5.setString(10, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getItemsEnchanted()));
                        ps5.setString(11, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getItemsBrewed()));
                        ps5.setString(12, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getItemsConsumed()));
                        ps5.setString(13, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getItemsDelivered()));
                        ps5.setString(14, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getNpcsInteracted()));
                        ps5.setString(15, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getNpcsNumKilled()));
                        ps5.setString(16, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getMobNumKilled()));
                        ps5.setString(17, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getMobsTamed()));
                        ps5.setInt(18, ((BukkitQuestProgress)entry.getValue()).getFishCaught());
                        ps5.setInt(19, ((BukkitQuestProgress)entry.getValue()).getCowsMilked());
                        ps5.setString(20, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getSheepSheared()));
                        ps5.setInt(21, ((BukkitQuestProgress)entry.getValue()).getPlayersKilled());
                        ps5.setString(22, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getLocationsReached()));
                        ps5.setString(23, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getPasswordsSaid()));
                        ps5.setString(24, this.serializeProgress(((BukkitQuestProgress)entry.getValue()).getCustomObjectiveCounts()));
                        ps5.setLong(25, ((BukkitQuestProgress)entry.getValue()).getDelayStartTime());
                        ps5.setLong(26, ((BukkitQuestProgress)entry.getValue()).getDelayTimeLeft());
                        ps5.execute();
                    }
                    finally {
                        if (ps5 == null) continue;
                        ps5.close();
                    }
                }
            }
        }
    }

    @Override
    public void deleteQuester(UUID uniqueId) throws Exception {
        try (Connection c = this.connectionFactory.getConnection();){
            try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_DELETE));){
                ps.setString(1, uniqueId.toString());
                ps.execute();
            }
            ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_CURRENT_QUESTS_DELETE));
            try {
                ps.setString(1, uniqueId.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_COMPLETED_QUESTS_DELETE));
            try {
                ps.setString(1, uniqueId.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_REDOABLE_QUESTS_DELETE));
            try {
                ps.setString(1, uniqueId.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_QUEST_PROGRESS_DELETE));
            try {
                ps.setString(1, uniqueId.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    @Override
    @Nullable
    public String getQuesterLastKnownName(UUID uniqueId) throws SQLException {
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_USERNAME));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString("lastknownname");
                    return string;
                }
            }
        }
        return null;
    }

    public ConcurrentHashMap<Quest, Integer> getQuesterCurrentQuests(UUID uniqueId) throws SQLException {
        ConcurrentHashMap<Quest, Integer> currentQuests = new ConcurrentHashMap<Quest, Integer>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_CURRENT_QUESTS_SELECT_BY_UUID));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Quest quest = this.plugin.getQuestById(rs.getString("questid"));
                    if (quest == null) continue;
                    currentQuests.put(quest, rs.getInt("stageNum"));
                }
            }
        }
        return currentQuests;
    }

    public ConcurrentHashMap<Quest, BukkitQuestProgress> getQuesterQuestProgress(UUID uniqueId) throws SQLException {
        BukkitQuester quester = this.plugin.getQuester(uniqueId);
        ConcurrentHashMap<Quest, BukkitQuestProgress> questProgress = new ConcurrentHashMap<Quest, BukkitQuestProgress>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_QUEST_PROGRESS_SELECT_BY_UUID));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Quest quest = this.plugin.getQuestById(rs.getString("quest_id"));
                    BukkitQuestProgress data = new BukkitQuestProgress(quester);
                    if (quest == null || quester.getCurrentStage(quest) == null) continue;
                    data.blocksBroken.addAll(this.deserializeIntProgress(rs.getString("blocks_broken")));
                    data.blocksDamaged.addAll(this.deserializeIntProgress(rs.getString("blocks_damaged")));
                    data.blocksPlaced.addAll(this.deserializeIntProgress(rs.getString("blocks_placed")));
                    data.blocksUsed.addAll(this.deserializeIntProgress(rs.getString("blocks_used")));
                    data.blocksCut.addAll(this.deserializeIntProgress(rs.getString("blocks_cut")));
                    data.itemsCrafted.addAll(this.deserializeIntProgress(rs.getString("items_crafted")));
                    data.itemsSmelted.addAll(this.deserializeIntProgress(rs.getString("items_smelted")));
                    data.itemsEnchanted.addAll(this.deserializeIntProgress(rs.getString("items_enchanted")));
                    data.itemsBrewed.addAll(this.deserializeIntProgress(rs.getString("items_brewed")));
                    data.itemsConsumed.addAll(this.deserializeIntProgress(rs.getString("items_consumed")));
                    data.itemsDelivered.addAll(this.deserializeIntProgress(rs.getString("items_delivered")));
                    data.npcsInteracted.addAll(this.deserializeBooleanProgress(rs.getString("npcs_interacted")));
                    data.npcsNumKilled.addAll(this.deserializeIntProgress(rs.getString("npcs_killed")));
                    data.mobNumKilled.addAll(this.deserializeIntProgress(rs.getString("mobs_killed")));
                    data.mobsTamed.addAll(this.deserializeIntProgress(rs.getString("mobs_tamed")));
                    data.setFishCaught(rs.getInt("fish_caught"));
                    data.setCowsMilked(rs.getInt("cows_milked"));
                    data.sheepSheared.addAll(this.deserializeIntProgress(rs.getString("sheep_sheared")));
                    data.setPlayersKilled(rs.getInt("players_killed"));
                    data.locationsReached.addAll(this.deserializeBooleanProgress(rs.getString("locations_reached")));
                    data.passwordsSaid.addAll(this.deserializeBooleanProgress(rs.getString("passwords_said")));
                    data.customObjectiveCounts.addAll(this.deserializeIntProgress(rs.getString("custom_counts")));
                    data.setDelayStartTime(rs.getLong("delay_start_time"));
                    data.setDelayTimeLeft(rs.getLong("delay_time_left"));
                    questProgress.put(quest, data);
                }
            }
        }
        return questProgress;
    }

    public ConcurrentSkipListSet<Quest> getQuesterCompletedQuests(UUID uniqueId) throws SQLException {
        ConcurrentSkipListSet<Quest> completedQuests = new ConcurrentSkipListSet<Quest>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_COMPLETED_QUESTS_SELECT_BY_UUID));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Quest quest = this.plugin.getQuestById(rs.getString("questid"));
                    if (quest == null) continue;
                    completedQuests.add(quest);
                }
            }
        }
        return completedQuests;
    }

    public ConcurrentHashMap<Quest, Long> getQuesterCompletedTimes(UUID uniqueId) throws SQLException {
        ConcurrentHashMap<Quest, Long> completedTimes = new ConcurrentHashMap<Quest, Long>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_REDOABLE_QUESTS_SELECT_BY_UUID));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Quest quest = this.plugin.getQuestById(rs.getString("questid"));
                    if (quest == null) continue;
                    completedTimes.put(quest, rs.getLong("lasttime"));
                }
            }
        }
        return completedTimes;
    }

    public ConcurrentHashMap<Quest, Integer> getQuesterAmountsCompleted(UUID uniqueId) throws SQLException {
        ConcurrentHashMap<Quest, Integer> amountsCompleted = new ConcurrentHashMap<Quest, Integer>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_REDOABLE_QUESTS_SELECT_BY_UUID));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Quest quest = this.plugin.getQuestById(rs.getString("questid"));
                    if (quest == null) continue;
                    amountsCompleted.put(quest, rs.getInt("amount"));
                }
            }
        }
        return amountsCompleted;
    }

    @Override
    public Collection<UUID> getSavedUniqueIds() throws SQLException {
        ConcurrentSkipListSet<UUID> ids = new ConcurrentSkipListSet<UUID>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_UUID));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                UUID id;
                try {
                    id = UUID.fromString(rs.getString("uuid"));
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                ids.add(id);
            }
        }
        return ids;
    }

    public String serializeProgress(LinkedList<?> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return String.valueOf(list.get(0));
        }
        return list.stream().map(String::valueOf).collect(Collectors.joining(",", "{", "}"));
    }

    public LinkedList<Integer> deserializeIntProgress(String string) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (string != null) {
            string = string.replace("{", "").replace("}", "");
            for (String section : string.split(",")) {
                list.add(Integer.parseInt(section));
            }
        }
        return list;
    }

    public LinkedList<Boolean> deserializeBooleanProgress(String string) {
        LinkedList<Boolean> list = new LinkedList<Boolean>();
        if (string != null) {
            string = string.replace("{", "").replace("}", "");
            for (String section : string.split(",")) {
                list.add(Boolean.parseBoolean(section));
            }
        }
        return list;
    }

    @Deprecated
    public String serializeItemStackProgress(LinkedList<ItemStack> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return String.valueOf(list.get(0).getAmount());
        }
        return list.stream().map(n -> String.valueOf(n.getAmount())).collect(Collectors.joining(",", "{", "}"));
    }

    @Deprecated
    public LinkedList<ItemStack> deserializeItemStackProgress(String string, LinkedList<ItemStack> objective) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (string != null) {
            string = string.replace("{", "").replace("}", "");
            int index = 0;
            for (String section : string.split(",")) {
                if (index >= objective.size()) break;
                int amt = Integer.parseInt(section);
                ItemStack is = objective.get(index);
                ItemStack temp = new ItemStack(is.getType(), amt, is.getDurability());
                temp.addUnsafeEnchantments(is.getEnchantments());
                temp.setItemMeta(is.getItemMeta());
                list.add(temp);
                ++index;
            }
        }
        return list;
    }
}

