/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.storage.implementation.sql.connection.hikari;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.pikamug.quests.Quests;
import me.pikamug.quests.libs.hikari.HikariConfig;
import me.pikamug.quests.libs.hikari.HikariDataSource;
import me.pikamug.quests.storage.implementation.sql.connection.ConnectionFactory;
import me.pikamug.quests.storage.misc.StorageCredentials;

public abstract class HikariConnectionFactory
implements ConnectionFactory {
    private final StorageCredentials configuration;
    private HikariDataSource hikari;

    public HikariConnectionFactory(StorageCredentials configuration) {
        this.configuration = configuration;
    }

    protected abstract String defaultPort();

    protected abstract void configureDatabase(HikariConfig var1, String var2, String var3, String var4, String var5, String var6);

    protected void overrideProperties(Map<String, String> properties) {
        properties.putIfAbsent("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    }

    protected void setProperties(HikariConfig config, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            config.addDataSourceProperty(property.getKey(), property.getValue());
        }
    }

    @Override
    public void init(Quests plugin) {
        HikariConfig config = new HikariConfig();
        config.setPoolName("quests-hikari");
        String[] addressSplit = this.configuration.getAddress().split(":");
        String address = addressSplit[0];
        String port = addressSplit.length > 1 ? addressSplit[1] : this.defaultPort();
        this.configureDatabase(config, address, port, this.configuration.getDatabase(), this.configuration.getUsername(), this.configuration.getPassword());
        HashMap<String, String> properties = new HashMap<String, String>(this.configuration.getProperties());
        this.overrideProperties(properties);
        this.setProperties(config, properties);
        config.setMaximumPoolSize(this.configuration.getMaxPoolSize());
        config.setMinimumIdle(this.configuration.getMinIdleConnections());
        config.setMaxLifetime(this.configuration.getMaxLifetime());
        config.setConnectionTimeout(this.configuration.getConnectionTimeout());
        this.hikari = new HikariDataSource(config);
    }

    @Override
    public void close() {
        if (this.hikari != null) {
            this.hikari.close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.hikari == null) {
            throw new SQLException("Unable to get a connection from the pool because hikari is null");
        }
        Connection connection = this.hikari.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get a connection from the pool because getConnection returned null");
        }
        return connection;
    }
}

