/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.tasks;

import java.util.Map;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.events.quester.BukkitQuesterPostViewEffectEvent;
import me.pikamug.quests.nms.BukkitParticleProvider;
import me.pikamug.quests.player.BukkitQuester;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BukkitNpcEffectThread
implements Runnable {
    final BukkitQuestsPlugin plugin;

    public BukkitNpcEffectThread(BukkitQuestsPlugin quests) {
        this.plugin = quests;
    }

    @Override
    public void run() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            for (BukkitNpcDependency npcDependency : this.plugin.getDependencies().getNpcDependencies()) {
                Map<UUID, Location> npcLocations = npcDependency.getNpcsByNearbyLocationSquared(player.getLocation(), 24.0);
                for (Map.Entry<UUID, Location> entry : npcLocations.entrySet()) {
                    this.showConfigEffect(this.plugin.getQuester(player.getUniqueId()), entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void showConfigEffect(BukkitQuester quester, UUID targetUuid, Location targetLocation) {
        if (targetUuid != null) {
            targetLocation.add(0.0, 2.0, 0.0);
            if (quester.canAcceptQuest(targetUuid)) {
                this.showEffect(quester.getPlayer(), targetLocation, this.plugin.getConfigSettings().getEffect());
                BukkitQuesterPostViewEffectEvent event = new BukkitQuesterPostViewEffectEvent(quester, targetUuid, targetLocation, this.plugin.getConfigSettings().getEffect(), false);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
            } else if (quester.canAcceptCompletedRedoableQuest(targetUuid)) {
                this.showEffect(quester.getPlayer(), targetLocation, this.plugin.getConfigSettings().getRedoEffect());
                BukkitQuesterPostViewEffectEvent event = new BukkitQuesterPostViewEffectEvent(quester, targetUuid, targetLocation, this.plugin.getConfigSettings().getRedoEffect(), true);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
            }
        }
    }

    public void showEffect(Player player, Location location, String effectType) {
        if (player == null || location == null) {
            return;
        }
        try {
            BukkitParticleProvider.sendToPlayer(player, location, effectType.toUpperCase());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

