/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.tasks;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;

public class BukkitStageTimer
implements Runnable {
    private final Quester quester;
    private final BukkitQuestsPlugin plugin;
    private final Quest quest;

    public BukkitStageTimer(BukkitQuestsPlugin plugin, Quester quester, Quest quest) {
        this.quester = quester;
        this.quest = quest;
        this.plugin = plugin;
    }

    @Override
    public void run() {
        if (this.quester == null) {
            return;
        }
        if (this.quester.getQuestProgressOrDefault(this.quest) == null) {
            return;
        }
        if (this.quester.getCurrentStage(this.quest) == null) {
            return;
        }
        if (!this.quester.testComplete(this.quest)) {
            return;
        }
        if (this.quester.getCurrentStage(this.quest).getFinishAction() != null) {
            this.quester.getCurrentStage(this.quest).getFinishAction().fire(this.quester, this.quest);
        }
        if (this.quest.getStages().indexOf(this.quester.getCurrentStage(this.quest)) == this.quest.getStages().size() - 1) {
            if (this.quester.getCurrentStage(this.quest).getScript() != null) {
                this.plugin.getDependencies().runDenizenScript(this.quester.getCurrentStage(this.quest).getScript(), this.quester, null);
            }
            this.quest.completeQuest(this.quester);
        } else {
            int stageNum = this.quester.getCurrentQuests().get(this.quest) + 1;
            this.quester.getQuestProgressOrDefault(this.quest).setDelayStartTime(0L);
            this.quester.getQuestProgressOrDefault(this.quest).setDelayTimeLeft(-1L);
            try {
                this.quest.setStage(this.quester, stageNum);
            }
            catch (IndexOutOfBoundsException e) {
                this.plugin.getLogger().severe("Unable to set stage of quest " + this.quest.getName() + " to Stage " + stageNum + " after delay");
            }
        }
        this.quester.updateJournal();
    }
}

