/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.util;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.dependencies.BukkitDependencies;
import me.pikamug.quests.dependencies.npc.BukkitNpcDependency;
import me.pikamug.quests.quests.Quest;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BukkitConfigUtil {
    private static final Pattern hexPattern = Pattern.compile("(?i)%#([0-9A-F]{6})%");

    public static boolean checkList(List<?> list, Class<?> clazz) {
        if (list == null || clazz == null) {
            return false;
        }
        for (Object o : list) {
            if (o == null) {
                Bukkit.getLogger().severe(clazz.getSimpleName() + " type in Quests file was \"null\"");
                return false;
            }
            if (clazz.isAssignableFrom(o.getClass())) continue;
            return false;
        }
        return true;
    }

    public static Location getLocation(String arg) {
        double z;
        double y;
        double x;
        String[] info = arg.split(" ");
        if (info.length < 4) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int xIndex = info.length - 3;
        int yIndex = info.length - 2;
        int zIndex = info.length - 1;
        for (int index = 0; index < xIndex; ++index) {
            String s = info[index];
            if (index == 0) {
                sb.append(s);
                continue;
            }
            sb.append(" ").append(s);
        }
        String world = sb.toString();
        try {
            x = Double.parseDouble(info[xIndex]);
            y = Double.parseDouble(info[yIndex]);
            z = Double.parseDouble(info[zIndex]);
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Please inform Quests developer location was wrong for " + world + " " + info[xIndex] + " " + info[yIndex] + " " + info[zIndex] + " ");
            return null;
        }
        if (Bukkit.getServer().getWorld(world) == null) {
            Bukkit.getLogger().severe("Quests could not locate world " + world + ", is it loaded?");
            return null;
        }
        return new Location(Bukkit.getServer().getWorld(world), x, y, z);
    }

    public static String getLocationInfo(Location loc) {
        return Objects.requireNonNull(loc.getWorld()).getName() + " " + loc.getX() + " " + loc.getY() + " " + loc.getZ();
    }

    public static String[] parseStringWithPossibleLineBreaks(String s, Quest quest, Player player) {
        String parsed = BukkitConfigUtil.parseString(s);
        if (parsed.contains("<npc>")) {
            if (quest.getNpcStart() != null) {
                parsed = parsed.replace("<npc>", quest.getNpcStartName());
            } else {
                Bukkit.getLogger().warning(quest.getName() + " quest uses <npc> tag but doesn't have an NPC start set");
            }
        }
        if (BukkitDependencies.placeholder != null && player != null) {
            parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)parsed);
        }
        return parsed.split("\n");
    }

    public static String[] parseStringWithPossibleLineBreaks(String s, Quest quest) {
        String parsed = BukkitConfigUtil.parseString(s);
        if (parsed.contains("<npc>")) {
            if (quest.getNpcStart() != null) {
                parsed = parsed.replace("<npc>", quest.getNpcStartName());
            } else {
                Bukkit.getLogger().warning(quest.getName() + " quest uses <npc> tag but doesn't have an NPC start set");
            }
        }
        return parsed.split("\n");
    }

    public static String[] parseStringWithPossibleLineBreaks(String s, UUID npc, int amount, BukkitQuestsPlugin plugin) {
        String parsed = BukkitConfigUtil.parseString(s, npc, plugin);
        if (parsed.contains("<amount>")) {
            parsed = parsed.replace("<amount>", String.valueOf(amount));
        }
        return parsed.split("\n");
    }

    public static String parseString(String s, Quest quest) {
        String parsed = BukkitConfigUtil.parseString(s);
        if (quest != null && quest.getName() != null && (parsed = parsed.replace("<quest>", quest.getName())).contains("<npc>")) {
            if (quest.getNpcStart() != null) {
                parsed = parsed.replace("<npc>", quest.getNpcStartName());
            } else {
                Bukkit.getLogger().warning(quest.getName() + " quest uses <npc> tag but doesn't have an NPC start set");
            }
        }
        return parsed;
    }

    public static String parseString(String s, Quest quest, Player player) {
        String parsed = BukkitConfigUtil.parseString(s, quest);
        if (BukkitDependencies.placeholder != null && player != null) {
            parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)parsed);
        }
        return parsed;
    }

    public static String parseString(String s, UUID npc, BukkitQuestsPlugin plugin) {
        String parsed = BukkitConfigUtil.parseString(s);
        if (parsed.contains("<npc>")) {
            String name = "null";
            for (BukkitNpcDependency npcDependency : plugin.getDependencies().getNpcDependencies()) {
                String npcName = npcDependency.getName(npc);
                if (npcName == null) continue;
                name = npcName;
                break;
            }
            parsed = parsed.replace("<npc>", name);
        }
        return parsed;
    }

    public static String parseString(String s) {
        String parsed = s;
        parsed = parsed.replace("<black>", ChatColor.BLACK.toString());
        parsed = parsed.replace("<darkblue>", ChatColor.DARK_BLUE.toString());
        parsed = parsed.replace("<darkgreen>", ChatColor.DARK_GREEN.toString());
        parsed = parsed.replace("<darkaqua>", ChatColor.DARK_AQUA.toString());
        parsed = parsed.replace("<darkred>", ChatColor.DARK_RED.toString());
        parsed = parsed.replace("<purple>", ChatColor.DARK_PURPLE.toString());
        parsed = parsed.replace("<gold>", ChatColor.GOLD.toString());
        parsed = parsed.replace("<grey>", ChatColor.GRAY.toString());
        parsed = parsed.replace("<gray>", ChatColor.GRAY.toString());
        parsed = parsed.replace("<darkgrey>", ChatColor.DARK_GRAY.toString());
        parsed = parsed.replace("<darkgray>", ChatColor.DARK_GRAY.toString());
        parsed = parsed.replace("<blue>", ChatColor.BLUE.toString());
        parsed = parsed.replace("<green>", ChatColor.GREEN.toString());
        parsed = parsed.replace("<aqua>", ChatColor.AQUA.toString());
        parsed = parsed.replace("<red>", ChatColor.RED.toString());
        parsed = parsed.replace("<pink>", ChatColor.LIGHT_PURPLE.toString());
        parsed = parsed.replace("<yellow>", ChatColor.YELLOW.toString());
        parsed = parsed.replace("<white>", ChatColor.WHITE.toString());
        parsed = parsed.replace("<random>", ChatColor.MAGIC.toString());
        parsed = parsed.replace("<italic>", ChatColor.ITALIC.toString());
        parsed = parsed.replace("<i>", ChatColor.ITALIC.toString());
        parsed = parsed.replace("<bold>", ChatColor.BOLD.toString());
        parsed = parsed.replace("<b>", ChatColor.BOLD.toString());
        parsed = parsed.replace("<underline>", ChatColor.UNDERLINE.toString());
        parsed = parsed.replace("<u>", ChatColor.UNDERLINE.toString());
        parsed = parsed.replace("<strike>", ChatColor.STRIKETHROUGH.toString());
        parsed = parsed.replace("<reset>", ChatColor.RESET.toString());
        parsed = parsed.replace("<br>", "\n");
        parsed = ChatColor.translateAlternateColorCodes((char)'&', (String)parsed);
        Matcher matcher = hexPattern.matcher(parsed);
        while (matcher.find()) {
            char[] chars;
            StringBuilder hex = new StringBuilder();
            hex.append("\u00a7x");
            for (char aChar : chars = matcher.group(1).toCharArray()) {
                hex.append('\u00a7').append(Character.toLowerCase(aChar));
            }
            parsed = parsed.replace(matcher.group(), hex.toString());
        }
        return parsed;
    }
}

