/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.util;

import java.util.HashMap;
import java.util.Map;
import me.pikamug.quests.util.BukkitItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BukkitInventoryUtil {
    public static void addItem(Player player, ItemStack item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("Null item while trying to add to inventory of " + player.getName());
        }
        PlayerInventory inv = player.getInventory();
        HashMap leftovers = inv.addItem(new ItemStack[]{item});
        if (!leftovers.isEmpty()) {
            for (ItemStack leftover : leftovers.values()) {
                player.getWorld().dropItem(player.getLocation(), leftover);
            }
        }
    }

    public static boolean canRemoveItem(Inventory inventory, ItemStack item) {
        int amount = item.getAmount();
        HashMap allItems = inventory.all(item.getType());
        int foundAmount = 0;
        for (Map.Entry items : allItems.entrySet()) {
            if (BukkitItemUtil.compareItems(item, (ItemStack)items.getValue(), true) != 0) continue;
            foundAmount = ((ItemStack)items.getValue()).getAmount() >= amount - foundAmount ? amount : (foundAmount += ((ItemStack)items.getValue()).getAmount());
            if (foundAmount < amount) continue;
            break;
        }
        return foundAmount == amount;
    }

    public static boolean removeItem(Inventory inventory, ItemStack item) {
        int amount = item.getAmount();
        HashMap allItems = inventory.all(item.getType());
        HashMap<Integer, Integer> removeFrom = new HashMap<Integer, Integer>();
        int foundAmount = 0;
        for (Map.Entry items : allItems.entrySet()) {
            if (BukkitItemUtil.compareItems(item, (ItemStack)items.getValue(), true) != 0) continue;
            if (((ItemStack)items.getValue()).getAmount() >= amount - foundAmount) {
                removeFrom.put((Integer)items.getKey(), amount - foundAmount);
                foundAmount = amount;
            } else {
                foundAmount += ((ItemStack)items.getValue()).getAmount();
                removeFrom.put((Integer)items.getKey(), ((ItemStack)items.getValue()).getAmount());
            }
            if (foundAmount < amount) continue;
            break;
        }
        if (foundAmount == amount) {
            for (Map.Entry toRemove : removeFrom.entrySet()) {
                ItemStack i = inventory.getItem(((Integer)toRemove.getKey()).intValue());
                if (i == null) continue;
                if (i.getAmount() - (Integer)toRemove.getValue() <= 0) {
                    inventory.clear(((Integer)toRemove.getKey()).intValue());
                    continue;
                }
                i.setAmount(i.getAmount() - (Integer)toRemove.getValue());
                inventory.setItem(((Integer)toRemove.getKey()).intValue(), i);
            }
            return true;
        }
        return false;
    }

    public static boolean stripItem(EntityEquipment equipment, ItemStack item) {
        int amount = item.getAmount();
        ItemStack[] allItems = equipment.getArmorContents();
        HashMap<Integer, Integer> removeFrom = new HashMap<Integer, Integer>();
        int foundAmount = 0;
        int index = 0;
        for (ItemStack i : allItems) {
            if (i == null) {
                ++index;
                continue;
            }
            if (BukkitItemUtil.compareItems(item, i, true) == 0) {
                if (i.getAmount() >= amount - foundAmount) {
                    removeFrom.put(index, amount - foundAmount);
                    foundAmount = amount;
                } else {
                    foundAmount += i.getAmount();
                    removeFrom.put(index, i.getAmount());
                }
                if (foundAmount >= amount) break;
            }
            ++index;
        }
        if (foundAmount == amount) {
            for (Map.Entry entry : removeFrom.entrySet()) {
                ItemStack i = allItems[(Integer)entry.getKey()];
                if (i.getAmount() - (Integer)entry.getValue() <= 0) {
                    allItems[((Integer)entry.getKey()).intValue()] = null;
                    continue;
                }
                i.setAmount(i.getAmount() - (Integer)entry.getValue());
                allItems[((Integer)entry.getKey()).intValue()] = i;
            }
            equipment.setArmorContents(allItems);
            return true;
        }
        return false;
    }

    public static int getEmptySlots(Player player) {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion().split("-")[0];
        ItemStack[] contents = bukkitVersion.startsWith("1.8.") || bukkitVersion.equals("1.8") ? player.getInventory().getContents() : player.getInventory().getStorageContents();
        int i = 0;
        for (ItemStack item : contents) {
            if (item == null || item.getType() == Material.AIR) continue;
            ++i;
        }
        return 36 - i;
    }
}

