/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.RomanNumeral;
import me.pikamug.quests.util.stack.BlockItemStack;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class BukkitItemUtil {
    public static int compareItems(ItemStack one, ItemStack two, boolean ignoreAmount) {
        return BukkitItemUtil.compareItems(one, two, ignoreAmount, false);
    }

    public static int compareItems(ItemStack one, ItemStack two, boolean ignoreAmount, boolean ignoreDurability) {
        String levelB;
        String levelA;
        if (one == null || two == null) {
            return 1;
        }
        if (!one.getType().name().equals(two.getType().name())) {
            return -1;
        }
        if (one.getAmount() != two.getAmount() && !ignoreAmount) {
            return -2;
        }
        if (one.getDurability() != two.getDurability() && !ignoreDurability && one.getDurability() < 999 && two.getDurability() < 999) {
            return -3;
        }
        if (one.getItemMeta() != null || two.getItemMeta() != null) {
            if (one.getItemMeta() != null && two.getItemMeta() == null) {
                return -4;
            }
            if (!one.hasItemMeta() && two.hasItemMeta()) {
                return -4;
            }
            if (one.getItemMeta().hasDisplayName() && !two.getItemMeta().hasDisplayName()) {
                return -4;
            }
            if (!one.getItemMeta().hasDisplayName() && two.getItemMeta().hasDisplayName()) {
                return -4;
            }
            if (one.getItemMeta().hasLore() && !two.getItemMeta().hasLore()) {
                return -4;
            }
            if (!one.getItemMeta().hasLore() && two.getItemMeta().hasLore()) {
                return -4;
            }
            if (one.getItemMeta().hasDisplayName() && two.getItemMeta().hasDisplayName() && !ChatColor.stripColor((String)one.getItemMeta().getDisplayName()).equals(ChatColor.stripColor((String)two.getItemMeta().getDisplayName()))) {
                return -4;
            }
            if (one.getItemMeta().hasLore() && two.getItemMeta().hasLore() && !one.getItemMeta().getLore().equals(two.getItemMeta().getLore())) {
                return -4;
            }
            try {
                ItemMeta test = one.getItemMeta();
                test.setUnbreakable(true);
                for (ItemFlag flag : ItemFlag.values()) {
                    if (one.getItemMeta().hasItemFlag(flag) || !two.getItemMeta().hasItemFlag(flag)) continue;
                    return -7;
                }
            }
            catch (Throwable test) {
                // empty catch block
            }
            if (one.getType().equals((Object)Material.WRITTEN_BOOK)) {
                BookMeta bMeta1 = (BookMeta)one.getItemMeta();
                BookMeta bMeta2 = (BookMeta)two.getItemMeta();
                if (bMeta1 != null && bMeta2 != null && Objects.equals(bMeta1.getTitle(), bMeta2.getTitle()) && Objects.equals(bMeta1.getAuthor(), bMeta2.getAuthor()) && !bMeta1.getPages().equals(bMeta2.getPages())) {
                    return -8;
                }
            }
            if (one.getItemMeta() instanceof PotionMeta && Material.getMaterial((String)"LINGERING_POTION") != null && (one.getType().equals((Object)Material.POTION) || one.getType().equals((Object)Material.LINGERING_POTION) || one.getType().equals((Object)Material.SPLASH_POTION))) {
                PotionMeta pMeta1 = (PotionMeta)one.getItemMeta();
                PotionMeta pMeta2 = (PotionMeta)two.getItemMeta();
                if (pMeta1.getBasePotionData() != null && pMeta2.getBasePotionData() != null) {
                    if (!pMeta1.getBasePotionData().getType().equals((Object)pMeta2.getBasePotionData().getType())) {
                        return -9;
                    }
                    if (pMeta1.getBasePotionData().isExtended() != pMeta2.getBasePotionData().isExtended()) {
                        return -9;
                    }
                    if (pMeta1.getBasePotionData().isUpgraded() != pMeta2.getBasePotionData().isUpgraded()) {
                        return -9;
                    }
                }
            }
            if (one.getItemMeta().toString().startsWith("TROPICAL_FISH_BUCKET_META")) {
                String meta1 = one.getItemMeta().toString();
                String meta2 = two.getItemMeta().toString();
                if (meta1.contains("variant=") && meta2.contains("variant=")) {
                    String variant2;
                    String variant1 = meta1.substring(meta1.indexOf("variant="), meta1.length() - 1);
                    if (!variant1.equals(variant2 = meta2.substring(meta2.indexOf("variant="), meta2.length() - 1))) {
                        return -10;
                    }
                } else {
                    return -10;
                }
            }
        }
        if (Material.getMaterial((String)"LINGERING_POTION") == null ? one.getType().equals((Object)Material.POTION) && one.getDurability() != two.getDurability() : one.getType().name().equals("TIPPED_ARROW") && two.getType().name().equals("TIPPED_ARROW") && !(levelA = BukkitItemUtil.getPrettyPotionLevel(one.getItemMeta())).equals(levelB = BukkitItemUtil.getPrettyPotionLevel(two.getItemMeta()))) {
            return -9;
        }
        if (!one.getEnchantments().equals(two.getEnchantments())) {
            return -5;
        }
        if (one.getType().equals((Object)Material.ENCHANTED_BOOK) && one.getItemMeta() instanceof EnchantmentStorageMeta && two.getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta esMeta1 = (EnchantmentStorageMeta)one.getItemMeta();
            EnchantmentStorageMeta esMeta2 = (EnchantmentStorageMeta)two.getItemMeta();
            if (esMeta1.hasStoredEnchants() && !esMeta2.hasStoredEnchants()) {
                return -6;
            }
            if (!esMeta1.getStoredEnchants().equals(esMeta2.getStoredEnchants())) {
                return -6;
            }
        }
        return 0;
    }

    public static ItemStack processItemStack(String material, int amount, short durability) {
        if (material == null) {
            return null;
        }
        try {
            Material mat = Material.getMaterial((String)material.toUpperCase());
            if (mat == null) {
                return null;
            }
            ItemStack item = mat.isBlock() && Material.getMaterial((String)"CRAFTER") != null ? new ItemStack(mat.createBlockData().getPlacementMaterial(), amount) : new ItemStack(mat, amount, durability);
            return item;
        }
        catch (Exception e) {
            try {
                Bukkit.getLogger().warning(material + " x " + amount + " is invalid! You may need to update your quests.yml or actions.yml in accordance with https://bit.ly/2BkBNNN");
                Material mat = Material.matchMaterial((String)material, (boolean)true);
                if (mat == null) {
                    return null;
                }
                return new ItemStack(mat, amount, durability);
            }
            catch (Exception e2) {
                Bukkit.getLogger().severe("Unable to use LEGACY_" + material + " as item name");
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static BlockItemStack processBlockItemStack(String material, int amount, short durability) {
        if (material == null) {
            return null;
        }
        try {
            Material mat = Material.getMaterial((String)material.toUpperCase());
            if (mat == null) {
                return null;
            }
            return BlockItemStack.of(mat, amount, durability);
        }
        catch (Exception e) {
            try {
                Bukkit.getLogger().warning(material + " x " + amount + " is invalid! You may need to update your quests.yml or actions.yml in accordance with https://bit.ly/2BkBNNN");
                Material mat = Material.matchMaterial((String)material, (boolean)true);
                if (mat == null) {
                    return null;
                }
                return BlockItemStack.of(mat, amount, durability);
            }
            catch (Exception e2) {
                Bukkit.getLogger().severe("Unable to use LEGACY_" + material + " as item name");
                e2.printStackTrace();
                return null;
            }
        }
    }

    @Deprecated
    public static ItemStack readItemStack(String data) {
        if (data == null) {
            return null;
        }
        String[] args = data.split(":");
        String name = null;
        int amount = 0;
        short durability = 0;
        HashMap<Enchantment, Integer> enchs = new HashMap<Enchantment, Integer>();
        String display = null;
        LinkedList<String> lore = new LinkedList<String>();
        String[] flags = new String[10];
        LinkedHashMap<Enchantment, Integer> stored = new LinkedHashMap<Enchantment, Integer>();
        int potionColor = -1;
        LinkedHashMap<String, Object> extra = new LinkedHashMap<String, Object>();
        ItemMeta meta = null;
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String value;
            String[] mapping;
            String key;
            String targ = stringArray[i];
            String arg = targ.replace("minecraft|", "minecraft:");
            if (arg.isEmpty()) continue;
            if (arg.startsWith("name-")) {
                name = arg.substring(5).toUpperCase();
                continue;
            }
            if (arg.startsWith("amount-")) {
                amount = Integer.parseInt(arg.substring(7));
                continue;
            }
            if (arg.startsWith("data-")) {
                durability = Short.parseShort(arg.substring(5));
                continue;
            }
            if (arg.startsWith("enchantment-")) {
                String[] temp = arg.substring(12).split(" ");
                try {
                    key = BukkitLang.getKey(temp[0]).replace(" ", "");
                    if (!key.equals("NULL")) {
                        Enchantment e = Enchantment.getByName((String)key.replace("ENCHANTMENT_", ""));
                        if (e != null) {
                            enchs.put(e, Integer.parseInt(temp[1]));
                            continue;
                        }
                        Bukkit.getLogger().severe("Legacy enchantment name '" + temp[0] + "' on " + name + " is invalid. Make sure it is spelled correctly");
                        continue;
                    }
                    if (Enchantment.getByName((String)temp[0]) != null) {
                        enchs.put(Enchantment.getByName((String)temp[0]), Integer.parseInt(temp[1]));
                        continue;
                    }
                    Bukkit.getLogger().severe("Enum enchantment name '" + temp[0] + "' on " + name + " is invalid. Make sure it is spelled correctly");
                    continue;
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("The enchantment name '" + temp[0] + "' on " + name + " is invalid. Make sure quests.yml is UTF-8 encoded");
                    return null;
                }
            }
            if (arg.startsWith("displayname-")) {
                display = ChatColor.translateAlternateColorCodes((char)'&', (String)arg.substring(12));
                continue;
            }
            if (arg.startsWith("lore-")) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)arg.substring(5)));
                continue;
            }
            if (arg.startsWith("ItemFlags-")) {
                int dash = arg.lastIndexOf(45);
                String value2 = arg.substring(dash + 1);
                mapping = value2.replace("[", "").replace("]", "").split(", ");
                int index = 0;
                String[] stringArray2 = mapping;
                int n2 = stringArray2.length;
                for (int j = 0; j < n2; ++j) {
                    String s;
                    flags[index] = s = stringArray2[j];
                    ++index;
                }
                continue;
            }
            if (arg.startsWith("stored-enchants")) {
                int dash = arg.lastIndexOf(45);
                String value2 = arg.substring(dash + 1);
                for (String s : mapping = value2.replace("{", "").replace("}", "").split(", ")) {
                    if (!s.contains("=")) continue;
                    String[] keyval = s.split("=");
                    stored.put(Enchantment.getByName((String)keyval[0]), Integer.valueOf(keyval[1]));
                }
                continue;
            }
            if (arg.startsWith("charged")) {
                int dash = arg.lastIndexOf(45);
                key = arg.substring(0, dash);
                value = arg.substring(dash + 1);
                extra.put(key, Boolean.valueOf(value));
                continue;
            }
            if (arg.contains("-")) {
                int dash = arg.lastIndexOf(45);
                key = arg.substring(0, dash);
                value = arg.substring(dash + 1);
                int i2 = -1;
                try {
                    i2 = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (i2 > -1) {
                    extra.put(key, i2);
                    continue;
                }
                if (value.startsWith("[") && value.endsWith("]")) {
                    List<String> pages = Arrays.asList(value.split(", "));
                    extra.put(key, pages);
                    continue;
                }
                if (value.startsWith("{") && value.endsWith("}")) {
                    String[] mapping2 = value.replace("{", "").replace("}", "").split(", ");
                    HashMap<String, String> nested = new HashMap<String, String>();
                    for (String s : mapping2) {
                        if (!s.contains("=")) {
                            Bukkit.getLogger().severe("Quests does not know how to handle " + value + " so please contact the developer on Github");
                            return null;
                        }
                        String[] keyval = s.split("=");
                        nested.put(keyval[0], keyval[1]);
                    }
                    extra.put(key, nested);
                    continue;
                }
                if (value.equals("true")) {
                    try {
                        if (!key.equalsIgnoreCase("unbreakable")) continue;
                        meta.setUnbreakable(true);
                    }
                    catch (Throwable tr) {
                        Bukkit.getLogger().info("You are running a version of CraftBukkit for which Quests cannot set the NBT tag " + key);
                    }
                    continue;
                }
                if (key.contains("custom-color")) continue;
                extra.put(key, value);
                continue;
            }
            if (arg.startsWith("[") && arg.endsWith("]")) {
                if (arg.contains("rgb")) {
                    String[] mapping3 = arg.replace("[", "").replace("]", "").split("x");
                    potionColor = Integer.parseInt(mapping3[1]);
                    continue;
                }
                Bukkit.getLogger().severe("Quests does not know how to handle " + arg + " so please contact the developer on Github");
                return null;
            }
            Bukkit.getLogger().severe("Quests was unable to read item argument: " + arg);
            return null;
        }
        ItemStack stack = BukkitItemUtil.processItemStack(name, amount, durability);
        if (stack == null) {
            return null;
        }
        meta = stack.getItemMeta();
        if (meta != null) {
            Object toLoad;
            if (!extra.isEmpty() && (toLoad = BukkitItemUtil.deserializeItemMeta(meta.getClass(), extra)) != null) {
                meta = toLoad;
            }
            if (!enchs.isEmpty()) {
                for (Enchantment enchantment : enchs.keySet()) {
                    try {
                        meta.addEnchant(enchantment, ((Integer)enchs.get(enchantment)).intValue(), true);
                    }
                    catch (IllegalArgumentException iae) {
                        Bukkit.getLogger().severe("Enchantment on " + name + " cannot be null. Skipping for that quest");
                    }
                }
            }
            if (display != null) {
                meta.setDisplayName(display);
            }
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            for (String flag : flags) {
                if (flag == null || flag.isEmpty()) continue;
                try {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
                }
                catch (NullPointerException npe) {
                    Bukkit.getLogger().severe((String)flag + " is not a valid ItemFlag");
                }
                catch (Throwable tr) {
                    Bukkit.getLogger().info("You are running a version of CraftBukkit for which Quests cannot add the item flag " + (String)flag);
                }
            }
        }
        if (potionColor != -1) {
            PotionMeta pMeta = (PotionMeta)meta;
            try {
                pMeta.setColor(Color.fromRGB((int)potionColor));
            }
            catch (Throwable tr) {
                Bukkit.getLogger().info("You are running a version of CraftBukkit for which Quests cannot set the potion color " + potionColor);
            }
        }
        if (stack.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            EnchantmentStorageMeta esMeta = (EnchantmentStorageMeta)meta;
            if (esMeta != null) {
                for (Map.Entry entry : stored.entrySet()) {
                    esMeta.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                }
            }
            stack.setItemMeta((ItemMeta)esMeta);
        } else {
            stack.setItemMeta(meta);
        }
        return stack;
    }

    @Deprecated
    public static String serializeItemStack(ItemStack is) {
        if (is == null) {
            return null;
        }
        StringBuilder serial = new StringBuilder("name-" + is.getType().name());
        serial.append(":amount-").append(is.getAmount());
        if (is.getDurability() != 0) {
            serial.append(":data-").append(is.getDurability());
        }
        if (!is.getEnchantments().isEmpty()) {
            for (Map.Entry entry : is.getEnchantments().entrySet()) {
                serial.append(":enchantment-").append(((Enchantment)entry.getKey()).getName()).append(" ").append(entry.getValue());
            }
        }
        if (is.hasItemMeta()) {
            ItemMeta meta = is.getItemMeta();
            if (meta.hasDisplayName()) {
                serial.append(":displayname-").append(meta.getDisplayName());
            }
            if (meta.hasLore()) {
                for (String s : meta.getLore()) {
                    serial.append(":lore-").append(s);
                }
            }
            LinkedHashMap linkedHashMap = new LinkedHashMap(meta.serialize());
            linkedHashMap.remove("lore");
            linkedHashMap.remove("display-name");
            for (String key : linkedHashMap.keySet()) {
                serial.append(":").append(key).append("-").append(linkedHashMap.get(key).toString().replace("minecraft:", "minecraft|"));
            }
        }
        return serial.toString();
    }

    public static ItemMeta deserializeItemMeta(Class<? extends ItemMeta> itemMetaClass, Map<String, Object> args) {
        DelegateDeserialization delegate = itemMetaClass.getAnnotation(DelegateDeserialization.class);
        return (ItemMeta)ConfigurationSerialization.deserializeObject(args, (Class)delegate.value());
    }

    public static String getDisplayString(ItemStack is) {
        StringBuilder text;
        if (is == null) {
            return null;
        }
        if (is.hasItemMeta() && is.getItemMeta().hasDisplayName()) {
            text = new StringBuilder("" + ChatColor.DARK_AQUA + ChatColor.ITALIC + is.getItemMeta().getDisplayName() + ChatColor.RESET + ChatColor.AQUA + " x " + is.getAmount());
        } else {
            text = new StringBuilder(ChatColor.AQUA + BukkitItemUtil.getName(is));
            if (is.getDurability() != 0) {
                text.append(ChatColor.AQUA).append(":").append(is.getDurability());
            }
            if (!is.getEnchantments().isEmpty()) {
                text.append(" ").append(ChatColor.GRAY).append(BukkitLang.get("with")).append(ChatColor.DARK_PURPLE);
                for (Map.Entry e : is.getEnchantments().entrySet()) {
                    text.append(" ").append(BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).append(":").append(e.getValue());
                }
            }
            text.append(ChatColor.AQUA).append(" x ").append(is.getAmount());
        }
        return text.toString();
    }

    public static String getString(ItemStack is) {
        String text;
        if (is == null) {
            return null;
        }
        if (is.getItemMeta() != null && is.getItemMeta().hasDisplayName()) {
            text = "" + ChatColor.DARK_AQUA + ChatColor.ITALIC + is.getItemMeta().getDisplayName() + ChatColor.RESET + ChatColor.AQUA + " x " + is.getAmount();
        } else {
            text = ChatColor.AQUA + BukkitItemUtil.getPrettyItemName(is.getType().name());
            if (is.getDurability() != 0) {
                text = text + ChatColor.AQUA + ":" + is.getDurability();
            }
            text = text + ChatColor.AQUA + " x " + is.getAmount();
        }
        return text;
    }

    public static String getName(ItemStack is) {
        String text;
        if (is == null) {
            return null;
        }
        if (is.getItemMeta() != null && is.getItemMeta().hasDisplayName()) {
            text = "" + ChatColor.DARK_AQUA + ChatColor.ITALIC + is.getItemMeta().getDisplayName();
        } else if (is.getType().equals((Object)Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)is.getItemMeta();
            text = "" + ChatColor.DARK_AQUA + ChatColor.LIGHT_PURPLE + bookMeta.getTitle();
        } else {
            text = ChatColor.AQUA + BukkitItemUtil.getPrettyItemName(is.getType().name());
        }
        return text;
    }

    public static String getName(BlockItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return ChatColor.AQUA + BukkitItemUtil.getPrettyItemName(itemStack.getType().name());
    }

    public static boolean isItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        return !is.getType().equals((Object)Material.AIR);
    }

    public static boolean isJournal(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (is.getItemMeta() == null) {
            return false;
        }
        if (!is.getItemMeta().hasDisplayName()) {
            return false;
        }
        return is.getItemMeta().getDisplayName().equals(ChatColor.LIGHT_PURPLE + BukkitLang.get("journalTitle"));
    }

    public static String getPrettyItemName(String itemName) {
        Material material = Material.matchMaterial((String)itemName);
        if (material == null) {
            return "invalid";
        }
        String baseString = material.toString();
        String[] substrings = baseString.split("_");
        String prettyString = "";
        int size = 1;
        for (String s : substrings) {
            prettyString = prettyString.concat(BukkitMiscUtil.getCapitalized(s));
            if (size < substrings.length) {
                prettyString = prettyString.concat(" ");
            }
            ++size;
        }
        return prettyString;
    }

    public static String getPrettyEnchantmentName(Enchantment enchant) {
        String baseString = enchant.getName();
        String[] substrings = baseString.split("_");
        String prettyString = "";
        int size = 1;
        for (String s : substrings) {
            prettyString = prettyString.concat(BukkitMiscUtil.getCapitalized(s));
            if (size < substrings.length) {
                prettyString = prettyString.concat(" ");
            }
            ++size;
        }
        return prettyString;
    }

    public static Enchantment getEnchantmentFromProperName(String properName) {
        properName = properName.replace(" ", "").toUpperCase();
        for (Enchantment e : Enchantment.values()) {
            if (!e.getName().replace("_", "").equalsIgnoreCase(properName.replace("_", ""))) continue;
            return e;
        }
        return null;
    }

    public static Enchantment getEnchantmentFromPrettyName(String enchant) {
        if (enchant != null && BukkitMiscUtil.spaceToCapital(enchant) != null) {
            enchant = BukkitMiscUtil.spaceToCapital(enchant);
        }
        return BukkitItemUtil.getEnchantmentFromProperName(enchant);
    }

    public static String getPrettyPotionLevel(ItemMeta itemMeta) {
        String prettyString = "";
        if (Material.getMaterial((String)"LINGERING_POTION") == null) {
            return prettyString;
        }
        if (!(itemMeta instanceof PotionMeta)) {
            return prettyString;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        if (meta.getBasePotionData().isUpgraded()) {
            int level = meta.getBasePotionData().getType().name().contains("SLOWNESS") ? 4 : 2;
            prettyString = ChatColor.GREEN + RomanNumeral.getNumeral(level) + ChatColor.RESET;
        } else if (meta.getBasePotionData().isExtended()) {
            prettyString = ChatColor.GREEN + "+" + ChatColor.RESET;
        }
        return prettyString;
    }
}

