/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.pikamug.quests.Quests;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BukkitLang {
    private static Quests plugin;
    private static final LinkedHashMap<String, String> defaultLang;
    private static final LinkedHashMap<String, LinkedHashMap<String, String>> otherLang;
    private static final Pattern hexPattern;

    public static Collection<String> values() {
        return defaultLang.values();
    }

    public static String get(Player player, String key) {
        String locale;
        if (key == null) {
            return null;
        }
        if (player == null) {
            return BukkitLang.get(key);
        }
        try {
            locale = player.getLocale();
        }
        catch (NoSuchMethodError e) {
            try {
                Method m = player.spigot().getClass().getDeclaredMethod("getLocale", new Class[0]);
                m.setAccessible(true);
                locale = (String)m.invoke((Object)player.spigot(), new Object[0]);
            }
            catch (Exception e2) {
                plugin.getPluginLogger().severe("Legacy player locale reflection failed, defaulting to en_US");
                e2.printStackTrace();
                locale = "en_US";
            }
        }
        int separator = locale.indexOf("_");
        if (separator == -1) {
            return defaultLang.containsKey(key) ? BukkitFormatToken.convertString(player, defaultLang.get(key)) : "NULL";
        }
        String language = locale.substring(0, separator);
        String country = locale.substring(separator + 1).toUpperCase();
        locale = language + "-" + country;
        if (plugin.getConfigSettings().canLanguageOverrideClient() || locale.equals(plugin.getConfigSettings().getLanguage())) {
            return defaultLang.containsKey(key) ? BukkitFormatToken.convertString(player, defaultLang.get(key)) : "NULL";
        }
        if (!otherLang.containsKey(locale)) {
            try {
                BukkitLang.load(plugin, locale);
            }
            catch (Exception e) {
                return defaultLang.containsKey(key) ? BukkitFormatToken.convertString(player, defaultLang.get(key)) : "NULL";
            }
        }
        if (otherLang.get(locale).get(key) == null) {
            return defaultLang.get(key);
        }
        return BukkitFormatToken.convertString(otherLang.get(locale).get(key));
    }

    public static String get(CommandSender commandSender, String key) {
        if (key == null) {
            return null;
        }
        if (commandSender instanceof Player) {
            return BukkitLang.get((Player)commandSender, key);
        }
        return BukkitLang.get(key);
    }

    public static String get(String key) {
        if (key == null) {
            return null;
        }
        return defaultLang.containsKey(key) ? BukkitFormatToken.convertString(defaultLang.get(key)) : "NULL";
    }

    public static String getKey(String value) {
        for (Map.Entry<String, String> entry : defaultLang.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return "NULL";
    }

    public static String getKeyFromPrefix(String keyPrefix, String value) {
        for (Map.Entry<String, String> entry : defaultLang.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(value) || !entry.getKey().toUpperCase().startsWith(keyPrefix)) continue;
            return entry.getKey();
        }
        return "NULL";
    }

    public static void clear() {
        defaultLang.clear();
        otherLang.clear();
    }

    public static int size() {
        return defaultLang.size();
    }

    public static String getModified(String key, String[] tokens) {
        String orig = defaultLang.get(key);
        for (int i = 0; i < tokens.length; ++i) {
            orig = orig.replace("%" + (i + 1), tokens[i]);
        }
        return orig;
    }

    public static void send(Player player, String message) {
        if (message != null && !ChatColor.stripColor((String)message).isEmpty()) {
            player.sendMessage(message);
        }
    }

    public static void init(Quests plugin) throws IOException, URISyntaxException {
        BukkitLang.plugin = plugin;
        String path = "lang";
        File jarFile = new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> results = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith("lang/") || !name.contains("strings.yml")) continue;
                results.add(name);
            }
            for (String resourcePath : results) {
                plugin.saveResourceAs(resourcePath, resourcePath, false);
                plugin.saveResourceAs(resourcePath, resourcePath.replace(".yml", "_new.yml"), true);
            }
            jar.close();
        }
        try {
            BukkitLang.load(plugin, plugin.getConfigSettings().getLanguage());
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static void load(Quests plugin, String iso) throws InvalidConfigurationException, IOException {
        YamlConfiguration config;
        BukkitLang.plugin = plugin;
        File langFile = new File(plugin.getPluginDataFolder(), File.separator + "lang" + File.separator + iso + File.separator + "strings.yml");
        File langFile_new = new File(plugin.getPluginDataFolder(), File.separator + "lang" + File.separator + iso + File.separator + "strings_new.yml");
        boolean exists_new = langFile_new.exists();
        LinkedHashMap<String, String> allStrings = new LinkedHashMap<String, String>();
        if (!langFile.exists() || iso.split("-").length <= 1) {
            if (defaultLang.isEmpty()) {
                plugin.getPluginLogger().severe("Failed loading lang files for " + iso + " because they were not found. Using default en-US instead");
                plugin.getPluginLogger().info("If the plugin has not generated language files, ensure Quests has write permissions");
                plugin.getPluginLogger().info("For help, visit https://pikamug.gitbook.io/quests/casual/translations");
                plugin.getConfigSettings().setLanguage("en-US");
                if (plugin.getConfigSettings().getConsoleLogging() > 3) {
                    plugin.getPluginLogger().info("CodeSource: " + plugin.getClass().getProtectionDomain().getCodeSource().toString());
                    plugin.getPluginLogger().info("LocationPath: " + plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
                }
            }
            config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getPluginResource("strings.yml")), StandardCharsets.UTF_8));
            for (Iterator key : config.getKeys(false)) {
                allStrings.put((String)((Object)key), config.getString((String)((Object)key)));
            }
        }
        config = langFile.length() > 4L ? YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(langFile), StandardCharsets.UTF_8)) : YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getPluginResource("strings.yml")), StandardCharsets.UTF_8));
        YamlConfiguration config_new = null;
        if (exists_new) {
            if (langFile_new.length() > 5L) {
                config_new = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(langFile_new), StandardCharsets.UTF_8));
            } else {
                exists_new = false;
            }
        }
        for (String key : config.getKeys(false)) {
            allStrings.put(key, config.getString(key));
            if (!exists_new) continue;
            config_new.set(key, null);
        }
        if (exists_new) {
            for (String key : config_new.getKeys(false)) {
                String value = config_new.getString(key);
                if (value == null) continue;
                allStrings.put(key, value);
                plugin.getPluginLogger().warning("There are new language phrases in /lang/" + iso + "/strings_new.yml for the current version! You must transfer them to, or regenerate, strings.yml to remove this warning!");
            }
            config_new.options().header("Below are any new strings for your current version of Quests! Transfer them to the strings.yml of the same folder to stay up-to-date and suppress console warnings.");
            config_new.options().copyHeader(true);
            config_new.save(langFile_new);
        }
        String cmdAdd = (String)allStrings.get("cmdAdd");
        String cmdClear = (String)allStrings.get("cmdClear");
        String cmdCancel = (String)allStrings.get("cmdCancel");
        String cmdDone = (String)allStrings.get("cmdDone");
        String missing = "( Missing translation: https://crowdin.com/translate/translate-quests )";
        String strAdd = allStrings.get("strAdd") != null ? ((String)allStrings.get("strAdd")).replace("<command>", cmdAdd) : "( Missing translation: https://crowdin.com/translate/translate-quests )";
        String strClear = allStrings.get("strClear") != null ? ((String)allStrings.get("strClear")).replace("<command>", cmdClear) : "( Missing translation: https://crowdin.com/translate/translate-quests )";
        String strCancel = allStrings.get("strCancel") != null ? ((String)allStrings.get("strCancel")).replace("<command>", cmdCancel) : "( Missing translation: https://crowdin.com/translate/translate-quests )";
        String strDone = allStrings.get("strDone") != null ? ((String)allStrings.get("strDone")).replace("<command>", cmdDone) : "( Missing translation: https://crowdin.com/translate/translate-quests )";
        String strSpace = (String)allStrings.get("strSpace");
        String strSemicolon = (String)allStrings.get("strSemicolon");
        for (Map.Entry entry : allStrings.entrySet()) {
            if (((String)entry.getValue()).contains("<add>")) {
                allStrings.put((String)entry.getKey(), ((String)entry.getValue()).replace("<add>", strAdd));
            }
            if (((String)entry.getValue()).contains("<clear>")) {
                allStrings.put((String)entry.getKey(), ((String)entry.getValue()).replace("<clear>", strClear));
            }
            if (((String)entry.getValue()).contains("<cancel>")) {
                allStrings.put((String)entry.getKey(), ((String)entry.getValue()).replace("<cancel>", strCancel));
            }
            if (((String)entry.getValue()).contains("<done>")) {
                allStrings.put((String)entry.getKey(), ((String)entry.getValue()).replace("<done>", strDone));
            }
            if (strSpace != null && ((String)entry.getValue()).contains("<space>")) {
                allStrings.put((String)entry.getKey(), ((String)entry.getValue()).replace("<space>", strSpace));
            }
            if (strSemicolon == null || !((String)entry.getValue()).contains("<semicolon>")) continue;
            allStrings.put((String)entry.getKey(), ((String)entry.getValue()).replace("<semicolon>", strSemicolon));
        }
        if (iso.equals(plugin.getConfigSettings().getLanguage())) {
            defaultLang.clear();
            defaultLang.putAll(allStrings);
        } else {
            otherLang.put(iso, allStrings);
        }
        if (langFile.length() > 4L) {
            plugin.getPluginLogger().info("Loaded language " + iso + ". Translations via Crowdin");
        } else {
            plugin.getPluginLogger().info("Failed to load language " + iso + " due to lack of translations");
        }
    }

    static {
        defaultLang = new LinkedHashMap();
        otherLang = new LinkedHashMap();
        hexPattern = Pattern.compile("(?i)%#([0-9a-fA-F]{6})%");
    }

    public static class BukkitFormatToken {
        static Map<String, String> tokenMap = new HashMap<String, String>();

        public static void init() {
            tokenMap.put("%br%", "\n");
            tokenMap.put("%tab%", "\t");
            tokenMap.put("%rtr%", "\r");
            tokenMap.put("%bold%", ChatColor.BOLD.toString());
            tokenMap.put("%italic%", ChatColor.ITALIC.toString());
            tokenMap.put("%underline%", ChatColor.UNDERLINE.toString());
            tokenMap.put("%strikethrough%", ChatColor.STRIKETHROUGH.toString());
            tokenMap.put("%magic%", ChatColor.MAGIC.toString());
            tokenMap.put("%reset%", ChatColor.RESET.toString());
            tokenMap.put("%white%", ChatColor.WHITE.toString());
            tokenMap.put("%black%", ChatColor.BLACK.toString());
            tokenMap.put("%aqua%", ChatColor.AQUA.toString());
            tokenMap.put("%darkaqua%", ChatColor.DARK_AQUA.toString());
            tokenMap.put("%blue%", ChatColor.BLUE.toString());
            tokenMap.put("%darkblue%", ChatColor.DARK_BLUE.toString());
            tokenMap.put("%gold%", ChatColor.GOLD.toString());
            tokenMap.put("%gray%", ChatColor.GRAY.toString());
            tokenMap.put("%darkgray%", ChatColor.DARK_GRAY.toString());
            tokenMap.put("%pink%", ChatColor.LIGHT_PURPLE.toString());
            tokenMap.put("%purple%", ChatColor.DARK_PURPLE.toString());
            tokenMap.put("%green%", ChatColor.GREEN.toString());
            tokenMap.put("%darkgreen%", ChatColor.DARK_GREEN.toString());
            tokenMap.put("%red%", ChatColor.RED.toString());
            tokenMap.put("%darkred%", ChatColor.DARK_RED.toString());
            tokenMap.put("%yellow%", ChatColor.YELLOW.toString());
        }

        public static String convertString(String s) {
            if (s == null) {
                return null;
            }
            if (tokenMap.isEmpty()) {
                BukkitFormatToken.init();
            }
            for (Map.Entry<String, String> token : tokenMap.entrySet()) {
                s = s.replace(token.getKey(), token.getValue());
                s = s.replace(token.getKey().toUpperCase(), token.getValue());
            }
            Matcher matcher = hexPattern.matcher(s);
            while (matcher.find()) {
                char[] chars;
                StringBuilder hex = new StringBuilder();
                hex.append("\u00a7x");
                for (char c : chars = matcher.group(1).toCharArray()) {
                    hex.append('\u00a7').append(Character.toLowerCase(c));
                }
                s = s.replace(matcher.group(), hex.toString());
            }
            return s;
        }

        public static String convertString(Player p, String s) {
            if (s == null) {
                return null;
            }
            if (tokenMap.isEmpty()) {
                BukkitFormatToken.init();
            }
            s = BukkitFormatToken.convertString(s);
            Plugin placeholderApi = Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI");
            if (placeholderApi != null && placeholderApi.isEnabled()) {
                s = PlaceholderAPI.setPlaceholders((Player)p, (String)s);
            }
            return s;
        }
    }
}

